/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.search.sru.db;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import search.library.util.cql.query.tree.GCQLAndNode;
import search.library.util.cql.query.tree.GCQLNode;
import search.library.util.cql.query.tree.GCQLNotNode;
import search.library.util.cql.query.tree.GCQLOrNode;
import search.library.util.cql.query.tree.GCQLProjectNode;
import search.library.util.cql.query.tree.GCQLQueryTreeManager;
import search.library.util.cql.query.tree.GCQLTermNode;
import search.library.util.cql.query.tree.ModifierSet;

public class CqlToSql {
    private static final Logger logger = LoggerFactory.getLogger(CqlToSql.class);
    List<String> projections = new ArrayList();
    Set<String> tables = new HashSet();
    List<String> columns = new ArrayList();
    String sqlQuery;
    String whereClause;
    Integer limit;
    Integer offset = 0;
    String cqlQuery;
    String defaultTable;

    public static void main(String[] args) throws Exception {
        String cql = "books.title == \"mytitle\" or books.author == \"myauthor2\"";
        Integer limit = 5;
        Integer offset = null;
        CqlToSql cts = new CqlToSql(cql, limit, offset, "");
        cts.parseQuery();
        logger.info("sql : " + cts.getSqlQuery());
        logger.info("sql : " + cts.getSqlCountQuery());
    }

    public CqlToSql(String cqlQuery, Integer limit, Integer offset, String defaultTable) {
        this.cqlQuery = cqlQuery;
        this.limit = limit;
        this.offset = offset;
        this.defaultTable = defaultTable;
    }

    public CqlToSql(String cqlQuery, String defaultTable) {
        this(cqlQuery, null, null, defaultTable);
    }

    private String getSelectCountClause() {
        return "SELECT COUNT(*)";
    }

    private String getSelectClause() {
        if (this.projections == null || this.projections.size() == 0) {
            return "SELECT *";
        }
        return "SELECT " + StringUtils.join((Collection)this.projections, (String)", ");
    }

    private String getFromClause() {
        if (this.tables == null || this.tables.size() == 0) {
            return "FROM " + this.defaultTable;
        }
        return "FROM " + StringUtils.join((Collection)this.tables, (String)", ");
    }

    private String getWhereClause() {
        return "WHERE " + this.whereClause;
    }

    private String getLimitClause() {
        if (this.limit == null) {
            return "";
        }
        return "LIMIT " + (this.offset != null ? this.offset : "0") + ", " + this.limit;
    }

    public String getSqlQuery() {
        String sql = this.getSelectClause() + " " + this.getFromClause() + " " + this.getWhereClause() + " " + this.getLimitClause();
        return sql;
    }

    public String getSqlCountQuery() {
        String sql = this.getSelectCountClause() + " " + this.getFromClause() + " " + this.getWhereClause();
        return sql;
    }

    public void parseQuery() throws Exception {
        GCQLNode head = GCQLQueryTreeManager.parseGCQLString((String)this.cqlQuery);
        this.whereClause = this.processNode(head);
        logger.info("tables      : " + this.tables);
        logger.info("projections : " + this.projections);
        logger.info("columns     : " + this.columns);
    }

    private String processNode(GCQLNode node) throws Exception {
        if (node instanceof GCQLProjectNode) {
            return this.processNode((GCQLProjectNode)node);
        }
        if (node instanceof GCQLAndNode) {
            return this.processNode((GCQLAndNode)node);
        }
        if (node instanceof GCQLNotNode) {
            return this.processNode((GCQLNotNode)node);
        }
        if (node instanceof GCQLOrNode) {
            return this.processNode((GCQLOrNode)node);
        }
        if (node instanceof GCQLTermNode) {
            return this.processNode((GCQLTermNode)node);
        }
        throw new Exception("This node class is not supported: " + node.getClass().toString());
    }

    private String processNode(GCQLProjectNode node) throws Exception {
        Vector nodeProjections = node.getProjectIndexes();
        for (ModifierSet projection : nodeProjections) {
            if (projection.getBase().equals("*")) {
                this.projections.clear();
                return this.processNode(node.subtree);
            }
            String projField = projection.getBase();
            if (projField == null) continue;
            this.projections.add(projField);
        }
        return this.processNode(node.subtree);
    }

    private String processNode(GCQLAndNode node) throws Exception {
        String left = this.processNode(node.left);
        String right = this.processNode(node.right);
        String result = "(" + left + " AND " + right + ")";
        return result;
    }

    private String processNode(GCQLOrNode node) throws Exception {
        String left = this.processNode(node.left);
        String right = this.processNode(node.right);
        String result = "(" + left + " OR " + right + ")";
        return result;
    }

    private String processNode(GCQLNotNode node) throws Exception {
        String left = this.processNode(node.left);
        String right = this.processNode(node.right);
        String result = "(" + left + " NOT " + right + ")";
        return result;
    }

    private String processNode(GCQLTermNode node) throws Exception {
        String idx = node.getIndex();
        String table = null;
        String column = null;
        if (idx.contains(".")) {
            table = idx.substring(0, idx.indexOf("."));
            column = idx;
        } else {
            table = this.defaultTable;
            column = this.defaultTable + "." + idx;
        }
        this.tables.add(table);
        this.columns.add(column);
        String relation = node.getRelation().getBase();
        String sqlRel = null;
        sqlRel = relation.equalsIgnoreCase("==") || relation.equalsIgnoreCase("exact") ? "=" : relation;
        String value = node.getTerm();
        return column + " " + sqlRel + " " + value;
    }
}

