/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.spatial.data.sdi.proxies;

import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.gcube.common.clients.Call;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.spatial.data.sdi.interfaces.Metadata;
import org.gcube.spatial.data.sdi.model.metadata.MetadataPublishOptions;
import org.gcube.spatial.data.sdi.model.metadata.MetadataReport;
import org.gcube.spatial.data.sdi.model.metadata.TemplateCollection;
import org.gcube.spatial.data.sdi.model.metadata.TemplateDescriptor;
import org.glassfish.jersey.media.multipart.BodyPart;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.glassfish.jersey.media.multipart.file.FileDataBodyPart;

public class DefaultMetadata
implements Metadata {
    private final ProxyDelegate<WebTarget> delegate;

    public DefaultMetadata(ProxyDelegate<WebTarget> config) {
        this.delegate = config;
    }

    public TemplateCollection getAvailableTemplates() {
        Call<WebTarget, Set<TemplateDescriptor>> call = new Call<WebTarget, Set<TemplateDescriptor>>(){

            public Set<TemplateDescriptor> call(WebTarget templates) throws Exception {
                GenericType<Set<TemplateDescriptor>> generic = new GenericType<Set<TemplateDescriptor>>(){};
                return (Set)templates.path("list").request(new String[]{"application/json"}).get((GenericType)generic);
            }
        };
        try {
            return new TemplateCollection(new HashSet((Collection)this.delegate.make((Call)call)));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public MetadataReport pushMetadata(File toPublish) {
        return this.pushMetadata(toPublish, new MetadataPublishOptions());
    }

    public MetadataReport pushMetadata(final File toPublish, final MetadataPublishOptions options) {
        Call<WebTarget, MetadataReport> applyTemplatesCall = null;
        Call<WebTarget, MetadataReport> publishCall = null;
        try {
            Call<WebTarget, String> uploadCall = new Call<WebTarget, String>(){

                public String call(WebTarget endpoint) throws Exception {
                    endpoint.register(MultiPartFeature.class);
                    FormDataMultiPart multi = new FormDataMultiPart();
                    FileDataBodyPart fileDataBodyPart = new FileDataBodyPart("theMeta", toPublish, MediaType.APPLICATION_OCTET_STREAM_TYPE);
                    multi.bodyPart((BodyPart)fileDataBodyPart);
                    Response resp = endpoint.request().post(Entity.entity((Object)multi, (MediaType)multi.getMediaType()));
                    DefaultMetadata.this.checkResponse(resp);
                    return (String)resp.readEntity(String.class);
                }
            };
            final String id = (String)this.delegate.make((Call)uploadCall);
            applyTemplatesCall = new Call<WebTarget, MetadataReport>(){

                public MetadataReport call(WebTarget endpoint) throws Exception {
                    Response resp = endpoint.path(id).request(new String[]{"application/json"}).put(Entity.entity(new HashSet(options.getTemplateInvocations()), (String)"application/json"));
                    DefaultMetadata.this.checkResponse(resp);
                    return (MetadataReport)resp.readEntity(MetadataReport.class);
                }
            };
            publishCall = new Call<WebTarget, MetadataReport>(){

                public MetadataReport call(WebTarget endpoint) throws Exception {
                    Response resp = endpoint.path("publish").path(id).path(options.getGeonetworkCategory()).queryParam("validate", new Object[]{options.isValidate()}).queryParam("public", new Object[]{options.isMakePublic()}).queryParam("stylesheet", new Object[]{options.getGeonetworkStyleSheet()}).request(new String[]{"application/json"}).get();
                    DefaultMetadata.this.checkResponse(resp);
                    return (MetadataReport)resp.readEntity(MetadataReport.class);
                }
            };
        }
        catch (Throwable t) {
            throw new RuntimeException("Unable to upload file.", t);
        }
        MetadataReport templateReport = null;
        try {
            if (!options.getTemplateInvocations().isEmpty()) {
                templateReport = (MetadataReport)this.delegate.make((Call)applyTemplatesCall);
            }
        }
        catch (Throwable t) {
            throw new RuntimeException("Unable to apply templates", t);
        }
        try {
            MetadataReport publishReport = (MetadataReport)this.delegate.make((Call)publishCall);
            if (templateReport != null) {
                publishReport.setAppliedTemplates(templateReport.getAppliedTemplates());
            }
            return publishReport;
        }
        catch (Throwable t) {
            throw new RuntimeException("Unable to publish metadata. ", t);
        }
    }

    protected void checkResponse(Response toCheck) throws Exception {
        switch (toCheck.getStatusInfo().getFamily()) {
            case SUCCESSFUL: {
                break;
            }
            default: {
                throw new Exception("Unexpected Response code : " + toCheck.getStatus(), new Exception((String)toCheck.readEntity(String.class)));
            }
        }
    }
}

