/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.spatial.data.sdi;

import io.swagger.jaxrs.config.BeanConfig;
import io.swagger.jaxrs.listing.ApiListingResource;
import io.swagger.jaxrs.listing.SwaggerSerializers;
import java.net.URL;
import javax.ws.rs.ApplicationPath;
import org.gcube.smartgears.ContextProvider;
import org.gcube.smartgears.configuration.container.ContainerConfiguration;
import org.gcube.smartgears.context.application.ApplicationContext;
import org.gcube.spatial.data.sdi.LocalConfiguration;
import org.gcube.spatial.data.sdi.rest.GeoNetwork;
import org.glassfish.jersey.server.ResourceConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationPath(value="SDI-Service")
public class SDIService
extends ResourceConfig {
    private static final Logger log = LoggerFactory.getLogger(SDIService.class);

    public SDIService() {
        this.packages(new String[]{"org.gcube.spatial.data"});
        this.register(ApiListingResource.class);
        this.register(SwaggerSerializers.class);
        ApplicationContext context = ContextProvider.get();
        ContainerConfiguration configuration = context.container().configuration();
        String hostName = configuration.hostname();
        Integer port = configuration.port();
        try {
            URL resourceUrl = context.application().getResource("/WEB-INF/config.properties");
            LocalConfiguration.init((URL)resourceUrl);
        }
        catch (Throwable t) {
            log.debug("Listing available paths");
            for (Object obj : context.application().getResourcePaths("/WEB-INF")) {
                log.debug("OBJ : {} ", obj);
            }
            throw new RuntimeException("Unable to load configuration properties", t);
        }
        BeanConfig beanConfig = new BeanConfig();
        beanConfig.setVersion("1.0.0");
        beanConfig.setSchemes(new String[]{"http", "https"});
        beanConfig.setHost(hostName + ":" + port);
        beanConfig.setBasePath("/gcube/service/");
        beanConfig.setResourcePackage(GeoNetwork.class.getPackage().getName());
        beanConfig.setTitle("SDI Service");
        beanConfig.setDescription("REST Interface towards SDI facilities");
        beanConfig.setPrettyPrint(true);
        beanConfig.setScan(true);
    }
}

