/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.spatial.data.sdi.engine.impl.cache;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.spatial.data.geonetwork.GeoNetworkAdministration;
import org.gcube.spatial.data.geonetwork.configuration.Configuration;
import org.gcube.spatial.data.geonetwork.extension.ServerAccess;
import org.gcube.spatial.data.geonetwork.model.Account;
import org.gcube.spatial.data.geonetwork.model.ScopeConfiguration;
import org.gcube.spatial.data.gis.GISInterface;
import org.gcube.spatial.data.gis.is.AbstractGeoServerDescriptor;
import org.gcube.spatial.data.sdi.engine.impl.cache.GeoNetworkRetriever;
import org.gcube.spatial.data.sdi.engine.impl.cache.ObjectRetriever;
import org.gcube.spatial.data.sdi.engine.impl.faults.ConfigurationNotFoundException;
import org.gcube.spatial.data.sdi.model.credentials.AccessType;
import org.gcube.spatial.data.sdi.model.credentials.Credentials;
import org.gcube.spatial.data.sdi.model.service.GeoNetworkConfiguration;
import org.gcube.spatial.data.sdi.model.service.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class GeoNetworkRetriever
implements ObjectRetriever<GeoNetworkConfiguration> {
    private static final Logger log = LoggerFactory.getLogger(GeoNetworkRetriever.class);

    public GeoNetworkConfiguration getObject() throws ConfigurationNotFoundException {
        try {
            GISInterface gis = GISInterface.get((AbstractGeoServerDescriptor[])new AbstractGeoServerDescriptor[0]);
            GeoNetworkAdministration gnAdmin = (GeoNetworkAdministration)gis.getGeoNewtorkPublisher();
            Configuration config = gnAdmin.getConfiguration();
            Version version = config.getGeoNetworkVersion().equals((Object)ServerAccess.Version.TRE) ? new Version(Integer.valueOf(3), Integer.valueOf(0), Integer.valueOf(0)) : new Version(Integer.valueOf(2), Integer.valueOf(6), Integer.valueOf(0));
            String baseEndpoint = config.getGeoNetworkEndpoint();
            ScopeConfiguration scopeConfig = config.getScopeConfiguration();
            ArrayList<Credentials> accessibleCredentials = new ArrayList<Credentials>();
            for (Account acc : scopeConfig.getAccounts().values()) {
                accessibleCredentials.add(GeoNetworkRetriever.fromGeoNetworkAccount((Account)acc));
            }
            Credentials adminCredentials = GeoNetworkRetriever.fromGeoNetworkAccount((Account)config.getAdminAccount());
            adminCredentials.setAccessType(AccessType.ADMIN);
            accessibleCredentials.add(adminCredentials);
            return new GeoNetworkConfiguration(version, baseEndpoint, accessibleCredentials, scopeConfig.getPrivateGroup() + "", scopeConfig.getPublicGroup() + "", "3");
        }
        catch (Exception e) {
            log.warn("Unable to gather geonetwork information", (Throwable)e);
            throw new ConfigurationNotFoundException("Unable to gather information on geonetwork. Please contact administrator.", (Throwable)e);
        }
    }

    protected static final Credentials fromGeoNetworkAccount(Account toTranslate) {
        switch (1.$SwitchMap$org$gcube$spatial$data$geonetwork$model$Account$Type[toTranslate.getType().ordinal()]) {
            case 1: {
                return new Credentials(toTranslate.getUser(), toTranslate.getPassword(), AccessType.CKAN);
            }
            case 2: {
                return new Credentials(toTranslate.getUser(), toTranslate.getPassword(), AccessType.CONTEXT_USER);
            }
        }
        throw new RuntimeException("Unrecognized account type " + toTranslate);
    }

    protected static final ServiceEndpoint getTheRightServiceEndpoint(List<ServiceEndpoint> resources, String endpointName, String priorityProperty) {
        ServiceEndpoint toReturn = null;
        int priority = 1000;
        for (ServiceEndpoint resource : resources) {
            for (ServiceEndpoint.AccessPoint point : resource.profile().accessPoints()) {
                Map properties;
                log.debug(point.toString());
                if (!point.name().equals(endpointName) || !(properties = point.propertyMap()).containsKey(priorityProperty)) continue;
                int currentPriority = Integer.parseInt(((ServiceEndpoint.Property)properties.get(priorityProperty)).value());
                if (toReturn != null && currentPriority >= priority) continue;
                toReturn = resource;
                priority = currentPriority;
            }
        }
        return toReturn;
    }

    protected static final ServiceEndpoint.AccessPoint getTheRightAccessPoint(ServiceEndpoint resource, String endpointName, String priorityProperty) {
        ServiceEndpoint.AccessPoint toReturn = null;
        int priority = 1000;
        for (ServiceEndpoint.AccessPoint point : resource.profile().accessPoints()) {
            Map properties;
            log.debug(point.toString());
            if (!point.name().equals(endpointName) || !(properties = point.propertyMap()).containsKey(priorityProperty)) continue;
            int currentPriority = Integer.parseInt(((ServiceEndpoint.Property)properties.get(priorityProperty)).value());
            if (toReturn != null && currentPriority >= priority) continue;
            toReturn = point;
            priority = currentPriority;
        }
        return toReturn;
    }
}

