/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.spatial.data.sdi.engine.impl.cache;

import java.util.Collections;
import java.util.List;
import org.gcube.common.resources.gcore.GCoreEndpoint;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.resources.gcore.common.Platform;
import org.gcube.spatial.data.geonetwork.utils.ScopeUtils;
import org.gcube.spatial.data.sdi.LocalConfiguration;
import org.gcube.spatial.data.sdi.engine.impl.cache.ISUtils;
import org.gcube.spatial.data.sdi.engine.impl.cache.ObjectRetriever;
import org.gcube.spatial.data.sdi.engine.impl.faults.ConfigurationNotFoundException;
import org.gcube.spatial.data.sdi.model.credentials.AccessType;
import org.gcube.spatial.data.sdi.model.credentials.Credentials;
import org.gcube.spatial.data.sdi.model.service.ThreddsConfiguration;
import org.gcube.spatial.data.sdi.model.service.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ThreddsRetriever
implements ObjectRetriever<ThreddsConfiguration> {
    private static final Logger log = LoggerFactory.getLogger(ThreddsRetriever.class);

    public ThreddsConfiguration getObject() throws ConfigurationNotFoundException {
        String sePlatform;
        String seCategory;
        List threddsSE;
        log.info("Loading Thredds information from IS. Current Scope is {} ", (Object)ScopeUtils.getCurrentScope());
        LocalConfiguration config = LocalConfiguration.get();
        String geClass = config.getProperty("th.ge.serviceClass");
        String geName = config.getProperty("th.ge.serviceName");
        List gCoreEndpoints = ISUtils.queryForGCoreEndpoint((String)geClass, (String)geName);
        if (gCoreEndpoints != null && !gCoreEndpoints.isEmpty()) {
            log.debug("Found {} GCore Endpoints ", (Object)gCoreEndpoints.size());
            for (int i = 0; i < gCoreEndpoints.size(); ++i) {
                GCoreEndpoint endpoint = (GCoreEndpoint)gCoreEndpoints.get(i);
                try {
                    log.debug("Checking element {}, ID {} ", (Object)i, (Object)endpoint.id());
                    ThreddsConfiguration toReturn = ThreddsRetriever.translate((GCoreEndpoint)endpoint);
                    if (toReturn == null) {
                        throw new Exception("Translated configuration was null");
                    }
                    return toReturn;
                }
                catch (Throwable t) {
                    log.warn("Unable to read retrieved gCore endpoint ID " + endpoint.id(), t);
                    continue;
                }
            }
        }
        if ((threddsSE = ISUtils.queryForServiceEndpoints((String)(seCategory = config.getProperty("th.se.category")), (String)(sePlatform = config.getProperty("th.se.platform")))) != null && !threddsSE.isEmpty()) {
            log.debug("Found {} Service Endpoints ", (Object)threddsSE.size());
            for (int i = 0; i < threddsSE.size(); ++i) {
                ServiceEndpoint endpoint = (ServiceEndpoint)threddsSE.get(i);
                try {
                    log.debug("Checking element {}, ID {} ", (Object)i, (Object)endpoint.id());
                    ThreddsConfiguration toReturn = ThreddsRetriever.translate((ServiceEndpoint)endpoint);
                    if (toReturn == null) {
                        throw new Exception("Translated configuration was null");
                    }
                    return toReturn;
                }
                catch (Throwable t) {
                    log.warn("Unable to read retrieved service endpoint ID " + endpoint.id(), t);
                    continue;
                }
            }
        }
        throw new ConfigurationNotFoundException("Thredds has not been found in current scope " + ScopeUtils.getCurrentScope());
    }

    private static final ThreddsConfiguration translate(GCoreEndpoint toTranslate) {
        return null;
    }

    private static final ThreddsConfiguration translate(ServiceEndpoint toTranslate) {
        Platform platform = toTranslate.profile().platform();
        Version version = new Version(Short.valueOf(platform.version()), platform.minorVersion(), platform.revisionVersion());
        ServiceEndpoint.AccessPoint access = (ServiceEndpoint.AccessPoint)toTranslate.profile().accessPoints().iterator().next();
        Credentials credentials = new Credentials(access.username(), access.password(), AccessType.ADMIN);
        return new ThreddsConfiguration(version, access.address(), Collections.singletonList(credentials));
    }
}

