/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.spatial.data.sdi.engine.impl;

import javax.inject.Inject;
import javax.inject.Singleton;
import org.gcube.spatial.data.geonetwork.utils.ScopeUtils;
import org.gcube.spatial.data.sdi.engine.GISManager;
import org.gcube.spatial.data.sdi.engine.GeoNetworkManager;
import org.gcube.spatial.data.sdi.engine.SDIManager;
import org.gcube.spatial.data.sdi.engine.ThreddsManager;
import org.gcube.spatial.data.sdi.engine.impl.SDIManagerImpl;
import org.gcube.spatial.data.sdi.engine.impl.faults.InvalidServiceDefinitionException;
import org.gcube.spatial.data.sdi.engine.impl.faults.ServiceRegistrationException;
import org.gcube.spatial.data.sdi.model.ScopeConfiguration;
import org.gcube.spatial.data.sdi.model.health.HealthReport;
import org.gcube.spatial.data.sdi.model.health.Level;
import org.gcube.spatial.data.sdi.model.health.ServiceHealthReport;
import org.gcube.spatial.data.sdi.model.services.GeoNetworkServiceDefinition;
import org.gcube.spatial.data.sdi.model.services.GeoServerDefinition;
import org.gcube.spatial.data.sdi.model.services.ServiceDefinition;
import org.gcube.spatial.data.sdi.model.services.ThreddsDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SDIManagerImpl
implements SDIManager {
    private static final Logger log = LoggerFactory.getLogger(SDIManagerImpl.class);
    GeoNetworkManager geonetworkManager;
    ThreddsManager threddsManager;
    GISManager gisManager;

    @Inject
    public SDIManagerImpl(GeoNetworkManager geonetworkManager, ThreddsManager threddsManager, GISManager gisManager) {
        this.geonetworkManager = geonetworkManager;
        this.threddsManager = threddsManager;
        this.gisManager = gisManager;
    }

    public ScopeConfiguration getContextConfiguration() {
        ScopeConfiguration toReturn = new ScopeConfiguration();
        toReturn.setContextName(ScopeUtils.getCurrentScopeName());
        try {
            toReturn.setGeonetworkConfiguration(this.geonetworkManager.getConfiguration());
        }
        catch (Exception e) {
            log.warn("Scope is not well configured. Missing GeoNetwork. ", (Throwable)e);
        }
        try {
            toReturn.setThreddsConfiguration(this.threddsManager.getConfiguration());
        }
        catch (Exception e) {
            log.warn("THREDDS not found in current scope {} ", (Object)ScopeUtils.getCurrentScope());
        }
        try {
            toReturn.setGeoserverClusterConfiguration(this.gisManager.getConfiguration());
        }
        catch (Exception e) {
            log.warn("GeoServer not found in current scope {} ", (Object)ScopeUtils.getCurrentScope());
        }
        return toReturn;
    }

    public String toString() {
        return super.toString();
    }

    public HealthReport getHealthReport() {
        HealthReport report = new HealthReport();
        report.setContext(ScopeUtils.getCurrentScope());
        ServiceHealthReport threddsReport = this.threddsManager.getHealthReport();
        report.setThredds(threddsReport);
        ServiceHealthReport gnReport = this.geonetworkManager.getHealthReport();
        report.setGeonetwork(gnReport);
        ServiceHealthReport gsReport = this.gisManager.getHealthReport();
        report.setGeoserverCluster(gsReport);
        Level overall = Level.OK;
        if (threddsReport.getOverallStatus().equals((Object)Level.ERROR) || gnReport.getOverallStatus().equals((Object)Level.ERROR) || gsReport.getOverallStatus().equals((Object)Level.ERROR)) {
            overall = Level.ERROR;
        } else if (threddsReport.getOverallStatus().equals((Object)Level.WARNING) || gnReport.getOverallStatus().equals((Object)Level.WARNING) || gsReport.getOverallStatus().equals((Object)Level.WARNING)) {
            overall = Level.WARNING;
        }
        report.setOverallStatus(overall);
        log.debug("Returning report : {} ", (Object)report);
        return report;
    }

    public String registerService(ServiceDefinition definition) throws ServiceRegistrationException {
        try {
            switch (1.$SwitchMap$org$gcube$spatial$data$sdi$model$services$ServiceDefinition$Type[definition.getType().ordinal()]) {
                case 1: {
                    return this.geonetworkManager.registerService((GeoNetworkServiceDefinition)definition);
                }
                case 2: {
                    return this.gisManager.registerService((GeoServerDefinition)definition);
                }
                case 3: {
                    return this.threddsManager.registerService((ThreddsDefinition)definition);
                }
            }
            throw new InvalidServiceDefinitionException("Unable to register. Invalid service type. Definition was " + definition);
        }
        catch (ClassCastException e) {
            throw new InvalidServiceDefinitionException("Unable to register. Incoherent service type. Definition was " + definition);
        }
    }

    public String importService(String sourceToken, String host, ServiceDefinition.Type expectedType) throws ServiceRegistrationException {
        switch (1.$SwitchMap$org$gcube$spatial$data$sdi$model$services$ServiceDefinition$Type[expectedType.ordinal()]) {
            case 1: {
                return this.geonetworkManager.importHostFromToken(sourceToken, host);
            }
            case 2: {
                return this.gisManager.importHostFromToken(sourceToken, host);
            }
            case 3: {
                return this.threddsManager.importHostFromToken(sourceToken, host);
            }
        }
        throw new InvalidServiceDefinitionException("Unable to register. Invalid service type " + expectedType);
    }
}

