/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.spatial.data.sdi.engine.impl.is;

import java.util.concurrent.ConcurrentHashMap;
import org.gcube.spatial.data.geonetwork.utils.ScopeUtils;
import org.gcube.spatial.data.sdi.engine.impl.faults.ConfigurationNotFoundException;
import org.gcube.spatial.data.sdi.engine.impl.is.CachedObject;
import org.gcube.spatial.data.sdi.engine.impl.is.ISModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Cache<T> {
    private static final Logger log = LoggerFactory.getLogger(Cache.class);
    private long objectsTTL;
    private ConcurrentHashMap<String, CachedObject<T>> theCache;
    private ISModule<T> retriever;
    private String cacheName;

    private Cache(long objectsTTL, ISModule<T> retriever, String cacheName) {
        this.objectsTTL = objectsTTL;
        this.retriever = retriever;
        this.cacheName = cacheName;
        this.theCache = new ConcurrentHashMap();
    }

    public synchronized T get() throws ConfigurationNotFoundException {
        String key = ScopeUtils.getCurrentScope();
        log.info("Getting object from cache{} , key is {} ", (Object)this.cacheName, (Object)key);
        if (!this.theCache.containsKey(key) || !((CachedObject)this.theCache.get(key)).isValid(this.objectsTTL)) {
            this.theCache.put(key, new CachedObject(this.retriever.getObject()));
        }
        return (T)((CachedObject)this.theCache.get(key)).getTheObject();
    }

    public void invalidate() {
        String key = ScopeUtils.getCurrentScope();
        log.info("Invalidating cache {} under scope {} ", (Object)this.cacheName, (Object)key);
        if (this.theCache.containsKey(key)) {
            ((CachedObject)this.theCache.get(key)).invalidate();
        }
    }

    public void invalidateAll() {
        for (CachedObject obj : this.theCache.values()) {
            obj.invalidate();
        }
    }

    public static <T> Cache<T> getCache(ISModule<T> retriever, long objectsTTL, String cacheName) {
        return new Cache(objectsTTL, retriever, cacheName);
    }
}

