/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.spatial.data.sdi.engine.impl.is;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.resources.gcore.GCoreEndpoint;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.resources.gcore.common.Platform;
import org.gcube.spatial.data.geonetwork.utils.ScopeUtils;
import org.gcube.spatial.data.sdi.LocalConfiguration;
import org.gcube.spatial.data.sdi.engine.impl.faults.InvalidServiceDefinitionException;
import org.gcube.spatial.data.sdi.engine.impl.faults.ServiceRegistrationException;
import org.gcube.spatial.data.sdi.engine.impl.is.ISModule;
import org.gcube.spatial.data.sdi.engine.impl.is.ISUtils;
import org.gcube.spatial.data.sdi.model.health.Level;
import org.gcube.spatial.data.sdi.model.health.ServiceHealthReport;
import org.gcube.spatial.data.sdi.model.health.Status;
import org.gcube.spatial.data.sdi.model.services.ServiceDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractISModule<T>
implements ISModule<T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractISModule.class);
    private final Object $lock = new Object[0];

    protected abstract String getGCoreEndpointServiceClass();

    protected abstract String getGCoreEndpointServiceName();

    protected abstract String getServiceEndpointAccessPointName();

    protected abstract String getServiceEndpointCategory();

    protected abstract String getServiceEndpointPlatformName();

    protected abstract String getManagedServiceType();

    public ServiceHealthReport getHealthReport() {
        ArrayList<Status> checkStatuses = new ArrayList<Status>();
        try {
            String hostname;
            log.trace("Checking {} heatlh under context {} ", (Object)this.getManagedServiceType(), (Object)ScopeUtils.getCurrentScope());
            List gCoreEndpoints = this.getGcoreEndpoints();
            List serviceEndpoints = this.getServiceEndpoints();
            log.debug("Found {} GC Endpoints and {} SE Endpoints", (Object)gCoreEndpoints.size(), (Object)serviceEndpoints.size());
            if (serviceEndpoints.isEmpty()) {
                if (gCoreEndpoints.isEmpty()) {
                    checkStatuses.add(new Status("No " + this.getManagedServiceType() + " found in context " + ScopeUtils.getCurrentScope(), Level.ERROR));
                } else {
                    checkStatuses.add(new Status("Unregistered " + this.getManagedServiceType() + " instances found. Check following messages", Level.ERROR));
                }
            }
            for (GCoreEndpoint gc : gCoreEndpoints) {
                hostname = ((GCoreEndpoint.Profile.Endpoint)gc.profile().endpoints().iterator().next()).uri().getHost();
                if (ISUtils.getByHostnameInCollection((String)hostname, (Collection)serviceEndpoints) != null) continue;
                String msg = "Found unregistered " + this.getManagedServiceType() + " hosted on " + hostname;
                log.debug(msg);
                checkStatuses.add(new Status(msg, Level.WARNING));
            }
            for (ServiceEndpoint se : serviceEndpoints) {
                try {
                    hostname = se.profile().runtime().hostedOn();
                    GCoreEndpoint found = (GCoreEndpoint)ISUtils.getByHostnameInCollection((String)hostname, (Collection)gCoreEndpoints);
                    if (found == null) {
                        checkStatuses.add(new Status("Service endpoint [name = " + se.profile().name() + ", host = " + hostname + " ID = " + se.id() + "] found but no related GC is present.", Level.ERROR));
                    } else {
                        String status;
                        switch (status = found.profile().deploymentData().status()) {
                            case "unreachable": 
                            case "down": {
                                checkStatuses.add(new Status("GCoreEndpoint [ID " + found.id() + "] for instance hosted on " + hostname + " has status : " + status, Level.ERROR));
                                break;
                            }
                        }
                    }
                    checkStatuses.addAll(this.performInstanceCheck(se));
                }
                catch (Throwable t) {
                    log.error("Unable to perform checks on SE " + se.id(), t);
                    checkStatuses.add(new Status("Internal error while checking " + this.getManagedServiceType() + " [SE ID : " + se.id() + "]." + t.getMessage(), Level.ERROR));
                }
            }
        }
        catch (Throwable t) {
            log.error("Unable to perform checks", t);
            checkStatuses.add(new Status("Internal error while checking " + this.getManagedServiceType() + " Status.", Level.ERROR));
        }
        return new ServiceHealthReport(checkStatuses);
    }

    protected abstract List<Status> performInstanceCheck(ServiceEndpoint var1);

    protected List<GCoreEndpoint> getGcoreEndpoints() {
        String geClass = this.getGCoreEndpointServiceClass();
        String geName = this.getGCoreEndpointServiceName();
        return ISUtils.queryForGCoreEndpoint((String)geClass, (String)geName);
    }

    protected List<ServiceEndpoint> getServiceEndpoints() {
        String seCategory = this.getServiceEndpointCategory();
        String sePlatform = this.getServiceEndpointPlatformName();
        return ISUtils.queryForServiceEndpoints((String)seCategory, (String)sePlatform);
    }

    public String importHostFromToken(String sourceToken, String host) throws ServiceRegistrationException {
        log.trace("Importing host {} from token {} ", (Object)host, (Object)sourceToken);
        String callerScope = ScopeUtils.getCurrentScope();
        String callerToken = SecurityTokenProvider.instance.get();
        try {
            List existingSEs = ISUtils.querySEByHostname((String)this.getServiceEndpointCategory(), (String)this.getServiceEndpointPlatformName(), (String)host);
            if (existingSEs.size() > 0) {
                throw new ServiceRegistrationException("HOST " + host + " is already registered in current scope with ID : " + ((ServiceEndpoint)existingSEs.get(0)).id());
            }
            SecurityTokenProvider.instance.set(sourceToken);
            log.debug("Source token {} is from scope {}.", (Object)sourceToken, (Object)ScopeUtils.getCurrentScope());
            List foundSEs = ISUtils.querySEByHostname((String)this.getServiceEndpointCategory(), (String)this.getServiceEndpointPlatformName(), (String)host);
            if (foundSEs.size() > 1) {
                throw new ServiceRegistrationException("Too many ServiceEndpoints found with hostname " + host);
            }
            if (foundSEs.isEmpty()) {
                throw new ServiceRegistrationException("No ServiceEndpoints found with hostname " + host);
            }
            ServiceEndpoint toImportSE = (ServiceEndpoint)foundSEs.get(0);
            GCoreEndpoint toImportGC = (GCoreEndpoint)ISUtils.getByHostnameInCollection((String)host, (Collection)this.getGcoreEndpoints());
            if (toImportGC == null) {
                throw new ServiceRegistrationException("No GCoreEndpoint found for hostname " + host);
            }
            try {
                log.debug("Registering resources to caller scope {} ", (Object)callerScope);
                String string = ISUtils.addToScope((ServiceEndpoint)toImportSE, (GCoreEndpoint)toImportGC, (String)callerScope);
                return string;
            }
            catch (Exception e) {
                throw new ServiceRegistrationException("Unable to register resources", (Throwable)e);
            }
        }
        finally {
            if (!SecurityTokenProvider.instance.get().equals(callerToken)) {
                SecurityTokenProvider.instance.set(callerToken);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String registerService(ServiceDefinition definition) throws ServiceRegistrationException {
        Object object = this.$lock;
        synchronized (object) {
            log.info("Registering {} ", (Object)definition);
            log.debug("Checking definition type..");
            this.checkDefinitionType(definition);
            log.debug("Checking IS ..");
            this.checkDefinition(definition);
            log.debug("Performing type specific checks..");
            this.checkDefinitionForServiceType(definition);
            log.debug("Preparing ServiceEndpoint.. ");
            ServiceEndpoint ep = this.prepareEndpoint(definition);
            log.debug("Publishing resource..");
            String id = ISUtils.registerService((ServiceEndpoint)ep);
            List registered = null;
            long registrationTime = System.currentTimeMillis();
            long timeout = Long.parseLong(LocalConfiguration.get().getProperty("is.registration.timeout"));
            do {
                log.debug("Waiting for IS to update. Passed {} ms.", (Object)(System.currentTimeMillis() - registrationTime));
                try {
                    Thread.sleep(500L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            } while ((registered = ISUtils.queryById((String)id)).isEmpty() && System.currentTimeMillis() - registrationTime <= timeout);
            if (registered.isEmpty()) {
                log.warn("Registered resource [ID :{}] was not found before Timeout of {} ms. Returning id. ", (Object)id, (Object)timeout);
                return id;
            }
            return (String)registered.get(0);
        }
    }

    protected abstract void checkDefinitionForServiceType(ServiceDefinition var1) throws InvalidServiceDefinitionException;

    protected abstract void checkDefinitionType(ServiceDefinition var1) throws InvalidServiceDefinitionException;

    protected void checkDefinition(ServiceDefinition definition) throws ServiceRegistrationException {
        List serviceEndpoints;
        String hostname = definition.getHostname();
        ServiceEndpoint existing = (ServiceEndpoint)ISUtils.getByHostnameInCollection((String)hostname, (Collection)(serviceEndpoints = this.getServiceEndpoints()));
        if (existing != null) {
            throw new ServiceRegistrationException("Service is already registered");
        }
        List gCoreNodes = this.getGcoreEndpoints();
        GCoreEndpoint running = (GCoreEndpoint)ISUtils.getByHostnameInCollection((String)hostname, (Collection)gCoreNodes);
        if (running == null) {
            throw new ServiceRegistrationException("No GCoreEndpoint found for " + definition);
        }
    }

    protected ServiceEndpoint prepareEndpoint(ServiceDefinition definition) {
        ServiceEndpoint toCreate = new ServiceEndpoint();
        ServiceEndpoint.Profile profile = toCreate.newProfile();
        profile.category(this.getServiceEndpointCategory());
        profile.description(definition.getDescription());
        Platform platform = profile.newPlatform();
        platform.name(this.getServiceEndpointPlatformName()).version(definition.getMajorVersion().shortValue()).minorVersion(definition.getMinorVersion().shortValue()).revisionVersion(definition.getReleaseVersion().shortValue());
        ServiceEndpoint.Runtime runtime = profile.newRuntime();
        runtime.hostedOn(definition.getHostname());
        GCoreEndpoint relatedGHN = (GCoreEndpoint)ISUtils.getByHostnameInCollection((String)definition.getHostname(), (Collection)this.getGcoreEndpoints());
        runtime.ghnId(relatedGHN.id());
        runtime.status("READY");
        return toCreate;
    }
}

