/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.spatial.data.sdi.engine.impl.is;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.spatial.data.geonetwork.GeoNetworkAdministration;
import org.gcube.spatial.data.geonetwork.configuration.Configuration;
import org.gcube.spatial.data.geonetwork.extension.ServerAccess;
import org.gcube.spatial.data.geonetwork.model.Account;
import org.gcube.spatial.data.geonetwork.model.ScopeConfiguration;
import org.gcube.spatial.data.gis.GISInterface;
import org.gcube.spatial.data.gis.is.AbstractGeoServerDescriptor;
import org.gcube.spatial.data.sdi.LocalConfiguration;
import org.gcube.spatial.data.sdi.engine.impl.faults.ConfigurationNotFoundException;
import org.gcube.spatial.data.sdi.engine.impl.faults.InvalidServiceDefinitionException;
import org.gcube.spatial.data.sdi.engine.impl.is.AbstractISModule;
import org.gcube.spatial.data.sdi.engine.impl.is.GeoNetworkRetriever;
import org.gcube.spatial.data.sdi.model.credentials.AccessType;
import org.gcube.spatial.data.sdi.model.credentials.Credentials;
import org.gcube.spatial.data.sdi.model.health.Status;
import org.gcube.spatial.data.sdi.model.service.GeoNetworkConfiguration;
import org.gcube.spatial.data.sdi.model.service.Version;
import org.gcube.spatial.data.sdi.model.services.GeoNetworkServiceDefinition;
import org.gcube.spatial.data.sdi.model.services.ServiceDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class GeoNetworkRetriever
extends AbstractISModule<GeoNetworkConfiguration> {
    private static final Logger log = LoggerFactory.getLogger(GeoNetworkRetriever.class);

    public GeoNetworkConfiguration getObject() throws ConfigurationNotFoundException {
        try {
            GISInterface gis = GISInterface.get((AbstractGeoServerDescriptor[])new AbstractGeoServerDescriptor[0]);
            GeoNetworkAdministration gnAdmin = (GeoNetworkAdministration)gis.getGeoNewtorkPublisher();
            Configuration config = gnAdmin.getConfiguration();
            Version version = config.getGeoNetworkVersion().equals((Object)ServerAccess.Version.TRE) ? new Version(Integer.valueOf(3), Integer.valueOf(0), Integer.valueOf(0)) : new Version(Integer.valueOf(2), Integer.valueOf(6), Integer.valueOf(0));
            String baseEndpoint = config.getGeoNetworkEndpoint();
            ScopeConfiguration scopeConfig = config.getScopeConfiguration();
            ArrayList<Credentials> accessibleCredentials = new ArrayList<Credentials>();
            for (Account acc : scopeConfig.getAccounts().values()) {
                accessibleCredentials.add(GeoNetworkRetriever.fromGeoNetworkAccount((Account)acc));
            }
            Credentials adminCredentials = GeoNetworkRetriever.fromGeoNetworkAccount((Account)config.getAdminAccount());
            adminCredentials.setAccessType(AccessType.ADMIN);
            accessibleCredentials.add(adminCredentials);
            return new GeoNetworkConfiguration(version, baseEndpoint, accessibleCredentials, scopeConfig.getPrivateGroup() + "", scopeConfig.getPublicGroup() + "", "3");
        }
        catch (Exception e) {
            log.warn("Unable to gather geonetwork information", (Throwable)e);
            throw new ConfigurationNotFoundException("Unable to gather information on geonetwork. Please contact administrator.", (Throwable)e);
        }
    }

    protected static final Credentials fromGeoNetworkAccount(Account toTranslate) {
        switch (1.$SwitchMap$org$gcube$spatial$data$geonetwork$model$Account$Type[toTranslate.getType().ordinal()]) {
            case 1: {
                return new Credentials(toTranslate.getUser(), toTranslate.getPassword(), AccessType.CKAN);
            }
            case 2: {
                return new Credentials(toTranslate.getUser(), toTranslate.getPassword(), AccessType.CONTEXT_USER);
            }
        }
        throw new RuntimeException("Unrecognized account type " + toTranslate);
    }

    protected static final ServiceEndpoint getTheRightServiceEndpoint(List<ServiceEndpoint> resources, String endpointName, String priorityProperty) {
        ServiceEndpoint toReturn = null;
        int priority = 1000;
        for (ServiceEndpoint resource : resources) {
            for (ServiceEndpoint.AccessPoint point : resource.profile().accessPoints()) {
                Map properties;
                log.debug(point.toString());
                if (!point.name().equals(endpointName) || !(properties = point.propertyMap()).containsKey(priorityProperty)) continue;
                int currentPriority = Integer.parseInt(((ServiceEndpoint.Property)properties.get(priorityProperty)).value());
                if (toReturn != null && currentPriority >= priority) continue;
                toReturn = resource;
                priority = currentPriority;
            }
        }
        return toReturn;
    }

    protected static final ServiceEndpoint.AccessPoint getTheRightAccessPoint(ServiceEndpoint resource, String endpointName, String priorityProperty) {
        ServiceEndpoint.AccessPoint toReturn = null;
        int priority = 1000;
        for (ServiceEndpoint.AccessPoint point : resource.profile().accessPoints()) {
            Map properties;
            log.debug(point.toString());
            if (!point.name().equals(endpointName) || !(properties = point.propertyMap()).containsKey(priorityProperty)) continue;
            int currentPriority = Integer.parseInt(((ServiceEndpoint.Property)properties.get(priorityProperty)).value());
            if (toReturn != null && currentPriority >= priority) continue;
            toReturn = point;
            priority = currentPriority;
        }
        return toReturn;
    }

    protected String getGCoreEndpointServiceClass() {
        return LocalConfiguration.get().getProperty("gn.ge.serviceClass");
    }

    protected String getGCoreEndpointServiceName() {
        return LocalConfiguration.get().getProperty("gn.ge.serviceName");
    }

    protected String getManagedServiceType() {
        return "GeoNetwork";
    }

    protected String getServiceEndpointCategory() {
        return LocalConfiguration.get().getProperty("gn.se.category");
    }

    protected String getServiceEndpointPlatformName() {
        return LocalConfiguration.get().getProperty("gn.se.platform");
    }

    protected String getServiceEndpointAccessPointName() {
        return LocalConfiguration.get().getProperty("gn.se.endpointName");
    }

    protected List<Status> performInstanceCheck(ServiceEndpoint se) {
        return Collections.EMPTY_LIST;
    }

    protected void checkDefinitionForServiceType(ServiceDefinition definition) {
        log.info("Checking geonetwork for {} ", (Object)definition);
    }

    protected ServiceEndpoint prepareEndpoint(ServiceDefinition definition) {
        ServiceEndpoint toReturn = super.prepareEndpoint(definition);
        GeoNetworkServiceDefinition gnDefinition = (GeoNetworkServiceDefinition)definition;
        ServiceEndpoint.AccessPoint point = new ServiceEndpoint.AccessPoint();
        point.address("http://" + definition.getHostname() + "/geonetwork");
        point.credentials(definition.getAdminPassword(), "admin");
        point.description("Main Access point");
        point.name(this.getServiceEndpointAccessPointName());
        ServiceEndpoint.Property priorityProperty = new ServiceEndpoint.Property();
        priorityProperty.nameAndValue("priority", gnDefinition.getPriority() + "");
        point.properties().add((Object)priorityProperty);
        ServiceEndpoint.Property suffixesProperty = new ServiceEndpoint.Property();
        suffixesProperty.nameAndValue("suffixes", " ");
        point.properties().add((Object)suffixesProperty);
        toReturn.profile().accessPoints().add((Object)point);
        return toReturn;
    }

    protected void checkDefinitionType(ServiceDefinition definition) throws InvalidServiceDefinitionException {
        if (!definition.getType().equals((Object)ServiceDefinition.Type.GEONETWORK) || !(definition instanceof GeoNetworkServiceDefinition)) {
            throw new InvalidServiceDefinitionException("Invalid service type [expected " + ServiceDefinition.Type.GEONETWORK + "]. Definition was " + definition);
        }
    }
}

