/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.spatial.data.sdi.engine.impl.is;

import java.security.Key;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.gcube.common.encryption.StringEncrypter;
import org.gcube.common.resources.gcore.GCoreEndpoint;
import org.gcube.common.resources.gcore.Resource;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.informationsystem.publisher.RegistryPublisher;
import org.gcube.informationsystem.publisher.RegistryPublisherFactory;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.QueryBox;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.gcube.spatial.data.geonetwork.utils.ScopeUtils;
import org.gcube.vremanagement.resourcemanager.client.RMBinderLibrary;
import org.gcube.vremanagement.resourcemanager.client.exceptions.InvalidScopeException;
import org.gcube.vremanagement.resourcemanager.client.exceptions.ResourcesCreationException;
import org.gcube.vremanagement.resourcemanager.client.fws.Types;
import org.gcube.vremanagement.resourcemanager.client.proxies.Proxies;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ISUtils {
    private static final Logger log = LoggerFactory.getLogger(ISUtils.class);

    static List<ServiceEndpoint> queryForServiceEndpoints(String category, String platformName) {
        log.debug("Querying for Service Endpoints [category : {} , platformName : {}, currentScope : {} ]", new Object[]{category, platformName, ScopeUtils.getCurrentScope()});
        XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
        query.addCondition("$resource/Profile/Category/text() eq '" + category + "'").addCondition("$resource/Profile/Platform/Name/text() eq '" + platformName + "'");
        DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.class);
        return client.submit((Query)query);
    }

    static List<GCoreEndpoint> queryForGCoreEndpoint(String serviceClass, String serviceName) {
        log.debug("Querying for GCore Endpoints [ServiceClass : {} , ServiceName : {}, currentScope : {} ]", new Object[]{serviceClass, serviceName, ScopeUtils.getCurrentScope()});
        XQuery query = ICFactory.queryFor(GCoreEndpoint.class);
        query.addCondition("$resource/Profile/ServiceClass/text() eq '" + serviceClass + "'").addCondition("$resource/Profile/ServiceName/text() eq '" + serviceName + "'");
        DiscoveryClient client = ICFactory.clientFor(GCoreEndpoint.class);
        return client.submit((Query)query);
    }

    static <T> T getByHostnameInCollection(String hostname, Collection<T> toCheckList) {
        for (T gc : toCheckList) {
            if (!(gc instanceof GCoreEndpoint ? ((GCoreEndpoint.Profile.Endpoint)((GCoreEndpoint)gc).profile().endpoints().iterator().next()).uri().getHost().equals(hostname) : ((ServiceEndpoint)gc).profile().runtime().hostedOn().equals(hostname))) continue;
            return gc;
        }
        return null;
    }

    static List<ServiceEndpoint> querySEByHostname(String category, String platformName, String hostname) {
        log.debug("Querying Service Endpoints by hostname [category : {} , platformName : {}, currentScope : {}, hostname {} ]", new Object[]{category, platformName, ScopeUtils.getCurrentScope(), hostname});
        XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
        query.addCondition("$resource/Profile/Category/text() eq '" + category + "'").addCondition("$resource/Profile/Platform/Name/text() eq '" + platformName + "'").addCondition("$resource/Profile/Runtime/HostedOn/text() eq '" + hostname + "'");
        DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.class);
        return client.submit((Query)query);
    }

    static List<String> queryById(String id) {
        DiscoveryClient client = ICFactory.client();
        String queryString = "declare namespace ic = 'http://gcube-system.org/namespaces/informationsystem/registry'; for $profiles in collection('/db/Profiles')//Document/Data/ic:Profile/Resource where $profiles/ID/text() eq '" + id + "' return $profiles";
        return client.submit((Query)new QueryBox(queryString));
    }

    static String registerService(ServiceEndpoint toRegister) {
        RegistryPublisher rp = RegistryPublisherFactory.create();
        Resource r = rp.create((Resource)toRegister);
        return r.id();
    }

    static String addToScope(ServiceEndpoint se, GCoreEndpoint gc, String targetScope) throws ResourcesCreationException, InvalidScopeException {
        log.trace("Publishing GC [ID : {}, Sc : {}, Sn {}, GHN-ID : {} ], SE [ID : {}, name : {}] to Scope {} from Scope {}", new Object[]{gc.id(), gc.profile().serviceClass(), gc.profile().serviceName(), gc.profile().ghnId(), se.id(), se.profile().name(), targetScope, ScopeUtils.getCurrentScope()});
        Types.AddResourcesParameters params = new Types.AddResourcesParameters();
        Types.ResourceList resourceList = new Types.ResourceList();
        ArrayList<Types.ResourceItem> list = new ArrayList<Types.ResourceItem>();
        Types.ResourceItem ghnItem = new Types.ResourceItem();
        ghnItem.id = gc.profile().ghnId();
        ghnItem.type = "GHN";
        list.add(ghnItem);
        Types.ResourceItem geItem = new Types.ResourceItem();
        geItem.id = gc.id();
        geItem.type = "RunningInstance";
        list.add(geItem);
        Types.ResourceItem seItem = new Types.ResourceItem();
        seItem.id = se.id();
        seItem.type = "RuntimeResource";
        list.add(seItem);
        resourceList.setResource(list);
        params.setTargetScope(targetScope);
        params.setResources(resourceList);
        RMBinderLibrary library = (RMBinderLibrary)Proxies.binderService().build();
        return library.addResources(params);
    }

    static String decryptString(String toDecrypt) {
        try {
            return StringEncrypter.getEncrypter().decrypt(toDecrypt, new Key[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to decrypt.", e);
        }
    }
}

