/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.spatial.data.sdi.engine.impl.metadata.templates;

import java.util.ArrayList;
import java.util.List;
import org.gcube.spatial.data.sdi.engine.impl.metadata.MetadataHandler;
import org.gcube.spatial.data.sdi.engine.impl.metadata.MetadataUtils;
import org.gcube.spatial.data.sdi.engine.impl.metadata.templates.AbstractTemplate;
import org.gcube.spatial.data.sdi.engine.impl.metadata.templates.InvalidTemplateInvocationException;
import org.gcube.spatial.data.sdi.engine.impl.metadata.templates.ThreddsOnlineTemplate;
import org.gcube.spatial.data.sdi.model.metadata.ParameterType;
import org.gcube.spatial.data.sdi.model.metadata.TemplateDescriptor;
import org.gcube.spatial.data.sdi.model.metadata.TemplateInvocation;

public class ThreddsOnlineTemplate
extends AbstractTemplate<ThreddsOnlineRequest> {
    private static ArrayList<ParameterType> EXPECTED_PARAMETERS = new ArrayList();
    private static String TEMPLATE_ID = "THREDDS_ONLINE_RESOURCES";
    private static String TEMPLATE_NAME = "Thredds Online Resources";
    private static String FILENAME = "ThreddsOnlineResources.ftlx";
    private static AbstractTemplate.InsertionPoint INSERTION = new AbstractTemplate.InsertionPoint(MetadataUtils.Position.sibling_after, "//gmd:identificationInfo");
    private static TemplateDescriptor DESCRIPTOR;

    public ThreddsOnlineTemplate() {
        super(FILENAME, INSERTION, DESCRIPTOR);
    }

    public ThreddsOnlineRequest getInstantiationRequest(MetadataHandler handler, TemplateInvocation invocation) throws InvalidTemplateInvocationException, Exception {
        if (!invocation.getToInvokeTemplateID().equals(TEMPLATE_ID)) {
            throw new InvalidTemplateInvocationException("Invalid template ID : " + invocation.getToInvokeTemplateID());
        }
        String filename = this.getParameter("filename", (List)invocation.getTemplateParameters(), true, null);
        String catalog = this.getParameter("catalog", (List)invocation.getTemplateParameters(), true, null);
        String hostname = this.getParameter("hostname", (List)invocation.getTemplateParameters(), true, null);
        String uuid = handler.getUUID();
        String gisLink = MetadataUtils.getGisLinkByUUID((String)uuid);
        return new ThreddsOnlineRequest(hostname, catalog, filename, gisLink);
    }

    static {
        EXPECTED_PARAMETERS.add(new ParameterType("catalog", "The thredds catalog name"));
        EXPECTED_PARAMETERS.add(new ParameterType("filename", "The dataset's file name"));
        EXPECTED_PARAMETERS.add(new ParameterType("hostname", "Thredds hostname"));
        DESCRIPTOR = new TemplateDescriptor(TEMPLATE_ID, TEMPLATE_NAME, "Template for online resources exposed by thredds.", "http://sdi-d4s.d4science.org", EXPECTED_PARAMETERS);
    }
}

