/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.spatial.data.sdi.engine.impl;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Singleton;
import org.gcube.spatial.data.sdi.engine.RoleManager;
import org.gcube.spatial.data.sdi.model.credentials.AccessType;
import org.gcube.spatial.data.sdi.model.credentials.Credentials;
import org.gcube.spatial.data.sdi.model.service.GeoServiceDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class RoleManagerImpl
implements RoleManager {
    private static final Logger log = LoggerFactory.getLogger(RoleManagerImpl.class);

    public Credentials getMostAccessible(List<Credentials> toFilter, boolean considerAdmin) {
        AccessType maxLevel = this.getMaxLevel(considerAdmin);
        Credentials toReturn = null;
        for (Credentials cred : toFilter) {
            if (cred.getAccessType().compareTo((Enum)maxLevel) < 0 || toReturn != null && cred.getAccessType().compareTo((Enum)toReturn.getAccessType()) >= 0) continue;
            toReturn = cred;
        }
        return toReturn;
    }

    public <T extends GeoServiceDescriptor> List<T> filterByRole(List<T> toFilter, boolean considerAdmin) {
        ArrayList toReturn = new ArrayList();
        AccessType maxLevel = this.getMaxLevel(considerAdmin);
        for (GeoServiceDescriptor geoServiceDescriptor : toFilter) {
        }
        return toReturn;
    }

    private AccessType getMaxLevel(boolean considerAdmin) {
        return considerAdmin ? AccessType.ADMIN : AccessType.CONTEXT_MANAGER;
    }
}

