/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.spatial.data.sdi.engine.impl;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.gcube.data.transfer.model.plugins.thredds.ThreddsCatalog;
import org.gcube.data.transfer.model.plugins.thredds.ThreddsInfo;
import org.gcube.spatial.data.sdi.LocalConfiguration;
import org.gcube.spatial.data.sdi.engine.TemplateManager;
import org.gcube.spatial.data.sdi.engine.ThreddsManager;
import org.gcube.spatial.data.sdi.engine.impl.AbstractManager;
import org.gcube.spatial.data.sdi.engine.impl.cluster.AbstractCluster;
import org.gcube.spatial.data.sdi.engine.impl.cluster.ThreddsCluster;
import org.gcube.spatial.data.sdi.engine.impl.cluster.ThreddsController;
import org.gcube.spatial.data.sdi.engine.impl.faults.ConfigurationNotFoundException;
import org.gcube.spatial.data.sdi.engine.impl.faults.ThreddsOperationFault;
import org.gcube.spatial.data.sdi.engine.impl.is.ISModule;
import org.gcube.spatial.data.sdi.engine.impl.is.ThreddsRetriever;
import org.gcube.spatial.data.sdi.model.service.ThreddsDescriptor;
import org.gcube.spatial.data.sdi.model.services.ThreddsDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ThreddsManagerImpl
extends AbstractManager<ThreddsDescriptor, ThreddsDefinition, ThreddsController>
implements ThreddsManager {
    private static final Logger log = LoggerFactory.getLogger(ThreddsManagerImpl.class);
    private ThreddsCluster cluster = null;
    private ThreddsRetriever retriever = new ThreddsRetriever();
    @Inject
    TemplateManager templateManager;

    public ThreddsManagerImpl() {
        this.cluster = new ThreddsCluster(LocalConfiguration.getTTL((String)"th.cache.TTL").longValue(), (ISModule)this.retriever, "Thredds Cache");
    }

    protected AbstractCluster<ThreddsDescriptor, ThreddsController> getCluster() {
        return this.cluster;
    }

    protected ISModule getRetriever() {
        return this.retriever;
    }

    public List<ThreddsDescriptor> getSuggestedInstances() throws ConfigurationNotFoundException {
        return this.getAvailableInstances();
    }

    public ThreddsCatalog publishCatalog(File catalogFile, String catalogReference) throws ConfigurationNotFoundException, ThreddsOperationFault {
        return ((ThreddsController)this.getCluster().getDefaultController()).publishCatalog(catalogFile, catalogReference);
    }

    public ThreddsCatalog createCatalogFromTemplate(String authorityUrl, String catalogPath, String datasetScanId, String datasetScanName, String subFolder, String catalogReference) throws Exception {
        ThreddsController controller = (ThreddsController)this.getCluster().getDefaultController();
        ThreddsInfo info = controller.getThreddsInfo();
        log.info("Going to create catalog for authorityURL {}, path {}, subFolder {} ", new Object[]{authorityUrl, catalogPath, subFolder});
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("AuthorityURL", authorityUrl);
        parameters.put("CatalogPath", catalogPath);
        parameters.put("DataSetScanID", datasetScanId);
        parameters.put("DataSetScanName", datasetScanName);
        parameters.put("Location", info.getLocalBasePath() + "/" + subFolder);
        File catalog = this.templateManager.generateFromTemplate(parameters, "thredds_catalog.ftlx");
        return controller.publishCatalog(catalog, catalogReference);
    }
}

