/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.spatial.data.sdi.engine.impl.cluster;

import it.geosolutions.geoserver.rest.GeoServerRESTManager;
import it.geosolutions.geoserver.rest.GeoServerRESTPublisher;
import it.geosolutions.geoserver.rest.GeoServerRESTReader;
import it.geosolutions.geoserver.rest.manager.GeoServerRESTStoreManager;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.spatial.data.geonetwork.utils.ScopeUtils;
import org.gcube.spatial.data.sdi.LocalConfiguration;
import org.gcube.spatial.data.sdi.engine.impl.cluster.GeoServiceController;
import org.gcube.spatial.data.sdi.engine.impl.faults.InvalidServiceEndpointException;
import org.gcube.spatial.data.sdi.engine.impl.faults.OutdatedServiceEndpointException;
import org.gcube.spatial.data.sdi.engine.impl.is.ISUtils;
import org.gcube.spatial.data.sdi.model.credentials.AccessType;
import org.gcube.spatial.data.sdi.model.credentials.Credentials;
import org.gcube.spatial.data.sdi.model.service.GeoServerDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoServerController
extends GeoServiceController<GeoServerDescriptor> {
    private static final Logger log = LoggerFactory.getLogger(GeoServerController.class);
    private HashMap<String, HashSet<String>> dataStores = null;
    private HashSet<String> workspaces = null;
    private HashSet<String> styles;
    private Long hostedLayerCount = 0L;
    private long lastDatastoreUpdate = 0L;
    private long lastWorkspaceUpdate = 0L;
    private long lastStylesUpdate = 0L;
    private long lastLayerCountUpdate = 0L;

    public GeoServerController(ServiceEndpoint serviceEndpoint) throws InvalidServiceEndpointException {
        super(serviceEndpoint);
    }

    public GeoServerDescriptor getLiveDescriptor() {
        String publicProperty;
        String sharedProperty;
        String contextProperty;
        GeoServerDescriptor toReturn = new GeoServerDescriptor();
        toReturn.setBaseEndpoint(this.baseURL);
        toReturn.setVersion(this.version);
        String scopeName = ScopeUtils.getCurrentScopeName();
        Map pointProperties = this.accessPoint.propertyMap();
        for (AccessType toLookForType : AccessType.values()) {
            String userNameProperty = toLookForType + "_u_" + scopeName;
            String passwordProperty = toLookForType + "_u_" + scopeName;
            if (!pointProperties.containsKey(userNameProperty)) continue;
            String user = ((ServiceEndpoint.Property)pointProperties.get(userNameProperty)).value();
            String password = ISUtils.decryptString((String)((ServiceEndpoint.Property)pointProperties.get(passwordProperty)).value());
            toReturn.getAccessibleCredentials().add(new Credentials(user, password, toLookForType));
        }
        toReturn.getAccessibleCredentials().add(this.adminAccount);
        String confidentialProperty = "confidential_" + scopeName;
        if (pointProperties.containsKey(confidentialProperty)) {
            toReturn.setConfidentialWorkspace(((ServiceEndpoint.Property)pointProperties.get(confidentialProperty)).value());
        }
        if (pointProperties.containsKey(contextProperty = "context_" + scopeName)) {
            toReturn.setContextVisibilityWorkspace(((ServiceEndpoint.Property)pointProperties.get(contextProperty)).value());
        }
        if (pointProperties.containsKey(sharedProperty = "shared_" + scopeName)) {
            toReturn.setSharedWorkspace(((ServiceEndpoint.Property)pointProperties.get(sharedProperty)).value());
        }
        if (pointProperties.containsKey(publicProperty = "public_" + scopeName)) {
            toReturn.setPublicWorkspace(((ServiceEndpoint.Property)pointProperties.get(publicProperty)).value());
        }
        toReturn.setHostedLayersCount(this.getHostedLayersCount());
        return toReturn;
    }

    protected ServiceEndpoint.AccessPoint getTheRightAccessPoint(ServiceEndpoint endpoint) {
        for (ServiceEndpoint.AccessPoint declaredPoint : endpoint.profile().accessPoints().asCollection()) {
            if (!declaredPoint.name().equals(LocalConfiguration.getProperty((String)"gs.se.endpointName"))) continue;
            return declaredPoint;
        }
        return null;
    }

    protected void initServiceEndpoint() throws OutdatedServiceEndpointException {
    }

    public GeoServerRESTReader getReader() throws MalformedURLException {
        return this.getManager().getReader();
    }

    public GeoServerRESTStoreManager getDataStoreManager() throws IllegalArgumentException, MalformedURLException {
        return this.getManager().getStoreManager();
    }

    public GeoServerRESTPublisher getPublisher() throws IllegalArgumentException, MalformedURLException {
        return this.getManager().getPublisher();
    }

    protected GeoServerRESTManager getManager() throws IllegalArgumentException, MalformedURLException {
        return new GeoServerRESTManager(new URL(this.baseURL), this.adminAccount.getUsername(), this.adminAccount.getPassword());
    }

    public synchronized Set<String> getDatastores(String workspace) {
        try {
            if (this.dataStores == null || System.currentTimeMillis() - this.lastDatastoreUpdate > LocalConfiguration.getTTL((String)"gs.cache.hostedLayers.TTL")) {
                log.trace("Loading datastores for {} ", (Object)this.baseURL);
                HashMap toSet = new HashMap();
                for (String ws : this.getWorkspaces()) {
                    HashSet currentWsDatastores = new HashSet(this.getLiveDatastores(ws));
                    log.debug("Found {} ds in {} ws ", (Object)currentWsDatastores.size(), (Object)ws);
                    toSet.put(ws, currentWsDatastores);
                }
                this.dataStores = toSet;
                this.lastDatastoreUpdate = System.currentTimeMillis();
            }
        }
        catch (Throwable t) {
            log.warn("Unable to get Datastores for {} ", (Object)this.baseURL, (Object)t);
        }
        return (Set)this.dataStores.get(workspace);
    }

    public synchronized Long getHostedLayersCount() {
        try {
            if (System.currentTimeMillis() - this.lastLayerCountUpdate > LocalConfiguration.getTTL((String)"gs.cache.hostedLayers.TTL")) {
                log.trace("Loading layer count for {} ", (Object)this.baseURL);
                this.hostedLayerCount = this.getLiveHostedLayersCount();
                log.debug("Found {} layers ", (Object)this.hostedLayerCount);
                this.lastLayerCountUpdate = System.currentTimeMillis();
            }
        }
        catch (Throwable t) {
            log.warn("Unable to get layer count for {} ", (Object)this.baseURL, (Object)t);
        }
        return this.hostedLayerCount;
    }

    public synchronized Set<String> getStyles() {
        try {
            if (this.styles == null || System.currentTimeMillis() - this.lastStylesUpdate > LocalConfiguration.getTTL((String)"gs.cache.hostedLayers.TTL")) {
                log.trace("Loading styles for {} ", (Object)this.baseURL);
                this.styles = new HashSet(this.getLiveStyles());
                log.debug("Found {} styles ", (Object)this.styles.size());
                this.lastStylesUpdate = System.currentTimeMillis();
            }
        }
        catch (Throwable t) {
            log.warn("Unable to get Styles for {} ", (Object)this.baseURL, (Object)t);
        }
        return this.styles;
    }

    public synchronized Set<String> getWorkspaces() {
        try {
            if (this.workspaces == null || System.currentTimeMillis() - this.lastWorkspaceUpdate > LocalConfiguration.getTTL((String)"gs.cache.hostedLayers.TTL")) {
                log.trace("Loading workspaces for {} ", (Object)this.baseURL);
                this.workspaces = new HashSet(this.getLiveWorkspaces());
                log.debug("Found {} workspaces", (Object)this.workspaces.size());
                this.lastWorkspaceUpdate = 0L;
            }
        }
        catch (Throwable t) {
            log.warn("Unable to get Workspaces for {} ", (Object)this.baseURL, (Object)t);
        }
        return this.workspaces;
    }

    public void invalidateWorkspacesCache() {
        this.lastWorkspaceUpdate = 0L;
    }

    public void invalidateDatastoresCache() {
        this.lastDatastoreUpdate = 0L;
    }

    public void invalidateStylesCache() {
        this.lastStylesUpdate = 0L;
    }

    public void invalidateHostedLayersCountCache() {
        this.lastLayerCountUpdate = 0L;
    }

    public void onChangedDataStores() {
        this.invalidateDatastoresCache();
    }

    public void onChangedLayers() {
        this.invalidateHostedLayersCountCache();
    }

    public void onChangedStyles() {
        this.invalidateStylesCache();
    }

    public void onChangedWorkspaces() {
        this.invalidateWorkspacesCache();
        this.invalidateDatastoresCache();
    }

    public Set<String> getLiveDatastores(String workspace) throws MalformedURLException {
        return new HashSet<String>(this.getReader().getDatastores(workspace).getNames());
    }

    public Long getLiveHostedLayersCount() throws MalformedURLException {
        return new Long(this.getReader().getLayers().size());
    }

    public Set<String> getLiveStyles() throws MalformedURLException {
        return new HashSet<String>(this.getReader().getStyles().getNames());
    }

    public Set<String> getLiveWorkspaces() throws MalformedURLException {
        return new HashSet<String>(this.getReader().getWorkspaceNames());
    }
}

