/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.spatial.data.sdi.rest;

import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.jaxrs.annotation.JacksonFeatures;
import io.swagger.annotations.Api;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import org.gcube.smartgears.annotations.ManagedBy;
import org.gcube.spatial.data.sdi.NetUtils;
import org.gcube.spatial.data.sdi.SDIServiceManager;
import org.gcube.spatial.data.sdi.engine.RoleManager;
import org.gcube.spatial.data.sdi.engine.SDIManager;
import org.gcube.spatial.data.sdi.model.credentials.Credentials;
import org.gcube.spatial.data.sdi.model.service.GeoNetworkDescriptor;
import org.gcube.spatial.data.sdi.model.services.GeoNetworkServiceDefinition;
import org.gcube.spatial.data.sdi.model.services.ServiceDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="GeoNetwork")
@Api(value="GeoNetwork")
@ManagedBy(value=SDIServiceManager.class)
public class GeoNetwork {
    private static final Logger log = LoggerFactory.getLogger(GeoNetwork.class);
    private static final String HOST_PATH_PARAM = "host";
    @Inject
    private SDIManager sdi;
    @Inject
    private RoleManager roleManager;

    @GET
    @Path(value="configuration/{host}")
    @Produces(value={"application/json"})
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    public GeoNetworkDescriptor getInstanceConfiguration(@PathParam(value="host") String host) {
        try {
            log.trace("Serving credentials for host {} ", (Object)host);
            host = NetUtils.getHost((String)host);
            return (GeoNetworkDescriptor)this.sdi.getGeoNetworkManager().getDescriptorByHostname(host);
        }
        catch (WebApplicationException e) {
            log.warn("Unable to serve request", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            log.warn("Unable to serve request", (Throwable)e);
            throw new WebApplicationException("Unable to serve request", (Throwable)e);
        }
    }

    @GET
    @Path(value="credentials/{host}")
    @Produces(value={"application/json"})
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    public Credentials getInstanceCredentials(@PathParam(value="host") String host) {
        try {
            log.trace("Serving credentials for host {} ", (Object)host);
            host = NetUtils.getHost((String)host);
            return this.roleManager.getMostAccessible(((GeoNetworkDescriptor)this.sdi.getGeoNetworkManager().getDescriptorByHostname(host)).getAccessibleCredentials(), false);
        }
        catch (WebApplicationException e) {
            log.warn("Unable to serve request", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            log.warn("Unable to serve request", (Throwable)e);
            throw new WebApplicationException("Unable to serve request", (Throwable)e);
        }
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/xml"})
    public String register(GeoNetworkServiceDefinition toRegister) {
        try {
            return this.sdi.registerService((ServiceDefinition)toRegister);
        }
        catch (WebApplicationException e) {
            log.warn("Unable to serve request", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            log.warn("Unable to serve request", (Throwable)e);
            throw new WebApplicationException("Unable to serve request", (Throwable)e);
        }
    }

    @POST
    @Path(value="import/{host}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/xml"})
    public String importFromScope(@QueryParam(value="sourceToken") String sourceToken, @PathParam(value="host") String host) {
        try {
            return this.sdi.importService(sourceToken, host, ServiceDefinition.Type.GEONETWORK);
        }
        catch (WebApplicationException e) {
            log.warn("Unable to serve request", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            log.warn("Unable to serve request", (Throwable)e);
            throw new WebApplicationException("Unable to serve request", (Throwable)e);
        }
    }
}

