/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.usecases.ws.thredds.engine.impl;

import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.gcube.common.homelibary.model.items.type.WorkspaceItemType;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.Properties;
import org.gcube.common.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.common.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.common.homelibrary.home.workspace.accounting.AccountingEntry;
import org.gcube.common.homelibrary.home.workspace.accounting.AccountingEntryRemoval;
import org.gcube.common.homelibrary.home.workspace.accounting.AccountingEntryRenaming;
import org.gcube.data.transfer.model.RemoteFileDescriptor;
import org.gcube.usecases.ws.thredds.Constants;
import org.gcube.usecases.ws.thredds.engine.impl.Process;
import org.gcube.usecases.ws.thredds.engine.impl.ThreddsController;
import org.gcube.usecases.ws.thredds.engine.impl.threads.DeleteRemoteRequest;
import org.gcube.usecases.ws.thredds.engine.impl.threads.SynchronizationThread;
import org.gcube.usecases.ws.thredds.engine.impl.threads.TransferFromThreddsRequest;
import org.gcube.usecases.ws.thredds.faults.InternalException;
import org.gcube.usecases.ws.thredds.faults.RemoteFileNotFoundException;
import org.gcube.usecases.ws.thredds.model.StepReport;
import org.gcube.usecases.ws.thredds.model.SynchFolderConfiguration;
import org.gcube.usecases.ws.thredds.model.SynchronizedElementInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkspaceUtils {
    private static final Logger log = LoggerFactory.getLogger(WorkspaceUtils.class);

    static Set<String> scanAccountingForStatus(WorkspaceFolder toScanFolder, SynchFolderConfiguration config, Set<String> localChildrenNames, Set<String> remoteChildrenNames, ThreddsController folderController, Process ownerProcess, ExecutorService service) throws InternalErrorException {
        HashSet<String> handledAccountingEntries = new HashSet<String>();
        log.debug("Checking history of {} ", (Object)toScanFolder.getPath());
        String relativePath = toScanFolder.getProperties().getPropertyValue("WS-SYNCH.REMOTE-PATH");
        Date folderLastUpdateTime = null;
        try {
            folderLastUpdateTime = WorkspaceUtils.safelyGetLastUpdate((WorkspaceItem)toScanFolder);
        }
        catch (Throwable t) {
            log.warn("Unable to get folder {} last update time. Assuming first run.. ", (Object)toScanFolder.getName(), (Object)t);
            folderLastUpdateTime = new Date(0L);
        }
        log.debug("Checking Accounting for {}. Last update time is {} ", (Object)toScanFolder.getName(), (Object)Constants.DATE_FORMAT.format(folderLastUpdateTime));
        for (AccountingEntry entry : toScanFolder.getAccounting()) {
            try {
                Date eventTime = entry.getDate().getTime();
                if (folderLastUpdateTime != null && !eventTime.after(folderLastUpdateTime)) continue;
                String toDeleteRemote = null;
                switch (entry.getEntryType()) {
                    case CUT: 
                    case REMOVAL: {
                        AccountingEntryRemoval removalEntry = (AccountingEntryRemoval)entry;
                        if (!removalEntry.getItemType().equals((Object)WorkspaceItemType.FOLDER) && !config.matchesFilter(removalEntry.getItemName())) break;
                        toDeleteRemote = removalEntry.getItemName();
                        break;
                    }
                    case RENAMING: {
                        AccountingEntryRenaming renamingEntry = (AccountingEntryRenaming)entry;
                        WorkspaceItem newItem = toScanFolder.find(renamingEntry.getNewItemName());
                        if (!newItem.isFolder() && !config.matchesFilter(renamingEntry.getOldItemName())) break;
                        toDeleteRemote = renamingEntry.getOldItemName();
                        break;
                    }
                }
                if (toDeleteRemote == null) continue;
                if (localChildrenNames.contains(toDeleteRemote)) {
                    log.debug("Skipping accounting entry for existing local item {} ", toDeleteRemote);
                    continue;
                }
                if (remoteChildrenNames.contains(toDeleteRemote)) {
                    log.debug("Checking age of remote {} ", (Object)toDeleteRemote);
                    RemoteFileDescriptor remote = folderController.getFileDescriptor(relativePath + "/" + toDeleteRemote);
                    Date remoteDate = new Date(remote.getLastUpdate());
                    log.debug("Last remote update : {} . Event date {}  ", (Object)Constants.DATE_FORMAT.format(remoteDate), (Object)Constants.DATE_FORMAT.format(eventTime));
                    if (service == null) continue;
                    log.debug("Service is not null. Submitting request ... ");
                    if (!eventTime.after(remoteDate)) continue;
                    service.execute(new SynchronizationThread(new DeleteRemoteRequest(ownerProcess, toScanFolder, toDeleteRemote)));
                    handledAccountingEntries.add(toDeleteRemote);
                    log.debug("Submitted DELETION request number {} ", (Object)ownerProcess.getStatus().getQueuedTransfers().incrementAndGet());
                    continue;
                }
                log.debug("To delete remote {} not found. skipping it.. ", (Object)toDeleteRemote);
            }
            catch (Throwable t) {
                log.error("Unable to submit deletion request for {} ", (Object)entry, (Object)t);
            }
        }
        return handledAccountingEntries;
    }

    static Set<String> scanRemoteFolder(RemoteFileDescriptor folderDesc, Set<String> handledAccountingEntries, Set<String> handledWorkspaceItemEntries, WorkspaceFolder toScanFolder, ThreddsController folderController, SynchFolderConfiguration config, Process ownerProcess, ExecutorService service) throws InternalException, InternalErrorException {
        log.debug("Checking remote content for {}. Remote Absolute Path is {} ", (Object)toScanFolder.getPath(), (Object)folderDesc.getAbsolutePath());
        HashSet<String> handledRemoteElements = new HashSet<String>();
        if (!folderDesc.isDirectory()) {
            throw new InternalException("Remote Descriptor " + folderDesc.getAbsolutePath() + " Is not a directory. ");
        }
        for (String child : folderDesc.getChildren()) {
            if (handledAccountingEntries.contains(child)) {
                log.debug("Skipping remote child {} because already handled with accouting", (Object)child);
                continue;
            }
            if (handledWorkspaceItemEntries.contains(child)) {
                log.debug("Skipping remote child {} because already handled with respective item", (Object)child);
                continue;
            }
            RemoteFileDescriptor childDesc = folderController.getFileDescriptor(child);
            if (childDesc.isDirectory()) {
                handledRemoteElements.add(child);
                continue;
            }
            if (config.matchesFilter(child)) {
                log.debug("Child {} matches filter...");
                handledRemoteElements.add(child);
                if (service == null) continue;
                service.execute(new SynchronizationThread(new TransferFromThreddsRequest(ownerProcess, null, toScanFolder, child)));
                log.debug("Submitted IMPORT request number {} ", (Object)ownerProcess.getStatus().getQueuedTransfers().incrementAndGet());
                continue;
            }
            log.debug("Skipping not matching remote {} ", (Object)child);
        }
        return handledRemoteElements;
    }

    static void initProperties(WorkspaceItem toInit, String remotePath, String filter, String targetToken, String catalogName, Boolean validateMeta, String rootFolderId) throws InternalErrorException {
        Map toSetProperties = toInit.getProperties().getProperties();
        WorkspaceUtils.initIfMissing(toSetProperties, "WS-SYNCH.TO-BE-SYNCHRONIZED", "true");
        WorkspaceUtils.initIfMissing(toSetProperties, "WS-SYNCH.LAST-UPDATE-TIME", "0");
        WorkspaceUtils.initIfMissing(toSetProperties, "WS-SYNCH.LAST-UPDATE-STATUS", (Object)((Object)StepReport.Status.OK) + "");
        WorkspaceUtils.initIfMissing(toSetProperties, "WS-SYNCH.SYNCH-STATUS", (Object)((Object)SynchronizedElementInfo.SynchronizationStatus.UP_TO_DATE) + "");
        if (toInit.isFolder()) {
            WorkspaceUtils.initIfMissing(toSetProperties, "WS-SYNCH.SYNCHRONIZATION-FILTER", filter);
            WorkspaceUtils.initIfMissing(toSetProperties, "WS-SYNCH.REMOTE-PATH", remotePath);
            WorkspaceUtils.initIfMissing(toSetProperties, "WS-SYNCH.REMOTE-PERSISTENCE", "thredds");
            WorkspaceUtils.initIfMissing(toSetProperties, "WS-SYNCH.TARGET-TOKEN", targetToken);
            WorkspaceUtils.initIfMissing(toSetProperties, "WS-SYNCH.RELATED-CATALOG", catalogName);
            WorkspaceUtils.initIfMissing(toSetProperties, "WS-SYNCH.VALIDATE-METADATA", validateMeta + "");
            WorkspaceUtils.initIfMissing(toSetProperties, "WS-SYNCH.ROOT-FOLDER-ID", rootFolderId);
        } else {
            WorkspaceUtils.initIfMissing(toSetProperties, "WS-SYNCH.METADATA-UUID", null);
        }
        toInit.getProperties().addProperties(toSetProperties);
    }

    private static void initIfMissing(Map<String, String> current, String key, String defaultValue) {
        if (!current.containsKey(key) || current.get(key) == null || current.get(key).equals("null")) {
            current.put(key, defaultValue);
        }
    }

    static boolean isConfigured(WorkspaceItem toCheck) throws InternalErrorException {
        return WorkspaceUtils.isConfigured(toCheck.getProperties().getProperties());
    }

    static boolean isConfigured(Map<String, String> toCheckProperties) {
        return toCheckProperties.containsKey("WS-SYNCH.TO-BE-SYNCHRONIZED") && toCheckProperties.get("WS-SYNCH.TO-BE-SYNCHRONIZED") != null;
    }

    static SynchronizedElementInfo.SynchronizationStatus getStatusAgainstRemote(WorkspaceItem item, Set<String> existingRemote, ThreddsController remoteFolderController, Date lastUpdateRoutine) throws NumberFormatException, InternalErrorException, RemoteFileNotFoundException {
        String itemName = item.getName();
        SynchronizedElementInfo.SynchronizationStatus status = SynchronizedElementInfo.SynchronizationStatus.OUTDATED_REMOTE;
        if (existingRemote.contains(itemName)) {
            Date lastUpdate;
            RemoteFileDescriptor desc = remoteFolderController.getFileDescriptor(itemName);
            Date remoteDate = new Date(desc.getLastUpdate());
            Date localDate = item.getLastModificationTime().getTime();
            if (localDate.equals(lastUpdate = WorkspaceUtils.safelyGetLastUpdate(item))) {
                status = remoteDate.after(lastUpdate) ? SynchronizedElementInfo.SynchronizationStatus.OUTDATED_WS : SynchronizedElementInfo.SynchronizationStatus.UP_TO_DATE;
            } else if (remoteDate.before(localDate)) {
                status = WorkspaceUtils.isModifiedAfter(item, lastUpdateRoutine) ? SynchronizedElementInfo.SynchronizationStatus.OUTDATED_REMOTE : SynchronizedElementInfo.SynchronizationStatus.UP_TO_DATE;
            } else if (remoteDate.after(localDate)) {
                status = remoteDate.equals(lastUpdate) ? SynchronizedElementInfo.SynchronizationStatus.UP_TO_DATE : (remoteDate.before(lastUpdate) ? SynchronizedElementInfo.SynchronizationStatus.OUTDATED_REMOTE : SynchronizedElementInfo.SynchronizationStatus.OUTDATED_WS);
            }
        }
        return status;
    }

    static Date safelyGetLastUpdate(WorkspaceItem item) throws InternalErrorException {
        try {
            return new Date(Long.parseLong(item.getProperties().getPropertyValue("WS-SYNCH.LAST-UPDATE-TIME")));
        }
        catch (NumberFormatException e) {
            log.debug("Unable to get last update time for {} ", (Object)item.getName(), (Object)e);
            return new Date(0L);
        }
    }

    public static boolean isModifiedAfter(WorkspaceItem item, Date fromDate) throws InternalErrorException {
        for (AccountingEntry entry : item.getAccounting()) {
            if (!entry.getDate().getTime().after(fromDate)) continue;
            switch (entry.getEntryType()) {
                case PASTE: 
                case CREATE: 
                case RESTORE: 
                case UPDATE: 
                case ADD: {
                    return true;
                }
            }
        }
        return false;
    }

    static void cleanItem(WorkspaceItem item) throws InternalErrorException {
        Properties props = item.getProperties();
        if (props.hasProperty("WS-SYNCH.TO-BE-SYNCHRONIZED")) {
            if (item.isFolder()) {
                props.addProperties(Constants.cleanedFolderPropertiesMap);
                for (WorkspaceItem child : ((WorkspaceFolder)item).getChildren()) {
                    WorkspaceUtils.cleanItem(child);
                }
            } else {
                props.addProperties(Constants.cleanedItemPropertiesMap);
            }
        }
    }

    static void setLastUpdateTime(WorkspaceFolder folder, long toSetTime) throws InternalErrorException {
        StepReport.Status currentWSStatus = StepReport.Status.valueOf(folder.getProperties().getPropertyValue("WS-SYNCH.LAST-UPDATE-STATUS"));
        if (currentWSStatus.equals((Object)StepReport.Status.OK)) {
            folder.getProperties().addProperties(Collections.singletonMap("WS-SYNCH.LAST-UPDATE-TIME", toSetTime + ""));
        }
        for (WorkspaceItem item : folder.getChildren()) {
            if (!item.isFolder()) continue;
            WorkspaceUtils.setLastUpdateTime((WorkspaceFolder)item, toSetTime);
        }
    }

    public static SynchFolderConfiguration loadConfiguration(WorkspaceItem item) throws InternalErrorException {
        if (item.isFolder()) {
            Properties props = item.getProperties();
            SynchFolderConfiguration config = new SynchFolderConfiguration();
            config.setFilter(props.getPropertyValue("WS-SYNCH.SYNCHRONIZATION-FILTER"));
            config.setRemotePath(props.getPropertyValue("WS-SYNCH.REMOTE-PATH"));
            config.setRemotePersistence(props.getPropertyValue("WS-SYNCH.REMOTE-PERSISTENCE"));
            config.setTargetToken(props.getPropertyValue("WS-SYNCH.TARGET-TOKEN"));
            config.setToCreateCatalogName(props.getPropertyValue("WS-SYNCH.RELATED-CATALOG"));
            config.setValidateMetadata(Boolean.parseBoolean(props.getPropertyValue("WS-SYNCH.VALIDATE-METADATA")));
            config.setRootFolderId(props.getPropertyValue("WS-SYNCH.ROOT-FOLDER-ID"));
            return config;
        }
        return WorkspaceUtils.loadConfiguration((WorkspaceItem)item.getParent());
    }

    static void resetStatus(WorkspaceItem item) throws InternalErrorException {
        Map props;
        if (item.isFolder()) {
            for (WorkspaceItem child : ((WorkspaceFolder)item).getChildren()) {
                WorkspaceUtils.resetStatus(child);
            }
        }
        if ((props = item.getProperties().getProperties()).containsKey("WS-SYNCH.LAST-UPDATE-STATUS")) {
            props.put("WS-SYNCH.LAST-UPDATE-STATUS", (Object)((Object)StepReport.Status.OK) + "");
            item.getProperties().addProperties(props);
        }
    }
}

