/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.executor.client.plugins.query;

import java.util.ArrayList;
import java.util.List;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.wsaddressing.W3CEndpointReferenceBuilder;
import org.gcube.common.clients.Plugin;
import org.gcube.common.resources.gcore.GCoreEndpoint;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.resources.discovery.client.api.DiscoveryException;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.api.SimpleQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.gcube.vremanagement.executor.client.plugins.query.filter.EndpointDiscoveryFilter;
import org.gcube.vremanagement.executor.client.plugins.query.filter.RandomEndpointDiscoveryFilter;
import org.gcube.vremanagement.executor.client.plugins.query.filter.ServiceEndpointQueryFilter;
import org.gcube.vremanagement.executor.client.util.Tuple;

public class SmartExecutorPluginQuery
implements org.gcube.common.clients.queries.Query<EndpointReference> {
    public static String classFormat = "$resource/Profile/ServiceClass/text() eq '%1s'";
    public static String nameFormat = "$resource/Profile/ServiceName/text() eq '%1s'";
    public static String statusFormat = "$resource/Profile/DeploymentData/Status/text() eq 'ready'";
    public static String containsFormat = "contains($entry/string(),'%1s')";
    private final Plugin<?, ?> plugin;
    private final SimpleQuery smartExecutorDiscoveryQuery;
    private ServiceEndpointQueryFilter serviceEndpointQueryFilter;
    private EndpointDiscoveryFilter endpointDiscoveryFilter = new RandomEndpointDiscoveryFilter();

    private static SimpleQuery makeEndpointDiscoveryQuery(Plugin<?, ?> plugin) {
        return ICFactory.queryFor(GCoreEndpoint.class).addCondition(String.format(classFormat, plugin.serviceClass())).addCondition(String.format(nameFormat, plugin.serviceName())).addCondition(String.format(statusFormat, new Object[0])).addVariable("$entry", "$resource/Profile/AccessPoint/RunningInstanceInterfaces/Endpoint").addCondition(String.format(containsFormat, plugin.name())).setResult("$entry/text()");
    }

    public SmartExecutorPluginQuery(Plugin<?, ?> plugin) {
        this.plugin = plugin;
        this.smartExecutorDiscoveryQuery = ICFactory.queryFor(ServiceEndpoint.class).addCondition(String.format("$resource/Profile/Category/text() eq '%s'", plugin.serviceClass())).addCondition(String.format("$resource/Profile/Name/text() eq '%s'", plugin.serviceName())).setResult("$resource");
    }

    public void addConditions(String pluginName, Tuple<String, String> ... tuples) {
        this.smartExecutorDiscoveryQuery.addVariable("$accessPoint", "$resource/Profile/AccessPoint").addCondition(String.format("$accessPoint/Interface/Endpoint/@EntryName eq '%s'", pluginName));
        if (tuples == null) {
            return;
        }
        for (int i = 0; i < tuples.length; ++i) {
            Tuple<String, String> tuple = tuples[i];
            String propertyVariableName = String.format("$property%d", i);
            this.smartExecutorDiscoveryQuery.addVariable(propertyVariableName, "$accessPoint/Properties/Property").addCondition(String.format("%s/Name/text() eq '%s'", propertyVariableName, tuple.getName())).addCondition(String.format("%s/Value/text() eq '%s'", propertyVariableName, tuple.getValue()));
        }
    }

    public void setServiceEndpointQueryFilter(ServiceEndpointQueryFilter serviceEndpointQueryFilter) {
        this.serviceEndpointQueryFilter = serviceEndpointQueryFilter;
    }

    public void setEndpointDiscoveryFilter(EndpointDiscoveryFilter endpointDiscoveryFilter) {
        if (endpointDiscoveryFilter != null) {
            this.endpointDiscoveryFilter = endpointDiscoveryFilter;
        }
    }

    public List<String> discoverEndpoints(EndpointDiscoveryFilter endpointDiscoveryFilter) throws org.gcube.common.clients.exceptions.DiscoveryException {
        List serviceEndpoints;
        if (this.serviceEndpointQueryFilter != null) {
            this.serviceEndpointQueryFilter.filter(this.smartExecutorDiscoveryQuery);
        }
        if ((serviceEndpoints = ICFactory.clientFor(ServiceEndpoint.class).submit((Query)this.smartExecutorDiscoveryQuery)).size() == 0) {
            throw new org.gcube.common.clients.exceptions.DiscoveryException("No running SmartExecutor wich match the requested conditions");
        }
        SimpleQuery preRunQuery = SmartExecutorPluginQuery.makeEndpointDiscoveryQuery(this.plugin);
        endpointDiscoveryFilter.filter(preRunQuery, serviceEndpoints);
        return ICFactory.client().submit((Query)preRunQuery);
    }

    public List<EndpointReference> fire() throws org.gcube.common.clients.exceptions.DiscoveryException {
        List serviceEndpoints;
        if (this.serviceEndpointQueryFilter != null) {
            this.serviceEndpointQueryFilter.filter(this.smartExecutorDiscoveryQuery);
        }
        if ((serviceEndpoints = ICFactory.clientFor(ServiceEndpoint.class).submit((Query)this.smartExecutorDiscoveryQuery)).size() == 0) {
            throw new org.gcube.common.clients.exceptions.DiscoveryException("No running SmartExecutor wich match the requested conditions");
        }
        SimpleQuery gCoreEndpointDiscoveryQuery = SmartExecutorPluginQuery.makeEndpointDiscoveryQuery(this.plugin);
        this.endpointDiscoveryFilter.filter(gCoreEndpointDiscoveryQuery, serviceEndpoints);
        ArrayList<EndpointReference> refs = new ArrayList<EndpointReference>();
        try {
            List addresses = ICFactory.client().submit((Query)gCoreEndpointDiscoveryQuery);
            for (String address : addresses) {
                refs.add((EndpointReference)new W3CEndpointReferenceBuilder().address(address).build());
            }
        }
        catch (DiscoveryException ex) {
            throw new org.gcube.common.clients.exceptions.DiscoveryException((Throwable)ex);
        }
        return refs;
    }
}

