/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.bluebridge.analytics.logic;

import gr.cite.bluebridge.analytics.model.Economics;
import gr.cite.bluebridge.analytics.model.Fish;
import gr.cite.bluebridge.analytics.model.FryGeneration;
import gr.cite.bluebridge.analytics.model.ItemCost;
import gr.cite.bluebridge.analytics.model.Model;
import gr.cite.bluebridge.analytics.model.ModelInput;
import gr.cite.bluebridge.analytics.model.OA;
import gr.cite.bluebridge.analytics.model.ProductMix;
import gr.cite.bluebridge.analytics.model.ProductPrice;
import gr.cite.bluebridge.analytics.model.Revenue;
import gr.cite.bluebridge.analytics.model.ShoppingCost;
import gr.cite.bluebridge.analytics.model.ShoppingList;
import gr.cite.bluebridge.analytics.model.Values;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

public class Evaluator {
    public int startYear;
    public int endYear;
    public static final int deduction = 5;
    public static final double irrGuess1 = 0.01;
    public static final double irrGuess2 = 0.0;
    public static final double PACKAGING_COST_PER_FISH = 0.22;
    public static final double WEIGHT_PER_FISH = 419.38;
    private Map<Integer, Integer> harvestedGenerationsPerYear = new HashMap<Integer, Integer>();

    public Economics calculate(ModelInput input) {
        this.startYear = Calendar.getInstance().get(1) + 1;
        this.endYear = this.startYear + 9;
        Model model = new Model(this.startYear, this.endYear);
        model.InitYearEntries(this.startYear, this.endYear, input.getFishes());
        this.setUpProductionParameters(model, input);
        this.setUpEOL(model);
        this.calculateShoppingList(model, input);
        this.calculateItemCost(model, input);
        this.calculateShoppingCost(model);
        this.calcuateDepreciatedShoppingCost(model);
        this.calculateOACost(model, input);
        this.calculateProductPrice(input, model);
        this.calculateProductMix(input, model);
        this.calculateRevenue(input, model);
        this.calculateUndepreciatedValues(input, model);
        this.calculateDepreciatedValues(input, model);
        return model.getEconomics();
    }

    public void setUpProductionParameters(Model model, ModelInput input) {
        model.getProductionParameters().setLargeCage(30);
        model.getProductionParameters().setSmallCage(20);
        model.getProductionParameters().setAnchorsSystem(3);
        model.getProductionParameters().setIsOffShoreAquaFarm(input.isOffShoreAquaFarm());
        model.getProductionParameters().setFeedNeedPerMonth(input.getFeedNeedPerMonth());
        model.getProductionParameters().setGenerationsPerYear(input.getGenerationsPerYear());
        model.getProductionParameters().setSupportEquipment(1);
        model.getProductionParameters().setPackagingPerFish(0.22);
        model.getProductionParameters().setConsumption(input.getConsumption());
    }

    public void setUpEOL(Model model) {
        model.getEOL().setCage(20);
        model.getEOL().setNets(8);
        model.getEOL().setAnchorsSystem(15);
        model.getEOL().setAutofeedingMachine(Integer.MAX_VALUE);
        model.getEOL().setSupportEquipment(20);
    }

    public void calculateShoppingList(Model model, ModelInput input) {
        Map<Integer, Integer> feedNeedPerYear = this.calculateFeedNeedPerYear(model, input);
        Double fryNeedPerYear = this.calculateFryNeedPerYear(model);
        for (int year = this.startYear; year <= this.endYear; ++year) {
            ShoppingList.YearEntry yearEntry = model.getShoppingList().getYearEntries().get(year);
            if ((year - this.startYear) % model.getEOL().getCage() == 0) {
                yearEntry.setCage(model.getProductionParameters().getLargeCage() + model.getProductionParameters().getSmallCage());
            } else {
                yearEntry.setCage(0);
            }
            if ((year - this.startYear) % model.getEOL().getNets() == 0) {
                yearEntry.setNets(model.getProductionParameters().getLargeCage() + model.getProductionParameters().getSmallCage());
            } else {
                yearEntry.setNets(0);
            }
            if ((year - this.startYear) % model.getEOL().getAnchorsSystem() == 0) {
                yearEntry.setAnchorsSystem(model.getProductionParameters().getAnchorsSystem());
            } else {
                yearEntry.setAnchorsSystem(0);
            }
            if ((year - this.startYear) % model.getEOL().getAutofeedingMachine() == 0 && model.getProductionParameters().getIsOffShoreAquaFarm()) {
                yearEntry.setAutofeedingMachine(1);
            } else {
                yearEntry.setAutofeedingMachine(0);
            }
            if ((year - this.startYear) % model.getEOL().getSupportEquipment() == 0) {
                yearEntry.setSupportEquipment(model.getProductionParameters().getSupportEquipment());
            } else {
                yearEntry.setSupportEquipment(0);
            }
            yearEntry.setFeed(feedNeedPerYear.get(year).intValue());
            yearEntry.setFry(fryNeedPerYear);
        }
    }

    public void calculateItemCost(Model model, ModelInput input) {
        for (int year = this.startYear; year <= this.endYear; ++year) {
            ItemCost.YearEntry yearEntry = model.getItemCost().getYearEntries().get(year);
            if (year == this.startYear) {
                yearEntry.setCage(6000.0);
                yearEntry.setNets(7200.0);
                yearEntry.setAnchorsSystem(76667.0);
                yearEntry.setAutofeedingMachine(1000000.0);
                yearEntry.setSupportEquipment(500000.0);
                yearEntry.setFeed(input.getFeedPrice());
                yearEntry.setFry(input.getFryPrice());
                continue;
            }
            ItemCost.YearEntry previousYearEntry = model.getItemCost().getYearEntries().get(year - 1);
            double inflationRate = 1.0 + input.getInflationRateOnYear(year);
            yearEntry.setCage(previousYearEntry.getCage() * inflationRate);
            yearEntry.setNets(previousYearEntry.getNets() * inflationRate);
            yearEntry.setAnchorsSystem(previousYearEntry.getAnchorsSystem() * inflationRate);
            yearEntry.setAutofeedingMachine(previousYearEntry.getAutofeedingMachine() * inflationRate);
            yearEntry.setSupportEquipment(previousYearEntry.getSupportEquipment() * inflationRate);
            yearEntry.setFeed(previousYearEntry.getFeed() * inflationRate);
            yearEntry.setFry(previousYearEntry.getFry() * inflationRate);
        }
    }

    public void calculateShoppingCost(Model model) {
        for (int year = this.startYear; year <= this.endYear; ++year) {
            ShoppingCost.YearEntry yearEntry = model.getShoppingCost().getYearEntries().get(year);
            ItemCost.YearEntry itemCostYearEntry = model.getItemCost().getYearEntries().get(year);
            ShoppingList.YearEntry shoppingListYearEntry = model.getShoppingList().getYearEntries().get(year);
            yearEntry.setCage(itemCostYearEntry.getCage() * (double)shoppingListYearEntry.getCage());
            yearEntry.setNets(itemCostYearEntry.getNets() * (double)shoppingListYearEntry.getNets());
            yearEntry.setAnchorsSystem(itemCostYearEntry.getAnchorsSystem() * (double)shoppingListYearEntry.getAnchorsSystem());
            yearEntry.setAutofeedingMachine(itemCostYearEntry.getAutofeedingMachine() * (double)shoppingListYearEntry.getAutofeedingMachine());
            yearEntry.setSupportEquipment(itemCostYearEntry.getSupportEquipment() * (double)shoppingListYearEntry.getSupportEquipment());
            yearEntry.setFeed(itemCostYearEntry.getFeed() * shoppingListYearEntry.getFeed());
            yearEntry.setFry(itemCostYearEntry.getFry() * shoppingListYearEntry.getFry());
        }
    }

    public void calcuateDepreciatedShoppingCost(Model model) {
        for (int year = this.startYear; year <= this.endYear; ++year) {
            ShoppingCost.YearEntry shoppingCostYearEntry = model.getShoppingCost().getYearEntries().get(year);
            for (int j = 0; j < 5; ++j) {
                if (year + j > this.endYear) continue;
                ShoppingCost.YearEntry depreciatedYearEntry = model.getDepreciatedShoppingCost().getYearEntries().get(year + j);
                double cageCost = depreciatedYearEntry.getCage() + shoppingCostYearEntry.getCage() / 5.0;
                double netsCost = depreciatedYearEntry.getNets() + shoppingCostYearEntry.getNets() / 5.0;
                double anchorsSystemCost = depreciatedYearEntry.getAnchorsSystem() + shoppingCostYearEntry.getAnchorsSystem() / 5.0;
                double autofeedingMachineCost = depreciatedYearEntry.getAutofeedingMachine() + shoppingCostYearEntry.getAutofeedingMachine() / 5.0;
                double supportEquipmentCost = depreciatedYearEntry.getSupportEquipment() + shoppingCostYearEntry.getSupportEquipment() / 5.0;
                depreciatedYearEntry.setCage(cageCost);
                depreciatedYearEntry.setNets(netsCost);
                depreciatedYearEntry.setAnchorsSystem(anchorsSystemCost);
                depreciatedYearEntry.setAutofeedingMachine(autofeedingMachineCost);
                depreciatedYearEntry.setSupportEquipment(supportEquipmentCost);
            }
            ShoppingCost.YearEntry depreciatedYearEntry = model.getDepreciatedShoppingCost().getYearEntries().get(year);
            depreciatedYearEntry.setFeed(shoppingCostYearEntry.getFeed());
            depreciatedYearEntry.setFry(shoppingCostYearEntry.getFry());
        }
    }

    public void calculateOACost(Model model, ModelInput input) {
        for (int year = this.startYear; year <= this.endYear; ++year) {
            OA.YearEntry yearEntry = model.getOA().getYearEntries().get(year);
            if (year == this.startYear) {
                yearEntry.setGeneralIndustrialExpenses(600000.0);
                yearEntry.setLicense(20000.0);
                continue;
            }
            OA.YearEntry previousYearEntry = model.getOA().getYearEntries().get(year - 1);
            double inflationRateThisYear = 1.0 + input.getInflationRateOnYear(year);
            double generalIndustrialExpenses = previousYearEntry.getGeneralIndustrialExpenses();
            yearEntry.setGeneralIndustrialExpenses(generalIndustrialExpenses * inflationRateThisYear);
        }
        this.calculateFishWeightPerYear(model);
        double packagingCostPerFish = model.getProductionParameters().getPackagingPerFish();
        for (int year = this.startYear + 1; year <= this.endYear; ++year) {
            OA.YearEntry yearEntry = model.getOA().getYearEntries().get(year);
            double inflationRate = 1.0 + input.getInflationRateOnYear(year);
            long fishCount = model.getScenario().getYearEntries().get(year).getFishCount();
            double packagingCostThisYear = (packagingCostPerFish *= inflationRate) * (double)fishCount;
            yearEntry.setPackagingCost(packagingCostThisYear);
        }
    }

    public void calculateProductPrice(ModelInput input, Model model) {
        Map<Fish, ProductPrice.YearEntry> yearEntry;
        int year;
        for (year = this.startYear; year <= this.endYear; ++year) {
            yearEntry = model.getProductPrice().getYearEntries().get(year);
            for (Fish fish : input.getFishes()) {
                if (year == this.startYear) {
                    yearEntry.get(fish).setPrice(fish.getInitialPrice());
                    continue;
                }
                Map<Fish, ProductPrice.YearEntry> previousYearEntry = model.getProductPrice().getYearEntries().get(year - 1);
                double previousYearPrice = previousYearEntry.get(fish).getPrice();
                double fishPrice = previousYearPrice * (1.0 + input.getInflationRateOnYear(year));
                yearEntry.get(fish).setPrice(fishPrice);
            }
        }
        for (year = this.startYear; year <= this.endYear; ++year) {
            yearEntry = model.getProductPrice().getYearEntries().get(year);
            for (Fish fish : input.getFishes()) {
                yearEntry.get(fish).setPrice(yearEntry.get(fish).getPrice());
            }
        }
    }

    public void calculateProductMix(ModelInput input, Model model) {
        for (int year = this.startYear; year <= this.endYear; ++year) {
            Map<Fish, ProductMix.YearEntry> yearEntry = model.getProductMix().getYearEntries().get(year);
            for (Fish fish : input.getFishes()) {
                long kg = this.roundToLong(fish.getMixPercent() / 100.0 * model.getScenario().getYearEntries().get(year).getKG());
                yearEntry.get(fish).setKG(kg);
            }
        }
    }

    public void calculateRevenue(ModelInput input, Model model) {
        for (int year = this.startYear; year <= this.endYear; ++year) {
            Map<Fish, Revenue.YearEntry> yearEntry = model.getRevenue().getYearEntries().get(year);
            Map<Fish, ProductMix.YearEntry> productMixYearEntry = model.getProductMix().getYearEntries().get(year);
            Map<Fish, ProductPrice.YearEntry> productPriceYearEntry = model.getProductPrice().getYearEntries().get(year);
            for (Fish fish : input.getFishes()) {
                double revenue = productMixYearEntry.get(fish).getKG() * productPriceYearEntry.get(fish).getPrice();
                yearEntry.get(fish).setRevenue(revenue);
            }
        }
    }

    public void calculateUndepreciatedValues(ModelInput input, Model model) {
        double previousIrr;
        for (int i = this.startYear; i <= this.endYear; ++i) {
            Values.YearEntry yearEntry = model.getEconomics().getUndepreciatedValues().getYearEntries().get(i);
            Values.YearEntry previousYearEntry = i == this.startYear ? null : model.getEconomics().getUndepreciatedValues().getYearEntries().get(i - 1);
            OA.YearEntry oaYearEntry = model.getOA().getYearEntries().get(i);
            yearEntry.setOACost(-(oaYearEntry.getLicense() + oaYearEntry.getGeneralIndustrialExpenses() + oaYearEntry.getPackagingCost()));
            ShoppingCost.YearEntry shoppingCostYearEntry = model.getShoppingCost().getYearEntries().get(i);
            yearEntry.setTotalShoppingCost(-(shoppingCostYearEntry.getCage() + shoppingCostYearEntry.getNets() + shoppingCostYearEntry.getAnchorsSystem() + shoppingCostYearEntry.getAutofeedingMachine() + shoppingCostYearEntry.getSupportEquipment() + shoppingCostYearEntry.getFeed() + shoppingCostYearEntry.getFry()));
            yearEntry.setExpenses(yearEntry.getOACost() + yearEntry.getTotalShoppingCost());
            Map<Fish, Revenue.YearEntry> revenueYearEntry = model.getRevenue().getYearEntries().get(i);
            double income = 0.0;
            for (Fish fish : input.getFishes()) {
                income += revenueYearEntry.get(fish).getRevenue();
            }
            yearEntry.setIncome(income);
            yearEntry.setPreTaxBalance(yearEntry.getExpenses() + yearEntry.getIncome());
            if (i == this.startYear) {
                yearEntry.setCummulativeCost(yearEntry.getOACost() + yearEntry.getTotalShoppingCost());
            } else {
                yearEntry.setCummulativeCost(previousYearEntry.getCummulativeCost() + yearEntry.getOACost() + yearEntry.getTotalShoppingCost());
            }
            yearEntry.setTax(yearEntry.getPreTaxBalance() > 0.0 ? -yearEntry.getPreTaxBalance() * input.getTaxRate() / 100.0 : 0.0);
            yearEntry.setAfterTaxBalance(yearEntry.getPreTaxBalance() + yearEntry.getTax());
            if (i == this.startYear) {
                yearEntry.setCummulativeGL(yearEntry.getPreTaxBalance());
            } else {
                yearEntry.setCummulativeGL(previousYearEntry.getCummulativeGL() + yearEntry.getPreTaxBalance());
            }
            if (i == this.startYear) {
                yearEntry.setAfterTaxCummulativeGL(yearEntry.getAfterTaxBalance());
            } else {
                yearEntry.setAfterTaxCummulativeGL(previousYearEntry.getAfterTaxCummulativeGL() + yearEntry.getAfterTaxBalance());
            }
            yearEntry.setNetProfitMargin((yearEntry.getIncome() + yearEntry.getExpenses()) / -yearEntry.getExpenses());
        }
        double npv = this.calculateNPV(model.getEconomics().getUndepreciatedValues(), input.getDiscountRate() / 100.0);
        model.getEconomics().getUndepreciatedValues().getTargetIndicators().setNPV(npv);
        double irr = 0.0;
        double guess1 = 0.01;
        double guess2 = 0.0;
        boolean firstIteration = true;
        do {
            boolean moreThanRangeGuess1Guess2;
            double distanceGuess2Irr;
            previousIrr = irr;
            irr = this.calculateIRR(model.getEconomics().getUndepreciatedValues(), guess1, guess2);
            if (firstIteration) {
                firstIteration = false;
                guess2 = irr;
                continue;
            }
            double distanceGuess1Irr = Math.abs(guess1 - irr);
            int winner = Double.compare(distanceGuess1Irr, distanceGuess2Irr = Math.abs(guess2 - irr)) < 0 ? 1 : 2;
            boolean lessThanRangeGuess1Guess2 = Double.compare(irr, guess1) < 0 && Double.compare(irr, guess2) < 0;
            boolean bl = moreThanRangeGuess1Guess2 = Double.compare(irr, guess1) > 0 && Double.compare(irr, guess2) > 0;
            if (lessThanRangeGuess1Guess2 || moreThanRangeGuess1Guess2) {
                if (winner == 1) {
                    guess2 = irr;
                    continue;
                }
                guess1 = irr;
                continue;
            }
            if (winner == 1) {
                guess1 = irr;
                guess2 /= 2.0;
                continue;
            }
            guess2 = irr;
            guess1 /= 2.0;
        } while (Math.abs(previousIrr - irr) > 9.0E-6);
        model.getEconomics().getUndepreciatedValues().getTargetIndicators().setIRR(this.roundWithPrecision(irr, 4));
    }

    public void calculateDepreciatedValues(ModelInput input, Model model) {
        double previousIrr;
        for (int i = this.startYear; i <= this.endYear; ++i) {
            Values.YearEntry yearEntry = model.getEconomics().getDepreciatedValues().getYearEntries().get(i);
            Values.YearEntry previousYearEntry = i == this.startYear ? null : model.getEconomics().getDepreciatedValues().getYearEntries().get(i - 1);
            OA.YearEntry oaYearEntry = model.getOA().getYearEntries().get(i);
            yearEntry.setOACost(-(oaYearEntry.getLicense() + oaYearEntry.getGeneralIndustrialExpenses() + oaYearEntry.getPackagingCost()));
            ShoppingCost.YearEntry depreciatedShoppingCostYearEntry = model.getDepreciatedShoppingCost().getYearEntries().get(i);
            yearEntry.setTotalShoppingCost(-(depreciatedShoppingCostYearEntry.getCage() + depreciatedShoppingCostYearEntry.getNets() + depreciatedShoppingCostYearEntry.getAnchorsSystem() + depreciatedShoppingCostYearEntry.getAutofeedingMachine() + depreciatedShoppingCostYearEntry.getSupportEquipment() + depreciatedShoppingCostYearEntry.getFeed() + depreciatedShoppingCostYearEntry.getFry()));
            yearEntry.setExpenses(yearEntry.getOACost() + yearEntry.getTotalShoppingCost());
            Map<Fish, Revenue.YearEntry> revenueYearEntry = model.getRevenue().getYearEntries().get(i);
            double income = 0.0;
            for (Fish fish : input.getFishes()) {
                income += revenueYearEntry.get(fish).getRevenue();
            }
            yearEntry.setIncome(income);
            yearEntry.setPreTaxBalance(yearEntry.getExpenses() + yearEntry.getIncome());
            if (i == this.startYear) {
                yearEntry.setCummulativeCost(yearEntry.getOACost() + yearEntry.getTotalShoppingCost());
            } else {
                yearEntry.setCummulativeCost(previousYearEntry.getCummulativeCost() + yearEntry.getOACost() + yearEntry.getTotalShoppingCost());
            }
            yearEntry.setTax(yearEntry.getPreTaxBalance() > 0.0 ? -yearEntry.getPreTaxBalance() * input.getTaxRate() / 100.0 : 0.0);
            yearEntry.setAfterTaxBalance(yearEntry.getPreTaxBalance() + yearEntry.getTax());
            if (i == this.startYear) {
                yearEntry.setCummulativeGL(yearEntry.getPreTaxBalance());
            } else {
                yearEntry.setCummulativeGL(previousYearEntry.getCummulativeGL() + yearEntry.getPreTaxBalance());
            }
            if (i == this.startYear) {
                yearEntry.setAfterTaxCummulativeGL(yearEntry.getAfterTaxBalance());
            } else {
                yearEntry.setAfterTaxCummulativeGL(previousYearEntry.getAfterTaxCummulativeGL() + yearEntry.getAfterTaxBalance());
            }
            yearEntry.setNetProfitMargin((yearEntry.getIncome() + yearEntry.getExpenses()) / -yearEntry.getExpenses());
        }
        double npv = this.calculateNPV(model.getEconomics().getDepreciatedValues(), input.getDiscountRate() / 100.0);
        model.getEconomics().getDepreciatedValues().getTargetIndicators().setNPV(npv);
        double irr = 0.0;
        double guess1 = 0.01;
        double guess2 = 0.0;
        boolean firstIteration = true;
        do {
            boolean moreThanRangeGuess1Guess2;
            double distanceGuess2Irr;
            previousIrr = irr;
            irr = this.calculateIRR(model.getEconomics().getDepreciatedValues(), guess1, guess2);
            if (firstIteration) {
                firstIteration = false;
                guess2 = irr;
                continue;
            }
            double distanceGuess1Irr = Math.abs(guess1 - irr);
            int winner = Double.compare(distanceGuess1Irr, distanceGuess2Irr = Math.abs(guess2 - irr)) < 0 ? 1 : 2;
            boolean lessThanRangeGuess1Guess2 = Double.compare(irr, guess1) < 0 && Double.compare(irr, guess2) < 0;
            boolean bl = moreThanRangeGuess1Guess2 = Double.compare(irr, guess1) > 0 && Double.compare(irr, guess2) > 0;
            if (lessThanRangeGuess1Guess2 || moreThanRangeGuess1Guess2) {
                if (winner == 1) {
                    guess2 = irr;
                    continue;
                }
                guess1 = irr;
                continue;
            }
            if (winner == 1) {
                guess1 = irr;
                guess2 /= 2.0;
                continue;
            }
            guess2 = irr;
            guess1 /= 2.0;
        } while (Math.abs(previousIrr - irr) > 9.0E-6);
        model.getEconomics().getDepreciatedValues().getTargetIndicators().setIRR(this.roundWithPrecision(irr, 4));
    }

    private double calculateIRR(Values values, double guess1, double guess2) {
        double npv1 = this.calculateNPV(values, guess1);
        double npv2 = this.calculateNPV(values, guess2);
        return guess1 + npv1 * (guess2 - guess1) / (npv1 - npv2);
    }

    private double calculateNPV(Values values, double rate) {
        double npv = values.getYearEntries().get(this.startYear).getAfterTaxBalance();
        int pow = 1;
        for (int year = this.startYear + 1; year <= this.endYear; ++year) {
            Values.YearEntry yearEntry = values.getYearEntries().get(year);
            double yearRate = 1.0 / Math.pow(1.0 + rate, pow);
            npv += yearEntry.getAfterTaxBalance() * yearRate;
            ++pow;
        }
        return npv;
    }

    private Map<Integer, Integer> calculateFeedNeedPerYear(Model model, ModelInput input) {
        HashMap<Integer, Integer> feedNeedPerYear = new HashMap<Integer, Integer>();
        Map<Integer, Integer> feedNeedPerMonth = model.getProductionParameters().getFeedNeedPerMonth();
        Set<Integer> generationsPerYear = model.getProductionParameters().getGenerationsPerYear().keySet();
        int monthsToMaturity = input.getMaturity();
        ArrayList<Integer> generationsAlive = new ArrayList<Integer>();
        for (int year = this.startYear; year <= this.endYear; ++year) {
            for (int generationMonth : generationsPerYear) {
                generationsAlive.add(generationMonth + monthsToMaturity - 1);
            }
            int feedNeedThisYear = 0;
            int harvestedGenerationsThisYear = 0;
            ListIterator iterator = generationsAlive.listIterator();
            block2: while (iterator.hasNext()) {
                int listIndex = iterator.nextIndex();
                Integer fishGenerationMonth = (Integer)iterator.next();
                for (int month = 1; month <= 12; ++month) {
                    if (fishGenerationMonth <= 0) continue;
                    if (monthsToMaturity + 1 - fishGenerationMonth > 0) {
                        feedNeedThisYear += feedNeedPerMonth.get(monthsToMaturity + 1 - fishGenerationMonth).intValue();
                    }
                    Integer n = fishGenerationMonth;
                    Integer n2 = fishGenerationMonth = Integer.valueOf(fishGenerationMonth - 1);
                    if (fishGenerationMonth > 0) {
                        generationsAlive.set(listIndex, fishGenerationMonth);
                        continue;
                    }
                    ++harvestedGenerationsThisYear;
                    iterator.remove();
                    continue block2;
                }
            }
            feedNeedPerYear.put(year, feedNeedThisYear);
            this.harvestedGenerationsPerYear.put(year, harvestedGenerationsThisYear);
        }
        return feedNeedPerYear;
    }

    private Double calculateFryNeedPerYear(Model model) {
        Map<Integer, FryGeneration> generationsPerYear = model.getProductionParameters().getGenerationsPerYear();
        double fryNeedPerYear = 0.0;
        for (Map.Entry<Integer, FryGeneration> entry : generationsPerYear.entrySet()) {
            FryGeneration fryGeneration = entry.getValue();
            fryNeedPerYear += (double)fryGeneration.getCount();
        }
        return fryNeedPerYear;
    }

    public void calculateFishWeightPerYear(Model model) {
        int totalBiomass = model.getProductionParameters().getConsumption().getTotalBiomassPerGeneration();
        for (int year = this.startYear; year <= this.endYear; ++year) {
            double totalFishWeight = (double)(totalBiomass * this.harvestedGenerationsPerYear.get(year)) / 1000.0;
            long fishCount = Math.round((double)(totalBiomass * this.harvestedGenerationsPerYear.get(year)) / 419.38);
            model.getScenario().getYearEntries().get(year).setKG(totalFishWeight);
            model.getScenario().getYearEntries().get(year).setFishCount(fishCount);
        }
    }

    private double roundWithPrecision(double value, int roundPrecision) {
        int pow = 10;
        for (int i = 1; i < roundPrecision; ++i) {
            pow *= 10;
        }
        double tmp = value * (double)pow;
        return (double)((int)(tmp - (double)((int)tmp) >= 0.5 ? tmp + 1.0 : tmp)) / (double)pow;
    }

    private long roundToLong(double value) {
        return Math.round(value);
    }
}

