/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.bluebridge.analytics.model;

import gr.cite.bluebridge.analytics.model.Fish;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ProductPrice {
    private Map<Integer, Map<Fish, YearEntry>> yearEntries = new HashMap<Integer, Map<Fish, YearEntry>>();

    public void InitYearEntries(int startYear, int endYear, List<Fish> fishes) {
        for (int i = startYear; i <= endYear; ++i) {
            HashMap<Fish, YearEntry> fishYearEntry = new HashMap<Fish, YearEntry>();
            for (Fish fish : fishes) {
                YearEntry yearEntry = new YearEntry();
                yearEntry.setYear(i);
                yearEntry.setFish(fish);
                fishYearEntry.put(fish, yearEntry);
            }
            this.yearEntries.put(i, fishYearEntry);
        }
    }

    public Map<Integer, Map<Fish, YearEntry>> getYearEntries() {
        return this.yearEntries;
    }

    public void setYearEntries(Map<Integer, Map<Fish, YearEntry>> yearEntries) {
        this.yearEntries = yearEntries;
    }

    public void print(int startYear, int endYear) {
        System.out.println("\n");
        System.out.format("%16s", "Year");
        for (int year = startYear; year <= endYear; ++year) {
            System.out.format("%15d", year);
        }
        System.out.println();
        Set<Fish> allFish = this.yearEntries.get(startYear).keySet();
        for (Fish fish : allFish) {
            System.out.format("%16s", fish.getFish());
            for (int year = startYear; year <= endYear; ++year) {
                YearEntry yearEntry = this.yearEntries.get(year).get(fish);
                System.out.format("%15.2f", yearEntry.getPrice());
            }
            System.out.println();
        }
    }

    public class YearEntry {
        private double year;
        private Fish fish;
        private double price;

        public double getYear() {
            return this.year;
        }

        public void setYear(double year) {
            this.year = year;
        }

        public Fish getFish() {
            return this.fish;
        }

        public void setFish(Fish fish) {
            this.fish = fish;
        }

        public double getPrice() {
            return this.price;
        }

        public void setPrice(double price) {
            this.price = price;
        }
    }
}

