/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.bluebridge.analytics.model;

import gr.cite.bluebridge.analytics.model.Model;
import gr.cite.bluebridge.analytics.model.Parameters;
import gr.cite.bluebridge.analytics.model.Values;

public class Economics {
    private int startYear;
    private int endYear;
    private Parameters parameters;
    private Values undepreciatedValues;
    private Values depreciatedValues;

    public Economics() {
    }

    public Economics(int startYear, int endYear) {
        this.startYear = startYear;
        this.endYear = endYear;
        this.undepreciatedValues = new Values();
        this.depreciatedValues = new Values();
    }

    public void InitYearEntries(int startYear, int endYear) {
        this.getUndepreciatedValues().InitYearEntries(startYear, endYear);
        this.getDepreciatedValues().InitYearEntries(startYear, endYear);
    }

    public Values getUndepreciatedValues() {
        return this.undepreciatedValues;
    }

    public void setUndepreciatedValues(Values undepreciatedValues) {
        this.undepreciatedValues = undepreciatedValues;
    }

    public Values getDepreciatedValues() {
        return this.depreciatedValues;
    }

    public void setDepreciatedValues(Values depreciatedValues) {
        this.depreciatedValues = depreciatedValues;
    }

    public Parameters getParameters() {
        return this.parameters;
    }

    public void setParameters(Parameters parameters) {
        this.parameters = parameters;
    }

    public int getStartYear() {
        return this.startYear;
    }

    public void setStartYear(int startYear) {
        this.startYear = startYear;
    }

    public int getEndYear() {
        return this.endYear;
    }

    public void setEndYear(int endYear) {
        this.endYear = endYear;
    }

    public void printValues(Values values) {
        Values.YearEntry yearEntry;
        int i;
        System.out.format("%26s", "Year");
        for (i = this.startYear; i <= this.endYear; ++i) {
            yearEntry = values.getYearEntries().get(i);
            System.out.format("%16d", yearEntry.getYear());
        }
        System.out.println();
        System.out.format("%26s", "OA Cost");
        for (i = this.startYear; i <= this.endYear; ++i) {
            yearEntry = values.getYearEntries().get(i);
            System.out.format("%16.2f", yearEntry.getOACost());
        }
        System.out.println();
        System.out.format("%26s", "Total Shopping Cost");
        for (i = this.startYear; i <= this.endYear; ++i) {
            yearEntry = values.getYearEntries().get(i);
            System.out.format("%16.2f", yearEntry.getTotalShoppingCost());
        }
        System.out.println();
        System.out.format("%26s", "Expenses");
        for (i = this.startYear; i <= this.endYear; ++i) {
            yearEntry = values.getYearEntries().get(i);
            System.out.format("%16.2f", yearEntry.getExpenses());
        }
        System.out.println();
        System.out.format("%26s", "Income");
        for (i = this.startYear; i <= this.endYear; ++i) {
            yearEntry = values.getYearEntries().get(i);
            System.out.format("%16.2f", yearEntry.getIncome());
        }
        System.out.println();
        System.out.format("%26s", "Pre Tax Balance");
        for (i = this.startYear; i <= this.endYear; ++i) {
            yearEntry = values.getYearEntries().get(i);
            System.out.format("%16.2f", yearEntry.getPreTaxBalance());
        }
        System.out.println();
        System.out.format("%26s", "Cummulative Cost");
        for (i = this.startYear; i <= this.endYear; ++i) {
            yearEntry = values.getYearEntries().get(i);
            System.out.format("%16.2f", yearEntry.getCummulativeCost());
        }
        System.out.println();
        System.out.format("%26s", "Tax");
        for (i = this.startYear; i <= this.endYear; ++i) {
            yearEntry = values.getYearEntries().get(i);
            System.out.format("%16.2f", yearEntry.getTax());
        }
        System.out.println();
        System.out.format("%26s", "After Tax Balance");
        for (i = this.startYear; i <= this.endYear; ++i) {
            yearEntry = values.getYearEntries().get(i);
            System.out.format("%16.2f", yearEntry.getAfterTaxBalance());
        }
        System.out.println();
        System.out.format("%26s", "Cummulative GL");
        for (i = this.startYear; i <= this.endYear; ++i) {
            yearEntry = values.getYearEntries().get(i);
            System.out.format("%16.2f", yearEntry.getCummulativeGL());
        }
        System.out.println();
        System.out.format("%26s", "After Tax Cummulative GL");
        for (i = this.startYear; i <= this.endYear; ++i) {
            yearEntry = values.getYearEntries().get(i);
            System.out.format("%16.2f", yearEntry.getAfterTaxCummulativeGL());
        }
        System.out.println();
        System.out.println("NPV: " + values.getTargetIndicators().getNPV());
        System.out.println("IRR: " + values.getTargetIndicators().getIRR());
    }

    public void printAll(Model model) {
        System.out.format("%90s", "Depreciated Shopping Cost");
        model.getDepreciatedShoppingCost().print(this.startYear, this.endYear);
        System.out.println("\n");
        System.out.format("%90s", "Shopping Cost");
        model.getShoppingCost().print(this.startYear, this.endYear);
        System.out.println("\n");
        System.out.format("%90s", "OA Cost");
        model.getOA().print(this.startYear, this.endYear);
        System.out.println("\n");
        System.out.format("%90s", "Item Cost");
        model.getItemCost().print(this.startYear, this.endYear);
        System.out.println("\n");
        System.out.format("%90s", "Product Price");
        model.getProductPrice().print(this.startYear, this.endYear);
        System.out.println("\n");
        System.out.format("%90s", "Revenue");
        model.getRevenue().print(this.startYear, this.endYear);
    }
}

