/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.bluebridge.analytics.model;

import java.util.HashMap;
import java.util.Map;

public class ShoppingCost {
    private Map<Integer, YearEntry> yearEntries = new HashMap<Integer, YearEntry>();

    public void InitYearEntries(int startYear, int endYear) {
        for (int i = startYear; i <= endYear; ++i) {
            YearEntry yearEntry = new YearEntry();
            yearEntry.setYear(i);
            this.yearEntries.put(i, yearEntry);
        }
    }

    public Map<Integer, YearEntry> getYearEntries() {
        return this.yearEntries;
    }

    public void setYearEntries(Map<Integer, YearEntry> yearEntries) {
        this.yearEntries = yearEntries;
    }

    public void print(int startYear, int endYear) {
        YearEntry yearEntry;
        int year;
        System.out.println("\n");
        System.out.format("%15s", "Year");
        for (year = startYear; year <= endYear; ++year) {
            System.out.format("%15d", year);
        }
        System.out.println("\n");
        System.out.format("%15s", "Cages");
        for (year = startYear; year <= endYear; ++year) {
            yearEntry = this.yearEntries.get(year);
            System.out.format("%15.2f", yearEntry.getCage());
        }
        System.out.println();
        System.out.format("%15s", "Nets");
        for (year = startYear; year <= endYear; ++year) {
            yearEntry = this.yearEntries.get(year);
            System.out.format("%15.2f", yearEntry.getNets());
        }
        System.out.println();
        System.out.format("%15s", "Anchors");
        for (year = startYear; year <= endYear; ++year) {
            yearEntry = this.yearEntries.get(year);
            System.out.format("%15.2f", yearEntry.getAnchorsSystem());
        }
        System.out.println();
        System.out.format("%15s", "AFgMachine");
        for (year = startYear; year <= endYear; ++year) {
            yearEntry = this.yearEntries.get(year);
            System.out.format("%15.2f", yearEntry.getAutofeedingMachine());
        }
        System.out.println();
        System.out.format("%15s", "SupEquipment");
        for (year = startYear; year <= endYear; ++year) {
            yearEntry = this.yearEntries.get(year);
            System.out.format("%15.2f", yearEntry.getSupportEquipment());
        }
        System.out.println();
        System.out.format("%15s", "Feed");
        for (year = startYear; year <= endYear; ++year) {
            yearEntry = this.yearEntries.get(year);
            System.out.format("%15.2f", yearEntry.getFeed());
        }
        System.out.println();
        System.out.format("%15s", "Fry");
        for (year = startYear; year <= endYear; ++year) {
            yearEntry = this.yearEntries.get(year);
            System.out.format("%15.2f", yearEntry.getFry());
        }
        System.out.println("\n");
        System.out.format("%15s", "Total");
        for (year = startYear; year <= endYear; ++year) {
            yearEntry = this.yearEntries.get(year);
            double sum = 0.0;
            sum += yearEntry.getCage();
            sum += yearEntry.getNets();
            sum += yearEntry.getAnchorsSystem();
            sum += yearEntry.getAutofeedingMachine();
            System.out.format("%15.2f", sum += yearEntry.getSupportEquipment());
        }
        double sum = 0.0;
        System.out.println();
        System.out.format("%15s", "Cumulative");
        for (int year2 = startYear; year2 <= endYear; ++year2) {
            YearEntry yearEntry2 = this.yearEntries.get(year2);
            sum += yearEntry2.getCage();
            sum += yearEntry2.getNets();
            sum += yearEntry2.getAnchorsSystem();
            sum += yearEntry2.getAutofeedingMachine();
            System.out.format("%15.2f", sum += yearEntry2.getSupportEquipment());
        }
        System.out.println();
    }

    public class YearEntry {
        private int year;
        private double cage = 0.0;
        private double nets = 0.0;
        private double anchorsSystem = 0.0;
        private double autofeedingMachine = 0.0;
        private double supportEquipment = 0.0;
        private double feed = 0.0;
        private double fry = 0.0;

        public double getYear() {
            return this.year;
        }

        public void setYear(int year) {
            this.year = year;
        }

        public double getCage() {
            return this.cage;
        }

        public void setCage(double cage) {
            this.cage = cage;
        }

        public double getNets() {
            return this.nets;
        }

        public void setNets(double nets) {
            this.nets = nets;
        }

        public double getAnchorsSystem() {
            return this.anchorsSystem;
        }

        public void setAnchorsSystem(double anchorsSystem) {
            this.anchorsSystem = anchorsSystem;
        }

        public double getAutofeedingMachine() {
            return this.autofeedingMachine;
        }

        public void setAutofeedingMachine(double autofeedingMachine) {
            this.autofeedingMachine = autofeedingMachine;
        }

        public double getSupportEquipment() {
            return this.supportEquipment;
        }

        public void setSupportEquipment(double supportEquipment) {
            this.supportEquipment = supportEquipment;
        }

        public double getFeed() {
            return this.feed;
        }

        public void setFeed(double feed) {
            this.feed = feed;
        }

        public double getFry() {
            return this.fry;
        }

        public void setFry(double fry) {
            this.fry = fry;
        }
    }
}

