/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.bluebridge.analytics.model;

import java.util.HashMap;
import java.util.Map;

public class OA {
    private Map<Integer, YearEntry> yearEntries = new HashMap<Integer, YearEntry>();

    public void InitYearEntries(int startYear, int endYear) {
        for (int i = startYear; i <= endYear; ++i) {
            YearEntry yearEntry = new YearEntry();
            yearEntry.setYear(i);
            this.yearEntries.put(i, yearEntry);
        }
    }

    public Map<Integer, YearEntry> getYearEntries() {
        return this.yearEntries;
    }

    public void setYearEntries(Map<Integer, YearEntry> yearEntries) {
        this.yearEntries = yearEntries;
    }

    public void print(int startYear, int endYear) {
        YearEntry yearEntry;
        int year;
        System.out.println("\n");
        System.out.format("%15s", "Year");
        for (year = startYear; year <= endYear; ++year) {
            System.out.format("%15d", year);
        }
        System.out.println("\n");
        System.out.format("%15s", "Licence");
        for (year = startYear; year <= endYear; ++year) {
            yearEntry = this.yearEntries.get(year);
            System.out.format("%15.2f", yearEntry.getLicense());
        }
        System.out.println();
        System.out.format("%15s", "Gen.Industrial");
        for (year = startYear; year <= endYear; ++year) {
            yearEntry = this.yearEntries.get(year);
            System.out.format("%15.2f", yearEntry.getGeneralIndustrialExpenses());
        }
        System.out.println();
        System.out.format("%15s", "Packaging Cost");
        for (year = startYear; year <= endYear; ++year) {
            yearEntry = this.yearEntries.get(year);
            System.out.format("%15.2f", yearEntry.getPackagingCost());
        }
        System.out.println("\n");
        System.out.format("%15s", "Total");
        for (year = startYear; year <= endYear; ++year) {
            yearEntry = this.yearEntries.get(year);
            double sum = 0.0;
            sum += yearEntry.getPackagingCost();
            sum += yearEntry.getLicense();
            System.out.format("%15.2f", sum += yearEntry.getGeneralIndustrialExpenses());
        }
        double sum = 0.0;
        System.out.println();
        System.out.format("%15s", "Cumulative");
        for (int year2 = startYear; year2 <= endYear; ++year2) {
            YearEntry yearEntry2 = this.yearEntries.get(year2);
            sum += yearEntry2.getPackagingCost();
            sum += yearEntry2.getLicense();
            System.out.format("%15.2f", sum += yearEntry2.getGeneralIndustrialExpenses());
        }
    }

    public class YearEntry {
        private int year;
        private double license;
        private double generalIndustrialExpenses;
        private double packagingCost;

        public int getYear() {
            return this.year;
        }

        public void setYear(int year) {
            this.year = year;
        }

        public double getLicense() {
            return this.license;
        }

        public void setLicense(double license) {
            this.license = license;
        }

        public double getGeneralIndustrialExpenses() {
            return this.generalIndustrialExpenses;
        }

        public void setGeneralIndustrialExpenses(double generalIndustrialExpenses) {
            this.generalIndustrialExpenses = generalIndustrialExpenses;
        }

        public double getPackagingCost() {
            return this.packagingCost;
        }

        public void setPackagingCost(double packagingCost) {
            this.packagingCost = packagingCost;
        }
    }
}

