/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.bluebridge.analytics.portlet;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import gr.cite.bluebridge.analytics.utils.DatabaseCredentials;
import gr.cite.bluebridge.analytics.utils.DatabaseDiscovery;
import gr.cite.bluebridge.analytics.utils.Json;
import gr.cite.bluebridge.analytics.utils.ServiceDiscovery;
import gr.cite.bluebridge.analytics.utils.ServiceProfile;
import gr.cite.bluebridge.analytics.utils.SingletonHttpClient;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.portal.custom.scopemanager.scopehelper.ScopeHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.portlet.bind.annotation.RenderMapping;
import org.springframework.web.portlet.bind.annotation.ResourceMapping;

@Controller(value="helloWorldController")
@RequestMapping(value={"VIEW"})
public class SpringPortal {
    private static Log logger = LogFactoryUtil.getLog(SpringPortal.class);
    @Autowired
    private ServiceProfile performAnalysis;
    @Autowired
    private ServiceProfile simulFishGrowthDataAPI;
    @Autowired
    private ServiceProfile simulFishGrowthDatabase;

    @RenderMapping
    public String viewHomePage(RenderRequest request, RenderResponse response) {
        logger.info((Object)"View Home Page");
        ScopeHelper.setContext((RenderRequest)request);
        return "view";
    }

    @ResourceMapping(value="PerformAnalysis")
    public void performAnalysis(@RequestParam(value="modelId") Long modelId, @RequestParam(value="taxRate") Integer taxRate, @RequestParam(value="fishMix") Double fishMix, @RequestParam(value="feedPrice") Double feedPrice, @RequestParam(value="fryPrice") Double fryPrice, @RequestParam(value="sellingPrice") Double sellingPrice, @RequestParam(value="isOffShoreAquaFarm") Boolean isOffShoreAquaFarm, ResourceRequest request, ResourceResponse response) {
        try {
            logger.info((Object)("Model Id: \"" + modelId + "\""));
            logger.info((Object)("Tax Rate: \"" + taxRate + "\""));
            logger.info((Object)("Fish Mix: \"" + fishMix + "\""));
            logger.info((Object)("Feed Price: \"" + feedPrice + "\""));
            logger.info((Object)("Fry Price: \"" + fryPrice + "\""));
            logger.info((Object)("Selling Price: \"" + sellingPrice + "\""));
            logger.info((Object)("Is Off Shore Aqua Farm: \"" + isOffShoreAquaFarm + "\""));
            String username = (String)request.getPortletSession().getAttribute("username", 1);
            logger.info((Object)("Current username: " + username));
            ASLSession session = SessionManager.getInstance().getASLSession(request.getPortletSession().getId(), username);
            String scope = session.getScope();
            String token = session.getSecurityToken();
            logger.info((Object)("Current scope: " + scope));
            logger.info((Object)("Current Token: " + token));
            String serviceAnalysisUrl = ServiceDiscovery.fetchServiceEndpoint((String)scope, (ServiceProfile)this.performAnalysis);
            Client client = SingletonHttpClient.getSingletonHttpClient().getClient();
            ClientResponse clientResponse = null;
            WebResource webResource = client.resource(serviceAnalysisUrl + "performAnalysis");
            HashMap<String, Serializable> map = new HashMap<String, Serializable>();
            map.put("modelId", modelId);
            map.put("fishMix", fishMix);
            map.put("taxRate", taxRate);
            map.put("feedPrice", feedPrice);
            map.put("fryPrice", fryPrice);
            map.put("sellingPrice", sellingPrice);
            map.put("isOffShoreAquaFarm", isOffShoreAquaFarm);
            String body = Json.buildJSON(map);
            clientResponse = (ClientResponse)((WebResource.Builder)((WebResource.Builder)((WebResource.Builder)webResource.accept(new String[]{"application/json"}).type("application/json")).header("gcube-token", (Object)token)).header("scope", (Object)scope)).post(ClientResponse.class, (Object)body);
            ClientResponse.Status status = clientResponse.getClientResponseStatus();
            String result = (String)clientResponse.getEntity(String.class);
            if (status != ClientResponse.Status.OK) {
                logger.error((Object)("Did not manage to perform analysis " + result));
                HashMap outputMap = new HashMap();
                Json.returnJson((ResourceResponse)response, outputMap);
                response.setProperty("portlet.http-status-code", Integer.toString(status.getStatusCode()));
            } else {
                Map outputMap = (Map)new ObjectMapper().readValue(result, Map.class);
                Json.returnJson((ResourceResponse)response, (Object)outputMap);
            }
        }
        catch (Exception e) {
            Json.returnJson((ResourceResponse)response, (Object)"Did not manage to perform analysis");
            logger.error((Object)"Did not manage to perform analysis");
            logger.error((Throwable)e);
            response.setProperty("portlet.http-status-code", Integer.toString(500));
        }
    }

    @ResourceMapping(value="SimulFishGrowthDataModel")
    public void SimulFishGrowthDataModel(ResourceRequest request, ResourceResponse response) {
        String username = (String)request.getPortletSession().getAttribute("username", 1);
        ASLSession session = SessionManager.getInstance().getASLSession(request.getPortletSession().getId(), username);
        String scope = session.getScope();
        String token = session.getSecurityToken();
        logger.info((Object)("Current username: " + username));
        logger.info((Object)("Current scope: " + scope));
        logger.info((Object)("Current Token: " + token));
        try {
            DatabaseCredentials databaseCredentials = DatabaseDiscovery.fetchDatabaseCredentials((String)scope, (ServiceProfile)this.simulFishGrowthDatabase);
            String serviceUrl = ServiceDiscovery.fetchServiceEndpoint((String)scope, (ServiceProfile)this.simulFishGrowthDataAPI);
            serviceUrl = serviceUrl + "ModelerFull/all/" + scope.replaceAll("/", "_") + "?statuses=1";
            logger.info((Object)("Service Url: " + serviceUrl));
            Client client = SingletonHttpClient.getSingletonHttpClient().getClient();
            ClientResponse clientResponse = null;
            WebResource webResource = client.resource(serviceUrl);
            clientResponse = (ClientResponse)((WebResource.Builder)((WebResource.Builder)((WebResource.Builder)((WebResource.Builder)((WebResource.Builder)((WebResource.Builder)((WebResource.Builder)webResource.accept(new String[]{"application/json"}).type("application/json")).header("gcube-token", (Object)token)).header("scope", (Object)scope)).header("dbname", (Object)databaseCredentials.getDbname())).header("dbuser", (Object)databaseCredentials.getDbuser())).header("dbhost", (Object)databaseCredentials.getDbhost())).header("dbpass", (Object)databaseCredentials.getDbpass())).get(ClientResponse.class);
            ClientResponse.Status status = clientResponse.getClientResponseStatus();
            String result = (String)clientResponse.getEntity(String.class);
            logger.info((Object)("result = " + result));
            logger.info((Object)("status = " + status.getStatusCode()));
            if (status != ClientResponse.Status.OK) {
                Json.returnJson((ResourceResponse)response, (Object)"Did not manage to get all models");
                logger.error((Object)"Did not manage to get all models");
                response.setProperty("portlet.http-status-code", Integer.toString(status.getStatusCode()));
            } else {
                PrintWriter writer = response.getWriter();
                writer.write(result);
                writer.close();
            }
        }
        catch (Exception e) {
            Json.returnJson((ResourceResponse)response, (Object)"Could not find Endpoint");
            response.setProperty("portlet.http-status-code", Integer.toString(500));
            logger.error((Throwable)e);
        }
    }
}

