/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.bluebridge.analytics.web;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import gr.cite.bluebridge.analytics.web.Parameters;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Parameters {
    private static Logger logger = LoggerFactory.getLogger(Parameters.class);
    private Long modelId;
    private String modelName;
    private String fishSpecies;
    private Double taxRate;
    private Double discountRate;
    private Double feedPrice;
    private Double fryPrice;
    private Double sellingPrice;
    private Double fishMix;
    private Integer maturity;
    private Boolean isOffShoreAquaFarm;
    private Object inflationRate;

    public String getModelName() {
        return this.modelName;
    }

    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    public String getFishSpecies() {
        return this.fishSpecies;
    }

    public void setFishSpecies(String fishSpecies) {
        this.fishSpecies = fishSpecies;
    }

    public Integer getMaturity() {
        return this.maturity;
    }

    public void setMaturity(Integer maturity) {
        this.maturity = maturity;
    }

    public Double getTaxRate() {
        return this.taxRate;
    }

    public Long getModelId() {
        return this.modelId;
    }

    public void setModelId(Long modelId) {
        this.modelId = modelId;
    }

    public void setTaxRate(Double taxRate) {
        this.taxRate = taxRate;
    }

    public Double getFeedPrice() {
        return this.feedPrice;
    }

    public void setFeedPrice(Double feedPrice) {
        this.feedPrice = feedPrice;
    }

    public Double getFryPrice() {
        return this.fryPrice;
    }

    public void setFryPrice(Double fryPrice) {
        this.fryPrice = fryPrice;
    }

    public Double getSellingPrice() {
        return this.sellingPrice;
    }

    public void setSellingPrice(Double sellingPrice) {
        this.sellingPrice = sellingPrice;
    }

    public Boolean getIsOffShoreAquaFarm() {
        return this.isOffShoreAquaFarm;
    }

    public void setIsOffShoreAquaFarm(Boolean isOffShoreAquaFarm) {
        this.isOffShoreAquaFarm = isOffShoreAquaFarm;
    }

    public Double getFishMix() {
        return this.fishMix;
    }

    public void setFishMix(Double fishMix) {
        this.fishMix = fishMix;
    }

    public Double getDiscountRate() {
        return this.discountRate;
    }

    public void setDiscountRate(Double discountRate) {
        this.discountRate = discountRate;
    }

    public Object getInflationRate() {
        return this.inflationRate;
    }

    public void setInflationRate(Object inflationRate) {
        this.inflationRate = inflationRate;
    }

    public String validate() {
        String errorMessage = "";
        try {
            errorMessage = errorMessage + (this.modelId < 0L ? "ModelId is not valid" : "");
            errorMessage = errorMessage + (this.taxRate < 0.0 ? "Tax Rate cannot be negative" : "");
            errorMessage = errorMessage + (this.feedPrice <= 0.0 ? "Feed Price must be greater than 0" : "");
            errorMessage = errorMessage + (this.fryPrice <= 0.0 ? "Fry Price must be greater than 0" : "");
            errorMessage = errorMessage + (this.sellingPrice <= 0.0 ? "Selling Price must be greater than 0" : "");
            errorMessage = errorMessage + (this.discountRate < 0.0 ? "Discount Rate  cannot be negative" : "");
            ObjectMapper mapper = new ObjectMapper();
            1 typeRef = new /* Unavailable Anonymous Inner Class!! */;
            TreeMap inflationRateMap = (TreeMap)mapper.readValue((String)this.inflationRate, (TypeReference)typeRef);
            for (Map.Entry entry : inflationRateMap.entrySet()) {
                errorMessage = errorMessage + ((Double)entry.getValue() < 0.0 ? "Price Inflation Rate cannot be negative ( year " + entry.getKey() + " )" : "");
            }
        }
        catch (Exception e) {
            logger.error(null, (Throwable)e);
            errorMessage = "One of the parameters was empty";
        }
        return errorMessage;
    }

    public void print() {
        logger.debug("modelId  = " + this.modelId);
        logger.debug("modelName  = " + this.modelName);
        logger.debug("taxRate = " + this.taxRate);
        logger.debug("discountRate = " + this.discountRate);
        logger.debug("feedPrice = " + this.feedPrice);
        logger.debug("fryPrice = " + this.fryPrice);
        logger.debug("sellingPrice = " + this.sellingPrice);
        logger.debug("fishMix = " + this.fishMix);
        logger.debug("maturity = " + this.maturity);
        logger.debug("inflationRate = " + this.inflationRate);
    }
}

