/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.bluebridge.analytics.logic;

import gr.cite.bluebridge.analytics.model.Consumption;
import gr.cite.bluebridge.analytics.model.Economics;
import gr.cite.bluebridge.analytics.model.Fish;
import gr.cite.bluebridge.analytics.model.FryGeneration;
import gr.cite.bluebridge.analytics.model.ItemCost;
import gr.cite.bluebridge.analytics.model.Model;
import gr.cite.bluebridge.analytics.model.ModelInput;
import gr.cite.bluebridge.analytics.model.OA;
import gr.cite.bluebridge.analytics.model.ProductMix;
import gr.cite.bluebridge.analytics.model.ProductPrice;
import gr.cite.bluebridge.analytics.model.Revenue;
import gr.cite.bluebridge.analytics.model.Scenario;
import gr.cite.bluebridge.analytics.model.ShoppingCost;
import gr.cite.bluebridge.analytics.model.ShoppingList;
import gr.cite.bluebridge.analytics.model.Values;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class Evaluator {
    public static final int startYear = 2017;
    public static final int endYear = 2026;
    public static final int deduction = 5;
    public static final double irrGuessLow = -0.2;
    public static final double irrGuessHigh = 0.9999;
    public static final double PACKAGING_COST_PER_FISH = 0.2;
    public static final int WEIGHT_PER_FISH = 400;
    private Map<Integer, Integer> harvestedGenerationsPerYear = new HashMap();

    public static void main(String[] args) {
        ModelInput input = new ModelInput();
        Fish giltheadSeaBream = new Fish();
        giltheadSeaBream.setFish("giltheadSeaBream");
        giltheadSeaBream.setMixPercent(100.0);
        giltheadSeaBream.setInitialPrice(4.8);
        input.setOffShoreAquaFarm(true);
        input.getFishes().add(giltheadSeaBream);
        input.setFeedPrice(1.25);
        input.setFryPrice(0.2);
        input.setTaxRate(29.0);
        input.setDiscountRate(3.75);
        input.setMaturity(18);
        TreeMap<Integer, Double> inflationRate = new TreeMap<Integer, Double>();
        inflationRate.put(2018, 0.5);
        input.setCustomInflationRateOnYear(inflationRate);
        Consumption consumption = Consumption.getFixedData();
        input.setConsumption(consumption);
        HashMap<Integer, FryGeneration> generationsPerYear = new HashMap<Integer, FryGeneration>();
        generationsPerYear.put(1, new FryGeneration(750000, 2.18));
        generationsPerYear.put(4, new FryGeneration(750000, 2.18));
        generationsPerYear.put(7, new FryGeneration(750000, 2.18));
        generationsPerYear.put(10, new FryGeneration(750000, 2.18));
        input.setGenerationsPerYear(generationsPerYear);
        Economics economics = new Evaluator().calculate(input);
    }

    public void setUpProductionParameters(Model model, ModelInput input) {
        model.getProductionParameters().setLargeCage(30);
        model.getProductionParameters().setSmallCage(20);
        model.getProductionParameters().setAnchorsSystem(3);
        model.getProductionParameters().setIsOffShoreAquaFarm(input.isOffShoreAquaFarm());
        model.getProductionParameters().setFeedNeedPerMonth(input.getFeedNeedPerMonth());
        model.getProductionParameters().setGenerationsPerYear(input.getGenerationsPerYear());
        model.getProductionParameters().setSupportEquipment(1);
        model.getProductionParameters().setPackagingPerFish(0.2);
        model.getProductionParameters().setConsumption(input.getConsumption());
    }

    public void setUpEOL(Model model) {
        model.getEOL().setCage(20);
        model.getEOL().setNets(8);
        model.getEOL().setAnchorsSystem(15);
        model.getEOL().setAutofeedingMachine(Integer.MAX_VALUE);
        model.getEOL().setSupportEquipment(20);
    }

    public void calculateShoppingList(Model model, ModelInput input) {
        Map feedNeedPerYear = this.calculateFeedNeedPerYear(model, input);
        Double fryNeedPerYear = this.calculateFryNeedPerYear(model);
        for (int i = 2017; i <= 2026; ++i) {
            ShoppingList.YearEntry yearEntry = (ShoppingList.YearEntry)model.getShoppingList().getYearEntries().get(i);
            if ((i - 2017) % model.getEOL().getCage() == 0) {
                yearEntry.setCage(model.getProductionParameters().getLargeCage() + model.getProductionParameters().getSmallCage());
            } else {
                yearEntry.setCage(0);
            }
            if ((i - 2017) % model.getEOL().getNets() == 0) {
                yearEntry.setNets(model.getProductionParameters().getLargeCage() + model.getProductionParameters().getSmallCage());
            } else {
                yearEntry.setNets(0);
            }
            if ((i - 2017) % model.getEOL().getAnchorsSystem() == 0) {
                yearEntry.setAnchorsSystem(model.getProductionParameters().getAnchorsSystem());
            } else {
                yearEntry.setAnchorsSystem(0);
            }
            if ((i - 2017) % model.getEOL().getAutofeedingMachine() == 0 && model.getProductionParameters().getIsOffShoreAquaFarm()) {
                yearEntry.setAutofeedingMachine(1);
            } else {
                yearEntry.setAutofeedingMachine(0);
            }
            if ((i - 2017) % model.getEOL().getSupportEquipment() == 0) {
                yearEntry.setSupportEquipment(model.getProductionParameters().getSupportEquipment());
            } else {
                yearEntry.setSupportEquipment(0);
            }
            yearEntry.setFeed((double)((Integer)feedNeedPerYear.get(i)).intValue());
            yearEntry.setFry(fryNeedPerYear.doubleValue());
        }
    }

    public void calculateItemCost(Model model, ModelInput input) {
        for (int year = 2017; year <= 2026; ++year) {
            ItemCost.YearEntry yearEntry = (ItemCost.YearEntry)model.getItemCost().getYearEntries().get(year);
            if (year == 2017) {
                yearEntry.setCage(6000.0);
                yearEntry.setNets(7200.0);
                yearEntry.setAnchorsSystem(76667.0);
                yearEntry.setAutofeedingMachine(1000000.0);
                yearEntry.setSupportEquipment(500000.0);
            } else {
                ItemCost.YearEntry previousYearEntry = (ItemCost.YearEntry)model.getItemCost().getYearEntries().get(year - 1);
                double inflationRate = input.getInflationRateOnYear(year) / 100.0;
                yearEntry.setCage(previousYearEntry.getCage() + previousYearEntry.getCage() * inflationRate);
                yearEntry.setNets(previousYearEntry.getNets() + previousYearEntry.getNets() * inflationRate);
                yearEntry.setAnchorsSystem(previousYearEntry.getAnchorsSystem() + previousYearEntry.getAnchorsSystem() * inflationRate);
                yearEntry.setAutofeedingMachine(previousYearEntry.getAutofeedingMachine() + previousYearEntry.getAutofeedingMachine() * inflationRate);
                yearEntry.setSupportEquipment(previousYearEntry.getSupportEquipment() + previousYearEntry.getSupportEquipment() * inflationRate);
            }
            yearEntry.setFeed(input.getFeedPrice());
            yearEntry.setFry(input.getFryPrice());
        }
    }

    public void calculateShoppingCost(Model model) {
        for (int i = 2017; i <= 2026; ++i) {
            ShoppingCost.YearEntry yearEntry = (ShoppingCost.YearEntry)model.getShoppingCost().getYearEntries().get(i);
            ItemCost.YearEntry itemCostYearEntry = (ItemCost.YearEntry)model.getItemCost().getYearEntries().get(i);
            ShoppingList.YearEntry shoppingListYearEntry = (ShoppingList.YearEntry)model.getShoppingList().getYearEntries().get(i);
            yearEntry.setCage(itemCostYearEntry.getCage() * (double)shoppingListYearEntry.getCage());
            yearEntry.setNets(itemCostYearEntry.getNets() * (double)shoppingListYearEntry.getNets());
            yearEntry.setAnchorsSystem(itemCostYearEntry.getAnchorsSystem() * (double)shoppingListYearEntry.getAnchorsSystem());
            yearEntry.setAutofeedingMachine(itemCostYearEntry.getAutofeedingMachine() * (double)shoppingListYearEntry.getAutofeedingMachine());
            yearEntry.setSupportEquipment(itemCostYearEntry.getSupportEquipment() * (double)shoppingListYearEntry.getSupportEquipment());
            yearEntry.setFeed(itemCostYearEntry.getFeed() * shoppingListYearEntry.getFeed());
            yearEntry.setFry(itemCostYearEntry.getFry() * shoppingListYearEntry.getFry());
        }
    }

    public void calcuateDepreciatedShoppingCost(Model model) {
        for (int i = 2017; i <= 2026; ++i) {
            ShoppingCost.YearEntry shoppingCostYearEntry = (ShoppingCost.YearEntry)model.getShoppingCost().getYearEntries().get(i);
            for (int j = 0; j < 5; ++j) {
                if (i + j > 2026) continue;
                ShoppingCost.YearEntry depreciatedYearEntry = (ShoppingCost.YearEntry)model.getDepreciatedShoppingCost().getYearEntries().get(i + j);
                depreciatedYearEntry.setCage(depreciatedYearEntry.getCage() + shoppingCostYearEntry.getCage() / 5.0);
                depreciatedYearEntry.setNets(depreciatedYearEntry.getNets() + shoppingCostYearEntry.getNets() / 5.0);
                depreciatedYearEntry.setAnchorsSystem(depreciatedYearEntry.getAnchorsSystem() + shoppingCostYearEntry.getAnchorsSystem() / 5.0);
                depreciatedYearEntry.setAutofeedingMachine(depreciatedYearEntry.getAutofeedingMachine() + shoppingCostYearEntry.getAutofeedingMachine() / 5.0);
                depreciatedYearEntry.setSupportEquipment(depreciatedYearEntry.getSupportEquipment() + shoppingCostYearEntry.getSupportEquipment() / 5.0);
            }
            ShoppingCost.YearEntry depreciatedYearEntry = (ShoppingCost.YearEntry)model.getDepreciatedShoppingCost().getYearEntries().get(i);
            depreciatedYearEntry.setFeed(shoppingCostYearEntry.getFeed());
            depreciatedYearEntry.setFry(shoppingCostYearEntry.getFry());
        }
    }

    public void calculateOACost(Model model) {
        int i;
        this.calculateFishWeightPerYear(model);
        ((OA.YearEntry)model.getOA().getYearEntries().get(2017)).setLicense(20000.0);
        for (i = 2017; i <= 2026; ++i) {
            ((OA.YearEntry)model.getOA().getYearEntries().get(i)).setGeneralIndustrialExpenses(600000.0);
        }
        for (i = 2017; i <= 2026; ++i) {
            double value = model.getProductionParameters().getPackagingPerFish() * (double)((Scenario.YearEntry)model.getScenario().getYearEntries().get(i)).getFishCount();
            ((OA.YearEntry)model.getOA().getYearEntries().get(i)).setPackagingCost(value);
        }
    }

    public void calculateProductPrice(ModelInput input, Model model) {
        for (int year = 2017; year <= 2026; ++year) {
            Map yearEntry = (Map)model.getProductPrice().getYearEntries().get(year);
            for (Fish fish : input.getFishes()) {
                if (year == 2017) {
                    ((ProductPrice.YearEntry)yearEntry.get(fish)).setPrice(fish.getInitialPrice());
                    continue;
                }
                Map previousYearEntry = (Map)model.getProductPrice().getYearEntries().get(year - 1);
                Double previousYearPrice = ((ProductPrice.YearEntry)previousYearEntry.get(fish)).getPrice();
                ((ProductPrice.YearEntry)yearEntry.get(fish)).setPrice(previousYearPrice + previousYearPrice * (input.getInflationRateOnYear(year) / 100.0));
            }
        }
    }

    public void calculateProductMix(ModelInput input, Model model) {
        for (int i = 2017; i <= 2026; ++i) {
            Map yearEntry = (Map)model.getProductMix().getYearEntries().get(i);
            for (Fish fish : input.getFishes()) {
                ((ProductMix.YearEntry)yearEntry.get(fish)).setKG(fish.getMixPercent() / 100.0 * ((Scenario.YearEntry)model.getScenario().getYearEntries().get(i)).getKG());
            }
        }
    }

    public void calculateRevenue(ModelInput input, Model model) {
        for (int i = 2017; i <= 2026; ++i) {
            Map yearEntry = (Map)model.getRevenue().getYearEntries().get(i);
            Map productMixYearEntry = (Map)model.getProductMix().getYearEntries().get(i);
            Map productPriceYearEntry = (Map)model.getProductPrice().getYearEntries().get(i);
            for (Fish fish : input.getFishes()) {
                ((Revenue.YearEntry)yearEntry.get(fish)).setRevenue(((ProductMix.YearEntry)productMixYearEntry.get(fish)).getKG() * ((ProductPrice.YearEntry)productPriceYearEntry.get(fish)).getPrice());
            }
        }
    }

    public void calculateUndepreciatedValues(ModelInput input, Model model) {
        for (int i = 2017; i <= 2026; ++i) {
            Values.YearEntry yearEntry = (Values.YearEntry)model.getEconomics().getUndepreciatedValues().getYearEntries().get(i);
            Values.YearEntry previousYearEntry = i == 2017 ? null : (Values.YearEntry)model.getEconomics().getUndepreciatedValues().getYearEntries().get(i - 1);
            OA.YearEntry oaYearEntry = (OA.YearEntry)model.getOA().getYearEntries().get(i);
            yearEntry.setOACost(-(oaYearEntry.getLicense() + oaYearEntry.getGeneralIndustrialExpenses() + oaYearEntry.getPackagingCost()));
            ShoppingCost.YearEntry shoppingCostYearEntry = (ShoppingCost.YearEntry)model.getShoppingCost().getYearEntries().get(i);
            yearEntry.setTotalShoppingCost(-(shoppingCostYearEntry.getCage() + shoppingCostYearEntry.getNets() + shoppingCostYearEntry.getAnchorsSystem() + shoppingCostYearEntry.getAutofeedingMachine() + shoppingCostYearEntry.getSupportEquipment() + shoppingCostYearEntry.getFeed() + shoppingCostYearEntry.getFry()));
            System.out.println("year = " + i + " depreciatedShoppingCostYearEntry.getCage() = " + shoppingCostYearEntry.getCage());
            System.out.println("year = " + i + " depreciatedShoppingCostYearEntry.getNets() = " + shoppingCostYearEntry.getNets());
            System.out.println("year = " + i + " depreciatedShoppingCostYearEntry.getAutofeedingMachine() = " + shoppingCostYearEntry.getAutofeedingMachine());
            System.out.println("year = " + i + " depreciatedShoppingCostYearEntry.getAnchorsSystem()= " + shoppingCostYearEntry.getAnchorsSystem());
            System.out.println("year = " + i + " depreciatedShoppingCostYearEntry.getSupportEquipment() = " + shoppingCostYearEntry.getSupportEquipment());
            System.out.println("year = " + i + " depreciatedShoppingCostYearEntry.getFeed() = " + shoppingCostYearEntry.getFeed());
            System.out.println("year = " + i + " depreciatedShoppingCostYearEntry.getFry() = " + shoppingCostYearEntry.getFry());
            yearEntry.setExpenses(yearEntry.getOACost() + yearEntry.getTotalShoppingCost());
            Map revenueYearEntry = (Map)model.getRevenue().getYearEntries().get(i);
            double income = 0.0;
            for (Fish fish : input.getFishes()) {
                income += ((Revenue.YearEntry)revenueYearEntry.get(fish)).getRevenue();
            }
            yearEntry.setIncome(income);
            yearEntry.setPreTaxBalance(yearEntry.getExpenses() + yearEntry.getIncome());
            if (i == 2017) {
                yearEntry.setCummulativeCost(yearEntry.getOACost() + yearEntry.getTotalShoppingCost());
            } else {
                yearEntry.setCummulativeCost(previousYearEntry.getCummulativeCost() + yearEntry.getOACost() + yearEntry.getTotalShoppingCost());
            }
            yearEntry.setTax(yearEntry.getPreTaxBalance() > 0.0 ? -yearEntry.getPreTaxBalance() * input.getTaxRate() / 100.0 : 0.0);
            yearEntry.setAfterTaxBalance(yearEntry.getPreTaxBalance() + yearEntry.getTax());
            if (i == 2017) {
                yearEntry.setCummulativeGL(yearEntry.getPreTaxBalance());
            } else {
                yearEntry.setCummulativeGL(previousYearEntry.getCummulativeGL() + yearEntry.getPreTaxBalance());
            }
            if (i == 2017) {
                yearEntry.setAfterTaxCummulativeGL(yearEntry.getAfterTaxBalance());
            } else {
                yearEntry.setAfterTaxCummulativeGL(previousYearEntry.getAfterTaxCummulativeGL() + yearEntry.getAfterTaxBalance());
            }
            yearEntry.setNetProfitMargin((yearEntry.getIncome() + yearEntry.getExpenses()) / -yearEntry.getExpenses());
        }
        double npv = this.calculateNPV(model.getEconomics().getUndepreciatedValues(), input.getDiscountRate() / 100.0);
        model.getEconomics().getUndepreciatedValues().getTargetIndicators().setNPV(npv);
        double guess1 = -0.2;
        double guess2 = 0.9999;
        double irr = this.calculateIRR(model.getEconomics().getUndepreciatedValues(), guess1, guess2);
        while ((guess2 = irr) - (irr = this.calculateIRR(model.getEconomics().getUndepreciatedValues(), guess1, guess2)) > 9.0E-5) {
        }
        model.getEconomics().getUndepreciatedValues().getTargetIndicators().setIRR(irr);
    }

    public void calculateDepreciatedValues(ModelInput input, Model model) {
        for (int i = 2017; i <= 2026; ++i) {
            Values.YearEntry yearEntry = (Values.YearEntry)model.getEconomics().getDepreciatedValues().getYearEntries().get(i);
            Values.YearEntry previousYearEntry = i == 2017 ? null : (Values.YearEntry)model.getEconomics().getDepreciatedValues().getYearEntries().get(i - 1);
            OA.YearEntry oaYearEntry = (OA.YearEntry)model.getOA().getYearEntries().get(i);
            yearEntry.setOACost(-(oaYearEntry.getLicense() + oaYearEntry.getGeneralIndustrialExpenses() + oaYearEntry.getPackagingCost()));
            ShoppingCost.YearEntry depreciatedShoppingCostYearEntry = (ShoppingCost.YearEntry)model.getDepreciatedShoppingCost().getYearEntries().get(i);
            yearEntry.setTotalShoppingCost(-(depreciatedShoppingCostYearEntry.getCage() + depreciatedShoppingCostYearEntry.getNets() + depreciatedShoppingCostYearEntry.getAnchorsSystem() + depreciatedShoppingCostYearEntry.getAutofeedingMachine() + depreciatedShoppingCostYearEntry.getSupportEquipment() + depreciatedShoppingCostYearEntry.getFeed() + depreciatedShoppingCostYearEntry.getFry()));
            yearEntry.setExpenses(yearEntry.getOACost() + yearEntry.getTotalShoppingCost());
            Map revenueYearEntry = (Map)model.getRevenue().getYearEntries().get(i);
            double income = 0.0;
            for (Fish fish : input.getFishes()) {
                income += ((Revenue.YearEntry)revenueYearEntry.get(fish)).getRevenue();
            }
            yearEntry.setIncome(income);
            yearEntry.setPreTaxBalance(yearEntry.getExpenses() + yearEntry.getIncome());
            if (i == 2017) {
                yearEntry.setCummulativeCost(yearEntry.getOACost() + yearEntry.getTotalShoppingCost());
            } else {
                yearEntry.setCummulativeCost(previousYearEntry.getCummulativeCost() + yearEntry.getOACost() + yearEntry.getTotalShoppingCost());
            }
            yearEntry.setTax(yearEntry.getPreTaxBalance() > 0.0 ? -yearEntry.getPreTaxBalance() * input.getTaxRate() / 100.0 : 0.0);
            yearEntry.setAfterTaxBalance(yearEntry.getPreTaxBalance() + yearEntry.getTax());
            if (i == 2017) {
                yearEntry.setCummulativeGL(yearEntry.getPreTaxBalance());
            } else {
                yearEntry.setCummulativeGL(previousYearEntry.getCummulativeGL() + yearEntry.getPreTaxBalance());
            }
            if (i == 2017) {
                yearEntry.setAfterTaxCummulativeGL(yearEntry.getAfterTaxBalance());
            } else {
                yearEntry.setAfterTaxCummulativeGL(previousYearEntry.getAfterTaxCummulativeGL() + yearEntry.getAfterTaxBalance());
            }
            yearEntry.setNetProfitMargin((yearEntry.getIncome() + yearEntry.getExpenses()) / -yearEntry.getExpenses());
        }
        double npv = this.calculateNPV(model.getEconomics().getDepreciatedValues(), input.getDiscountRate() / 100.0);
        model.getEconomics().getDepreciatedValues().getTargetIndicators().setNPV(npv);
        double guess1 = -0.2;
        double guess2 = 0.9999;
        double irr = this.calculateIRR(model.getEconomics().getDepreciatedValues(), guess1, guess2);
        while ((guess2 = irr) - (irr = this.calculateIRR(model.getEconomics().getDepreciatedValues(), guess1, guess2)) > 9.0E-5) {
        }
        model.getEconomics().getDepreciatedValues().getTargetIndicators().setIRR(irr);
    }

    private Map<Integer, Integer> calculateFeedNeedPerYear(Model model, ModelInput input) {
        HashMap<Integer, Integer> feedNeedPerYear = new HashMap<Integer, Integer>();
        Map feedNeedPerMonth = model.getProductionParameters().getFeedNeedPerMonth();
        Set generationsPerYear = model.getProductionParameters().getGenerationsPerYear().keySet();
        int monthsToMaturity = input.getMaturity();
        ArrayList<Integer> generationsAlive = new ArrayList<Integer>();
        for (int year = 2017; year <= 2026; ++year) {
            Iterator iterator = generationsPerYear.iterator();
            while (iterator.hasNext()) {
                int generationMonth = (Integer)iterator.next();
                generationsAlive.add(generationMonth + monthsToMaturity - 1);
            }
            int feedNeedThisYear = 0;
            int harvestedGenerationsThisYear = 0;
            ListIterator iterator2 = generationsAlive.listIterator();
            block2: while (iterator2.hasNext()) {
                int listIndex = iterator2.nextIndex();
                Integer fishGenerationMonth = (Integer)iterator2.next();
                for (int month = 1; month <= 12; ++month) {
                    if (fishGenerationMonth <= 0) continue;
                    if (monthsToMaturity + 1 - fishGenerationMonth > 0) {
                        feedNeedThisYear += ((Integer)feedNeedPerMonth.get(monthsToMaturity + 1 - fishGenerationMonth)).intValue();
                    }
                    Integer n = fishGenerationMonth;
                    Integer n2 = fishGenerationMonth = Integer.valueOf(fishGenerationMonth - 1);
                    if (fishGenerationMonth > 0) {
                        generationsAlive.set(listIndex, fishGenerationMonth);
                        continue;
                    }
                    ++harvestedGenerationsThisYear;
                    iterator2.remove();
                    continue block2;
                }
            }
            feedNeedPerYear.put(year, feedNeedThisYear);
            this.harvestedGenerationsPerYear.put(year, harvestedGenerationsThisYear);
        }
        return feedNeedPerYear;
    }

    private Double calculateFryNeedPerYear(Model model) {
        Map generationsPerYear = model.getProductionParameters().getGenerationsPerYear();
        double fryNeedPerYear = 0.0;
        for (Map.Entry entry : generationsPerYear.entrySet()) {
            FryGeneration fryGeneration = (FryGeneration)entry.getValue();
            fryNeedPerYear += (double)fryGeneration.getCount() * fryGeneration.getWeightPerFish();
        }
        return fryNeedPerYear /= 1000.0;
    }

    public void calculateFishWeightPerYear(Model model) {
        int totalBiomass = model.getProductionParameters().getConsumption().getTotalBiomassPerGeneration();
        for (int year = 2017; year <= 2026; ++year) {
            double totalFishWeight = (double)(totalBiomass * (Integer)this.harvestedGenerationsPerYear.get(year)) / 1000.0;
            int fishCount = totalBiomass * (Integer)this.harvestedGenerationsPerYear.get(year) / 400;
            ((Scenario.YearEntry)model.getScenario().getYearEntries().get(year)).setKG(totalFishWeight);
            ((Scenario.YearEntry)model.getScenario().getYearEntries().get(year)).setFishCount(fishCount);
        }
        System.out.println();
    }

    public Economics calculate(ModelInput input) {
        Model model = new Model();
        model.InitYearEntries(2017, 2026, input.getFishes());
        this.setUpProductionParameters(model, input);
        this.setUpEOL(model);
        this.calculateShoppingList(model, input);
        this.calculateItemCost(model, input);
        this.calculateShoppingCost(model);
        this.calcuateDepreciatedShoppingCost(model);
        this.calculateOACost(model);
        this.calculateProductPrice(input, model);
        this.calculateProductMix(input, model);
        this.calculateRevenue(input, model);
        this.calculateUndepreciatedValues(input, model);
        this.calculateDepreciatedValues(input, model);
        return model.getEconomics();
    }

    private double calculateIRR(Values values, double guess1, double guess2) {
        double npv1 = this.calculateNPV(values, guess1);
        double npv2 = this.calculateNPV(values, guess2);
        return guess1 + npv1 * (guess2 - guess1) / (npv1 - npv2);
    }

    private double calculateNPV(Values values, double rate) {
        double npv = ((Values.YearEntry)values.getYearEntries().get(2017)).getAfterTaxBalance();
        int pow = 1;
        for (int i = 2018; i <= 2026; ++i) {
            Values.YearEntry yearEntry = (Values.YearEntry)values.getYearEntries().get(i);
            double yearRate = Math.pow(1.0 / (1.0 + rate), pow);
            npv += yearEntry.getAfterTaxBalance() * yearRate;
            ++pow;
        }
        return npv;
    }

    public static void printValues(Values values) {
        Values.YearEntry yearEntry;
        int i;
        System.out.format("%26s", "Year");
        for (i = 2017; i <= 2026; ++i) {
            yearEntry = (Values.YearEntry)values.getYearEntries().get(i);
            System.out.format("%16d", yearEntry.getYear());
        }
        System.out.println();
        System.out.format("%26s", "OA Cost");
        for (i = 2017; i <= 2026; ++i) {
            yearEntry = (Values.YearEntry)values.getYearEntries().get(i);
            System.out.format("%16.2f", yearEntry.getOACost());
        }
        System.out.println();
        System.out.format("%26s", "Total Shopping Cost");
        for (i = 2017; i <= 2026; ++i) {
            yearEntry = (Values.YearEntry)values.getYearEntries().get(i);
            System.out.format("%16.2f", yearEntry.getTotalShoppingCost());
        }
        System.out.println();
        System.out.format("%26s", "Expenses");
        for (i = 2017; i <= 2026; ++i) {
            yearEntry = (Values.YearEntry)values.getYearEntries().get(i);
            System.out.format("%16.2f", yearEntry.getExpenses());
        }
        System.out.println();
        System.out.format("%26s", "Income");
        for (i = 2017; i <= 2026; ++i) {
            yearEntry = (Values.YearEntry)values.getYearEntries().get(i);
            System.out.format("%16.2f", yearEntry.getIncome());
        }
        System.out.println();
        System.out.format("%26s", "Pre Tax Balance");
        for (i = 2017; i <= 2026; ++i) {
            yearEntry = (Values.YearEntry)values.getYearEntries().get(i);
            System.out.format("%16.2f", yearEntry.getPreTaxBalance());
        }
        System.out.println();
        System.out.format("%26s", "Cummulative Cost");
        for (i = 2017; i <= 2026; ++i) {
            yearEntry = (Values.YearEntry)values.getYearEntries().get(i);
            System.out.format("%16.2f", yearEntry.getCummulativeCost());
        }
        System.out.println();
        System.out.format("%26s", "Tax");
        for (i = 2017; i <= 2026; ++i) {
            yearEntry = (Values.YearEntry)values.getYearEntries().get(i);
            System.out.format("%16.2f", yearEntry.getTax());
        }
        System.out.println();
        System.out.format("%26s", "After Tax Balance");
        for (i = 2017; i <= 2026; ++i) {
            yearEntry = (Values.YearEntry)values.getYearEntries().get(i);
            System.out.format("%16.2f", yearEntry.getAfterTaxBalance());
        }
        System.out.println();
        System.out.format("%26s", "Cummulative GL");
        for (i = 2017; i <= 2026; ++i) {
            yearEntry = (Values.YearEntry)values.getYearEntries().get(i);
            System.out.format("%16.2f", yearEntry.getCummulativeGL());
        }
        System.out.println();
        System.out.format("%26s", "After Tax Cummulative GL");
        for (i = 2017; i <= 2026; ++i) {
            yearEntry = (Values.YearEntry)values.getYearEntries().get(i);
            System.out.format("%16.2f", yearEntry.getAfterTaxCummulativeGL());
        }
        System.out.println();
        System.out.println("NPV: " + values.getTargetIndicators().getNPV());
        System.out.println("IRR: " + values.getTargetIndicators().getIRR());
    }
}

