/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.bluebridge.analytics.controllers;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import gr.cite.bluebridge.analytics.endpoint.EndpointManager;
import gr.cite.bluebridge.analytics.endpoint.ServiceProfile;
import gr.cite.bluebridge.analytics.endpoint.exceptions.ServiceDiscoveryException;
import gr.cite.bluebridge.analytics.logic.Evaluator;
import gr.cite.bluebridge.analytics.model.Consumption;
import gr.cite.bluebridge.analytics.model.Economics;
import gr.cite.bluebridge.analytics.model.Fish;
import gr.cite.bluebridge.analytics.model.FryGeneration;
import gr.cite.bluebridge.analytics.model.ModelInput;
import gr.cite.bluebridge.analytics.web.CustomResponseEntity;
import gr.cite.bluebridge.analytics.web.Parameters;
import gr.cite.bluebridge.analytics.web.SingletonHttpClient;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/"})
public class AnalyticsResource {
    @Autowired
    private ServiceProfile simulFishGrowthDataAPI;
    @Autowired
    private SingletonHttpClient singletonHttpClient;
    @Autowired
    private EndpointManager endpointManager;
    private static Logger logger = LoggerFactory.getLogger(AnalyticsResource.class);

    @RequestMapping(value={"performAnalysis"}, method={RequestMethod.POST})
    public ResponseEntity<?> performAnalysis(@RequestBody Parameters parameters, @RequestHeader(value="scope") String scope, @RequestHeader(value="gcube-token") String token) {
        parameters.print();
        logger.info("scope = " + scope);
        logger.info("token = " + token);
        String invalidParameters = parameters.validate();
        if (invalidParameters.length() > 0) {
            logger.error(invalidParameters);
            return new ResponseEntity((Object)invalidParameters, HttpStatus.BAD_REQUEST);
        }
        try {
            List endpoints = this.endpointManager.getServiceEndpoints(scope, this.simulFishGrowthDataAPI);
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("scope", scope);
            headers.put("gcube-token", token);
            Integer status = null;
            Response clientResponse = null;
            for (String endpoint : endpoints) {
                String fromDate = "160101";
                Calendar cal = Calendar.getInstance();
                SimpleDateFormat sdf = new SimpleDateFormat("yyMMdd", Locale.ENGLISH);
                cal.setTime(sdf.parse(fromDate));
                cal.add(2, parameters.getMaturity());
                Date date = cal.getTime();
                String toDate = sdf.format(date);
                String resource = endpoint + "Scenario/execute/consumption/" + fromDate + "/" + toDate + "/217/750000/" + parameters.getModelId();
                logger.debug("Endpoint Url: " + endpoint);
                try {
                    clientResponse = this.singletonHttpClient.doGet(resource, headers);
                    status = clientResponse.getStatus();
                }
                catch (Exception e) {
                    status = this.singletonHttpClient.exceptionHandler(e);
                    this.endpointManager.removeServiceEndpoint(scope, this.simulFishGrowthDataAPI, endpoint);
                    logger.warn("Cannot reach endpoint : " + status, (Throwable)e);
                }
                if (status != 200) continue;
                break;
            }
            if (status != 200) {
                logger.warn("SimulfishGrowthDataAPI returned status " + status + " while requesting consumption");
                return new CustomResponseEntity(status, (Object)"Could not perform analysis. Service is down or has rejected the request.");
            }
            String consumptionString = (String)clientResponse.readEntity(String.class);
            ObjectMapper mapper = new ObjectMapper();
            mapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
            Consumption consumption = (Consumption)mapper.readValue(consumptionString, Consumption.class);
            ModelInput input = new ModelInput();
            Fish giltheadSeaBream = new Fish();
            giltheadSeaBream.setFish("giltheadSeaBream");
            giltheadSeaBream.setMixPercent(100.0);
            giltheadSeaBream.setInitialPrice(parameters.getSellingPrice().doubleValue());
            input.getFishes().add(giltheadSeaBream);
            input.setTaxRate(parameters.getTaxRate().doubleValue());
            input.setDiscountRate(parameters.getDiscountRate().doubleValue());
            input.setInflationRate(parameters.getInflationRate());
            input.setMaturity(parameters.getMaturity().intValue());
            input.setFeedPrice(parameters.getFeedPrice().doubleValue());
            input.setFryPrice(parameters.getFryPrice().doubleValue());
            input.setOffShoreAquaFarm(parameters.getIsOffShoreAquaFarm().booleanValue());
            input.setConsumption(consumption);
            HashMap<Integer, FryGeneration> generationsPerYear = new HashMap<Integer, FryGeneration>();
            generationsPerYear.put(1, new FryGeneration(750000, 2.17));
            generationsPerYear.put(4, new FryGeneration(750000, 2.17));
            generationsPerYear.put(7, new FryGeneration(750000, 2.17));
            generationsPerYear.put(10, new FryGeneration(750000, 2.17));
            input.setGenerationsPerYear(generationsPerYear);
            Economics economics = new Evaluator().calculate(input);
            economics.setParameters(parameters);
            logger.info("Successful request!");
            return new CustomResponseEntity(Response.Status.OK, (Object)economics);
        }
        catch (ServiceDiscoveryException e) {
            logger.error("Could not perform analysis. SimulFishGrowthDataAPI could not be discovered", (Throwable)e);
            return new CustomResponseEntity((Object)"Could not perform analysis. Server Internal Error", Response.Status.NOT_FOUND);
        }
        catch (Exception e) {
            logger.error("Could not perform analysis. Internal Error in Techno Economic Analysis Service", (Throwable)e);
            return new CustomResponseEntity((Object)"Could not perform analysis. Server Internal Error", Response.Status.INTERNAL_SERVER_ERROR);
        }
    }
}

