/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.bluebridge.analytics.endpoint;

import gr.cite.bluebridge.analytics.endpoint.DatabaseCredentials;
import gr.cite.bluebridge.analytics.endpoint.DatabaseDiscovery;
import gr.cite.bluebridge.analytics.endpoint.DatabaseProfile;
import gr.cite.bluebridge.analytics.endpoint.ServiceDiscovery;
import gr.cite.bluebridge.analytics.endpoint.ServiceProfile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;

public class EndpointManager {
    private static Map<String, Map<DatabaseProfile, DatabaseCredentials>> databaseEndpoints = new HashMap();
    private static Map<String, Map<ServiceProfile, Set<String>>> serviceEndpoints = new HashMap();
    private static Object databaseLock = new Object();
    private static Object serviceLock = new Object();
    private static Logger logger = LoggerFactory.getLogger(EndpointManager.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Scheduled(fixedDelayString="#{${cache.refresh.interval} * 60 * 1000}")
    public void refreshEndpoints() {
        Object object = serviceLock;
        synchronized (object) {
            for (String scope : serviceEndpoints.keySet()) {
                logger.info("Refreshing " + scope + " service endpoints");
                for (ServiceProfile serviceProfile : ((Map)serviceEndpoints.get(scope)).keySet()) {
                    try {
                        this.fetchServiceEndpoints(scope, serviceProfile);
                    }
                    catch (Exception e) {
                        logger.error("Cannot service refresh endpoints: " + e);
                    }
                }
            }
        }
    }

    private void fetchhDatabaseEndpoints(String scope, DatabaseProfile databaseProfile) throws Exception {
        logger.debug("Fetching  database endpoints for scope " + scope);
        DatabaseCredentials databaseCredentials = DatabaseDiscovery.fetchDatabaseCredentials((String)scope, (DatabaseProfile)databaseProfile);
        ((Map)databaseEndpoints.get(scope)).put(databaseProfile, databaseCredentials);
    }

    private void fetchServiceEndpoints(String scope, ServiceProfile serviceProfile) throws Exception {
        logger.debug("Fetching service endpoints for scope " + scope);
        Set endpoints = ServiceDiscovery.fetchServiceEndpoint((String)scope, (ServiceProfile)serviceProfile);
        ((Map)serviceEndpoints.get(scope)).put(serviceProfile, endpoints);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatabaseCredentials getDatabaseEndpoint(String scope, DatabaseProfile databaseProfile) throws Exception {
        DatabaseCredentials asynchronizedDatabaseCredentials;
        Object object = databaseLock;
        synchronized (object) {
            boolean databaseNotExists;
            boolean scopeNotExists;
            boolean bl = scopeNotExists = !databaseEndpoints.containsKey(scope);
            boolean bl2 = scopeNotExists ? true : (databaseNotExists = !((Map)databaseEndpoints.get(scope)).containsKey(databaseProfile));
            if (scopeNotExists) {
                databaseEndpoints.put(scope, new HashMap());
            }
            if (databaseNotExists) {
                this.fetchhDatabaseEndpoints(scope, databaseProfile);
            }
            DatabaseCredentials databaseCredentials = (DatabaseCredentials)((Map)databaseEndpoints.get(scope)).get(databaseProfile);
            asynchronizedDatabaseCredentials = databaseCredentials.clone();
        }
        return asynchronizedDatabaseCredentials;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getServiceEndpoints(String scope, ServiceProfile serviceProfile) throws Exception {
        ArrayList<String> asynchronizedEndpoints;
        Object object = serviceLock;
        synchronized (object) {
            boolean hasNotEndpoints;
            boolean serviceNotExists;
            boolean scopeNotExists;
            boolean bl = scopeNotExists = !serviceEndpoints.containsKey(scope);
            boolean bl2 = scopeNotExists ? true : (serviceNotExists = !((Map)serviceEndpoints.get(scope)).containsKey(serviceProfile));
            boolean bl3 = serviceNotExists ? true : (hasNotEndpoints = ((Set)((Map)serviceEndpoints.get(scope)).get(serviceProfile)).size() == 0);
            if (scopeNotExists) {
                serviceEndpoints.put(scope, new HashMap());
            }
            if (serviceNotExists || hasNotEndpoints) {
                this.fetchServiceEndpoints(scope, serviceProfile);
            }
            Set endpoints = (Set)((Map)serviceEndpoints.get(scope)).get(serviceProfile);
            asynchronizedEndpoints = new ArrayList<String>(endpoints);
        }
        Collections.shuffle(asynchronizedEndpoints);
        logger.info("Returned " + asynchronizedEndpoints.size() + " service endpoint(s)");
        return asynchronizedEndpoints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeServiceEndpoint(String scope, ServiceProfile serviceProfile, String endpoint) {
        Object object = serviceLock;
        synchronized (object) {
            if (((Set)((Map)serviceEndpoints.get(scope)).get(serviceProfile)).contains(endpoint)) {
                logger.debug("Removing endpoint " + endpoint + " from cache.");
                ((Set)((Map)serviceEndpoints.get(scope)).get(serviceProfile)).remove(endpoint);
            }
        }
    }
}

