/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.bluebridge.analytics.model;

import gr.cite.bluebridge.analytics.model.ItemCost;
import java.util.HashMap;
import java.util.Map;

public class ItemCost {
    private Map<Integer, YearEntry> yearEntries = new HashMap();

    public void InitYearEntries(int startYear, int endYear) {
        for (int i = startYear; i <= endYear; ++i) {
            YearEntry yearEntry = new YearEntry(this);
            yearEntry.setYear((double)i);
            this.yearEntries.put(i, yearEntry);
        }
    }

    public Map<Integer, YearEntry> getYearEntries() {
        return this.yearEntries;
    }

    public void setYearEntries(Map<Integer, YearEntry> yearEntries) {
        this.yearEntries = yearEntries;
    }

    public void print(int startYear, int endYear) {
        YearEntry yearEntry;
        int year;
        System.out.println("\n");
        System.out.format("%15s", "Year");
        for (year = startYear; year <= endYear; ++year) {
            System.out.format("%15d", year);
        }
        System.out.println("\n");
        System.out.format("%15s", "Cages");
        for (year = startYear; year <= endYear; ++year) {
            yearEntry = (YearEntry)this.yearEntries.get(year);
            System.out.format("%15.2f", yearEntry.getCage());
        }
        System.out.println();
        System.out.format("%15s", "Nets");
        for (year = startYear; year <= endYear; ++year) {
            yearEntry = (YearEntry)this.yearEntries.get(year);
            System.out.format("%15.2f", yearEntry.getNets());
        }
        System.out.println();
        System.out.format("%15s", "Anchors");
        for (year = startYear; year <= endYear; ++year) {
            yearEntry = (YearEntry)this.yearEntries.get(year);
            System.out.format("%15.2f", yearEntry.getAnchorsSystem());
        }
        System.out.println();
        System.out.format("%15s", "AFgMachine");
        for (year = startYear; year <= endYear; ++year) {
            yearEntry = (YearEntry)this.yearEntries.get(year);
            System.out.format("%15.2f", yearEntry.getAutofeedingMachine());
        }
        System.out.println();
        System.out.format("%15s", "SupEquipment");
        for (year = startYear; year <= endYear; ++year) {
            yearEntry = (YearEntry)this.yearEntries.get(year);
            System.out.format("%15.2f", yearEntry.getSupportEquipment());
        }
        System.out.println();
        System.out.format("%15s", "Feed");
        for (year = startYear; year <= endYear; ++year) {
            yearEntry = (YearEntry)this.yearEntries.get(year);
            System.out.format("%15.4f", yearEntry.getFeed());
        }
        System.out.println();
        System.out.format("%15s", "Fry");
        for (year = startYear; year <= endYear; ++year) {
            yearEntry = (YearEntry)this.yearEntries.get(year);
            System.out.format("%15.4f", yearEntry.getFry());
        }
    }
}

