/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.clustermanager;

import com.fasterxml.jackson.databind.ObjectMapper;
import gr.cite.clustermanager.model.ZNodeData;
import gr.cite.clustermanager.model.ZNodeDatum;
import gr.cite.geoanalytics.dataaccess.geoserverbridge.GeoServerBridge;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.curator.utils.ZKPaths;
import org.apache.log4j.Logger;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.springframework.beans.factory.annotation.Autowired;

public class DataCreator {
    static final Logger log = Logger.getLogger(DataCreator.class);
    private static String path;
    private static DataCreator instance;
    private static String host;
    private static String gosName;
    private static String geoserverName;
    private static CuratorFramework client;
    private ObjectMapper objectMapper = new ObjectMapper();
    @Autowired
    private GeoServerBridge geoServerBridge;

    private DataCreator() {
    }

    public void create() throws Exception {
        List<ZNodeData> zNodeData = this.geoServerBridge.getLayers().stream().map(x -> new ZNodeData(x.getName(), ZNodeData.ZNodeStatus.ACTIVE)).collect(Collectors.toList());
        ZNodeDatum ZNodeDatum2 = new ZNodeDatum(zNodeData, geoserverName);
        String zNodeDataAsString = this.objectMapper.writeValueAsString((Object)ZNodeDatum2);
        byte[] layersNamesByte = zNodeDataAsString.getBytes();
        String znodePath = ZKPaths.makePath((String)path, (String)gosName);
        try {
            client.setData().forPath(znodePath, layersNamesByte);
        }
        catch (KeeperException.NoNodeException e) {
            ((ACLBackgroundPathAndBytesable)client.create().creatingParentContainersIfNeeded().withMode(CreateMode.EPHEMERAL)).forPath(znodePath, layersNamesByte);
        }
    }

    public static synchronized DataCreator getInstance(String host, String path, String gosName, String geoserverName) {
        if (instance == null) {
            instance = new DataCreator();
            try {
                if (host.isEmpty() || path.isEmpty() || geoserverName.isEmpty()) {
                    throw new Exception("Host or Path is not set.");
                }
                DataCreator.setHost(host);
                DataCreator.setPath(path);
                DataCreator.setGosName(gosName);
                DataCreator.setGeoserverName(geoserverName);
                client = CuratorFrameworkFactory.newClient((String)host, (RetryPolicy)new ExponentialBackoffRetry(1000, 3));
                client.start();
                log.debug((Object)"New data monitor instance has been created");
            }
            catch (Exception e) {
                log.error((Object)"Could not start children client.");
                e.printStackTrace();
            }
        }
        return instance;
    }

    public static String getHost() {
        return host;
    }

    private static void setHost(String host) {
        DataCreator.host = host;
    }

    public static String getPath() {
        return path;
    }

    private static void setPath(String path) {
        DataCreator.path = path;
    }

    public void setGeoServerBridge(GeoServerBridge geoServerBridge) {
        this.geoServerBridge = geoServerBridge;
    }

    public static String getGosName() {
        return gosName;
    }

    public static void setGosName(String geoserverName) {
        gosName = geoserverName;
    }

    public static String getGeoserverName() {
        return geoserverName;
    }

    public static void setGeoserverName(String geoserverName) {
        DataCreator.geoserverName = geoserverName;
    }

    static {
        instance = null;
        client = null;
    }
}

