/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.clustermanager.actuators;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.log4j.Logger;

public class ClientBase
implements Serializable {
    private static final long serialVersionUID = 8587740627633188071L;
    static final Logger logger = Logger.getLogger(ClientBase.class);
    private CuratorFramework client = null;
    private ObjectMapper objectMapper;

    public ClientBase(String zkConnStr) throws Exception {
        if (this.client != null || zkConnStr == null || zkConnStr.isEmpty()) {
            throw new Exception("Zookeeper connection string is not set in spring loading properties (ClientBase). Cannot initiate zookeeper monitoring");
        }
        this.client = CuratorFrameworkFactory.newClient((String)zkConnStr, (RetryPolicy)new ExponentialBackoffRetry(1000, 3));
        this.client.start();
        this.objectMapper = new ObjectMapper();
        logger.debug((Object)"Initiated ClientBase");
    }

    public CuratorFramework getClient() {
        return this.client;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }
}

