/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.clustermanager.actuators.layers;

import com.fasterxml.jackson.databind.ObjectMapper;
import gr.cite.clustermanager.model.layers.ZNodeData;
import gr.cite.clustermanager.model.layers.ZNodeDatum;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.curator.framework.state.ConnectionStateListener;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.curator.utils.ZKPaths;
import org.apache.zookeeper.CreateMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataCreatorGos {
    static final Logger log = LoggerFactory.getLogger(DataCreatorGos.class);
    private static DataCreatorGos instance = null;
    private static String zkConnStr;
    private static String gosIdentifier;
    private static String geoserverUrl;
    private static String gosHost;
    private static String gosPort;
    private static String geoserverWorkspace;
    private static String datastoreName;
    private static CuratorFramework curatorClient;
    private Client jerseyClient = ClientBuilder.newClient();
    private ObjectMapper objectMapper = new ObjectMapper();
    private static List<String> lastCreatedLayerIDs;

    private DataCreatorGos() {
    }

    public void create(List<String> layerIDs) throws Exception {
        List<ZNodeData> zNodeData = layerIDs.stream().map(layerID -> new ZNodeData((String)layerID, ZNodeData.ZNodeStatus.ACTIVE)).collect(Collectors.toList());
        ZNodeDatum ZNodeDatum2 = new ZNodeDatum(zNodeData, geoserverUrl, gosHost, gosPort, geoserverWorkspace, datastoreName);
        String zNodeDataAsString = this.objectMapper.writeValueAsString((Object)ZNodeDatum2);
        byte[] layersNamesByte = zNodeDataAsString.getBytes();
        String znodePath = ZKPaths.makePath((String)"/layers", (String)gosIdentifier);
        try {
            curatorClient.delete().forPath(znodePath);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            ((ACLBackgroundPathAndBytesable)curatorClient.create().creatingParentContainersIfNeeded().withMode(CreateMode.EPHEMERAL)).forPath(znodePath, layersNamesByte);
            curatorClient.setData().forPath(znodePath, layersNamesByte);
        }
        catch (Exception e1) {
            e1.printStackTrace();
            boolean ok = false;
            while (!ok) {
                try {
                    ((ACLBackgroundPathAndBytesable)curatorClient.create().creatingParentContainersIfNeeded().withMode(CreateMode.EPHEMERAL)).forPath(znodePath, layersNamesByte);
                    curatorClient.setData().forPath(znodePath, layersNamesByte);
                    ok = true;
                }
                catch (Exception e2) {
                    log.warn("Could not upload current gos information. Will try again in a while...");
                    Thread.sleep(3000L);
                }
            }
        }
        lastCreatedLayerIDs = layerIDs;
    }

    public static synchronized DataCreatorGos getInstance(String setZkConnStr, String gosIdentifier, String geoserverUrl, String gosHost, String gosPort, String geoserverWorkspace, String datastoreName) {
        if (instance == null) {
            instance = new DataCreatorGos();
            try {
                if (setZkConnStr.isEmpty()) {
                    throw new Exception("Geoserver host parameter is not set on properties file.");
                }
                DataCreatorGos.setZkConnStr(setZkConnStr);
                DataCreatorGos.setGosHost(gosHost);
                DataCreatorGos.setGosPort(gosPort);
                DataCreatorGos.setGosIdentifier(gosIdentifier);
                DataCreatorGos.setGeoserverUrl(geoserverUrl);
                DataCreatorGos.setDatastoreName(datastoreName);
                DataCreatorGos.setGeoserverWorkspace(geoserverWorkspace);
                curatorClient = CuratorFrameworkFactory.newClient((String)setZkConnStr, (RetryPolicy)new ExponentialBackoffRetry(1000, Integer.MAX_VALUE));
                curatorClient.start();
                log.debug("New data monitor instance has been created");
            }
            catch (Exception e) {
                log.error("Could not start children client.");
                e.printStackTrace();
            }
            curatorClient.getConnectionStateListenable().addListener((Object)new ConnectionStateListener(){

                public void stateChanged(CuratorFramework client, ConnectionState newState) {
                    log.debug("Connection state with zookeeper changed to: " + newState);
                    if ((newState == ConnectionState.CONNECTED || newState == ConnectionState.RECONNECTED) && lastCreatedLayerIDs != null) {
                        try {
                            log.info("Republishing gos layers on cluster, due to cluster connection state change: " + newState);
                            log.debug("Republishing layers: " + lastCreatedLayerIDs);
                            instance.create(lastCreatedLayerIDs);
                        }
                        catch (Exception e) {
                            log.info("Could not republish the layers");
                        }
                    }
                }
            });
        }
        return instance;
    }

    public static String getZkConnStr() {
        return zkConnStr;
    }

    private static void setZkConnStr(String zkConnStr) {
        DataCreatorGos.zkConnStr = zkConnStr;
    }

    public static String getGosIdentifier() {
        return gosIdentifier;
    }

    public static void setGosIdentifier(String gosIdentifier) {
        DataCreatorGos.gosIdentifier = gosIdentifier;
    }

    public static String getGeoserverUrl() {
        return geoserverUrl;
    }

    public static void setGeoserverUrl(String geoserverUrl) {
        DataCreatorGos.geoserverUrl = geoserverUrl;
    }

    public static String getGosHost() {
        return gosHost;
    }

    public static void setGosHost(String gosHost) {
        DataCreatorGos.gosHost = gosHost;
    }

    public static String getGosPort() {
        return gosPort;
    }

    public static void setGosPort(String gosPort) {
        DataCreatorGos.gosPort = gosPort;
    }

    public static void setGeoserverWorkspace(String geoserverWorkspace) {
        DataCreatorGos.geoserverWorkspace = geoserverWorkspace;
    }

    public static void setDatastoreName(String datastoreName) {
        DataCreatorGos.datastoreName = datastoreName;
    }

    static {
        curatorClient = null;
        lastCreatedLayerIDs = null;
    }
}

