/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.clustermanager.actuators.layers;

import com.fasterxml.jackson.databind.ObjectMapper;
import gr.cite.clustermanager.configuration.Configuration;
import gr.cite.clustermanager.model.layers.GosDefinition;
import gr.cite.clustermanager.model.layers.ZNodeData;
import gr.cite.clustermanager.model.layers.ZNodeDatum;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.recipes.cache.PathChildrenCache;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheEvent;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheListener;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataMonitor
implements Serializable {
    private static final long serialVersionUID = -810422468564392420L;
    static final Logger log = LoggerFactory.getLogger(DataMonitor.class);
    private static DataMonitor instance = null;
    private static String zkConnStr;
    private static CuratorFramework client;
    private static PathChildrenCache cache;
    private ObjectMapper objectMapper = new ObjectMapper();
    private Map<String, ZNodeDatum> gosIdentifierToLayerData = new ConcurrentHashMap<String, ZNodeDatum>();
    private Map<String, Set<GosDefinition>> availableLayerToGosDefinitionData = new ConcurrentHashMap<String, Set<GosDefinition>>();
    private Map<String, Set<GosDefinition>> notAvailableLayerToGosDefinitionData = new ConcurrentHashMap<String, Set<GosDefinition>>();

    private static void initializeClient(String zkConnStr) {
        try {
            if (zkConnStr.isEmpty()) {
                throw new Exception("Zookeeper connection string is not set in spring loading properties. Cannot initiate zookeeper monitoring");
            }
            DataMonitor.setZkConnStr(zkConnStr);
            client = CuratorFrameworkFactory.newClient((String)DataMonitor.zkConnStr, (RetryPolicy)new ExponentialBackoffRetry(1000, Integer.MAX_VALUE));
            client.start();
            cache = new PathChildrenCache(client, "/layers", true);
            cache.start();
            DataMonitor.addListener(cache);
            log.debug("New data monitor instance has been created");
        }
        catch (Exception e) {
            log.error("Could not start children client.");
            e.printStackTrace();
        }
    }

    public static synchronized DataMonitor getInstance(String host) {
        if (instance == null) {
            instance = new DataMonitor();
            DataMonitor.initializeClient(host);
        }
        return instance;
    }

    private static void addListener(PathChildrenCache cache) {
        PathChildrenCacheListener listener = new PathChildrenCacheListener(){

            public void childEvent(CuratorFramework client, PathChildrenCacheEvent event) throws Exception {
                switch (event.getType()) {
                    case CHILD_ADDED: {
                        log.debug("Znode with name " + event.getData().getPath() + " has been ADDED.");
                        instance.addData(event);
                        log.debug("With raw data -> " + new String(event.getData().getData(), StandardCharsets.UTF_8));
                        break;
                    }
                    case CHILD_UPDATED: {
                        log.debug("Znode with name " + event.getData().getPath() + " has been UPDATED.");
                        instance.updateData(event);
                        log.debug("With raw data -> " + new String(event.getData().getData(), StandardCharsets.UTF_8));
                        break;
                    }
                    case CHILD_REMOVED: {
                        log.debug("Znode with name " + event.getData().getPath() + " has been DELETED.");
                        instance.removeData(event);
                        log.debug("With raw data -> " + new String(event.getData().getData(), StandardCharsets.UTF_8));
                        break;
                    }
                    default: {
                        log.debug("Nothing happened!!!");
                    }
                }
            }
        };
        cache.getListenable().addListener((Object)listener);
    }

    private void addData(PathChildrenCacheEvent event) throws IOException {
        String gosIdentifier = event.getData().getPath().substring("/layers".length() + 1);
        String data = new String(event.getData().getData(), StandardCharsets.UTF_8);
        try {
            ZNodeDatum zNodeDatum = (ZNodeDatum)this.objectMapper.readValue(data, ZNodeDatum.class);
            log.debug("BEFORE ADDING: " + zNodeDatum);
            this.getGosIdentifierToLayerData().put(gosIdentifier, zNodeDatum);
            zNodeDatum.getZNodeDatas().forEach(zNodeData -> {
                if (zNodeData.getzNodeStatus().equals((Object)ZNodeData.ZNodeStatus.ACTIVE)) {
                    if (!this.availableLayerToGosDefinitionData.containsKey(zNodeData.getLayerId())) {
                        this.availableLayerToGosDefinitionData.put(zNodeData.getLayerId(), new HashSet());
                    }
                    this.availableLayerToGosDefinitionData.get(zNodeData.getLayerId()).add(new GosDefinition(gosIdentifier, Configuration.getFullGosEndpoint(zNodeDatum.getGosHost(), zNodeDatum.getGosPort()), zNodeDatum.getGeoserverEndpoint(), zNodeDatum.getDatastoreName(), zNodeDatum.getGeoserverWorkspace()));
                } else {
                    if (!this.notAvailableLayerToGosDefinitionData.containsKey(zNodeData.getLayerId())) {
                        this.notAvailableLayerToGosDefinitionData.put(zNodeData.getLayerId(), new HashSet());
                    }
                    this.notAvailableLayerToGosDefinitionData.get(zNodeData.getLayerId()).add(new GosDefinition(gosIdentifier, Configuration.getFullGosEndpoint(zNodeDatum.getGosHost(), zNodeDatum.getGosPort()), zNodeDatum.getGeoserverEndpoint(), zNodeDatum.getDatastoreName(), zNodeDatum.getGeoserverWorkspace()));
                }
            });
            log.debug("AFTER ADDING: " + zNodeDatum);
        }
        catch (IOException e) {
            log.error("An error occured during deserialization of zookeeper information", (Throwable)e);
            throw e;
        }
    }

    private void updateData(PathChildrenCacheEvent event) throws IOException {
        String gosIdentifier = event.getData().getPath().substring("/layers".length() + 1);
        String data = new String(event.getData().getData(), StandardCharsets.UTF_8);
        try {
            ZNodeDatum zNodeDatum = (ZNodeDatum)this.objectMapper.readValue(data, ZNodeDatum.class);
            log.debug("BEFORE UPDATING: " + zNodeDatum);
            this.getGosIdentifierToLayerData().put(gosIdentifier, zNodeDatum);
            Map<String, ZNodeData.ZNodeStatus> layerIdStatus = zNodeDatum.getZNodeDatas().parallelStream().map(zNodeData -> {
                if (zNodeData.getzNodeStatus().equals((Object)ZNodeData.ZNodeStatus.ACTIVE)) {
                    if (!this.availableLayerToGosDefinitionData.containsKey(zNodeData.getLayerId())) {
                        this.availableLayerToGosDefinitionData.put(zNodeData.getLayerId(), new HashSet());
                    }
                    this.availableLayerToGosDefinitionData.get(zNodeData.getLayerId()).add(new GosDefinition(gosIdentifier, Configuration.getFullGosEndpoint(zNodeDatum.getGosHost(), zNodeDatum.getGosPort()), zNodeDatum.getGeoserverEndpoint(), zNodeDatum.getDatastoreName(), zNodeDatum.getGeoserverWorkspace()));
                } else {
                    if (!this.notAvailableLayerToGosDefinitionData.containsKey(zNodeData.getLayerId())) {
                        this.notAvailableLayerToGosDefinitionData.put(zNodeData.getLayerId(), new HashSet());
                    }
                    this.notAvailableLayerToGosDefinitionData.get(zNodeData.getLayerId()).add(new GosDefinition(gosIdentifier, Configuration.getFullGosEndpoint(zNodeDatum.getGosHost(), zNodeDatum.getGosPort()), zNodeDatum.getGeoserverEndpoint(), zNodeDatum.getDatastoreName(), zNodeDatum.getGeoserverWorkspace()));
                }
                return zNodeData;
            }).collect(Collectors.toMap(zNodeData -> zNodeData.getLayerId(), zNodeData -> zNodeData.getzNodeStatus()));
            this.availableLayerToGosDefinitionData = this.availableLayerToGosDefinitionData.entrySet().parallelStream().map(entry -> {
                ZNodeData.ZNodeStatus status = (ZNodeData.ZNodeStatus)((Object)((Object)layerIdStatus.get(entry.getKey())));
                if (status == null) {
                    ((Set)entry.getValue()).remove(new GosDefinition(gosIdentifier, "", "", "", ""));
                } else if (status != ZNodeData.ZNodeStatus.ACTIVE) {
                    ((Set)entry.getValue()).remove(new GosDefinition(gosIdentifier, "", "", "", ""));
                }
                return entry;
            }).collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> (Set)entry.getValue()));
            this.notAvailableLayerToGosDefinitionData = this.notAvailableLayerToGosDefinitionData.entrySet().parallelStream().map(entry -> {
                ZNodeData.ZNodeStatus status = (ZNodeData.ZNodeStatus)((Object)((Object)layerIdStatus.get(entry.getKey())));
                if (status == null) {
                    ((Set)entry.getValue()).remove(new GosDefinition(gosIdentifier, "", "", "", ""));
                } else if (status == ZNodeData.ZNodeStatus.ACTIVE) {
                    ((Set)entry.getValue()).remove(new GosDefinition(gosIdentifier, "", "", "", ""));
                }
                return entry;
            }).collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> (Set)entry.getValue()));
            log.debug("AFTER UPDATING: " + zNodeDatum);
        }
        catch (IOException e) {
            log.error("An error occured during deserialization of zookeeper information", (Throwable)e);
            throw e;
        }
    }

    private void removeData(PathChildrenCacheEvent event) throws IOException {
        String gosIdentifier = event.getData().getPath().substring("/layers".length() + 1);
        String data = new String(event.getData().getData(), StandardCharsets.UTF_8);
        try {
            ZNodeDatum zNodeDatum = (ZNodeDatum)this.objectMapper.readValue(data, ZNodeDatum.class);
            log.debug("BEFORE DELETING: " + zNodeDatum);
            this.getGosIdentifierToLayerData().remove(gosIdentifier);
            zNodeDatum.getZNodeDatas().forEach(zNodeData -> {
                if (zNodeData.getzNodeStatus().equals((Object)ZNodeData.ZNodeStatus.ACTIVE)) {
                    Set<GosDefinition> gosDefs = this.availableLayerToGosDefinitionData.get(zNodeData.getLayerId());
                    if (gosDefs != null) {
                        gosDefs.remove(new GosDefinition(gosIdentifier, Configuration.getFullGosEndpoint(zNodeDatum.getGosHost(), zNodeDatum.getGosPort()), zNodeDatum.getGeoserverEndpoint(), zNodeDatum.getDatastoreName(), zNodeDatum.getGeoserverWorkspace()));
                    }
                } else {
                    Set<GosDefinition> gosDefs = this.notAvailableLayerToGosDefinitionData.get(zNodeData.getLayerId());
                    if (gosDefs != null) {
                        gosDefs.remove(new GosDefinition(gosIdentifier, Configuration.getFullGosEndpoint(zNodeDatum.getGosHost(), zNodeDatum.getGosPort()), zNodeDatum.getGeoserverEndpoint(), zNodeDatum.getDatastoreName(), zNodeDatum.getGeoserverWorkspace()));
                    }
                }
            });
            log.debug("AFTER DELETING: " + zNodeDatum);
        }
        catch (IOException e) {
            log.error("An error occured during deserialization of zookeeper information", (Throwable)e);
            throw e;
        }
    }

    public String getZkConnStr() {
        return zkConnStr;
    }

    private static void setZkConnStr(String zkConnStr) {
        DataMonitor.zkConnStr = zkConnStr;
    }

    public Map<String, ZNodeDatum> getGosIdentifierToLayerData() {
        return this.gosIdentifierToLayerData;
    }

    public void setGosIdentifierToLayerData(Map<String, ZNodeDatum> gosIdentifierToLayerData) {
        this.gosIdentifierToLayerData = gosIdentifierToLayerData;
    }

    public Map<String, Set<GosDefinition>> getAvailableLayerToGosDefinitionData() {
        return this.availableLayerToGosDefinitionData;
    }

    public void setAvailableLayerToGosDefinitionData(Map<String, Set<GosDefinition>> availableLayerToGosDefinitionData) {
        this.availableLayerToGosDefinitionData = availableLayerToGosDefinitionData;
    }

    public Map<String, Set<GosDefinition>> getNotAvailableLayerToGosDefinitionData() {
        return this.notAvailableLayerToGosDefinitionData;
    }

    public void setNotAvailableLayerToGosDefinitionData(Map<String, Set<GosDefinition>> notAvailableLayerToGosDefinitionData) {
        this.notAvailableLayerToGosDefinitionData = notAvailableLayerToGosDefinitionData;
    }

    public Set<String> getAllGosIdentifiers() {
        return this.gosIdentifierToLayerData.keySet();
    }

    public Set<GosDefinition> getAllGosEndpoints() {
        return this.gosIdentifierToLayerData.entrySet().stream().map(entry -> new GosDefinition((String)entry.getKey(), Configuration.getFullGosEndpoint(((ZNodeDatum)entry.getValue()).getGosHost(), ((ZNodeDatum)entry.getValue()).getGosPort()), ((ZNodeDatum)entry.getValue()).getGeoserverEndpoint(), ((ZNodeDatum)entry.getValue()).getDatastoreName(), ((ZNodeDatum)entry.getValue()).getGeoserverWorkspace())).collect(Collectors.toSet());
    }

    public Set<String> getAvailableLayersOf(String gosIdentifier) {
        return this.gosIdentifierToLayerData.get(gosIdentifier).getZNodeDatas().parallelStream().filter(zNodeData -> zNodeData.getzNodeStatus() == ZNodeData.ZNodeStatus.ACTIVE).map(zNodeData -> zNodeData.getLayerId()).collect(Collectors.toSet());
    }

    public Set<String> getAllLayersOf(String gosIdentifier) {
        return this.gosIdentifierToLayerData.get(gosIdentifier).getZNodeDatas().parallelStream().map(zNodeData -> zNodeData.getLayerId()).collect(Collectors.toSet());
    }

    public Set<GosDefinition> getAvailableGosFor(String layerID) {
        HashSet availableGos = this.availableLayerToGosDefinitionData.get(layerID);
        return availableGos != null ? availableGos : new HashSet();
    }

    public Set<GosDefinition> getNotAvailableGosFor(String layerID) {
        HashSet notAvailableGos = this.notAvailableLayerToGosDefinitionData.get(layerID);
        return notAvailableGos != null ? notAvailableGos : new HashSet();
    }

    public String getGeoserverUrlFor(String gosIdentifier) {
        ZNodeDatum zDatum = this.gosIdentifierToLayerData.get(gosIdentifier);
        return zDatum != null ? zDatum.getGeoserverEndpoint() : null;
    }

    static {
        client = null;
        cache = null;
    }
}

