/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.commons.util.datarepository.inject;

import com.google.common.collect.Maps;
import com.google.inject.Provider;
import gr.cite.commons.util.datarepository.DataRepository;
import gr.cite.commons.util.datarepository.filesystem.FileSystemDataRepository;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemDataRepositoryProvider
implements Provider<DataRepository> {
    private static final Logger logger = LoggerFactory.getLogger(FileSystemDataRepositoryProvider.class);
    private FileSystemDataRepository dataRepository = new FileSystemDataRepository();

    public FileSystemDataRepositoryProvider() {
        Properties properties = new Properties();
        try (InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("fileRepositoryConfig.properties");){
            properties.load(inputStream);
            this.dataRepository.setConfig((Map)Maps.fromProperties((Properties)properties));
            this.postConstructCalls();
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private void postConstructCalls() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        List<Method> methods = Arrays.asList(FileSystemDataRepository.class.getDeclaredMethods());
        for (Method method : methods) {
            if (!method.isAnnotationPresent(PostConstruct.class)) continue;
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            method.invoke((Object)this.dataRepository, new Object[0]);
            break;
        }
    }

    public DataRepository get() {
        return this.dataRepository;
    }
}

