/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.gaap.datatransferobjects;

import com.vividsolutions.jts.io.WKTReader;
import gr.cite.geoanalytics.dataaccess.entities.shape.Shape;
import java.util.Date;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShapeMessenger {
    private static Logger logger = LoggerFactory.getLogger(ShapeMessenger.class);
    private String id = null;
    private String code = null;
    private int shapeClass = -1;
    private String name = null;
    private String geometry = null;
    private String extraData = null;
    private String importId = null;
    private String layerId = null;
    private String creatorID = null;
    private String layerGeocodeSystem = null;

    public ShapeMessenger() {
        logger.trace("Initialized default contructor for ShapeMessenger");
    }

    public ShapeMessenger(Shape shape) {
        logger.trace("Initializing ShapeMessenger...");
        this.id = shape.getId().toString();
        this.code = shape.getCode();
        this.name = shape.getName();
        this.layerId = shape.getLayerID().toString();
        if (shape.getGeography() != null) {
            this.geometry = shape.getGeography().toText();
        }
        this.extraData = shape.getExtraData();
        if (shape.getCreatorID() != null && !shape.getCreatorID().toString().isEmpty()) {
            this.creatorID = shape.getCreatorID().toString();
        }
        this.setShapeClass(shape.getShapeClass());
        logger.trace("Initialized ShapeMessenger");
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public int getShapeClass() {
        return this.shapeClass;
    }

    public void setShapeClass(int shapeClass) {
        this.shapeClass = shapeClass;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getGeometry() {
        return this.geometry;
    }

    public void setGeometry(String geometry) {
        this.geometry = geometry;
    }

    public String getExtraData() {
        return this.extraData;
    }

    public void setExtraData(String extraData) {
        this.extraData = extraData;
    }

    public String getImportId() {
        return this.importId;
    }

    public void setImportId(String importId) {
        this.importId = importId;
    }

    public String getLayerId() {
        return this.layerId;
    }

    public void setLayerId(String layerId) {
        this.layerId = layerId;
    }

    public String getLayerGeocodeSystem() {
        return this.layerGeocodeSystem;
    }

    public void setLayerGeocodeSystem(String layerGeocodeSystem) {
        this.layerGeocodeSystem = layerGeocodeSystem;
    }

    public String getCreatorID() {
        return this.creatorID;
    }

    public void setCreatorID(String creatorID) {
        this.creatorID = creatorID;
    }

    public Shape toShape() throws Exception {
        Shape shape = new Shape();
        shape.setId(UUID.fromString(this.getId()));
        shape.setCode(this.getCode());
        shape.setName(this.getName());
        shape.setShapeClass(this.getShapeClass());
        if (this.getGeometry() != null && !this.getGeometry().isEmpty()) {
            shape.setGeography(new WKTReader().read(this.getGeometry()));
        }
        shape.setExtraData(this.getExtraData());
        if (this.getLayerId() != null && !this.getLayerId().isEmpty()) {
            shape.setLayerID(UUID.fromString(this.getLayerId()));
        }
        shape.setCreationDate(new Date());
        shape.setLastUpdate(new Date());
        if (this.getCreatorID() != null && !this.getCreatorID().isEmpty()) {
            shape.setCreatorID(UUID.fromString(this.getCreatorID()));
        }
        return shape;
    }
}

