/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.gaap.datatransferobjects;

import com.fasterxml.jackson.annotation.JsonProperty;
import gr.cite.gaap.datatransferobjects.TsvImportProperties;
import gr.cite.geoanalytics.util.http.CustomException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.util.Assert;

public class ShapefileImportProperties {
    private static Logger logger = LoggerFactory.getLogger(TsvImportProperties.class);
    private String newLayerName;
    private String geocodeSystem;
    private String geocodeMapping;
    @JsonProperty(value="isTemplate")
    private boolean isTemplate;

    public ShapefileImportProperties() {
        logger.trace("Initialized default contructor for TsvImportProperties");
    }

    public String getNewLayerName() {
        return this.newLayerName;
    }

    public void setNewLayerName(String newLayerName) {
        this.newLayerName = newLayerName;
    }

    public String getGeocodeSystem() {
        return this.geocodeSystem;
    }

    public void setGeocodeSystem(String geocodeSystem) {
        this.geocodeSystem = geocodeSystem;
    }

    public String getGeocodeMapping() {
        return this.geocodeMapping;
    }

    public void setGeocodeMapping(String geocodeMapping) {
        this.geocodeMapping = geocodeMapping;
    }

    public boolean isTemplate() {
        return this.isTemplate;
    }

    public void setTemplate(boolean isTemplate) {
        this.isTemplate = isTemplate;
    }

    public void validate() throws CustomException {
        try {
            Assert.notNull((Object)this.newLayerName, (String)"Layer name cannot be empty");
            Assert.hasLength((String)this.newLayerName, (String)"Layer name cannot be empty");
            if (this.isTemplate) {
                Assert.notNull((Object)this.geocodeSystem, (String)"Geocode System name cannot be empty");
                Assert.hasLength((String)this.geocodeSystem, (String)"Geocode System name cannot be empty");
                Assert.notNull((Object)this.geocodeMapping, (String)"Geocode Mapping cannot be empty");
                Assert.hasLength((String)this.geocodeMapping, (String)"Geocode Mapping cannot be empty");
            }
        }
        catch (IllegalArgumentException e) {
            throw new CustomException(HttpStatus.BAD_REQUEST, e.getMessage());
        }
    }

    public String toString() {
        return "\nNew Layer = " + this.newLayerName + "\nIs Template = " + this.isTemplate + "\nGeocode System = " + this.geocodeSystem + "\nGeocode Mapping = " + this.geocodeMapping + "\n";
    }
}

