/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.gaap.datatransferobjects;

import gr.cite.geoanalytics.util.http.CustomException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.util.Assert;

public class TsvImportProperties {
    private static Logger logger = LoggerFactory.getLogger(TsvImportProperties.class);
    private String layerName;
    private String geocodeSystem;
    private String fileName;

    public TsvImportProperties() {
        logger.trace("Initialized default contructor for TsvImportProperties");
    }

    public String getLayerName() {
        return this.layerName;
    }

    public void setLayerName(String layerName) {
        this.layerName = layerName;
    }

    public String getGeocodeSystem() {
        return this.geocodeSystem;
    }

    public void setGeocodeSystem(String geocodeSystem) {
        this.geocodeSystem = geocodeSystem;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void validate() throws CustomException {
        try {
            Assert.notNull((Object)this.layerName, (String)"Layer name cannot be empty");
            Assert.notNull((Object)this.geocodeSystem, (String)"Geocode System cannot be empty");
            Assert.hasLength((String)this.layerName, (String)"Layer name cannot be empty");
            Assert.hasLength((String)this.geocodeSystem, (String)"Geocode System cannot be empty");
        }
        catch (IllegalArgumentException e) {
            throw new CustomException(HttpStatus.BAD_REQUEST, e.getMessage());
        }
    }

    public String toString() {
        return "TsvImportProperties [newLayerName=" + this.layerName + ", geocodeSystemName=" + this.geocodeSystem + ", filename=" + this.fileName + "]";
    }
}

