/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.gaap.datatransferobjects.plugin;

import java.util.Calendar;

public class ExecutionDetailsInfo {
    private String executionDetailsID;
    private String submissionOrigin;
    private String startTimestamp;
    private String stopTimestamp;
    private String status;
    private Integer progress;
    private String layerName;
    private String layerId;
    private String userName;
    private String pluginName;
    private String projectName;
    private String tenantName;

    public ExecutionDetailsInfo() {
    }

    public ExecutionDetailsInfo(String executionDetailsID, String submissionOrigin, Long startTimestamp, Long stopTimestamp, String status, Integer progress, String layerName, String layerId, String userName, String pluginName, String projectName, String tenantName) {
        this.executionDetailsID = executionDetailsID;
        this.submissionOrigin = submissionOrigin;
        this.startTimestamp = this.convertMiliSecondsToDateString(startTimestamp);
        this.stopTimestamp = this.convertMiliSecondsToDateString(stopTimestamp);
        this.status = status;
        this.progress = progress;
        this.layerName = layerName;
        this.userName = userName;
        this.pluginName = pluginName;
        this.projectName = projectName;
        this.tenantName = tenantName;
    }

    public String getExecutionDetailsID() {
        return this.executionDetailsID;
    }

    public void setExecutionDetailsID(String executionDetailsID) {
        this.executionDetailsID = executionDetailsID;
    }

    public String getSubmissionOrigin() {
        return this.submissionOrigin;
    }

    public void setSubmissionOrigin(String submissionOrigin) {
        this.submissionOrigin = submissionOrigin;
    }

    public String getStartTimestamp() {
        return this.startTimestamp;
    }

    public void setStartTimestamp(Long startTimestamp) {
        this.startTimestamp = this.convertMiliSecondsToDateString(startTimestamp);
    }

    public String getStopTimestamp() {
        return this.stopTimestamp;
    }

    public void setStopTimestamp(Long stopTimestamp) {
        this.stopTimestamp = this.convertMiliSecondsToDateString(stopTimestamp);
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Integer getProgress() {
        return this.progress;
    }

    public void setProgress(Integer progress) {
        this.progress = progress;
    }

    public String getLayerName() {
        return this.layerName;
    }

    public void setLayerName(String layerName) {
        this.layerName = layerName;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPluginName() {
        return this.pluginName;
    }

    public void setPluginName(String pluginName) {
        this.pluginName = pluginName;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getTenantName() {
        return this.tenantName;
    }

    public void setTenantName(String tenantName) {
        this.tenantName = tenantName;
    }

    public String getLayerId() {
        return this.layerId;
    }

    public void setLayerId(String layerId) {
        this.layerId = layerId;
    }

    public String convertMiliSecondsToDateString(Long timeStamp) {
        if (timeStamp == null || timeStamp == 0L) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(timeStamp);
        int mYear = calendar.get(1);
        int mMonth = calendar.get(2);
        int mDay = calendar.get(5);
        int mHour = calendar.get(11);
        int mMinutes = calendar.get(12);
        return mMonth + "/" + mDay + "/" + mYear + " " + mHour + ":" + mMinutes;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.executionDetailsID == null ? 0 : this.executionDetailsID.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExecutionDetailsInfo other = (ExecutionDetailsInfo)obj;
        return !(this.executionDetailsID == null ? other.executionDetailsID != null : !this.executionDetailsID.equals(other.executionDetailsID));
    }

    public String toString() {
        return "ExecutionDetailsInfo [executionDetailsID=" + this.executionDetailsID + ", submissionOrigin=" + this.submissionOrigin + ", startTimestamp=" + this.startTimestamp + ", stopTimestamp=" + this.stopTimestamp + ", status=" + this.status + ", progress=" + this.progress + ", layerName=" + this.layerName + ", userName=" + this.userName + ", pluginName=" + this.pluginName + ", projectName=" + this.projectName + "]";
    }
}

