/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.gaap.datatransferobjects.request;

import gr.cite.geoanalytics.util.http.CustomException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.util.Assert;

public class ImportMetadata {
    private static Logger logger = LoggerFactory.getLogger(ImportMetadata.class);
    private String user;
    private String title;
    private String description;
    private String purpose;
    private String limitation;
    private List<String> keywords;
    private String distributorOrganisationName;
    private String distributorIndividualName;
    private String distributorOnlineResource;
    private String providerOrganisationName;
    private String providerIndividualName;
    private String providerOnlineResource;

    public ImportMetadata() {
        logger.trace("Initialized default contructor for ImportMetadata");
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setAbstractField(String abstractField) {
        this.description = abstractField;
    }

    public String getPurpose() {
        return this.purpose;
    }

    public void setPurpose(String purpose) {
        this.purpose = purpose;
    }

    public String getLimitation() {
        return this.limitation;
    }

    public void setLimitation(String limitation) {
        this.limitation = limitation;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getDistributorOrganisationName() {
        return this.distributorOrganisationName;
    }

    public void setDistributorOrganisationName(String distributorOrganisationName) {
        this.distributorOrganisationName = distributorOrganisationName;
    }

    public String getDistributorIndividualName() {
        return this.distributorIndividualName;
    }

    public void setDistributorIndividualName(String distributorIndividualName) {
        this.distributorIndividualName = distributorIndividualName;
    }

    public String getDistributorOnlineResource() {
        return this.distributorOnlineResource;
    }

    public void setDistributorOnlineResource(String distributorOnlineResource) {
        this.distributorOnlineResource = distributorOnlineResource;
    }

    public String getProviderOrganisationName() {
        return this.providerOrganisationName;
    }

    public void setProviderOrganisationName(String providerOrganisationName) {
        this.providerOrganisationName = providerOrganisationName;
    }

    public String getProviderIndividualName() {
        return this.providerIndividualName;
    }

    public void setProviderIndividualName(String providerIndividualName) {
        this.providerIndividualName = providerIndividualName;
    }

    public String getProviderOnlineResource() {
        return this.providerOnlineResource;
    }

    public void setProviderOnlineResource(String providerOnlineResource) {
        this.providerOnlineResource = providerOnlineResource;
    }

    public List<String> getKeywords() {
        return this.keywords;
    }

    public void setKeywords(List<String> keywords) {
        this.keywords = keywords;
    }

    public void validate() throws Exception {
        try {
            Assert.notNull((Object)this.user, (String)"Auth. Organization cannot name be empty");
            Assert.notNull((Object)this.title, (String)"Layer name cannot be empty");
            Assert.notNull((Object)this.description, (String)"Layer description name cannot be empty");
            Assert.notNull((Object)this.purpose, (String)"Layer purpose name cannot be empty");
            Assert.notNull((Object)this.limitation, (String)"Layer limitation cannot be empty");
            Assert.notNull((Object)this.distributorOrganisationName, (String)"Distr. Organization cannot be empty");
            Assert.notNull((Object)this.distributorIndividualName, (String)"Distributor/s cannot be empty");
            Assert.notNull((Object)this.distributorOnlineResource, (String)"URL of distribution cannot be empty");
            Assert.notNull((Object)this.providerOrganisationName, (String)"Prov. Organization cannot be empty");
            Assert.notNull((Object)this.providerIndividualName, (String)"Providers cannot be empty");
            Assert.notNull((Object)this.providerOnlineResource, (String)"URL of provision cannot be empty");
            Assert.hasLength((String)this.user, (String)"Auth. Organization name cannot be empty");
            Assert.hasLength((String)this.title, (String)"Layer name cannot be empty");
            Assert.hasLength((String)this.description, (String)"Layer description name cannot be empty");
            Assert.hasLength((String)this.purpose, (String)"Layer purpose name cannot be empty");
            Assert.hasLength((String)this.limitation, (String)"Layer limitation cannot be empty");
            Assert.hasLength((String)this.distributorOrganisationName, (String)"Distr. Organization cannot be empty");
            Assert.hasLength((String)this.distributorIndividualName, (String)"Distributor/s cannot be empty");
            Assert.hasLength((String)this.distributorOnlineResource, (String)"URL of distribution cannot be empty");
            Assert.hasLength((String)this.providerOrganisationName, (String)"Prov. Organization cannot be empty");
            Assert.hasLength((String)this.providerIndividualName, (String)"Providers cannot be empty");
            Assert.hasLength((String)this.providerOnlineResource, (String)"URL of provision cannot be empty");
            Assert.notEmpty(this.keywords, (String)"Layer keywords cannot be empty");
        }
        catch (IllegalArgumentException e) {
            throw new CustomException(HttpStatus.BAD_REQUEST, e.getMessage());
        }
    }

    public String toString() {
        return "ImportMetadata [user=" + this.user + ", title=" + this.title + ", abstractField=" + this.description + ", purpose=" + this.purpose + ", keywords=" + this.keywords + ", limitation=" + this.limitation + ", distributorOrganisationName=" + this.distributorOrganisationName + ", distributorIndividualName=" + this.distributorIndividualName + ", distributorOnlineResource=" + this.distributorOnlineResource + ", providerOrganisationName=" + this.providerOrganisationName + ", providerIndividualName=" + this.providerIndividualName + ", providerOnlineResource=" + this.providerOnlineResource + "]";
    }
}

