/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.gaap.datatransferobjects;

import com.fasterxml.jackson.annotation.JsonProperty;
import gr.cite.gaap.datatransferobjects.TsvImportProperties;
import gr.cite.geoanalytics.util.http.CustomException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.util.Assert;

public class ShapefileImportProperties {
    private static Logger logger = LoggerFactory.getLogger(TsvImportProperties.class);
    private String newLayerName;
    private String geocodeSystem;
    private String geocodeMapping;
    private String style;
    private String dbfEncoding;
    private String description;
    private List<String> tags;
    @JsonProperty(value="isTemplate")
    private boolean isTemplate;

    public ShapefileImportProperties() {
        logger.trace("Initialized default contructor for TsvImportProperties");
    }

    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getNewLayerName() {
        return this.newLayerName;
    }

    public void setNewLayerName(String newLayerName) {
        this.newLayerName = newLayerName;
    }

    public String getGeocodeSystem() {
        return this.geocodeSystem;
    }

    public void setGeocodeSystem(String geocodeSystem) {
        this.geocodeSystem = geocodeSystem;
    }

    public String getGeocodeMapping() {
        return this.geocodeMapping;
    }

    public void setGeocodeMapping(String geocodeMapping) {
        this.geocodeMapping = geocodeMapping;
    }

    public boolean isTemplate() {
        return this.isTemplate;
    }

    public void setTemplate(boolean isTemplate) {
        this.isTemplate = isTemplate;
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public String getDbfEncoding() {
        return this.dbfEncoding;
    }

    public void setDbfEncoding(String dbfEncoding) {
        this.dbfEncoding = dbfEncoding;
    }

    public void validate() throws CustomException {
        try {
            Assert.notNull((Object)this.newLayerName, (String)"Layer name cannot be empty");
            Assert.hasLength((String)this.newLayerName, (String)"Layer name cannot be empty");
            Assert.notNull((Object)this.style, (String)"Style cannot be empty");
            Assert.hasLength((String)this.style, (String)"Style cannot be empty");
            Assert.notEmpty(this.tags, (String)"Tags cannot be empty");
            if (this.isTemplate) {
                Assert.notNull((Object)this.geocodeSystem, (String)"Geocode System name cannot be empty");
                Assert.hasLength((String)this.geocodeSystem, (String)"Geocode System name cannot be empty");
                Assert.notNull((Object)this.geocodeMapping, (String)"Geocode Mapping cannot be empty");
                Assert.hasLength((String)this.geocodeMapping, (String)"Geocode Mapping cannot be empty");
            }
        }
        catch (IllegalArgumentException e) {
            throw new CustomException(HttpStatus.BAD_REQUEST, e.getMessage());
        }
    }

    public String toString() {
        return "ShapefileImportProperties [newLayerName=" + this.newLayerName + ", geocodeSystem=" + this.geocodeSystem + ", geocodeMapping=" + this.geocodeMapping + ", style=" + this.style + ", isTemplate=" + this.isTemplate + "]";
    }
}

