/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.gaap.datatransferobjects;

import gr.cite.geoanalytics.util.http.CustomException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.util.Assert;

public class GeoTiffImportProperties {
    private static Logger logger = LoggerFactory.getLogger(GeoTiffImportProperties.class);
    private String layerName;
    private String style;
    private String description;
    private List<String> tags;

    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public GeoTiffImportProperties() {
        logger.trace("Initialized default contructor for GeoTiffImportProperties");
    }

    public String getLayerName() {
        return this.layerName;
    }

    public void setLayerName(String layerName) {
        this.layerName = layerName;
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public void validate() throws CustomException {
        try {
            Assert.isTrue((this.layerName != null && !this.layerName.isEmpty() ? 1 : 0) != 0, (String)"Layer Name cannot be empty");
            Assert.isTrue((this.style != null && !this.style.isEmpty() ? 1 : 0) != 0, (String)"Style cannot be empty");
            Assert.notEmpty(this.tags, (String)"Tags cannot be empty");
        }
        catch (IllegalArgumentException e) {
            throw new CustomException(HttpStatus.BAD_REQUEST, e.getMessage());
        }
    }

    public String toString() {
        return "GeoTiffImportProperties [layerName=" + this.layerName + ", style=" + this.style + "]";
    }
}

