/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.gaap.datatransferobjects;

import com.fasterxml.jackson.annotation.JsonProperty;
import gr.cite.geoanalytics.util.http.CustomException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.util.Assert;

public class ShapefileImportProperties {
    private static Logger logger = LoggerFactory.getLogger(ShapefileImportProperties.class);
    private String newLayerName;
    private String geocodeSystem;
    private String geocodeMapping;
    private String style;
    private String dbfEncoding;
    private boolean dbfUserInput;
    private String description;
    private List<String> tags;
    private String srid;
    @JsonProperty(value="isTemplate")
    private boolean isTemplate;

    public ShapefileImportProperties() {
        logger.trace("Initialized default contructor for TsvImportProperties");
    }

    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getNewLayerName() {
        return this.newLayerName;
    }

    public void setNewLayerName(String newLayerName) {
        this.newLayerName = newLayerName;
    }

    public String getGeocodeSystem() {
        return this.geocodeSystem;
    }

    public void setGeocodeSystem(String geocodeSystem) {
        this.geocodeSystem = geocodeSystem;
    }

    public String getGeocodeMapping() {
        return this.geocodeMapping;
    }

    public void setGeocodeMapping(String geocodeMapping) {
        this.geocodeMapping = geocodeMapping;
    }

    public boolean isTemplate() {
        return this.isTemplate;
    }

    public void setTemplate(boolean isTemplate) {
        this.isTemplate = isTemplate;
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public String getDbfEncoding() {
        return this.dbfEncoding;
    }

    public void setDbfEncoding(String dbfEncoding) {
        this.dbfEncoding = dbfEncoding;
    }

    public boolean isDbfUserInput() {
        return this.dbfUserInput;
    }

    public void setDbfUserInput(boolean dbfUserInput) {
        this.dbfUserInput = dbfUserInput;
    }

    public String getSrid() {
        return this.srid;
    }

    public void setSrid(String srid) {
        this.srid = srid;
    }

    public void validate() throws CustomException {
        try {
            Assert.notNull((Object)this.newLayerName, (String)"Layer name cannot be empty");
            Assert.hasLength((String)this.newLayerName, (String)"Layer name cannot be empty");
            Assert.notNull((Object)this.style, (String)"Style cannot be empty");
            Assert.hasLength((String)this.style, (String)"Style cannot be empty");
            Assert.notEmpty(this.tags, (String)"Tags cannot be empty");
            Assert.notNull((Object)this.dbfEncoding, (String)"Encoding cannot be empty");
            if (this.isTemplate) {
                Assert.notNull((Object)this.geocodeSystem, (String)"Geocode System name cannot be empty");
                Assert.hasLength((String)this.geocodeSystem, (String)"Geocode System name cannot be empty");
                Assert.notNull((Object)this.geocodeMapping, (String)"Geocode Mapping cannot be empty");
                Assert.hasLength((String)this.geocodeMapping, (String)"Geocode Mapping cannot be empty");
            }
        }
        catch (IllegalArgumentException e) {
            throw new CustomException(HttpStatus.BAD_REQUEST, e.getMessage());
        }
    }

    public void DecodeToUTF8() throws UnsupportedEncodingException {
        this.setNewLayerName(URLDecoder.decode(this.getNewLayerName(), "UTF-8"));
        this.setDescription(URLDecoder.decode(this.getDescription(), "UTF-8"));
        this.setTags(this.getTags().stream().map(tag -> {
            try {
                return URLDecoder.decode(tag, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                return tag;
            }
        }).collect(Collectors.toList()));
    }

    public String toString() {
        return "ShapefileImportProperties [newLayerName=" + this.newLayerName + ", geocodeSystem=" + this.geocodeSystem + ", geocodeMapping=" + this.geocodeMapping + ", style=" + this.style + ", isTemplate=" + this.isTemplate + "]";
    }
}

