/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.gaap.geospatialbackend;

import com.vividsolutions.jts.geom.Geometry;
import gr.cite.gaap.datatransferobjects.AttributeInfo;
import gr.cite.gaap.datatransferobjects.Coords;
import gr.cite.gaap.datatransferobjects.GeoLocation;
import gr.cite.gaap.datatransferobjects.GeoSearchSelection;
import gr.cite.gaap.datatransferobjects.NewProjectData;
import gr.cite.gaap.servicelayer.ShapeInfo;
import gr.cite.gaap.servicelayer.ShapeManager;
import gr.cite.geoanalytics.dataaccess.entities.principal.Principal;
import gr.cite.geoanalytics.dataaccess.entities.project.Project;
import gr.cite.geoanalytics.dataaccess.entities.shape.Shape;
import gr.cite.geoanalytics.dataaccess.entities.shape.ShapeImport;
import gr.cite.geoanalytics.dataaccess.entities.taxonomy.Taxonomy;
import gr.cite.geoanalytics.dataaccess.entities.taxonomy.TaxonomyTerm;
import gr.cite.geoanalytics.dataaccess.entities.taxonomy.TaxonomyTermShape;
import gr.cite.geoanalytics.dataaccess.geoserverbridge.elements.Bounds;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.springframework.stereotype.Service;

@Service
public interface GeospatialBackend {
    public Shape findShapeById(UUID var1) throws IOException;

    public ShapeInfo findShapeByIdInfo(UUID var1) throws Exception;

    public String retrieveShapeAttributeValue(Shape var1, String var2) throws Exception;

    public AttributeInfo retrieveShapeAttribute(Shape var1, String var2) throws Exception;

    public AttributeInfo retrieveShapeAttributeByTaxonomy(Shape var1, String var2) throws Exception;

    public void addShapeAttribute(Shape var1, String var2, String var3, Taxonomy var4) throws Exception;

    public void setShapeAttributes(Shape var1, Map<String, AttributeInfo> var2) throws Exception;

    public void updateShapeAttribute(Shape var1, String var2, String var3) throws Exception;

    public void removeShapeAttribute(Shape var1, String var2) throws Exception;

    public Map<String, AttributeInfo> consolidateAttributes(Shape var1) throws Exception;

    public Map<String, AttributeInfo> computeAttributes(Shape var1) throws Exception;

    public Map<String, AttributeInfo> retrieveShapeAttributes(Shape var1) throws Exception;

    public Set<String> getShapeAttributeValues(Taxonomy var1) throws Exception;

    public String generateShapesOfImport(TaxonomyTerm var1, Map<String, Map<String, AttributeInfo>> var2, Map<String, Set<String>> var3, UUID var4, String var5, ShapeManager.GeographyHierarchy var6, Principal var7) throws Exception;

    public void generateShapeBoundary(TaxonomyTerm var1, TaxonomyTerm var2, Principal var3) throws Exception;

    public List<Shape> getShapesOfImport(UUID var1) throws Exception;

    public List<Shape> getShapesOfLayer(String var1, String var2) throws Exception;

    public List<Shape> getShapesOfLayer(TaxonomyTerm var1) throws Exception;

    public List<ShapeInfo> getShapeInfoForTerm(String var1, String var2) throws Exception;

    public Shape getShapeFromLayerTermAndShapeTerm(TaxonomyTerm var1, TaxonomyTerm var2);

    public Shape getShapeFromLayerTermAndShapeTerm(TaxonomyTerm var1, TaxonomyTerm var2, boolean var3);

    public Map<String, Shape> getShapesFromLayerTerm(TaxonomyTerm var1);

    public TaxonomyTerm getTermFromLayerTermAndShape(TaxonomyTerm var1, Shape var2);

    public TaxonomyTerm getTermFromLayerTermAndShape(TaxonomyTerm var1, Shape var2, boolean var3);

    public void deleteShapesOfTerm(TaxonomyTerm var1) throws Exception;

    public List<TaxonomyTermShape> findTermMappingsOfLayerShapes(TaxonomyTerm var1) throws Exception;

    public List<TaxonomyTerm> findTaxonomyTermShapes(Shape var1) throws Exception;

    public List<TaxonomyTerm> findTaxonomyTermShapes(Shape var1, boolean var2) throws Exception;

    public List<Shape> findShapesOfImport(ShapeImport var1) throws Exception;

    public long countShapesOfImport(UUID var1) throws Exception;

    public List<ShapeInfo> findShapesOfImport(UUID var1) throws Exception;

    public List<ShapeInfo> findShapeWithinBounds(String var1) throws Exception;

    public List<Shape> findShapesEnclosingGeometry(Shape var1) throws Exception;

    public List<Shape> findShapesOfLayerEnclosingGeometry(Shape var1, TaxonomyTerm var2) throws Exception;

    public List<Shape> findShapesOfLayerEnclosingGeometry(Shape var1, TaxonomyTerm var2, TaxonomyTerm var3) throws Exception;

    public List<Shape> findShapesEnclosingGeometry(Geometry var1) throws Exception;

    public List<Shape> findShapesOfLayerEnclosingGeometry(Geometry var1, TaxonomyTerm var2) throws Exception;

    public List<Shape> findShapesOfLayerEnclosingGeometry(Geometry var1, TaxonomyTerm var2, TaxonomyTerm var3) throws Exception;

    public boolean existShapesOfTerm(TaxonomyTerm var1) throws Exception;

    public ShapeInfo getShape(UUID var1) throws Exception;

    public Bounds getShapeBounds(UUID var1) throws Exception;

    public Shape createFromGeometry(Project var1, String var2) throws Exception;

    public void updateGeometry(UUID var1, String var2) throws Exception;

    public String getGeometry(UUID var1) throws Exception;

    public String getBoundingBoxByProjectName(String var1) throws Exception;

    public void update(Shape var1) throws Exception;

    public void delete(List<String> var1) throws Exception;

    public ShapeManager.GeographyHierarchy getDefaultGeographyHierarchy() throws Exception;

    public ShapeManager.GeographyHierarchy getGeographyHierarchy(Taxonomy var1) throws Exception;

    public List<TaxonomyTerm> geoLocate(double var1, double var3) throws Exception;

    public List<GeoLocation> termLocate(GeoSearchSelection.SearchType var1, String var2, Principal var3) throws Exception;

    public Map<UUID, List<TaxonomyTerm>> getBreadcrumbs(Coords var1) throws Exception;

    public List<GeoLocation> attributeLocate(GeoSearchSelection.SearchType var1, Map<String, String> var2, Principal var3) throws Exception;

    public Set<String> getAttributeValuesOfShapesByTerm(TaxonomyTerm var1, Shape.Attribute var2) throws Exception;

    public void createShapeAssociationsWithLayerTerm(TaxonomyTerm var1, List<Shape> var2);

    public Shape createFromGeometryPolygon(Project var1, NewProjectData var2, Principal var3) throws Exception;
}

