/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.gaap.servicelayer;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.io.WKTReader;
import com.vividsolutions.jts.io.WKTWriter;
import gr.cite.commons.util.datarepository.DataRepository;
import gr.cite.commons.util.datarepository.elements.RepositoryFile;
import gr.cite.gaap.datatransferobjects.AttributeInfo;
import gr.cite.gaap.datatransferobjects.Coords;
import gr.cite.gaap.datatransferobjects.GeoLocation;
import gr.cite.gaap.datatransferobjects.GeoLocationTag;
import gr.cite.gaap.datatransferobjects.GeoSearchSelection;
import gr.cite.gaap.datatransferobjects.NewProjectData;
import gr.cite.gaap.geospatialbackend.GeospatialBackend;
import gr.cite.gaap.servicelayer.ConfigurationManager;
import gr.cite.gaap.servicelayer.DocumentManager;
import gr.cite.gaap.servicelayer.ShapeImportManager;
import gr.cite.gaap.servicelayer.ShapeInfo;
import gr.cite.gaap.servicelayer.TaxonomyManager;
import gr.cite.gaap.utilities.ExceptionUtils;
import gr.cite.gaap.utilities.StringUtils;
import gr.cite.geoanalytics.common.ShapeAttributeDataType;
import gr.cite.geoanalytics.dataaccess.dao.UUIDGenerator;
import gr.cite.geoanalytics.dataaccess.entities.Entity;
import gr.cite.geoanalytics.dataaccess.entities.document.Document;
import gr.cite.geoanalytics.dataaccess.entities.principal.Principal;
import gr.cite.geoanalytics.dataaccess.entities.project.Project;
import gr.cite.geoanalytics.dataaccess.entities.project.dao.ProjectDao;
import gr.cite.geoanalytics.dataaccess.entities.security.principal.dao.PrincipalDao;
import gr.cite.geoanalytics.dataaccess.entities.shape.Shape;
import gr.cite.geoanalytics.dataaccess.entities.shape.ShapeDocument;
import gr.cite.geoanalytics.dataaccess.entities.shape.ShapeImport;
import gr.cite.geoanalytics.dataaccess.entities.shape.ShapeTerm;
import gr.cite.geoanalytics.dataaccess.entities.shape.dao.ShapeDao;
import gr.cite.geoanalytics.dataaccess.entities.shape.dao.ShapeDocumentDao;
import gr.cite.geoanalytics.dataaccess.entities.shape.dao.ShapeTermDao;
import gr.cite.geoanalytics.dataaccess.entities.sysconfig.xml.global.TaxonomyConfig;
import gr.cite.geoanalytics.dataaccess.entities.sysconfig.xml.mapping.AttributeMappingConfig;
import gr.cite.geoanalytics.dataaccess.entities.taxonomy.Taxonomy;
import gr.cite.geoanalytics.dataaccess.entities.taxonomy.TaxonomyTerm;
import gr.cite.geoanalytics.dataaccess.entities.taxonomy.TaxonomyTermLink;
import gr.cite.geoanalytics.dataaccess.entities.taxonomy.TaxonomyTermShape;
import gr.cite.geoanalytics.dataaccess.entities.taxonomy.dao.TaxonomyDao;
import gr.cite.geoanalytics.dataaccess.entities.taxonomy.dao.TaxonomyTermDao;
import gr.cite.geoanalytics.dataaccess.entities.taxonomy.dao.TaxonomyTermLinkDao;
import gr.cite.geoanalytics.dataaccess.entities.taxonomy.dao.TaxonomyTermShapeDao;
import gr.cite.geoanalytics.dataaccess.entities.taxonomy.definition.TaxonomyData;
import gr.cite.geoanalytics.dataaccess.geoserverbridge.elements.Bounds;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@Service
@Primary
public class ShapeManager
implements GeospatialBackend {
    private static final Logger log = LoggerFactory.getLogger(ShapeManager.class);
    protected TaxonomyManager taxonomyManager;
    private DocumentManager documentManager;
    private DataRepository repository;
    protected ConfigurationManager configurationManager;
    private ShapeImportManager shapeImportManager;
    private ShapeDao shapeDao;
    private ShapeTermDao shapeTermDao;
    private ShapeDocumentDao shapeDocumentDao;
    private TaxonomyDao taxonomyDao;
    private TaxonomyTermDao taxonomyTermDao;
    private TaxonomyTermLinkDao taxonomyTermLinkDao;
    private TaxonomyTermShapeDao taxonomyTermShapeDao;
    private ProjectDao projectDao;
    private PrincipalDao principalDao;
    private static final String NoMappingKey = "\t\t\t__NoVal__\t\t\t";
    private static final String NoValueKey = "";

    @Inject
    public ShapeManager(PrincipalDao principalDao, TaxonomyManager taxonomyManager, DocumentManager documentManager, DataRepository repository, ConfigurationManager configurationManager) {
        this.principalDao = principalDao;
        this.taxonomyManager = taxonomyManager;
        this.documentManager = documentManager;
        this.repository = repository;
        this.configurationManager = configurationManager;
    }

    @Inject
    public void setShapeImportManager(ShapeImportManager shapeImportManager) {
        this.shapeImportManager = shapeImportManager;
    }

    @Inject
    public void setShapeDao(ShapeDao shapeDao) {
        this.shapeDao = shapeDao;
    }

    @Inject
    public void setShapeTermDao(ShapeTermDao shapeTermDao) {
        this.shapeTermDao = shapeTermDao;
    }

    @Inject
    public void setShapeDocumentDao(ShapeDocumentDao shapeDocumentDao) {
        this.shapeDocumentDao = shapeDocumentDao;
    }

    @Inject
    public void setTaxonomyDao(TaxonomyDao taxonomyDao) {
        this.taxonomyDao = taxonomyDao;
    }

    @Inject
    public void setTaxonomyTermDao(TaxonomyTermDao taxonomyTermDao) {
        this.taxonomyTermDao = taxonomyTermDao;
    }

    @Inject
    public void setTaxonomyTermLinkDao(TaxonomyTermLinkDao taxonomyTermLinkDao) {
        this.taxonomyTermLinkDao = taxonomyTermLinkDao;
    }

    @Inject
    public void setTaxonomyTermShapeDao(TaxonomyTermShapeDao taxonomyTermShapeDao) {
        this.taxonomyTermShapeDao = taxonomyTermShapeDao;
    }

    @Inject
    public void setProjectDao(ProjectDao projectDao) {
        this.projectDao = projectDao;
    }

    @Override
    @Transactional(readOnly=true)
    public Shape findShapeById(UUID id) throws IOException {
        return (Shape)this.shapeDao.read((Serializable)id);
    }

    @Override
    @Transactional(readOnly=true)
    public ShapeInfo findShapeByIdInfo(UUID id) throws Exception {
        Shape s = (Shape)this.shapeDao.read((Serializable)id);
        ShapeInfo si = new ShapeInfo();
        si.setShape(s);
        TaxonomyTerm t = this.shapeDao.findTermOfShape(s);
        si.setTerm(t);
        return si;
    }

    @Override
    public String retrieveShapeAttributeValue(Shape s, String attribute) throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        org.w3c.dom.Document d = db.parse(new ByteArrayInputStream(s.getExtraData().getBytes("UTF-8")));
        NodeList els = d.getElementsByTagName(attribute);
        if (els == null || els.getLength() == 0) {
            return null;
        }
        Element el = (Element)els.item(0);
        return el.getFirstChild().getNodeValue();
    }

    @Override
    public AttributeInfo retrieveShapeAttribute(Shape s, String attribute) throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        org.w3c.dom.Document d = db.parse(new ByteArrayInputStream(s.getExtraData().getBytes("UTF-8")));
        NodeList els = d.getElementsByTagName(attribute);
        if (els == null || els.getLength() == 0) {
            return null;
        }
        Element el = (Element)els.item(0);
        AttributeInfo ai = new AttributeInfo();
        ai.setName(attribute);
        ai.setValue(el.getFirstChild().getNodeValue());
        ai.setTaxonomy(el.getAttribute("taxonomy"));
        ai.setType(ShapeAttributeDataType.valueOf((String)el.getAttribute("type").toUpperCase()).toString());
        ai.setPresentable(Boolean.valueOf(el.getAttribute("presentable")).booleanValue());
        return ai;
    }

    @Override
    @Transactional(readOnly=true)
    public AttributeInfo retrieveShapeAttributeByTaxonomy(Shape s, String taxonomy) throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        org.w3c.dom.Document d = db.parse(new ByteArrayInputStream(s.getExtraData().getBytes("UTF-8")));
        NodeList els = d.getElementsByTagName("extraData").item(0).getChildNodes();
        for (int i = 0; i < els.getLength(); ++i) {
            Element el = (Element)els.item(i);
            if (!el.getAttribute("taxonomy").equals(taxonomy)) continue;
            AttributeInfo ai = new AttributeInfo();
            ai.setName(el.getNodeName());
            ai.setValue(el.getFirstChild().getNodeValue());
            ai.setTaxonomy(taxonomy);
            ai.setType(ShapeAttributeDataType.valueOf((String)el.getAttribute("type").toUpperCase()).toString());
            ai.setPresentable(Boolean.valueOf(el.getAttribute("presentable")).booleanValue());
            return ai;
        }
        return null;
    }

    @Transactional(readOnly=true)
    private Map<String, AttributeInfo> retrieveRawShapeAttributes(Shape s) throws Exception {
        HashMap<String, AttributeInfo> attributes = new HashMap<String, AttributeInfo>();
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        org.w3c.dom.Document d = db.parse(new ByteArrayInputStream(s.getExtraData().getBytes("UTF-8")));
        NodeList els = d.getElementsByTagName("extraData").item(0).getChildNodes();
        for (int i = 0; i < els.getLength(); ++i) {
            Element el = (Element)els.item(i);
            String taxon = el.getAttribute("taxonomy");
            if (taxon == null || taxon.trim().isEmpty()) continue;
            AttributeInfo ai = new AttributeInfo();
            ai.setName(el.getNodeName());
            if (el.getFirstChild() != null) {
                ai.setValue(el.getFirstChild().getNodeValue());
            }
            ai.setTaxonomy(taxon);
            ai.setType(ShapeAttributeDataType.valueOf((String)el.getAttribute("type").toUpperCase()).toString());
            ai.setPresentable(Boolean.valueOf(el.getAttribute("presentable")).booleanValue());
            attributes.put(taxon, ai);
        }
        return attributes;
    }

    @Override
    @Transactional
    public void addShapeAttribute(Shape s, String attrName, String attrValue, Taxonomy taxonomy) throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        org.w3c.dom.Document d = db.parse(new ByteArrayInputStream(s.getExtraData().getBytes("UTF-8")));
        Element root = d.getDocumentElement();
        NodeList els = d.getElementsByTagName(attrName);
        if (els != null && els.getLength() != 0) {
            throw new Exception("Attribute " + attrName + " already exists");
        }
        Element el = d.createElement(attrName);
        el.setAttribute("type", ShapeAttributeDataType.STRING.toString());
        if (taxonomy != null) {
            el.setAttribute("taxonomy", taxonomy.getId().toString());
        }
        el.appendChild(d.createTextNode(attrValue));
        root.appendChild(el);
        s.setExtraData(this.transformDocToString(d));
        this.shapeDao.update((Entity)s);
    }

    private String transformDocToString(org.w3c.dom.Document document) throws TransformerException {
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        StringWriter writer = new StringWriter();
        transformer.transform(new DOMSource(document), new StreamResult(writer));
        return writer.getBuffer().toString().replaceAll("\n|\r", NoValueKey);
    }

    @Override
    @Transactional
    public void setShapeAttributes(Shape s, Map<String, AttributeInfo> attrs) throws Exception {
        StringBuilder xml = new StringBuilder();
        xml.append("<extraData>");
        for (Map.Entry<String, AttributeInfo> attrE : attrs.entrySet()) {
            AttributeInfo attr = attrE.getValue();
            xml.append("<" + attr.getName() + " type=\"" + ShapeAttributeDataType.valueOf((String)attr.getType().toUpperCase()).toString() + "\" " + "taxonomy=\"" + attr.getTaxonomy() + "\" " + (attr.getTerm() != null ? "term=\"" + attr.getTerm() + "\"" : NoValueKey) + ">");
            xml.append(attr.getValue());
            xml.append("</" + attr.getName() + ">");
        }
        xml.append("</extraData>");
        s.setExtraData(xml.toString());
        this.shapeDao.update((Entity)s);
    }

    @Override
    @Transactional
    public void updateShapeAttribute(Shape s, String attrName, String attrValue) throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        org.w3c.dom.Document d = db.parse(new ByteArrayInputStream(s.getExtraData().getBytes("UTF-8")));
        NodeList els = d.getElementsByTagName(attrName);
        if (els == null || els.getLength() == 0) {
            throw new Exception("Attribute " + attrName + " not found");
        }
        Element el = (Element)els.item(0);
        el.getFirstChild().setNodeValue(attrValue);
        this.shapeDao.update((Entity)s);
    }

    @Override
    @Transactional
    public void removeShapeAttribute(Shape s, String attrName) throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        org.w3c.dom.Document d = db.parse(new ByteArrayInputStream(s.getExtraData().getBytes("UTF-8")));
        NodeList els = d.getElementsByTagName(attrName);
        if (els == null || els.getLength() == 0) {
            throw new Exception("Attribute " + attrName + " not found");
        }
        Element el = (Element)els.item(0);
        d.removeChild(el);
        this.shapeDao.update((Entity)s);
    }

    @Override
    @Transactional
    public Set<String> getAttributeValuesOfShapesByTerm(TaxonomyTerm layerTerm, Shape.Attribute attr) throws Exception {
        TaxonomyTerm tt = this.taxonomyManager.findTermById(layerTerm.getId().toString(), false);
        if (tt == null) {
            throw new Exception("Taxonomy term " + layerTerm.getId() + " not found");
        }
        return this.shapeDao.getAttributeValuesOfShapesByTerm(tt, attr);
    }

    private Map<String, AttributeInfo> filterAttributes(Map<String, AttributeInfo> attributes, List<String> taxonomies) {
        HashMap<String, AttributeInfo> filteredAttrs = new HashMap<String, AttributeInfo>();
        block0: for (Map.Entry<String, AttributeInfo> aie : attributes.entrySet()) {
            for (String t : taxonomies) {
                if (!aie.getValue().getTaxonomy().equals(t)) continue;
                filteredAttrs.put(aie.getKey(), aie.getValue());
                continue block0;
            }
        }
        return filteredAttrs;
    }

    private void linkAttributeDocument(Shape s, TaxonomyTermShape tts) throws Exception {
        Document d = this.shapeDocumentDao.findUniqueByTaxonomyTermShape(tts);
        if (d != null) {
            Document thisD;
            TaxonomyTermShape thisTts = this.taxonomyTermShapeDao.find(tts.getTerm(), s);
            if (thisTts == null) {
                thisTts = new TaxonomyTermShape();
                thisTts.setCreator(this.principalDao.systemPrincipal());
                thisTts.setShape(s);
                thisTts.setTerm(tts.getTerm());
                this.taxonomyTermShapeDao.create((Entity)thisTts);
            }
            if ((thisD = this.shapeDocumentDao.findUniqueByTaxonomyTermShape(thisTts)) == null) {
                ShapeDocument sd = new ShapeDocument();
                sd.setCreator(this.principalDao.systemPrincipal());
                sd.setTaxonomyTermShape(thisTts);
                sd.setDocument(d);
                this.shapeDocumentDao.create((Entity)sd);
            }
        }
    }

    @Override
    @Transactional(readOnly=true)
    public Map<String, AttributeInfo> consolidateAttributes(Shape s) throws Exception {
        HashMap<String, AttributeInfo> attrs = new HashMap<String, AttributeInfo>();
        HashSet<TaxonomyConfig> extraTaxonIds = new HashSet<TaxonomyConfig>();
        List<TaxonomyConfig> infoCategories = this.configurationManager.retrieveTaxonomyConfigByClass(TaxonomyConfig.Type.PROJECTINFOCATEGORYTAXONOMY);
        for (TaxonomyConfig infoCfg : infoCategories) {
            extraTaxonIds.addAll(this.configurationManager.retrieveTaxonomyConfigByClass(TaxonomyConfig.Type.valueOf((String)infoCfg.getType())));
        }
        Point centroid = s.getGeography().getCentroid();
        List<TaxonomyTerm> geoLocation = this.geoLocate(centroid.getX(), centroid.getY());
        String geographyTaxonId = this.configurationManager.retrieveTaxonomyConfig(TaxonomyConfig.Type.GEOGRAPHYTAXONOMY).get(0).getId();
        HashSet attrTerms = new HashSet();
        TaxonomyTerm tt = null;
        Iterator<TaxonomyTerm> ttIt = geoLocation.iterator();
        ArrayList<String> attrTaxonomies = new ArrayList<String>();
        for (TaxonomyConfig tcfg : extraTaxonIds) {
            attrTaxonomies.add(tcfg.getId());
        }
        boolean foundWidestGeographyTerm = false;
        while (ttIt.hasNext()) {
            ArrayList<TaxonomyTerm> descendants;
            tt = ttIt.next();
            if (tt.getTaxonomy().getId().toString().equals(geographyTaxonId)) {
                foundWidestGeographyTerm = true;
            }
            List linkedTerms = this.taxonomyTermDao.getActiveLinkedTerms(tt, TaxonomyTermLink.Verb.AttrFor);
            attrTerms.addAll(linkedTerms);
            ArrayList toCheck = new ArrayList(linkedTerms);
            do {
                descendants = new ArrayList<TaxonomyTerm>();
                for (TaxonomyTerm tc : toCheck) {
                    descendants.addAll(this.taxonomyManager.getChildrenOfTerm(tc.getId().toString(), true, false));
                }
                attrTerms.addAll(descendants);
                toCheck = descendants;
            } while (!descendants.isEmpty());
            if (!foundWidestGeographyTerm) continue;
            attrTaxonomies.add(tt.getTaxonomy().getId().toString());
        }
        ttIt = geoLocation.iterator();
        foundWidestGeographyTerm = false;
        while (ttIt.hasNext()) {
            TaxonomyTermShape tts;
            tt = ttIt.next();
            if (tt.getTaxonomy().getId().toString().equals(geographyTaxonId)) {
                foundWidestGeographyTerm = true;
            }
            if (!foundWidestGeographyTerm || (tts = this.taxonomyTermShapeDao.findUniqueByTerm(tt)) == null) continue;
            Map<String, AttributeInfo> shapeAttrs = this.retrieveRawShapeAttributes(tts.getShape());
            Map<String, AttributeInfo> filteredAttrs = this.filterAttributes(shapeAttrs, attrTaxonomies);
            attrs.putAll(filteredAttrs);
            for (AttributeInfo fa : filteredAttrs.values()) {
                String termIdStr = null;
                if (fa.getTerm() != null) {
                    termIdStr = fa.getTerm();
                } else {
                    List<AttributeMappingConfig> valCfgs = this.configurationManager.getAttributeMappings(fa.getName(), fa.getValue());
                    if (valCfgs != null) {
                        for (AttributeMappingConfig valCfg : valCfgs) {
                            if (valCfg.getTermId() == null) continue;
                            termIdStr = valCfg.getTermId();
                            break;
                        }
                    }
                }
                if (termIdStr == null) continue;
                TaxonomyTerm attrT = this.taxonomyManager.findTermById(termIdStr, false);
                List attrTtss = this.taxonomyTermShapeDao.findNonProjectByTerm(attrT);
                TaxonomyTermShape attrTts = null;
                if (attrT != null) {
                    for (TaxonomyTermShape aTts : attrTtss) {
                        if (!this.shapeDao.within(s, aTts.getShape())) continue;
                        attrTts = aTts;
                        break;
                    }
                }
                if (attrTts == null) continue;
                this.linkAttributeDocument(s, attrTts);
            }
        }
        for (TaxonomyTerm t : attrTerms) {
            List ttss = this.taxonomyTermShapeDao.findByTerm(t);
            TaxonomyTermShape tts = null;
            for (TaxonomyTermShape ttShape : ttss) {
                if (!this.shapeDao.within(s, ttShape.getShape())) continue;
                tts = ttShape;
                break;
            }
            if (tts == null) continue;
            AttributeInfo attr = this.retrieveShapeAttributeByTaxonomy(tts.getShape(), t.getTaxonomy().getId().toString());
            attrs.put(attr.getTaxonomy(), attr);
            this.linkAttributeDocument(s, tts);
        }
        return attrs;
    }

    @Override
    @Transactional(readOnly=true)
    public Map<String, AttributeInfo> computeAttributes(Shape s) throws Exception {
        HashMap<String, AttributeInfo> attrs = new HashMap<String, AttributeInfo>();
        Point centroid = s.getGeography().getCentroid();
        AttributeInfo ai = new AttributeInfo();
        ai.setName("location");
        ai.setPresentable(true);
        ai.setTaxonomy(this.configurationManager.retrieveTaxonomyConfig(TaxonomyConfig.Type.LOCATIONTAXONOMY).get(0).getId());
        ai.setType(ShapeAttributeDataType.STRING.toString());
        ai.setValue(centroid.getX() + "," + centroid.getY());
        attrs.put(TaxonomyConfig.Type.LOCATIONTAXONOMY.toString(), ai);
        double area = this.shapeDao.area(s);
        ai = new AttributeInfo();
        ai.setName("area");
        ai.setPresentable(true);
        ai.setTaxonomy(this.configurationManager.retrieveTaxonomyConfig(TaxonomyConfig.Type.AREATAXONOMY).get(0).getId());
        ai.setType(ShapeAttributeDataType.DOUBLE.toString());
        ai.setValue(new Double(area).toString());
        attrs.put(TaxonomyConfig.Type.AREATAXONOMY.toString(), ai);
        return attrs;
    }

    /*
     * Could not resolve type clashes
     */
    @Override
    @Transactional(readOnly=true)
    public Map<String, AttributeInfo> retrieveShapeAttributes(Shape s) throws Exception {
        HashMap<String, AttributeInfo> res = new HashMap<String, AttributeInfo>();
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        if (s.getExtraData() == null || s.getExtraData().trim().isEmpty()) {
            return res;
        }
        org.w3c.dom.Document d = db.parse(new ByteArrayInputStream(s.getExtraData().getBytes("UTF-8")));
        GeographyHierarchy hier = this.getDefaultGeographyHierarchy();
        NodeList els = d.getChildNodes().item(0).getChildNodes();
        for (int i = 0; i < els.getLength(); ++i) {
            TaxonomyTermShape tts;
            String geogTaxonomyName = null;
            String geogTaxonomyId = null;
            Element el = (Element)els.item(i);
            String taxonomyId = el.getAttribute("taxonomy");
            if (taxonomyId == null || taxonomyId.trim().isEmpty()) continue;
            TaxonomyConfig tcfg = this.configurationManager.retrieveTaxonomyConfigById(taxonomyId, true);
            if (tcfg != null && (tcfg.getType().equals(TaxonomyConfig.Type.GEOGRAPHYTAXONOMY.toString()) || tcfg.getType().equals(TaxonomyConfig.Type.ALTGEOGRAPHYTAXONOMY.toString()))) {
                tcfg = null;
            }
            if (tcfg == null) {
                boolean foundGeog = false;
                for (Taxonomy geogT : hier.getMainHierarchy()) {
                    if (!geogT.getId().toString().equals(taxonomyId)) continue;
                    foundGeog = true;
                    geogTaxonomyName = geogT.getName();
                    geogTaxonomyId = geogT.getId().toString();
                    break;
                }
                if (!foundGeog) {
                    for (List altHier : hier.getAlternativeHierarchies()) {
                        for (Taxonomy geogT : altHier) {
                            if (!geogT.getId().toString().equals(taxonomyId)) continue;
                            foundGeog = true;
                            geogTaxonomyName = geogT.getName();
                            geogTaxonomyId = geogT.getId().toString();
                            break;
                        }
                        if (!foundGeog) continue;
                        break;
                    }
                }
                if (!foundGeog) continue;
            }
            List<AttributeMappingConfig> taxonMcfgs = this.configurationManager.getAttributeMappings(el.getNodeName(), null);
            List<AttributeMappingConfig> valMcfgs = null;
            if (el.getFirstChild() != null) {
                valMcfgs = this.configurationManager.getAttributeMappings(el.getNodeName(), el.getFirstChild().getNodeValue());
            }
            boolean presentable = true;
            boolean mapValue = false;
            if (taxonMcfgs != null) {
                Taxonomy geogT;
                geogT = taxonMcfgs.iterator();
                while (geogT.hasNext()) {
                    AttributeMappingConfig mcfg = geogT.next();
                    if (mcfg.isPresentable().booleanValue()) continue;
                    presentable = false;
                    break;
                }
                if (!presentable) continue;
            }
            String ttStr = null;
            if (valMcfgs != null) {
                for (AttributeMappingConfig mcfg : valMcfgs) {
                    if (mcfg.isMapValue().booleanValue()) {
                        mapValue = true;
                    }
                    if (mcfg.getTermId() == null) continue;
                    ttStr = mcfg.getTermId();
                }
            }
            TaxonomyTerm tt = null;
            Document shapeDocument = null;
            if (ttStr != null && !ttStr.trim().isEmpty()) {
                tt = this.taxonomyManager.findTermById(ttStr, false);
            }
            if (tt != null && (tts = this.taxonomyTermShapeDao.find(tt, s)) != null) {
                shapeDocument = this.shapeDocumentDao.findUniqueByTaxonomyTermShape(tts);
            }
            String val = null;
            if (!mapValue) {
                if (el.getFirstChild() != null) {
                    val = el.getFirstChild().getNodeValue();
                }
            } else {
                if (tt == null) {
                    log.error("Could not find mapped taxonomy term: " + el.getAttribute("term") + ". Skipping");
                    continue;
                }
                val = tt.getName();
            }
            AttributeInfo ai = new AttributeInfo();
            ai.setName(el.getNodeName());
            ai.setValue(val);
            ai.setType(tcfg != null ? tcfg.getId() : geogTaxonomyName);
            ai.setTaxonomy(tcfg != null ? tcfg.getId() : geogTaxonomyName);
            if (shapeDocument != null) {
                ai.setDocument(shapeDocument.getId().toString());
            }
            res.put(tcfg != null ? tcfg.getId().toString() : geogTaxonomyName, ai);
        }
        return res;
    }

    @Override
    @Transactional(readOnly=true)
    public Set<String> getShapeAttributeValues(Taxonomy t) throws Exception {
        List<AttributeMappingConfig> mcfgs = this.configurationManager.getAttributeMappingsForTermId(t.getId().toString());
        String layerId = null;
        Shape.Attribute attr = null;
        for (AttributeMappingConfig mcfg : mcfgs) {
            if (mcfg.getAttributeValue() != null) continue;
            if (!mcfg.isPresentable().booleanValue()) {
                throw new Exception("Not a presentable attribute");
            }
            layerId = mcfg.getLayerTermId();
            attr = new Shape.Attribute(mcfg.getAttributeName(), mcfg.getAttributeType(), mcfg.getTermId(), null);
            break;
        }
        if (layerId == null) {
            return new HashSet<String>();
        }
        return this.shapeDao.getAttributeValuesOfShapesByTerm(this.taxonomyManager.findTermById(layerId, false), attr);
    }

    private int termLevel(TaxonomyTerm term) {
        TaxonomyTerm curTerm = term;
        int level = 0;
        while (curTerm.getParent() != null) {
            ++level;
        }
        return level;
    }

    private TaxonomyTerm locateShape(Shape s, Taxonomy parentTaxonomy) throws Exception {
        Point centroid = s.getGeography().getCentroid();
        centroid.setSRID(4326);
        Shape pointShape = new Shape();
        pointShape.setGeography((Geometry)centroid);
        List<TaxonomyTerm> parentTerms = this.taxonomyManager.getTermsOfTaxonomy(parentTaxonomy.getId().toString(), true, false);
        for (TaxonomyTerm parentTerm : parentTerms) {
            List<Shape> parentShapes = this.taxonomyManager.getShapesOfTerm(parentTerm);
            for (Shape parentShape : parentShapes) {
                if (!this.shapeDao.within(pointShape, parentShape)) continue;
                return parentTerm;
            }
        }
        return null;
    }

    private TaxonomyTermInsertionPoint locateShapeInsertionPoint(Shape s, Taxonomy parentTaxonomy) throws Exception {
        Shape pointShape = new Shape();
        pointShape.setGeography(s.getGeography());
        List<TaxonomyTerm> parentTerms = this.taxonomyManager.getTermsOfTaxonomy(parentTaxonomy.getId().toString(), true, false);
        List<TaxonomyTerm> bottomTerms = this.taxonomyManager.getBottomTermsOfTaxonomy(parentTaxonomy.getId().toString(), false);
        List<TaxonomyTerm> topTerms = this.taxonomyManager.getTopmostTermsOfTaxonomy(parentTaxonomy.getId().toString(), false);
        TaxonomyTermInsertionPoint insertionPoint = this.topDownSearchWithin(pointShape, topTerms);
        if (insertionPoint != null) {
            return insertionPoint;
        }
        ArrayList<TaxonomyTerm> over = new ArrayList<TaxonomyTerm>();
        for (TaxonomyTerm topTerm : topTerms) {
            List<Shape> checkShapes = this.taxonomyManager.getShapesOfTerm(topTerm);
            for (Shape checkShape : checkShapes) {
                if (!this.shapeDao.within(checkShape, s)) continue;
                over.add(topTerm);
            }
        }
        if (!over.isEmpty()) {
            return new TaxonomyTermInsertionPoint(over, null);
        }
        return new TaxonomyTermInsertionPoint(new ArrayList<TaxonomyTerm>(), null);
    }

    private TaxonomyTermInsertionPoint bottomUpSearchWithin(Shape pointShape, List<TaxonomyTerm> bottomTerms) throws Exception {
        for (TaxonomyTerm bottomTerm : bottomTerms) {
            TaxonomyTerm child = null;
            TaxonomyTerm curTerm = bottomTerm;
            do {
                if (this.shapeWithinShapeOfTaxonomyTerm(pointShape, curTerm)) {
                    return new TaxonomyTermInsertionPoint(new ArrayList<TaxonomyTerm>(), curTerm);
                }
                TaxonomyTerm tmp = curTerm;
                if ((curTerm = curTerm.getParent()) == null) continue;
                child = tmp;
            } while (curTerm != null);
        }
        return null;
    }

    private TaxonomyTermInsertionPoint topDownSearchWithin(Shape checkShape, List<TaxonomyTerm> topTerms) throws Exception {
        for (TaxonomyTerm topTerm : topTerms) {
            TaxonomyTermInsertionPoint insertionPoint = this.treeTopDownSearchWithin(checkShape, topTerm);
            if (insertionPoint == null) continue;
            return insertionPoint;
        }
        return null;
    }

    private TaxonomyTermInsertionPoint treeTopDownSearchWithin(Shape checkShape, TaxonomyTerm top) throws Exception {
        boolean withinTop = this.shapeWithinShapeOfTaxonomyTerm(checkShape, top);
        if (!withinTop) {
            return null;
        }
        List<TaxonomyTerm> children = this.taxonomyManager.getChildrenOfTerm(top.getId().toString(), true, false);
        for (TaxonomyTerm child : children) {
            TaxonomyTermInsertionPoint insertionPoint = this.treeTopDownSearchWithin(checkShape, child);
            if (insertionPoint == null) continue;
            return insertionPoint;
        }
        if (withinTop) {
            ArrayList<TaxonomyTerm> over = new ArrayList<TaxonomyTerm>();
            for (TaxonomyTerm child : children) {
                if (!this.shapeOfTaxonomyTermWithinShape(child, checkShape)) continue;
                over.add(child);
            }
            return new TaxonomyTermInsertionPoint(over, top);
        }
        return null;
    }

    private boolean shapeWithinShapeOfTaxonomyTerm(Shape checkShape, TaxonomyTerm curTerm) throws Exception {
        List<Shape> shapes = this.taxonomyManager.getShapesOfTerm(curTerm);
        for (Shape shape : shapes) {
            if (!this.shapeDao.within(checkShape, shape)) continue;
            return true;
        }
        return false;
    }

    private boolean shapeOfTaxonomyTermWithinShape(TaxonomyTerm term, Shape checkShape) throws Exception {
        List<Shape> shapes = this.taxonomyManager.getShapesOfTerm(term);
        for (Shape shape : shapes) {
            if (!this.shapeDao.within(shape, checkShape)) continue;
            return true;
        }
        return false;
    }

    private Taxonomy findSourceTaxonomy(Map<String, Map<String, AttributeInfo>> attrInfo, Map<String, Set<String>> valueMappingValues) throws Exception {
        String sourceTaxonomyName = null;
        for (Map<String, AttributeInfo> map : attrInfo.values()) {
            for (AttributeInfo ai : map.values()) {
                if (ai.getValue() != null || !ai.isAutoValueMapping()) continue;
                sourceTaxonomyName = ai.getTaxonomy();
                break;
            }
            if (sourceTaxonomyName == null) continue;
            break;
        }
        if (sourceTaxonomyName == null) {
            for (Map.Entry entry : attrInfo.entrySet()) {
                HashSet<String> mappedValues = new HashSet<String>();
                String taxon = null;
                for (AttributeInfo ai : ((Map)entry.getValue()).values()) {
                    if (ai.getValue() == null) continue;
                    mappedValues.add(ai.getValue());
                    taxon = ai.getTaxonomy();
                }
                if (!mappedValues.containsAll((Collection)valueMappingValues.get(entry.getKey()))) continue;
                sourceTaxonomyName = taxon;
                break;
            }
        }
        if (sourceTaxonomyName == null) {
            return null;
        }
        Taxonomy sourceTaxonomy = this.taxonomyManager.findTaxonomyByName(sourceTaxonomyName, false);
        return sourceTaxonomy;
    }

    private boolean checkGeographic(Taxonomy termTaxonomy, GeographyHierarchy geographyHierarchy) {
        ArrayList<List<Taxonomy>> hier = new ArrayList<List<Taxonomy>>(geographyHierarchy.getAlternativeHierarchies());
        hier.add(geographyHierarchy.getMainHierarchy());
        for (List list : hier) {
            for (Taxonomy t : list) {
                if (!t.getId().equals(termTaxonomy.getId())) continue;
                return true;
            }
        }
        return false;
    }

    private Map<Taxonomy, TermLinkInfo> locateLinked(Map<String, Map<String, AttributeInfo>> attrInfo, Taxonomy sourceTaxonomy, GeographyHierarchy geographyHierarchy) throws Exception {
        HashMap<Taxonomy, TermLinkInfo> linkedLocationInfo = new HashMap<Taxonomy, TermLinkInfo>();
        List<Object> hier = new ArrayList();
        Collections.reverse(geographyHierarchy.getMainHierarchy());
        hier = geographyHierarchy.getMainHierarchy();
        for (Map.Entry<String, Map<String, AttributeInfo>> aie : attrInfo.entrySet()) {
            String verb;
            AttributeInfo ai = aie.getValue().get(NoValueKey);
            if (ai == null || (verb = ai.getLinkVerb()) == null) continue;
            Taxonomy linkTaxonomy = this.taxonomyManager.findTaxonomyByName(ai.getTaxonomy(), false);
            Iterator<Object> currentGeogTaxonomyIt = hier.iterator();
            boolean located = false;
            while (currentGeogTaxonomyIt.hasNext()) {
                linkedLocationInfo.put(linkTaxonomy, new TermLinkInfo(verb));
                Taxonomy currentGeogTaxonomy = (Taxonomy)currentGeogTaxonomyIt.next();
                List<TaxonomyTerm> sourceTerms = this.taxonomyManager.getTermsOfTaxonomy(sourceTaxonomy.getId().toString(), true, false);
                located = true;
                for (TaxonomyTerm tt : sourceTerms) {
                    TaxonomyTerm destTerm = this.locateShape(this.taxonomyTermDao.getShape(tt), currentGeogTaxonomy);
                    if (destTerm == null) {
                        located = false;
                        break;
                    }
                    ((TermLinkInfo)linkedLocationInfo.get((Object)linkTaxonomy)).links.put(tt, destTerm);
                }
                if (!located) continue;
            }
            if (located) continue;
            log.error("Could not locate linked terms of taxonomy " + linkTaxonomy.getName() + " within the geography hierarchy");
            throw new Exception("Could not locate linked terms of taxonomy " + linkTaxonomy.getName() + " within the geography hierarchy");
        }
        return linkedLocationInfo;
    }

    @Override
    @Transactional
    public String generateShapesOfImport(TaxonomyTerm tt, Map<String, Map<String, AttributeInfo>> attrInfo, Map<String, Set<String>> valueMappingValues, UUID importId, String layerTermId, GeographyHierarchy geographyHierarchy, Principal principal) throws Exception {
        DocumentBuilderFactory dbf = null;
        DocumentBuilder db = null;
        TransformerFactory tf = null;
        Transformer transformer = null;
        HashMap<String, Map<String, AttributeMappingConfig>> cfgCache = new HashMap<String, Map<String, AttributeMappingConfig>>();
        List<ShapeImport> result = this.shapeImportManager.getImport(importId);
        boolean valueMappings = false;
        boolean autoValueMappings = false;
        boolean autoDocMappings = false;
        boolean linked = false;
        for (Map<String, AttributeInfo> aim : attrInfo.values()) {
            for (AttributeInfo ai : aim.values()) {
                if (ai.getValue() != null) {
                    valueMappings = true;
                    continue;
                }
                if (ai.isAutoValueMapping()) {
                    autoValueMappings = true;
                }
                if (ai.isAutoDocumentMapping()) {
                    autoDocMappings = true;
                }
                if (ai.getLinkVerb() == null) continue;
                linked = true;
            }
        }
        Taxonomy sourceTaxonomy = null;
        if (linked && (sourceTaxonomy = this.findSourceTaxonomy(attrInfo, valueMappingValues)) == null) {
            log.error("Unable to find a source taxonomy for linked term mapping");
            throw new Exception("Unable to find a source taxonomy for linked term mapping");
        }
        if (valueMappings || autoValueMappings) {
            dbf = DocumentBuilderFactory.newInstance();
            db = dbf.newDocumentBuilder();
        }
        if (autoValueMappings) {
            tf = TransformerFactory.newInstance();
            tf.setAttribute("indent-number", 2);
            transformer = tf.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("encoding", "UTF-8");
        }
        int cnt = 0;
        log.info("Import " + importId + " contains " + result.size() + " shapes");
        String identity = null;
        HashMap<String, Map<String, Integer>> createdMappingCounts = new HashMap<String, Map<String, Integer>>();
        long count = 0L;
        for (ShapeImport si : result) {
            Long start = System.currentTimeMillis();
            identity = si.getShapeIdentity();
            if (importId.equals(si.getShapeImport())) {
                Shape s = new Shape();
                s.setName(si.getShapeIdentity() + "_" + cnt++);
                s.setCreationDate(si.getCreationDate());
                s.setLastUpdate(si.getLastUpdate());
                s.setCreator(principal);
                s.setExtraData(si.getData());
                s.setGeography(si.getGeography());
                s.setShapeImport(si);
                s.setShapeClass(1);
                this.shapeDao.create((Entity)s);
                ShapeTerm st = new ShapeTerm();
                st.setCreator(si.getCreator());
                st.setShape(s);
                st.setTerm((TaxonomyTerm)this.taxonomyTermDao.read((Serializable)tt.getId()));
                this.shapeTermDao.create((Entity)st);
                if (valueMappings) {
                    this.createTermsForShapeAttributes(attrInfo, principal, db, s);
                }
                if (autoValueMappings || autoDocMappings) {
                    org.w3c.dom.Document d = db.parse(new InputSource(new StringReader(s.getExtraData())));
                    for (Map.Entry<String, Map<String, AttributeInfo>> ai : attrInfo.entrySet()) {
                        AttributeInfo attr2 = ai.getValue().get(NoValueKey);
                        if (attr2 == null || !attr2.isStore() || !attr2.isAutoValueMapping() && !attr2.isAutoDocumentMapping()) continue;
                        if (attr2.getTaxonomy() == null) {
                            throw new Exception("Taxonomy of auto-created terms is not defined");
                        }
                        NodeList els = d.getElementsByTagName(ai.getKey());
                        Node el = els.item(0);
                        Set<String> vals = valueMappingValues.get(attr2.getName());
                        if (vals == null) continue;
                        Taxonomy termTaxonomy = this.taxonomyManager.findTaxonomyByName(attr2.getTaxonomy(), false);
                        boolean geographicTaxonomy = this.checkGeographic(termTaxonomy, geographyHierarchy);
                        if (geographicTaxonomy) {
                            this.setTaxonomyDataGeographic(termTaxonomy);
                            this.taxonomyManager.updateTaxonomy(termTaxonomy, termTaxonomy.getName(), false);
                        }
                        if (el.getFirstChild() == null) continue;
                        String nodeValue = el.getFirstChild().getNodeValue();
                        this.generateAutoValuedTermsForShapeAttributes(layerTermId, principal, cfgCache, createdMappingCounts, s, attr2, vals, termTaxonomy, geographicTaxonomy, nodeValue);
                        this.generateAutoDocumentMappingsForShapeAttributes(layerTermId, principal, cfgCache, s, attr2, vals, termTaxonomy, nodeValue);
                        System.out.println("Inserted shape and generated geography terms. Count: " + count);
                        ++count;
                    }
                }
            }
            System.out.println("Count: " + count + " millis: " + (System.currentTimeMillis() - start));
        }
        attrInfo.values().stream().map(x -> (AttributeInfo)x.get(NoValueKey)).filter(attr -> attr != null && attr.isAutoValueMapping() && attr.isStore()).forEach(this::createTaxonomiesOfTermLevels);
        if (linked) {
            Map<Taxonomy, TermLinkInfo> linkedLocationInfo = this.locateLinked(attrInfo, sourceTaxonomy, geographyHierarchy);
            for (TermLinkInfo lli : linkedLocationInfo.values()) {
                for (Map.Entry<TaxonomyTerm, TaxonomyTerm> link : lli.links.entrySet()) {
                    TaxonomyTermLink l = new TaxonomyTermLink();
                    l.setSourceTerm(link.getKey());
                    l.setDestinationTerm(link.getValue());
                    l.setCreator(principal);
                    l.setVerb(TaxonomyTermLink.Verb.valueOf((String)lli.verb));
                    this.taxonomyTermLinkDao.create((Entity)l);
                }
            }
        }
        if (autoValueMappings) {
            // empty if block
        }
        return identity;
    }

    private void createTaxonomiesOfTermLevels(AttributeInfo attr) {
        Taxonomy taxonomy = this.taxonomyManager.findTaxonomyByName(attr.getTermParentTaxonomy(), false);
        String topTaxonomyName = taxonomy.getName();
        int level = 0;
        List<Object> terms = this.taxonomyManager.getTopmostTermsOfTaxonomy(taxonomy.getId().toString(), false);
        ++level;
        while (!terms.isEmpty()) {
            terms = terms.stream().flatMap(t -> this.taxonomyManager.getChildrenOfTerm(t.getId().toString(), true, false).stream()).collect(Collectors.toList());
            Taxonomy parent = taxonomy;
            taxonomy = this.taxonomyManager.findTaxonomyByName(topTaxonomyName + " " + level, false);
            if (taxonomy == null) {
                taxonomy = new Taxonomy();
                taxonomy.setCreator(parent.getCreator());
                taxonomy.setIsActive(true);
                taxonomy.setName(topTaxonomyName + " " + level);
                TaxonomyData taxonomyData = new TaxonomyData();
                taxonomyData.setGeographic(true);
                taxonomyData.setParent(parent.getId());
                taxonomy.setExtraData(this.taxonomyManager.marshalTaxonomyData(taxonomyData));
                this.taxonomyManager.updateTaxonomy(taxonomy, null, true);
            }
            Taxonomy createdTaxonomy = taxonomy;
            terms.forEach(term -> {
                term.setTaxonomy(createdTaxonomy);
                this.taxonomyManager.updateTerm((TaxonomyTerm)term, term.getName(), term.getTaxonomy().getName(), false);
            });
            ++level;
        }
    }

    private void generateAutoValuedTermsForShapeAttributes(String layerTermId, Principal principal, Map<String, Map<String, AttributeMappingConfig>> cfgCache, Map<String, Map<String, Integer>> createdMappingCounts, Shape s, AttributeInfo attr, Set<String> vals, Taxonomy termTaxonomy, boolean geographicTaxonomy, String nodeValue) throws Exception {
        for (String val : vals) {
            Document doc;
            String termName;
            if (!val.equals(nodeValue)) continue;
            if (geographicTaxonomy && attr.getTermParentTaxonomy() == null) {
                throw new Exception("Taxonomy of auto-created term parent terms is not defined");
            }
            if (!attr.isAutoValueMapping()) continue;
            TaxonomyTermInsertionPoint insertionPoint = null;
            if (attr.getTermParentTaxonomy() != null) {
                insertionPoint = this.locateShapeInsertionPoint(s, this.taxonomyManager.findTaxonomyByName(attr.getTermParentTaxonomy(), false));
            }
            if (!createdMappingCounts.containsKey(termName = StringUtils.normalizeEntityName((String)(new String(new char[]{val.charAt(0)}).toUpperCase() + val.substring(1).toLowerCase())))) {
                createdMappingCounts.put(termName, new HashMap());
            }
            Integer termCnt = null;
            if (createdMappingCounts.get(termName).containsKey(val)) {
                termCnt = createdMappingCounts.get(termName).get(val);
            } else {
                createdMappingCounts.get(termName).put(val, 0);
                termCnt = 0;
            }
            TaxonomyTerm ttstt = new TaxonomyTerm();
            ttstt.setCreator(principal);
            ttstt.setIsActive(true);
            ttstt.setName(termName);
            ttstt.setParent(insertionPoint.under);
            ttstt.setExtraData("auto " + attr.getTermParentTaxonomy());
            ttstt.setTaxonomy(termTaxonomy);
            TaxonomyTerm existingTtstt = this.taxonomyManager.findTermByName(termName, false);
            if (existingTtstt != null) {
                List<Shape> shapesOfExisting = this.taxonomyManager.getShapesOfTerm(existingTtstt);
                for (Shape existingS : shapesOfExisting) {
                    if (!s.getId().equals(existingS.getId())) continue;
                    this.taxonomyManager.deleteTerm(existingTtstt);
                    throw new Exception("Duplicate shape of term " + existingTtstt.getName());
                }
                if (termCnt == 0) {
                    existingTtstt.setName(termName + " " + 0);
                    this.taxonomyManager.updateTerm(existingTtstt, existingTtstt.getName(), existingTtstt.getTaxonomy().getName(), false);
                }
                termCnt = termCnt + 1;
                ttstt.setName(termName + " " + termCnt);
            }
            this.taxonomyManager.updateTerm(ttstt, null, null, true);
            this.updateParentOfChildrenOfInsertedTerm(insertionPoint, ttstt);
            AttributeMappingConfig mcfg = new AttributeMappingConfig();
            mcfg.setAttributeName(attr.getName());
            mcfg.setAttributeType(attr.getType());
            mcfg.setAttributeValue(val);
            mcfg.setLayerTermId(layerTermId);
            mcfg.setTermId(ttstt.getId().toString());
            mcfg.setPresentable(Boolean.valueOf(attr.isPresentable()));
            mcfg.setMapValue(Boolean.valueOf(attr.isMapValue()));
            this.addMappingConfig(mcfg, cfgCache);
            createdMappingCounts.get(termName).put(val, termCnt);
            TaxonomyTermShape tts = new TaxonomyTermShape();
            tts.setTerm(this.taxonomyManager.findTermByName(ttstt.getName(), false));
            tts.setShape(s);
            tts.setCreator(principal);
            this.taxonomyTermShapeDao.create((Entity)tts);
            if (!attr.isAutoDocumentMapping() || (doc = this.findMapDocumentByValue(val)) == null) continue;
            this.mapDocumentByValue(doc, tts, principal);
        }
    }

    private void updateParentOfChildrenOfInsertedTerm(TaxonomyTermInsertionPoint insertionPoint, TaxonomyTerm ttstt) throws Exception {
        if (!insertionPoint.over.isEmpty()) {
            for (TaxonomyTerm over : insertionPoint.over) {
                over.setParent(ttstt);
                this.taxonomyManager.updateTerm(over, null, null, false);
            }
        }
    }

    private void generateAutoDocumentMappingsForShapeAttributes(String layerTermId, Principal principal, Map<String, Map<String, AttributeMappingConfig>> cfgCache, Shape s, AttributeInfo attr, Set<String> vals, Taxonomy termTaxonomy, String nodeValue) throws Exception {
        for (String val : vals) {
            TaxonomyTermShape tts;
            Document doc;
            if (!val.equals(nodeValue) || !attr.isAutoDocumentMapping() || (doc = this.findMapDocumentByValue(val)) == null) continue;
            String termName = attr.getTaxonomy() + StringUtils.normalizeEntityName((String)(new String(new char[]{val.charAt(0)}).toUpperCase() + val.substring(1).toLowerCase()));
            TaxonomyTerm ttstt = this.taxonomyManager.findTermByName(termName, false);
            if (ttstt == null) {
                ttstt = new TaxonomyTerm();
                ttstt.setName(termName);
                ttstt.setCreator(principal);
                ttstt.setIsActive(true);
                ttstt.setTaxonomy(termTaxonomy);
                this.taxonomyManager.updateTerm(ttstt, null, null, true);
                AttributeMappingConfig mcfg = new AttributeMappingConfig();
                mcfg.setAttributeName(attr.getName());
                mcfg.setAttributeType(attr.getType());
                mcfg.setAttributeValue(val);
                mcfg.setLayerTermId(layerTermId);
                mcfg.setTermId(ttstt.getId().toString());
                this.addMappingConfig(mcfg, cfgCache);
            }
            if ((tts = this.taxonomyTermShapeDao.find(ttstt, s)) == null) {
                tts = new TaxonomyTermShape();
                tts.setCreator(principal);
                tts.setShape(s);
                tts.setTerm(ttstt);
                this.taxonomyTermShapeDao.create((Entity)tts);
            }
            this.mapDocumentByValue(doc, tts, principal);
        }
    }

    private void createTermsForShapeAttributes(Map<String, Map<String, AttributeInfo>> attrInfo, Principal principal, DocumentBuilder db, Shape s) throws SAXException, IOException, Exception {
        org.w3c.dom.Document d = db.parse(new InputSource(new StringReader(s.getExtraData())));
        for (Map.Entry<String, Map<String, AttributeInfo>> ai : attrInfo.entrySet()) {
            NodeList els;
            if (ai.getValue().get(NoValueKey) != null && !ai.getValue().get(NoValueKey).isStore() || (els = d.getElementsByTagName(ai.getKey())).getLength() != 1) continue;
            Node el = els.item(0);
            for (Map.Entry<String, AttributeInfo> aie : ai.getValue().entrySet()) {
                if (el.getFirstChild() == null || !aie.getKey().equals(el.getFirstChild().getNodeValue())) continue;
                TaxonomyTerm ttstt = this.taxonomyManager.findTermByNameAndTaxonomy(aie.getValue().getTerm(), aie.getValue().getTaxonomy(), false);
                TaxonomyTermShape tts = new TaxonomyTermShape();
                tts.setTerm(ttstt);
                tts.setShape(s);
                tts.setCreator(principal);
                this.taxonomyTermShapeDao.create((Entity)tts);
                if (aie.getValue().getDocument() == null) continue;
                Document document = this.documentManager.findById(aie.getValue().getDocument(), false);
                ShapeDocument sd = new ShapeDocument();
                sd.setCreator(principal);
                sd.setTaxonomyTermShape(tts);
                sd.setDocument(document);
                this.shapeDocumentDao.create((Entity)sd);
            }
        }
    }

    private void addMappingConfig(AttributeMappingConfig mcfg, Map<String, Map<String, AttributeMappingConfig>> cfgCache) throws Exception {
        if (cfgCache == null) {
            this.configurationManager.updateMappingConfig(mcfg);
            return;
        }
        String key = null;
        if (mcfg.getAttributeName() == null) {
            return;
        }
        key = mcfg.getTermId() == null && mcfg.getAttributeValue() == null ? NoMappingKey : (mcfg.getAttributeValue() == null ? NoValueKey : mcfg.getAttributeValue());
        if (cfgCache.get(mcfg.getAttributeName()) == null) {
            cfgCache.put(mcfg.getAttributeName(), new HashMap());
        }
        if (cfgCache.get(mcfg.getAttributeName()).get(key) == null) {
            cfgCache.get(mcfg.getAttributeName()).put(key, mcfg);
            this.configurationManager.updateMappingConfig(mcfg);
        }
    }

    private void setTaxonomyDataGeographic(Taxonomy taxonomy) {
        TaxonomyData taxonomyData = new TaxonomyData();
        taxonomyData.setGeographic(true);
        taxonomy.setExtraData(this.taxonomyManager.marshalTaxonomyData(taxonomyData));
    }

    private Document findMapDocumentByValue(String val) throws Exception {
        List<Document> ds = this.documentManager.searchDocuments(Collections.singletonList(val));
        if (ds != null && !ds.isEmpty()) {
            if (ds.size() == 1) {
                Document doc = ds.get(0);
                RepositoryFile rf = this.repository.retrieve(doc.getId().toString());
                if (rf == null) {
                    log.error("Could not locate doc " + doc.getId() + " for value " + val + " in data repository");
                    throw new Exception("Could not locate doc " + doc.getId() + " for value " + val + " in data repository");
                }
                return doc;
            }
            log.warn("Multiple documents matching " + val + " were found during auto document mapping");
            return null;
        }
        log.warn("Could not find document for value " + val + ".");
        return null;
    }

    private void mapDocumentByValue(Document doc, TaxonomyTermShape tts, Principal principal) throws Exception {
        ShapeDocument sd = new ShapeDocument();
        sd.setCreator(principal);
        sd.setTaxonomyTermShape(tts);
        sd.setDocument(doc);
        this.shapeDocumentDao.create((Entity)sd);
    }

    @Override
    @Transactional
    public void generateShapeBoundary(TaxonomyTerm layerTerm, TaxonomyTerm boundaryTerm, Principal principal) throws Exception {
        List<Shape> shapes = this.getShapesOfLayer(layerTerm);
        Shape boundary = new Shape();
        boundary.setCreator(principal);
        boundary.setGeography(shapes.get(0).getGeography());
        boundary.setName(layerTerm.getName() + "_boundary");
        this.shapeDao.create((Entity)boundary);
        for (int i = 1; i < shapes.size(); ++i) {
            Shape buffer = this.shapeDao.buffer(shapes.get(i), 10.0f);
            this.shapeDao.create((Entity)buffer);
            Shape union = this.shapeDao.union(boundary, buffer);
            boundary.setGeography(union.getGeography());
            this.shapeDao.update((Entity)boundary);
            this.shapeDao.delete((Entity)buffer);
        }
        TaxonomyTermShape tts = new TaxonomyTermShape();
        tts.setCreator(principal);
        tts.setTerm(boundaryTerm);
        tts.setShape(boundary);
        this.taxonomyTermShapeDao.create((Entity)tts);
    }

    @Override
    @Transactional(readOnly=true)
    public List<Shape> getShapesOfImport(UUID importId) throws Exception {
        ShapeImport si = new ShapeImport();
        si.setShapeImport(importId);
        List shapes = this.shapeDao.findShapesByImport(si);
        if (shapes == null) {
            return null;
        }
        return shapes;
    }

    @Override
    @Transactional(readOnly=true)
    public List<Shape> getShapesOfLayer(TaxonomyTerm tt) throws Exception {
        List shapes = this.shapeDao.findShapesByTerm(tt);
        if (shapes == null) {
            return null;
        }
        return shapes;
    }

    @Override
    @Transactional(readOnly=true)
    public List<Shape> getShapesOfLayer(String termName, String termTaxonomy) throws Exception {
        TaxonomyTerm tt = this.taxonomyManager.findTermByNameAndTaxonomy(termName, termTaxonomy, false);
        return this.getShapesOfLayer(tt);
    }

    @Override
    @Transactional(readOnly=true)
    public Shape getShapeFromLayerTermAndShapeTerm(TaxonomyTerm layerTerm, TaxonomyTerm termForShape) {
        return this.getShapeFromLayerTermAndShapeTerm(layerTerm, termForShape, false);
    }

    @Override
    @Transactional(readOnly=true)
    public Shape getShapeFromLayerTermAndShapeTerm(TaxonomyTerm layerTerm, TaxonomyTerm termForShape, boolean loadDetails) {
        Shape shape = this.shapeDao.getShapeFromLayerTermAndShapeTerm(layerTerm, termForShape);
        return shape;
    }

    @Override
    @Transactional(readOnly=true)
    public Map<String, Shape> getShapesFromLayerTerm(TaxonomyTerm layerTerm) {
        return this.shapeDao.getShapesFromLayerTerm(layerTerm);
    }

    @Override
    @Transactional(readOnly=true)
    public TaxonomyTerm getTermFromLayerTermAndShape(TaxonomyTerm layerTerm, Shape shape) {
        return this.getTermFromLayerTermAndShape(layerTerm, shape, false);
    }

    @Override
    @Transactional(readOnly=true)
    public TaxonomyTerm getTermFromLayerTermAndShape(TaxonomyTerm layerTerm, Shape shape, boolean loadDetails) {
        TaxonomyTerm t = this.shapeDao.getTermFromLayerTermAndShape(layerTerm, shape);
        if (loadDetails) {
            this.taxonomyManager.getTermDetails(t);
        }
        return t;
    }

    @Override
    @Transactional(readOnly=true)
    public List<ShapeInfo> getShapeInfoForTerm(String termName, String termTaxonomy) throws Exception {
        TaxonomyTerm tt = this.taxonomyManager.findTermByNameAndTaxonomy(termName, termTaxonomy, false);
        List shapes = this.shapeDao.findShapesByTerm(tt);
        if (shapes == null) {
            return null;
        }
        ArrayList<ShapeInfo> res = new ArrayList<ShapeInfo>();
        for (Shape s : shapes) {
            ShapeInfo si = new ShapeInfo();
            si.setShape(s);
            si.setTerm(tt);
            res.add(si);
        }
        return res;
    }

    @Override
    @Transactional
    public void deleteShapesOfTerm(TaxonomyTerm tt) throws Exception {
        List shapes = this.shapeDao.findShapesByTerm(tt);
        this.shapeTermDao.deleteByTerm(tt);
        for (Shape s : shapes) {
            this.shapeDao.delete((Entity)s);
        }
    }

    @Override
    @Transactional(readOnly=true)
    public List<TaxonomyTermShape> findTermMappingsOfLayerShapes(TaxonomyTerm tt) throws Exception {
        return this.shapeDao.findTermMappingsOfLayerShapes(tt);
    }

    @Override
    @Transactional(readOnly=true)
    public List<TaxonomyTerm> findTaxonomyTermShapes(Shape s) throws Exception {
        return this.findTaxonomyTermShapes(s, false);
    }

    @Override
    @Transactional(readOnly=true)
    public List<TaxonomyTerm> findTaxonomyTermShapes(Shape s, boolean loadDetails) throws Exception {
        List result = this.shapeDao.findTaxononyTermShapes(s);
        if (loadDetails) {
            result.forEach(tt -> {
                TaxonomyTerm cfr_ignored_0 = (TaxonomyTerm)this.taxonomyTermDao.loadDetails((Entity)tt);
            });
        }
        return result;
    }

    @Override
    @Transactional(readOnly=true)
    public List<Shape> findShapesOfImport(ShapeImport shapeImport) throws Exception {
        return this.shapeDao.findShapesByImport(shapeImport);
    }

    @Override
    @Transactional(readOnly=true)
    public long countShapesOfImport(UUID shapeImport) throws Exception {
        return this.shapeDao.countShapesByImport(shapeImport);
    }

    @Override
    @Transactional(readOnly=true)
    public List<ShapeInfo> findShapesOfImport(UUID shapeImport) throws Exception {
        List shapes = this.shapeDao.findShapesByImport(shapeImport);
        ArrayList<ShapeInfo> res = new ArrayList<ShapeInfo>();
        for (Shape s : shapes) {
            ShapeInfo si = new ShapeInfo();
            si.setShape(s);
            TaxonomyTerm t = this.shapeDao.findTermOfShape(s);
            si.setTerm(t);
            res.add(si);
        }
        return res;
    }

    @Override
    @Transactional(readOnly=true)
    public List<ShapeInfo> findShapeWithinBounds(String bounds) throws Exception {
        Geometry geom = new WKTReader().read(bounds);
        geom.setSRID(4326);
        Shape sh = new Shape();
        sh.setId(UUIDGenerator.randomUUID());
        sh.setGeography(geom);
        List shapes = this.shapeDao.findContains(sh);
        ArrayList<ShapeInfo> res = new ArrayList<ShapeInfo>();
        for (Shape s : shapes) {
            ShapeInfo si = new ShapeInfo();
            si.setShape(s);
            TaxonomyTerm t = this.shapeDao.findTermOfShape(s);
            si.setTerm(t);
            res.add(si);
        }
        return res;
    }

    @Override
    @Transactional(readOnly=true)
    public boolean existShapesOfTerm(TaxonomyTerm tt) throws Exception {
        return this.shapeDao.existShapesOfTerm(tt);
    }

    @Override
    @Transactional(readOnly=true)
    public ShapeInfo getShape(UUID id) throws Exception {
        ShapeInfo si = new ShapeInfo();
        Shape s = (Shape)this.shapeDao.read((Serializable)id);
        if (s == null) {
            return null;
        }
        si.setShape(s);
        TaxonomyTerm t = this.shapeDao.findTermOfShape(s);
        si.setTerm(t);
        return si;
    }

    @Override
    @Transactional(readOnly=true)
    public Bounds getShapeBounds(UUID id) throws Exception {
        Shape s = (Shape)this.shapeDao.read((Serializable)id);
        if (s == null) {
            throw new Exception("Shape " + id + " not found");
        }
        Shape env = this.shapeDao.envelope(s);
        Geometry geom = env.getGeography();
        return null;
    }

    @Transactional
    public Shape createFromGeometry(Principal principal, String shapeName, String geometry) throws Exception {
        Geometry geom = new WKTReader().read(geometry);
        geom.setSRID(4326);
        Shape s = new Shape();
        s.setGeography(geom);
        s.setName(shapeName);
        s.setCreator(principal);
        this.shapeDao.create((Entity)s);
        return s;
    }

    @Override
    @Transactional
    public Shape createFromGeometry(Project project, String geometry) throws Exception {
        return this.createFromGeometry(project.getCreator(), project.getName(), geometry);
    }

    @Override
    @Transactional
    public Shape createFromGeometryPolygon(Project project, NewProjectData npd, Principal principal) throws Exception {
        WKTReader reader = new WKTReader();
        String polygon = "POLYGON((" + npd.getCoords().getCoord0()[0] + " " + npd.getCoords().getCoord0()[1] + "," + npd.getCoords().getCoord1()[0] + " " + npd.getCoords().getCoord1()[1] + "," + npd.getCoords().getCoord2()[0] + " " + npd.getCoords().getCoord2()[1] + "," + npd.getCoords().getCoord3()[0] + " " + npd.getCoords().getCoord3()[1] + "," + npd.getCoords().getCoord0()[0] + " " + npd.getCoords().getCoord0()[1] + "))";
        Geometry g = reader.read(polygon);
        g.setSRID(4326);
        Shape s = new Shape();
        s.setGeography(g);
        s.setCreator(principal);
        this.shapeDao.create((Entity)s);
        return s;
    }

    @Override
    @Transactional
    public void updateGeometry(UUID id, String geometry) throws Exception {
        Shape ex = (Shape)this.shapeDao.read((Serializable)id);
        if (ex == null) {
            throw new Exception("Shape " + id + " not found");
        }
        Geometry geom = new WKTReader().read(geometry);
        ex.setGeography(geom);
        this.shapeDao.update((Entity)ex);
    }

    @Override
    @Transactional(readOnly=true)
    public String getGeometry(UUID id) throws Exception {
        Shape s = (Shape)this.shapeDao.read((Serializable)id);
        if (s == null) {
            throw new Exception("Shape " + id + " not found");
        }
        return new WKTWriter().write(s.getGeography());
    }

    @Override
    @Transactional(readOnly=true)
    public String getBoundingBoxByProjectNameAndTenant(String projectName, String tenantName) throws Exception {
        List projects = this.projectDao.findByNameAndTenant(projectName, tenantName);
        if (projects != null && projects.size() > 1) {
            throw new Exception("Multiple projects with name " + projectName);
        }
        Project project = null;
        if (projects != null && !projects.isEmpty()) {
            project = (Project)projects.get(0);
        }
        return project.getClient();
    }

    @Override
    @Transactional
    public void update(Shape s) throws Exception {
        Shape ex = (Shape)this.shapeDao.read((Serializable)s.getId());
        if (ex == null) {
            throw new Exception("Shape " + s.getId() + " not found");
        }
        if (s.getCode() != null) {
            ex.setCode(s.getCode());
        }
        if (s.getExtraData() != null) {
            ex.setExtraData(s.getExtraData());
        }
        if (s.getName() != null) {
            ex.setName(s.getName());
        }
        if (s.getShapeClass() > -1) {
            ex.setShapeClass(s.getShapeClass());
        }
        this.shapeDao.update((Entity)ex);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delete(List<String> shapes) throws Exception {
        for (String s : shapes) {
            Shape sh = (Shape)this.shapeDao.read((Serializable)UUID.fromString(s));
            if (sh == null) {
                throw new Exception("Shape " + s + " not found");
            }
            TaxonomyTerm tt = this.shapeDao.findTermOfShape(sh);
            if (tt != null) {
                ShapeTerm st = this.shapeTermDao.find(tt, sh);
                if (st == null) {
                    throw new Exception("Could not find shape term for shape " + s);
                }
                this.shapeTermDao.delete((Entity)st);
            }
            List ttss = this.taxonomyTermShapeDao.findByShape(sh);
            for (TaxonomyTermShape tts : ttss) {
                this.shapeDocumentDao.deleteByTaxonomyTermShape(tts);
                this.taxonomyTermShapeDao.delete((Entity)tts);
            }
            this.shapeDao.delete((Entity)sh);
        }
    }

    @Override
    @Transactional(readOnly=true)
    public List<Shape> findShapesEnclosingGeometry(Shape s) throws Exception {
        return this.shapeDao.findWithin(s);
    }

    @Override
    @Transactional(readOnly=true)
    public List<Shape> findShapesOfLayerEnclosingGeometry(Shape s, TaxonomyTerm layerTerm) throws Exception {
        return this.shapeDao.findWithin(s, layerTerm, null);
    }

    @Override
    @Transactional(readOnly=true)
    public List<Shape> findShapesOfLayerEnclosingGeometry(Shape s, TaxonomyTerm layerTerm, TaxonomyTerm term) throws Exception {
        return this.shapeDao.findWithin(s, layerTerm, term);
    }

    @Override
    @Transactional(readOnly=true)
    public List<Shape> findShapesEnclosingGeometry(Geometry geometry) throws Exception {
        Shape s = new Shape();
        s.setGeography(geometry);
        return this.findShapesEnclosingGeometry(s);
    }

    @Override
    @Transactional(readOnly=true)
    public List<Shape> findShapesOfLayerEnclosingGeometry(Geometry geometry, TaxonomyTerm layerTerm) throws Exception {
        Shape s = new Shape();
        s.setGeography(geometry);
        return this.findShapesOfLayerEnclosingGeometry(s, layerTerm);
    }

    @Override
    @Transactional(readOnly=true)
    public List<Shape> findShapesOfLayerEnclosingGeometry(Geometry geometry, TaxonomyTerm layerTerm, TaxonomyTerm term) throws Exception {
        Shape s = new Shape();
        s.setGeography(geometry);
        return this.findShapesOfLayerEnclosingGeometry(s, layerTerm, term);
    }

    private List<List<Taxonomy>> getAlternativeHierarchies(List<Taxonomy> mainHierarchy, List<List<Taxonomy>> currentAlts, int index, List<Taxonomy> allTaxonomies, Map<UUID, TaxonomyData> taxonomyData) throws Exception {
        ArrayList<List<Taxonomy>> currHierarchies = new ArrayList<List<Taxonomy>>(currentAlts);
        currHierarchies.add(mainHierarchy);
        ArrayList<List<Taxonomy>> altHierarchies = new ArrayList<List<Taxonomy>>();
        Taxonomy altTaxonomy = mainHierarchy.get(index);
        TaxonomyData altTaxonomyData = taxonomyData.get(altTaxonomy.getId());
        for (List list : currHierarchies) {
            for (UUID alt : altTaxonomyData.getAlternatives()) {
                Taxonomy t2;
                ArrayList<Taxonomy> altHierarchy = new ArrayList<Taxonomy>();
                Iterator iterator = list.iterator();
                while (iterator.hasNext() && !(t2 = (Taxonomy)iterator.next()).getId().equals(altTaxonomy.getId())) {
                    altHierarchy.add(t2);
                }
                altHierarchies.add(altHierarchy);
            }
        }
        block3: for (int i = 0; i < altTaxonomyData.getAlternatives().size(); ++i) {
            for (List list : altHierarchies) {
                Taxonomy child = null;
                int ind = i;
                List children = allTaxonomies.stream().filter(t -> ((TaxonomyData)taxonomyData.get(t.getId())).getParent().equals(altTaxonomyData.getAlternatives().get(ind))).collect(Collectors.toList());
                if (!children.isEmpty()) {
                    if (children.size() > 1) {
                        throw new Exception("Branched taxonomy hierarchies not supported");
                    }
                    child = (Taxonomy)children.get(0);
                }
                if (child == null) continue block3;
                list.add(child);
            }
        }
        List<Taxonomy> rest = mainHierarchy.subList(index + 1, mainHierarchy.size());
        for (List list : altHierarchies) {
            list.addAll(rest);
        }
        return altHierarchies;
    }

    @Override
    @Transactional(readOnly=true)
    public GeographyHierarchy getDefaultGeographyHierarchy() throws Exception {
        return this.getGeographyHierarchy(this.taxonomyManager.findTaxonomyById(this.configurationManager.retrieveTaxonomyConfig(TaxonomyConfig.Type.GEOGRAPHYTAXONOMY).get(0).getId(), false));
    }

    @Override
    @Transactional(readOnly=true)
    public GeographyHierarchy getGeographyHierarchy(Taxonomy geogTaxonomy) throws Exception {
        GeographyHierarchy hierarchy = new GeographyHierarchy();
        List<Taxonomy> allTaxonomies = this.taxonomyManager.allTaxonomies(false);
        Map<UUID, TaxonomyData> taxonomyData = allTaxonomies.stream().filter(t -> t.getExtraData() != null).collect(Collectors.toMap(Taxonomy::getId, t -> this.taxonomyManager.unmarshalTaxonomyData(t.getExtraData())));
        Taxonomy reloadedGeoTax = allTaxonomies.stream().filter(t -> t.getId().equals(geogTaxonomy.getId())).findFirst().get();
        hierarchy.setMainHierarchy(this.constructMainHierarchy(reloadedGeoTax, allTaxonomies, taxonomyData));
        hierarchy.setAlternativeHierarchies(this.constructAlternativeHierarchies(hierarchy, allTaxonomies, taxonomyData));
        return hierarchy;
    }

    private List<List<Taxonomy>> constructAlternativeHierarchies(GeographyHierarchy hierarchy, List<Taxonomy> allTaxonomies, Map<UUID, TaxonomyData> taxonomyData) throws Exception {
        ArrayList<Integer> altIndexes = new ArrayList<Integer>();
        int i = 0;
        for (Taxonomy currTaxonomy : hierarchy.getMainHierarchy()) {
            if (!taxonomyData.get(currTaxonomy.getId()).getAlternatives().isEmpty()) {
                altIndexes.add(i);
            }
            ++i;
        }
        ArrayList<List<Taxonomy>> altHierarchies = new ArrayList<List<Taxonomy>>();
        for (Integer index : altIndexes) {
            altHierarchies.addAll(this.getAlternativeHierarchies(hierarchy.getMainHierarchy(), altHierarchies, index, allTaxonomies, taxonomyData));
        }
        return altHierarchies;
    }

    private List<Taxonomy> constructMainHierarchy(Taxonomy geogTaxonomy, List<Taxonomy> allTaxonomies, Map<UUID, TaxonomyData> taxonomyData) throws Exception {
        TaxonomyData taxData;
        if (geogTaxonomy == null) {
            throw new IllegalArgumentException("Geography taxonomy cannot be null");
        }
        LinkedList<Taxonomy> hier = new LinkedList<Taxonomy>();
        hier.add(geogTaxonomy);
        Taxonomy currTaxonomy = geogTaxonomy;
        while (currTaxonomy != null && (taxData = taxonomyData.get(currTaxonomy.getId())) != null && taxData.getParent() != null) {
            Taxonomy parent = this.taxonomyManager.findTaxonomyById(taxData.getParent().toString(), false);
            if (taxData.getParent() != null) {
                hier.push(parent);
            }
            currTaxonomy = parent;
        }
        currTaxonomy = (Taxonomy)hier.peekLast();
        while (true) {
            Taxonomy ct = currTaxonomy;
            Taxonomy child = null;
            List children = allTaxonomies.stream().filter(t -> {
                TaxonomyData td = (TaxonomyData)taxonomyData.get(t.getId());
                return td != null && td.getParent() != null && td.getParent().equals(ct.getId());
            }).collect(Collectors.toList());
            if (!children.isEmpty()) {
                if (children.size() > 1) {
                    throw new Exception("Branched taxonomy hierarchies not supported");
                }
                child = (Taxonomy)children.get(0);
            }
            if (child == null) break;
            hier.add(child);
            currTaxonomy = child;
        }
        return hier;
    }

    @Override
    @Transactional(readOnly=true)
    public List<TaxonomyTerm> geoLocate(double x, double y) throws Exception {
        boolean located;
        List<TaxonomyTerm> terms;
        ArrayList<TaxonomyTerm> res = new ArrayList<TaxonomyTerm>();
        GeometryFactory gf = new GeometryFactory(new PrecisionModel(), 4326);
        Point point = gf.createPoint(new Coordinate(x, y));
        Shape pointShape = new Shape();
        pointShape.setGeography((Geometry)point);
        TaxonomyConfig tcfg = null;
        List<TaxonomyConfig> tcfgs = this.configurationManager.retrieveTaxonomyConfig(TaxonomyConfig.Type.GEOGRAPHYTAXONOMY);
        if (tcfgs != null) {
            tcfg = this.configurationManager.retrieveTaxonomyConfig(TaxonomyConfig.Type.GEOGRAPHYTAXONOMY).get(0);
        }
        if ((terms = this.taxonomyManager.getTopmostTermsOfTaxonomy(tcfg.getId(), false)) == null || terms.isEmpty()) {
            return res;
        }
        block0: do {
            located = false;
            for (TaxonomyTerm term : terms) {
                List<Shape> termShapes = this.taxonomyManager.getShapesOfTerm(term);
                if (termShapes == null || termShapes.isEmpty()) {
                    log.error("Could not find shapes of taxonomy term " + term.getId());
                    throw new Exception("Could not find shapes of taxonomy term " + term.getId());
                }
                for (Shape termShape : termShapes) {
                    if (!this.shapeDao.within(pointShape, termShape)) continue;
                    if (term.getParent() != null) {
                        term.getParent().getName();
                    }
                    if (term.getTaxonomyTermClass() != null) {
                        term.getTaxonomyTermClass().getName();
                    }
                    term.getTaxonomy().getName();
                    term.getCreator().getName();
                    res.add(term);
                    terms = this.taxonomyManager.getChildrenOfTerm(term.getId().toString(), true, false);
                    located = true;
                    break;
                }
                if (!located) continue;
                continue block0;
            }
        } while (terms != null && !terms.isEmpty() && located);
        return res;
    }

    @Override
    @Transactional(readOnly=true)
    public List<GeoLocation> termLocate(GeoSearchSelection.SearchType searchType, String term, Principal principal) throws Exception {
        ArrayList<GeoLocation> res = new ArrayList<GeoLocation>();
        List<Shape> shapes = this.shapeDao.searchShapes(Collections.singletonList(term));
        HashMap<String, Project> projectShapeMappings = new HashMap<String, Project>();
        shapes = this.filterBySearchType(searchType, shapes, principal, projectShapeMappings);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        for (Shape s : shapes) {
            Point centroid;
            List<TaxonomyTerm> terms;
            boolean nonGeographic = false;
            List ttss = this.taxonomyTermShapeDao.findByShape(s);
            for (TaxonomyTermShape tts : ttss) {
                Taxonomy tax = tts.getTerm().getTaxonomy();
                if (tax.getExtraData() == null || tax.getExtraData().isEmpty()) {
                    nonGeographic = true;
                    break;
                }
                org.w3c.dom.Document ed = db.parse(tax.getExtraData());
                if (ed.getDocumentElement().hasAttribute("geographic") && Boolean.parseBoolean(ed.getDocumentElement().getAttribute("geographic").trim())) continue;
                nonGeographic = true;
                break;
            }
            if (!nonGeographic || (terms = this.geoLocate((centroid = s.getGeography().getCentroid()).getX(), centroid.getY())) == null || terms.isEmpty()) continue;
            ArrayList<GeoLocationTag> tags = new ArrayList<GeoLocationTag>();
            for (TaxonomyTerm t : terms) {
                Shape tts = this.taxonomyTermShapeDao.findUniqueByTerm(t).getShape();
                Point ttsCentroid = tts.getGeography().getCentroid();
                AttributeInfo tagInfo = this.retrieveShapeAttributeByTaxonomy(this.taxonomyTermShapeDao.findUniqueByTerm(t).getShape(), t.getTaxonomy().getId().toString());
                Taxonomy tax = this.taxonomyManager.findTaxonomyById(tagInfo.getTaxonomy(), false);
                Geometry b = tts.getGeography().getEnvelope();
                Bounds bounds = new Bounds(b.getCoordinates()[0].x, b.getCoordinates()[0].y, b.getCoordinates()[2].x, b.getCoordinates()[2].y, null);
                tags.add(new GeoLocationTag(t.getId().toString(), tagInfo.getValue(), tax.getId().toString(), tax.getName(), ttsCentroid.getX(), ttsCentroid.getY(), bounds));
            }
            Geometry b = s.getGeography().getEnvelope();
            Bounds bounds = new Bounds(b.getCoordinates()[0].x, b.getCoordinates()[0].y, b.getCoordinates()[2].x, b.getCoordinates()[2].y, null);
            if (searchType == GeoSearchSelection.SearchType.MAP) {
                res.add(new GeoLocation(tags, centroid.getX(), centroid.getY(), bounds));
                continue;
            }
            if (searchType != GeoSearchSelection.SearchType.PROJECTS) continue;
            Project shapeProject = (Project)projectShapeMappings.get(s.getId().toString());
            res.add(new GeoLocation(tags, centroid.getX(), centroid.getY(), bounds, shapeProject.getName(), shapeProject.getId().toString()));
        }
        return res;
    }

    @Override
    @Transactional
    public Map<UUID, List<TaxonomyTerm>> getBreadcrumbs(Coords coords) throws Exception {
        GeometryFactory geometryFactory = new GeometryFactory(new PrecisionModel(), 4326);
        Point point = geometryFactory.createPoint(new Coordinate(coords.getLon(), coords.getLat()));
        List<Shape> shapes = this.findShapesEnclosingGeometry((Geometry)point);
        HashMap<UUID, TaxonomyTerm> termsById = new HashMap<UUID, TaxonomyTerm>();
        for (Shape shape : shapes) {
            List<TaxonomyTerm> taxonomyTermsOfShape = this.findTaxonomyTermShapes(shape);
            this.removeTermsWhichAreAncestorsOfIncoming(termsById, taxonomyTermsOfShape);
            this.addTermsWhichAreNotAncestorsOfExisting(termsById, taxonomyTermsOfShape);
        }
        return termsById.values().stream().filter(term -> ExceptionUtils.wrap(() -> this.getGeographyHierarchy(term.getTaxonomy())).get() != null).map(term -> {
            ArrayList<TaxonomyTerm> breadcrumb = new ArrayList<TaxonomyTerm>();
            do {
                breadcrumb.add((TaxonomyTerm)term);
            } while ((term = term.getParent()) != null);
            Collections.reverse(breadcrumb);
            return breadcrumb;
        }).collect(Collectors.toMap(breadcrumb -> ((GeographyHierarchy)ExceptionUtils.wrap(() -> this.getGeographyHierarchy(((TaxonomyTerm)breadcrumb.get(0)).getTaxonomy())).get()).getMainHierarchy().get(0).getId(), breadcrumb -> breadcrumb));
    }

    private void removeTermsWhichAreAncestorsOfIncoming(Map<UUID, TaxonomyTerm> termsById, List<TaxonomyTerm> taxonomyTermsOfShape) {
        termsById.keySet().removeAll(termsById.values().stream().filter(t -> taxonomyTermsOfShape.stream().anyMatch(tts -> {
            do {
                if (tts.getParent() == null || !tts.getParent().getId().equals(t.getId())) continue;
                return true;
            } while ((tts = tts.getParent()) != null);
            return false;
        })).map(TaxonomyTerm::getId).collect(Collectors.toSet()));
    }

    private void addTermsWhichAreNotAncestorsOfExisting(Map<UUID, TaxonomyTerm> termsById, List<TaxonomyTerm> taxonomyTermsOfShape) {
        termsById.putAll(taxonomyTermsOfShape.stream().filter(tts -> termsById.values().stream().allMatch(t -> {
            do {
                if (t.getParent() == null || !t.getParent().getId().equals(tts.getId())) continue;
                return false;
            } while ((t = t.getParent()) != null);
            return true;
        })).collect(Collectors.toMap(TaxonomyTerm::getId, x -> x)));
    }

    private List<Shape> filterBySearchType(GeoSearchSelection.SearchType searchType, List<Shape> shapes, Principal principal, Map<String, Project> projectShapeMappings) throws Exception {
        ArrayList<Shape> filtered = new ArrayList<Shape>();
        List projects = this.projectDao.findByCreator(principal);
        ArrayList<Shape> projectShapes = new ArrayList<Shape>();
        HashSet<UUID> filteredIds = new HashSet<UUID>();
        for (Shape s : shapes) {
            for (Project p : projects) {
                if (s.getId().equals(p.getShape())) {
                    if (p.getStatus() == Project.ProjectStatus.DELETED) continue;
                    projectShapeMappings.put(s.getId().toString(), p);
                    projectShapes.add(s);
                    continue;
                }
                if (filteredIds.contains(s.getId())) continue;
                filtered.add(s);
                filteredIds.add(s.getId());
            }
        }
        if (searchType == GeoSearchSelection.SearchType.PROJECTS) {
            return projectShapes;
        }
        return filtered;
    }

    private Map<String, Map<String, Shape.Attribute>> partitionAttributes(Map<String, String> attributes, GeographyHierarchy geographyHierarchy) throws Exception {
        HashSet<String> geographicNames = new HashSet<String>();
        ArrayList<List<Taxonomy>> hier = new ArrayList<List<Taxonomy>>(geographyHierarchy.getAlternativeHierarchies());
        hier.add(geographyHierarchy.getMainHierarchy());
        for (List list : hier) {
            for (Taxonomy t : list) {
                geographicNames.add(t.getName());
            }
        }
        hier.add(geographyHierarchy.getMainHierarchy());
        HashMap<String, String> toProcess = new HashMap<String, String>(attributes);
        HashMap<String, Map<String, Shape.Attribute>> hashMap = new HashMap<String, Map<String, Shape.Attribute>>();
        while (!toProcess.isEmpty()) {
            HashSet<Object> toDelete = new HashSet<Object>();
            for (Map.Entry entry : toProcess.entrySet()) {
                if (geographicNames.contains(entry.getKey())) {
                    toDelete.add(entry.getKey());
                    continue;
                }
                Taxonomy t = this.taxonomyManager.findTaxonomyByName((String)entry.getKey(), false);
                if (t == null) {
                    toDelete.add(entry.getKey());
                    continue;
                }
                TaxonomyConfig tcfg = this.configurationManager.retrieveTaxonomyConfigById(t.getId().toString());
                if (tcfg == null) {
                    toDelete.add(entry.getKey());
                    continue;
                }
                List<AttributeMappingConfig> mcfgs = this.configurationManager.getAttributeMappingsForTermId(t.getId().toString());
                String layer = null;
                for (AttributeMappingConfig mcfg : mcfgs) {
                    if (mcfg.getAttributeValue() != null) continue;
                    layer = mcfg.getLayerTermId();
                    break;
                }
                if (layer == null) {
                    toDelete.add(entry.getKey());
                    continue;
                }
                HashMap<String, Shape.Attribute> layerAttrs = new HashMap<String, Shape.Attribute>();
                mcfgs = this.configurationManager.getMappingConfigsForLayer(layer);
                for (AttributeMappingConfig mcfg : mcfgs) {
                    Taxonomy mT;
                    if (mcfg.getTermId() == null || mcfg.getAttributeValue() != null || (mT = this.taxonomyManager.findTaxonomyById(mcfg.getTermId(), false)) == null || !mT.getName().equals(entry.getKey())) continue;
                    toDelete.add(mT.getName());
                    if (geographicNames.contains(mT.getName()) || layerAttrs.containsKey(mcfg.getAttributeName())) continue;
                    layerAttrs.put(mcfg.getAttributeName(), new Shape.Attribute(mcfg.getAttributeName(), mcfg.getAttributeType(), mcfg.getTermId(), (String)entry.getValue()));
                }
                if (layerAttrs.isEmpty()) continue;
                if (!hashMap.containsKey(layer)) {
                    hashMap.put(layer, new HashMap());
                }
                ((Map)hashMap.get(layer)).putAll(layerAttrs);
            }
            for (String string : toDelete) {
                toProcess.remove(string);
            }
        }
        return hashMap;
    }

    @Override
    @Transactional(readOnly=true)
    public List<GeoLocation> attributeLocate(GeoSearchSelection.SearchType searchType, Map<String, String> attributes, Principal principal) throws Exception {
        GeographyHierarchy hier = this.getDefaultGeographyHierarchy();
        Taxonomy mostSpecificGeog = null;
        String mostSpecificGeogTerm = null;
        Iterator<Taxonomy> hierIt = hier.getMainHierarchy().iterator();
        int i = 0;
        int tIndex = -1;
        while (hierIt.hasNext()) {
            Taxonomy t = hierIt.next();
            if (attributes.containsKey(t.getName())) {
                mostSpecificGeog = t;
                mostSpecificGeogTerm = attributes.get(t.getName());
                attributes.remove(t.getName());
                tIndex = i;
            }
            ++i;
        }
        int maxIndex = tIndex;
        for (List<Taxonomy> alt : hier.getAlternativeHierarchies()) {
            Iterator<Taxonomy> altIt = alt.iterator();
            i = 0;
            int altIndex = 0;
            while (altIt.hasNext()) {
                Taxonomy t = altIt.next();
                if (attributes.containsKey(t.getName())) {
                    altIndex = i;
                    if (altIndex > maxIndex) {
                        maxIndex = altIndex;
                        mostSpecificGeog = t;
                        mostSpecificGeogTerm = attributes.get(t.getName());
                        altIndex = i;
                    }
                    attributes.remove(t.getName());
                }
                ++i;
            }
        }
        TaxonomyTerm tt = this.taxonomyManager.findTermByName(mostSpecificGeogTerm, false);
        Shape shapeTerm = this.taxonomyManager.getShapeOfTerm(tt);
        HashMap<String, Project> projectShapeMappings = new HashMap<String, Project>();
        List<Object> foundShapes = new ArrayList();
        Map<String, Map<String, Shape.Attribute>> partition = this.partitionAttributes(attributes, hier);
        if (!partition.isEmpty()) {
            Map.Entry<String, Map<String, Shape.Attribute>> first = partition.entrySet().iterator().next();
            foundShapes = this.shapeDao.searchShapesWithinByAttributes(first.getValue(), shapeTerm);
            foundShapes = this.filterBySearchType(searchType, foundShapes, principal, projectShapeMappings);
            partition.remove(first.getKey());
        } else {
            foundShapes = this.shapeDao.searchShapesWithinByAttributes(new HashMap(), shapeTerm);
            foundShapes = this.filterBySearchType(searchType, foundShapes, principal, projectShapeMappings);
        }
        for (Map.Entry entry : partition.entrySet()) {
            List list = this.shapeDao.searchShapesWithinByAttributes((Map)entry.getValue(), shapeTerm);
            HashMap<String, Shape> toAdd = new HashMap<String, Shape>();
            for (Shape rs : list) {
                for (Shape shape : foundShapes) {
                    if (this.shapeDao.within(shape, rs)) {
                        if (toAdd.containsKey(shape.getId().toString())) continue;
                        toAdd.put(shape.getId().toString(), shape);
                        continue;
                    }
                    if (!this.shapeDao.within(rs, shape) || toAdd.containsKey(rs.getId().toString())) continue;
                    toAdd.put(rs.getId().toString(), rs);
                }
            }
            foundShapes = new ArrayList(toAdd.values());
            foundShapes = this.filterBySearchType(searchType, foundShapes, principal, projectShapeMappings);
        }
        ArrayList<GeoLocation> res = new ArrayList<GeoLocation>();
        for (Shape shape : foundShapes) {
            Point centroid = shape.getGeography().getCentroid();
            List<TaxonomyTerm> terms = this.geoLocate(centroid.getX(), centroid.getY());
            if (terms == null || terms.isEmpty()) continue;
            ArrayList<GeoLocationTag> tags = new ArrayList<GeoLocationTag>();
            for (TaxonomyTerm taxonomyTerm : terms) {
                Shape tts = this.taxonomyTermShapeDao.findUniqueByTerm(taxonomyTerm).getShape();
                Point ttsCentroid = tts.getGeography().getCentroid();
                AttributeInfo tagInfo = this.retrieveShapeAttributeByTaxonomy(this.taxonomyTermShapeDao.findUniqueByTerm(taxonomyTerm).getShape(), taxonomyTerm.getTaxonomy().getId().toString());
                Taxonomy tax = this.taxonomyManager.findTaxonomyById(tagInfo.getTaxonomy(), false);
                Geometry b = tts.getGeography().getEnvelope();
                Bounds bounds = new Bounds(b.getCoordinates()[0].x, b.getCoordinates()[0].y, b.getCoordinates()[2].x, b.getCoordinates()[2].y, null);
                tags.add(new GeoLocationTag(taxonomyTerm.getId().toString(), tagInfo.getValue(), tax.getId().toString(), tax.getName(), ttsCentroid.getX(), ttsCentroid.getY(), bounds));
            }
            Geometry b = shape.getGeography().getEnvelope();
            Bounds bounds = new Bounds(b.getCoordinates()[0].x, b.getCoordinates()[0].y, b.getCoordinates()[2].x, b.getCoordinates()[2].y, null);
            if (searchType == GeoSearchSelection.SearchType.MAP) {
                res.add(new GeoLocation(tags, centroid.getX(), centroid.getY(), bounds));
                continue;
            }
            if (searchType != GeoSearchSelection.SearchType.PROJECTS) continue;
            Project shapeProject = (Project)projectShapeMappings.get(shape.getId().toString());
            res.add(new GeoLocation(tags, centroid.getX(), centroid.getY(), bounds, shapeProject.getName(), shapeProject.getId().toString()));
        }
        return res;
    }

    @Override
    @Transactional
    public void createShapeAssociationsWithLayerTerm(TaxonomyTerm taxonomyTerm, List<Shape> shapes) {
        shapes.stream().forEach(shape -> {
            ShapeTerm shapeTerm = new ShapeTerm();
            shapeTerm.setCreator(this.principalDao.systemPrincipal());
            shapeTerm.setShape(shape);
            shapeTerm.setTerm(taxonomyTerm);
            this.shapeTermDao.create((Entity)shapeTerm);
        });
    }

    @Override
    public String getBoundingBoxByProjectName(String projectName) throws Exception {
        return null;
    }

    public class TaxonomyTermInsertionPoint {
        private List<TaxonomyTerm> over;
        private TaxonomyTerm under;

        public TaxonomyTermInsertionPoint() {
        }

        public TaxonomyTermInsertionPoint(List<TaxonomyTerm> over, TaxonomyTerm under) {
            this.over = over;
            this.under = under;
        }

        public List<TaxonomyTerm> getParent() {
            return this.over;
        }

        public void setOver(List<TaxonomyTerm> over) {
            this.over = over;
        }

        public TaxonomyTerm getUnder() {
            return this.under;
        }

        public void setUnder(TaxonomyTerm under) {
            this.under = under;
        }
    }

    private class TermLinkInfo {
        public String verb = null;
        public Map<TaxonomyTerm, TaxonomyTerm> links = new HashMap<TaxonomyTerm, TaxonomyTerm>();

        public TermLinkInfo(String verb) {
            this.verb = verb;
        }
    }

    public class GeographyHierarchy {
        private List<Taxonomy> mainHierarchy = null;
        private List<List<Taxonomy>> alternativeHierarchies = new ArrayList<List<Taxonomy>>();

        public List<Taxonomy> getMainHierarchy() {
            return this.mainHierarchy;
        }

        public void setMainHierarchy(List<Taxonomy> mainHierarchy) {
            this.mainHierarchy = mainHierarchy;
        }

        public List<List<Taxonomy>> getAlternativeHierarchies() {
            return this.alternativeHierarchies;
        }

        public void setAlternativeHierarchies(List<List<Taxonomy>> alternativeHierarchies) {
            this.alternativeHierarchies = alternativeHierarchies;
        }

        public void addAlternativeHierarchy(List<Taxonomy> hierarchy) {
            this.alternativeHierarchies.add(hierarchy);
        }
    }
}

