/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.gaap.servicelayer;

import gr.cite.gaap.datatransferobjects.LayerStyleMessenger;
import gr.cite.gaap.servicelayer.DescendantInclusionType;
import gr.cite.gaap.utilities.PresentationConfigXMLHandler;
import gr.cite.geoanalytics.context.Configuration;
import gr.cite.geoanalytics.dataaccess.entities.Entity;
import gr.cite.geoanalytics.dataaccess.entities.geocode.GeocodeSystem;
import gr.cite.geoanalytics.dataaccess.entities.geocode.dao.GeocodeSystemDao;
import gr.cite.geoanalytics.dataaccess.entities.principal.Principal;
import gr.cite.geoanalytics.dataaccess.entities.shape.Shape;
import gr.cite.geoanalytics.dataaccess.entities.sysconfig.SysConfig;
import gr.cite.geoanalytics.dataaccess.entities.sysconfig.dao.SysConfigDao;
import gr.cite.geoanalytics.dataaccess.entities.sysconfig.xml.global.SystemGlobalConfig;
import gr.cite.geoanalytics.dataaccess.entities.sysconfig.xml.global.TaxonomyConfig;
import gr.cite.geoanalytics.dataaccess.entities.sysconfig.xml.layer.LayerConfig;
import gr.cite.geoanalytics.dataaccess.entities.sysconfig.xml.layer.SystemLayerConfig;
import gr.cite.geoanalytics.dataaccess.entities.sysconfig.xml.mapping.AttributeMappingConfig;
import gr.cite.geoanalytics.dataaccess.entities.sysconfig.xml.mapping.SystemMappingConfig;
import gr.cite.geoanalytics.dataaccess.entities.sysconfig.xml.presentation.GeoStyle;
import gr.cite.geoanalytics.dataaccess.entities.sysconfig.xml.presentation.LayerStyle;
import gr.cite.geoanalytics.dataaccess.entities.sysconfig.xml.presentation.SystemPresentationConfig;
import gr.cite.geoanalytics.dataaccess.entities.sysconfig.xml.presentation.TermStyle;
import gr.cite.geoanalytics.dataaccess.entities.sysconfig.xml.presentation.Theme;
import gr.cite.geoanalytics.dataaccess.entities.user.dao.UserDaoOld;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.inject.Inject;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ConfigurationManager {
    private Configuration configuration = null;
    private boolean shutdownInProgress = false;
    private SystemLayerConfig systemLayerConfig = null;
    private SystemMappingConfig systemMappingConfig = null;
    private SystemPresentationConfig systemPresentationConfig = null;
    private SystemGlobalConfig systemGlobalConfig = null;
    private Object systemGlobalConfigLock = new Object();
    private Object systemLayerConfigLock = new Object();
    private Object systemMappingConfigLock = new Object();
    private Object systemPresentationConfigLock = new Object();
    private UserDaoOld userDaoOld;
    private GeocodeSystemDao geocodeSystemDao;
    private SysConfigDao sysConfigDao;
    private List<SystemStatusListener> listeners = new ArrayList<SystemStatusListener>();

    @Inject
    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    @Inject
    public void setUserDao(UserDaoOld userDaoOld) {
        this.userDaoOld = userDaoOld;
    }

    @Inject
    public void setGeocodeSystemDao(GeocodeSystemDao geocodeSystemDao) {
        this.geocodeSystemDao = geocodeSystemDao;
    }

    @Inject
    public void setSysConfigDao(SysConfigDao sysConfigDao) {
        this.sysConfigDao = sysConfigDao;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(readOnly=true)
    public boolean isSystemOnline() throws Exception {
        Object object = this.systemGlobalConfigLock;
        synchronized (object) {
            if (this.systemGlobalConfig == null) {
                this.retrieveSystemGlobalConfig();
            }
            return this.systemGlobalConfig.isSystemOnline();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateOnlineStatus(boolean value) throws Exception {
        Object object = this.systemGlobalConfigLock;
        synchronized (object) {
            if (this.systemGlobalConfig == null) {
                this.retrieveSystemGlobalConfig();
            }
            this.systemGlobalConfig.setSystemOnline(value);
            this.updateSystemGlobalConfig();
        }
    }

    @Transactional
    public void bringUpSystem() throws Exception {
        this.updateOnlineStatus(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> listTaxonomyConfigTypes() throws Exception {
        Set cachedTypes = SystemGlobalConfig.getCachedTaxonomyConfigTypes();
        if (cachedTypes != null) {
            return new ArrayList<String>(cachedTypes);
        }
        Object object = this.systemGlobalConfigLock;
        synchronized (object) {
            if (this.systemGlobalConfig == null) {
                this.retrieveSystemGlobalConfig();
            }
            return new ArrayList<String>(this.systemGlobalConfig.getTaxonomyConfigTypes());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public void setTaxonomyConfig(List<TaxonomyConfig> taxonomyConfigs) throws Exception {
        HashMap taxons = new HashMap();
        for (TaxonomyConfig taxonomyConfig : taxonomyConfigs) {
            List t = this.geocodeSystemDao.findByName(taxonomyConfig.getId());
            if (t == null || t.size() == 0) {
                throw new Exception("Taxonomy " + taxonomyConfig.getId() + " not found");
            }
            if (t.size() != 1) {
                throw new Exception("Non-unique taxonomy " + taxonomyConfig.getId());
            }
            taxons.put(taxonomyConfig.getId(), t.get(0));
        }
        Object object = this.systemGlobalConfigLock;
        synchronized (object) {
            if (this.systemGlobalConfig == null) {
                this.retrieveSystemGlobalConfig();
            }
            ArrayList<TaxonomyConfig> toDelete = new ArrayList<TaxonomyConfig>();
            for (TaxonomyConfig taxonomyConfig : taxonomyConfigs) {
                if (taxonomyConfig.getId() == null || taxonomyConfig.getId().isEmpty() || taxonomyConfig.getId().equalsIgnoreCase("none")) {
                    toDelete.add(taxonomyConfig);
                    continue;
                }
                GeocodeSystem t = (GeocodeSystem)taxons.get(taxonomyConfig.getId());
                taxonomyConfig.setId(t.getId().toString());
                this.systemGlobalConfig.setTaxonomyConfig(taxonomyConfig);
            }
            for (TaxonomyConfig taxonomyConfig : toDelete) {
                this.systemGlobalConfig.removeTaxonomyConfig(taxonomyConfig);
            }
            this.updateSystemGlobalConfig();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public void setTaxonomyConfig(TaxonomyConfig taxonomyConfig) throws Exception {
        List t = this.geocodeSystemDao.findByName(taxonomyConfig.getId());
        if (t == null) {
            throw new Exception("Taxonomy " + taxonomyConfig.getId() + " not found");
        }
        if (t.size() != 1) {
            throw new Exception("Non-unique taxonomy " + taxonomyConfig.getId());
        }
        Object object = this.systemGlobalConfigLock;
        synchronized (object) {
            if (this.systemGlobalConfig == null) {
                this.retrieveSystemGlobalConfig();
            }
            taxonomyConfig.setId(((GeocodeSystem)t.get(0)).getId().toString());
            this.systemGlobalConfig.setTaxonomyConfig(taxonomyConfig);
            this.updateSystemGlobalConfig();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public void addTaxonomyConfigType(String taxonomyConfigType) throws Exception {
        if (SystemGlobalConfig.getCachedTaxonomyConfigTypes() != null && SystemGlobalConfig.getCachedTaxonomyConfigTypes().contains(taxonomyConfigType)) {
            return;
        }
        Object object = this.systemGlobalConfigLock;
        synchronized (object) {
            if (this.systemGlobalConfig == null) {
                this.retrieveSystemGlobalConfig();
            }
            if (!this.systemGlobalConfig.getTaxonomyConfigTypes().contains(taxonomyConfigType)) {
                this.systemGlobalConfig.addTaxonomyConfigType(taxonomyConfigType);
                this.updateSystemGlobalConfig();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(readOnly=true)
    public List<TaxonomyConfig> retrieveTaxonomyConfig(boolean translateId) throws Exception {
        ArrayList<TaxonomyConfig> res = new ArrayList<TaxonomyConfig>();
        List cfg = null;
        Object object = this.systemGlobalConfigLock;
        synchronized (object) {
            if (this.systemGlobalConfig == null) {
                this.retrieveSystemGlobalConfig();
            }
            cfg = this.systemGlobalConfig.getTaxonomyConfig();
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(readOnly=true)
    public List<TaxonomyConfig> retrieveTaxonomyConfig(String taxonomyConfigType, boolean translateId) throws Exception {
        List cfg = null;
        Object object = this.systemGlobalConfigLock;
        synchronized (object) {
            if (this.systemGlobalConfig == null) {
                this.retrieveSystemGlobalConfig();
            }
            cfg = this.systemGlobalConfig.getTaxonomyConfig();
        }
        ArrayList<TaxonomyConfig> taxonomyConfigs = new ArrayList<TaxonomyConfig>();
        for (TaxonomyConfig c : cfg) {
            if (!c.getType().equals(taxonomyConfigType)) continue;
            TaxonomyConfig tcfg = new TaxonomyConfig();
            tcfg.setId(translateId ? ((GeocodeSystem)this.geocodeSystemDao.read((Serializable)UUID.fromString(c.getId()))).getName() : c.getId());
            tcfg.setType(c.getType());
            taxonomyConfigs.add(tcfg);
        }
        if (!taxonomyConfigs.isEmpty()) {
            return taxonomyConfigs;
        }
        return null;
    }

    @Transactional(readOnly=true)
    public List<TaxonomyConfig> retrieveTaxonomyConfig(TaxonomyConfig.Type taxonomyConfigType, boolean translateId) throws Exception {
        return this.retrieveTaxonomyConfig(taxonomyConfigType.toString(), translateId);
    }

    @Transactional(readOnly=true)
    public List<TaxonomyConfig> retrieveTaxonomyConfig(String taxonomyConfigType) throws Exception {
        return this.retrieveTaxonomyConfig(taxonomyConfigType, false);
    }

    @Transactional(readOnly=true)
    public List<TaxonomyConfig> retrieveTaxonomyConfig(TaxonomyConfig.Type type) throws Exception {
        return this.retrieveTaxonomyConfig(type.toString());
    }

    private List<GeocodeSystem> filterTaxonomyByInclusionType(List<GeocodeSystem> ts, Principal principal, DescendantInclusionType inclusionType) {
        if (inclusionType == DescendantInclusionType.ALL) {
            return ts;
        }
        ArrayList<GeocodeSystem> res = new ArrayList<GeocodeSystem>();
        for (GeocodeSystem t : ts) {
            switch (inclusionType) {
                case ALL: {
                    res.add(t);
                    break;
                }
                case EXCLUDE_USER_TAXONOMIES: {
                    if (t.getIsUserTaxonomy()) break;
                    res.add(t);
                    break;
                }
                case INCLUDE_TAXONOMIES_OF_USER: {
                    if (t.getIsUserTaxonomy() && !principal.getId().equals(t.getCreator().getId())) break;
                    res.add(t);
                    break;
                }
                case INCLUDE_TAXONOMIES_OF_CUSTOMER: {
                    if (t.getIsUserTaxonomy() && !principal.getId().equals(t.getCreator().getId()) && (principal.getTenant() == null || t.getCreator().getTenant() == null || principal.getTenant().getId() != t.getCreator().getTenant().getId())) break;
                    res.add(t);
                }
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<GeocodeSystem> doRetrieveTaxonomiesByClass(TaxonomyConfig.Type taxonomyConfigClassType, boolean loadDetails) throws Exception {
        List baseTaxonomyIds = null;
        Object object = this.systemGlobalConfigLock;
        synchronized (object) {
            if (this.systemGlobalConfig == null) {
                this.retrieveSystemGlobalConfig();
            }
            baseTaxonomyIds = this.systemGlobalConfig.getByTaxonomyTag(taxonomyConfigClassType.toString());
        }
        if (baseTaxonomyIds == null || baseTaxonomyIds.isEmpty()) {
            return new ArrayList<GeocodeSystem>();
        }
        ArrayList<Entity> baseTaxonomies = new ArrayList<Entity>();
        for (String bti : baseTaxonomyIds) {
            baseTaxonomies.add(this.geocodeSystemDao.read((Serializable)UUID.fromString(bti)));
        }
        ArrayList<GeocodeSystem> instances = new ArrayList<GeocodeSystem>();
        for (GeocodeSystem geocodeSystem : baseTaxonomies) {
            instances.addAll(this.geocodeSystemDao.getInstancesByID(geocodeSystem.getId()));
        }
        if (loadDetails) {
            for (GeocodeSystem geocodeSystem : instances) {
                geocodeSystem.getCreator().getTenant();
                geocodeSystem.getExtraData();
                geocodeSystem.getTaxonomyClass();
            }
        }
        return instances;
    }

    @Transactional(readOnly=true)
    public List<TaxonomyConfig> retrieveTaxonomyConfigByClass(TaxonomyConfig.Type taxonomyConfigClassType) throws Exception {
        return this.retrieveTaxonomyConfigByClass(taxonomyConfigClassType, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(readOnly=true)
    public List<TaxonomyConfig> retrieveTaxonomyConfigByClass(TaxonomyConfig.Type taxonomyConfigClassType, boolean translateId) throws Exception {
        ArrayList<TaxonomyConfig> res = new ArrayList<TaxonomyConfig>();
        List<GeocodeSystem> instances = this.doRetrieveTaxonomiesByClass(taxonomyConfigClassType, false);
        SystemGlobalConfig systemGlobalConfig = this.systemGlobalConfig;
        synchronized (systemGlobalConfig) {
            for (GeocodeSystem i : instances) {
                TaxonomyConfig tcfg = this.systemGlobalConfig.getByTaxonomyId(i.getId().toString());
                if (tcfg == null) continue;
                if (translateId) {
                    tcfg.setId(((GeocodeSystem)this.geocodeSystemDao.read((Serializable)UUID.fromString(tcfg.getId()))).getName());
                }
                res.add(tcfg);
            }
        }
        return res;
    }

    @Transactional(readOnly=true)
    public List<GeocodeSystem> retrieveTaxonomiesByClass(TaxonomyConfig.Type taxonomyConfigClassType, Principal principal, DescendantInclusionType inclusionType, boolean loadDetails) throws Exception {
        List<GeocodeSystem> instances = this.doRetrieveTaxonomiesByClass(taxonomyConfigClassType, loadDetails);
        return this.filterTaxonomyByInclusionType(instances, principal, inclusionType);
    }

    @Transactional(readOnly=true)
    public List<GeocodeSystem> retrieveTaxonomiesByClass(TaxonomyConfig.Type taxonomyConfigClassType, Principal principal, DescendantInclusionType inclusionType) throws Exception {
        return this.retrieveTaxonomiesByClass(taxonomyConfigClassType, principal, inclusionType, false);
    }

    @Transactional(readOnly=true)
    public List<GeocodeSystem> retrieveTaxonomiesByClass(TaxonomyConfig.Type taxonomyConfigClassType, boolean loadDetails) throws Exception {
        return this.retrieveTaxonomiesByClass(taxonomyConfigClassType, null, DescendantInclusionType.ALL, loadDetails);
    }

    @Transactional(readOnly=true)
    public List<GeocodeSystem> retrieveTaxonomiesByClass(TaxonomyConfig.Type taxonomyConfigClassType) throws Exception {
        return this.retrieveTaxonomiesByClass(taxonomyConfigClassType, null, DescendantInclusionType.ALL, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(readOnly=true)
    public TaxonomyConfig retrieveTaxonomyConfigById(String id, boolean translateId) throws Exception {
        TaxonomyConfig tcfg = null;
        SystemGlobalConfig systemGlobalConfig = this.systemGlobalConfig;
        synchronized (systemGlobalConfig) {
            if (this.systemGlobalConfig == null) {
                this.retrieveSystemGlobalConfig();
            }
            tcfg = this.systemGlobalConfig.getByTaxonomyId(id);
        }
        if (tcfg == null) {
            return null;
        }
        if (translateId) {
            tcfg.setId(((GeocodeSystem)this.geocodeSystemDao.read((Serializable)UUID.fromString(tcfg.getId()))).getName());
        }
        return tcfg;
    }

    @Transactional(readOnly=true)
    public TaxonomyConfig retrieveTaxonomyConfigById(String id) throws Exception {
        return this.retrieveTaxonomyConfigById(id, false);
    }

    private void retrieveSystemGlobalConfig() throws Exception {
        List configs = this.sysConfigDao.findByClass(SysConfig.SysConfigClass.GLOBALCONFIG.configClassCode());
        if (configs == null || configs.isEmpty()) {
            throw new Exception("Could not retrieve system global configuration");
        }
        if (configs.size() != 1) {
            throw new Exception("Non-unique system global configuration");
        }
        SysConfig config = (SysConfig)configs.get(0);
        JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{SystemGlobalConfig.class});
        Unmarshaller um = ctx.createUnmarshaller();
        this.systemGlobalConfig = (SystemGlobalConfig)um.unmarshal((Reader)new StringReader(config.getConfig()));
    }

    private void retrieveSystemLayerConfig() throws Exception {
        List cfgs = this.sysConfigDao.findByClass(SysConfig.SysConfigClass.LAYERCONFIG.configClassCode());
        if (cfgs == null || cfgs.isEmpty()) {
            throw new Exception("Could not retrieve system layer config");
        }
        if (cfgs.size() != 1) {
            throw new Exception("Non-unique system layer config");
        }
        SysConfig cfg = (SysConfig)cfgs.get(0);
        JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{SystemLayerConfig.class});
        Unmarshaller um = ctx.createUnmarshaller();
        this.systemLayerConfig = (SystemLayerConfig)um.unmarshal((Reader)new StringReader(cfg.getConfig()));
    }

    private void retrieveSystemAttributeMappingConfig() throws Exception {
        List cfgs = this.sysConfigDao.findByClass(SysConfig.SysConfigClass.ATTRIBUTEMAPPING.configClassCode());
        if (cfgs == null || cfgs.isEmpty()) {
            throw new Exception("Could not retrieve system mapping config");
        }
        if (cfgs.size() != 1) {
            throw new Exception("Non-unique system mapping config");
        }
        SysConfig cfg = (SysConfig)cfgs.get(0);
        JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{SystemMappingConfig.class});
        Unmarshaller um = ctx.createUnmarshaller();
        this.systemMappingConfig = (SystemMappingConfig)um.unmarshal((Reader)new StringReader(cfg.getConfig()));
    }

    private void retrieveSystemPresentationConfig() throws Exception {
        List cfgs = this.sysConfigDao.findByClass(SysConfig.SysConfigClass.PRESENTATION.configClassCode());
        if (cfgs == null || cfgs.isEmpty()) {
            throw new Exception("Could not retrieve system mapping config");
        }
        if (cfgs.size() != 1) {
            throw new Exception("Non-unique system mapping config");
        }
        SysConfig cfg = (SysConfig)cfgs.get(0);
        this.systemPresentationConfig = PresentationConfigXMLHandler.unmarshal((String)cfg.getConfig());
    }

    private void updateSystemGlobalConfig() throws Exception {
        List cfgs = this.sysConfigDao.findByClass(SysConfig.SysConfigClass.GLOBALCONFIG.configClassCode());
        if (cfgs == null || cfgs.isEmpty()) {
            throw new Exception("Could not retrieve system global config");
        }
        if (cfgs.size() != 1) {
            throw new Exception("Non-unique system global config");
        }
        SysConfig cfg = (SysConfig)cfgs.get(0);
        JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{SystemGlobalConfig.class});
        Marshaller m = ctx.createMarshaller();
        StringWriter sw = new StringWriter();
        m.marshal((Object)this.systemGlobalConfig, (Writer)sw);
        cfg.setConfig(sw.toString());
        this.sysConfigDao.update((Entity)cfg);
    }

    private void updateSystemLayerConfig() throws Exception {
        List cfgs = this.sysConfigDao.findByClass(SysConfig.SysConfigClass.LAYERCONFIG.configClassCode());
        if (cfgs == null || cfgs.isEmpty()) {
            throw new Exception("Could not retrieve system layer config");
        }
        if (cfgs.size() != 1) {
            throw new Exception("Non-unique system layer config");
        }
        SysConfig cfg = (SysConfig)cfgs.get(0);
        JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{SystemLayerConfig.class});
        Marshaller m = ctx.createMarshaller();
        StringWriter sw = new StringWriter();
        m.marshal((Object)this.systemLayerConfig, (Writer)sw);
        cfg.setConfig(sw.toString());
        this.sysConfigDao.update((Entity)cfg);
    }

    private void updateSystemMappingConfig() throws Exception {
        List cfgs = this.sysConfigDao.findByClass(SysConfig.SysConfigClass.ATTRIBUTEMAPPING.configClassCode());
        if (cfgs == null || cfgs.isEmpty()) {
            throw new Exception("Could not retrieve system mapping config");
        }
        if (cfgs.size() != 1) {
            throw new Exception("Non-unique system mapping config");
        }
        SysConfig cfg = (SysConfig)cfgs.get(0);
        JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{SystemMappingConfig.class});
        Marshaller m = ctx.createMarshaller();
        StringWriter sw = new StringWriter();
        m.marshal((Object)this.systemMappingConfig, (Writer)sw);
        cfg.setConfig(sw.toString());
        this.sysConfigDao.update((Entity)cfg);
    }

    private void updateSystemPresentationConfig() throws Exception {
        List cfgs = this.sysConfigDao.findByClass(SysConfig.SysConfigClass.PRESENTATION.configClassCode());
        if (cfgs == null || cfgs.isEmpty()) {
            throw new Exception("Could not retrieve system mapping config");
        }
        if (cfgs.size() != 1) {
            throw new Exception("Non-unique system mapping config");
        }
        SysConfig cfg = (SysConfig)cfgs.get(0);
        String pc = PresentationConfigXMLHandler.marshal((SystemPresentationConfig)this.systemPresentationConfig);
        cfg.setConfig(pc);
        this.sysConfigDao.update((Entity)cfg);
    }

    @Transactional(readOnly=true)
    public List<SysConfig> getSystemConfigsByClass(SysConfig.SysConfigClass sysConfigClass) {
        return this.sysConfigDao.findByClass(sysConfigClass.configClassCode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(readOnly=true)
    public List<LayerConfig> getLayerConfig() throws Exception {
        ArrayList<LayerConfig> res = new ArrayList<LayerConfig>();
        Object object = this.systemLayerConfigLock;
        synchronized (object) {
            if (this.systemLayerConfig == null) {
                this.retrieveSystemLayerConfig();
            }
            for (LayerConfig lc : this.systemLayerConfig.getLayerConfigs()) {
                res.add(new LayerConfig(lc));
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(readOnly=true)
    public LayerConfig getLayerConfig(UUID layerID) throws Exception {
        LayerConfig lcfg = null;
        Object object = this.systemLayerConfigLock;
        synchronized (object) {
            if (this.systemLayerConfig == null) {
                this.retrieveSystemLayerConfig();
            }
            if ((lcfg = this.systemLayerConfig.getLayerConfig(layerID.toString())) != null) {
                lcfg = new LayerConfig(lcfg);
            }
        }
        return lcfg;
    }

    private void updateLayerConfig(LayerConfig lcfg, boolean create) throws Exception {
        if (this.systemLayerConfig == null) {
            this.retrieveSystemLayerConfig();
        }
        if (!create && this.systemLayerConfig.getLayerConfig(lcfg.getTermId()) == null) {
            throw new Exception("Layer configuration for term " + lcfg.getTermId() + " does not exist");
        }
        if (create && this.systemLayerConfig.getLayerConfig(lcfg.getTermId()) != null) {
            throw new Exception("Layer configuration for term " + lcfg.getTermId() + " already exists");
        }
        this.systemLayerConfig.setLayerConfig(lcfg);
        this.updateSystemLayerConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public void updateLayerConfig(LayerConfig lcfg) throws Exception {
        Object object = this.systemLayerConfigLock;
        synchronized (object) {
            this.updateLayerConfig(lcfg, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public void addLayerConfig(LayerConfig lcfg) throws Exception {
        Object object = this.systemLayerConfigLock;
        synchronized (object) {
            this.updateLayerConfig(lcfg, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public void removeLayerConfig(UUID layerID) throws Exception {
        LayerConfig lcfg = null;
        Object object = this.systemLayerConfigLock;
        synchronized (object) {
            if (this.systemLayerConfig == null) {
                this.retrieveSystemLayerConfig();
            }
            if ((lcfg = this.systemLayerConfig.getLayerConfig(layerID.toString())) == null) {
                throw new Exception("No layer configuration found for layerID " + layerID);
            }
            this.systemLayerConfig.removeLayerConfig(layerID.toString());
            this.updateSystemLayerConfig();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(readOnly=true)
    public List<AttributeMappingConfig> getMappingConfig() throws Exception {
        ArrayList<AttributeMappingConfig> res = new ArrayList<AttributeMappingConfig>();
        Object object = this.systemMappingConfigLock;
        synchronized (object) {
            if (this.systemMappingConfig == null) {
                this.retrieveSystemAttributeMappingConfig();
            }
            for (AttributeMappingConfig mc : this.systemMappingConfig.getMappingConfigs()) {
                res.add(new AttributeMappingConfig(mc));
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(readOnly=true)
    public List<AttributeMappingConfig> getMappingConfigs(String attributeName) throws Exception {
        ArrayList<AttributeMappingConfig> res = null;
        Object object = this.systemMappingConfigLock;
        synchronized (object) {
            List mcfg;
            if (this.systemMappingConfig == null) {
                this.retrieveSystemAttributeMappingConfig();
            }
            if ((mcfg = this.systemMappingConfig.getMappingConfig(attributeName)) != null) {
                res = new ArrayList<AttributeMappingConfig>();
                for (AttributeMappingConfig m : mcfg) {
                    res.add(new AttributeMappingConfig(m));
                }
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(readOnly=true)
    public List<AttributeMappingConfig> getMappingConfigsForLayer(String attributeName, String layerTermId) throws Exception {
        ArrayList<AttributeMappingConfig> res = null;
        Object object = this.systemMappingConfigLock;
        synchronized (object) {
            List mcfg;
            if (this.systemMappingConfig == null) {
                this.retrieveSystemAttributeMappingConfig();
            }
            if ((mcfg = this.systemMappingConfig.getMappingConfigForLayer(attributeName, layerTermId)) != null) {
                res = new ArrayList<AttributeMappingConfig>();
                for (AttributeMappingConfig m : mcfg) {
                    res.add(new AttributeMappingConfig(m));
                }
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(readOnly=true)
    public List<AttributeMappingConfig> getMappingConfigsForLayer(String layerTermId) throws Exception {
        ArrayList<AttributeMappingConfig> res = null;
        Object object = this.systemMappingConfigLock;
        synchronized (object) {
            List mcfg;
            if (this.systemMappingConfig == null) {
                this.retrieveSystemAttributeMappingConfig();
            }
            if ((mcfg = this.systemMappingConfig.getMappingConfigForLayer(layerTermId)) != null) {
                res = new ArrayList<AttributeMappingConfig>();
                for (AttributeMappingConfig m : mcfg) {
                    res.add(new AttributeMappingConfig(m));
                }
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(readOnly=true)
    public List<AttributeMappingConfig> getAttributeMappings(String attributeName, String attributeValue) throws Exception {
        ArrayList<AttributeMappingConfig> res = null;
        Object object = this.systemMappingConfigLock;
        synchronized (object) {
            List mcfg;
            if (this.systemMappingConfig == null) {
                this.retrieveSystemAttributeMappingConfig();
            }
            if ((mcfg = this.systemMappingConfig.getMappingConfig(attributeName, attributeValue)) != null) {
                res = new ArrayList<AttributeMappingConfig>();
                for (AttributeMappingConfig m : mcfg) {
                    res.add(new AttributeMappingConfig(m));
                }
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(readOnly=true)
    public AttributeMappingConfig getAttributeMappingForLayer(String attributeName, String attributeValue, String layerTermId) throws Exception {
        Object object = this.systemMappingConfigLock;
        synchronized (object) {
            AttributeMappingConfig mcfg;
            if (this.systemMappingConfig == null) {
                this.retrieveSystemAttributeMappingConfig();
            }
            if ((mcfg = this.systemMappingConfig.getMappingConfigForLayer(attributeName, attributeValue, layerTermId)) != null) {
                return mcfg;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(readOnly=true)
    public List<AttributeMappingConfig> getAttributeMappingsForTermId(String termId) throws Exception {
        ArrayList<AttributeMappingConfig> res = null;
        Object object = this.systemMappingConfigLock;
        synchronized (object) {
            List mcfg;
            if (this.systemMappingConfig == null) {
                this.retrieveSystemAttributeMappingConfig();
            }
            if ((mcfg = this.systemMappingConfig.getMappingConfigForId(termId)) != null) {
                res = new ArrayList<AttributeMappingConfig>();
                for (AttributeMappingConfig m : mcfg) {
                    res.add(new AttributeMappingConfig(m));
                }
            }
        }
        return res;
    }

    public AttributeLayerIdPair findAttributeByTermId(String termId) throws Exception {
        List<AttributeMappingConfig> mcfgs = this.getAttributeMappingsForTermId(termId);
        String layerId = null;
        Shape.Attribute attr = null;
        for (AttributeMappingConfig mcfg : mcfgs) {
            if (mcfg.getAttributeValue() != null) continue;
            if (!mcfg.isPresentable().booleanValue()) {
                throw new Exception("Not a presentable attribute");
            }
            layerId = mcfg.getLayerTermId();
            attr = new Shape.Attribute(mcfg.getAttributeName(), mcfg.getAttributeType(), mcfg.getTermId(), null);
            break;
        }
        return new AttributeLayerIdPair(attr, layerId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(readOnly=true)
    public AttributeMappingConfig getMappingConfigsForIdAndLayer(String termId, String layerTermId) throws Exception {
        Object object = this.systemMappingConfigLock;
        synchronized (object) {
            AttributeMappingConfig mcfg;
            if (this.systemMappingConfig == null) {
                this.retrieveSystemAttributeMappingConfig();
            }
            if ((mcfg = this.systemMappingConfig.getMappingConfigForIdAndLayer(termId, layerTermId)) != null) {
                return new AttributeMappingConfig(mcfg);
            }
        }
        return null;
    }

    private void updateMappingConfig(AttributeMappingConfig mcfg, boolean create, boolean strict) throws Exception {
        if (this.systemMappingConfig == null) {
            this.retrieveSystemAttributeMappingConfig();
        }
        if (!create && strict && this.systemMappingConfig.getMappingConfig(mcfg.getAttributeName()) == null) {
            throw new Exception("Attribute mapping configuration for term " + mcfg.getAttributeName() + (mcfg.getAttributeValue() != null ? mcfg.getAttributeValue() : "") + " does not exist");
        }
        if (create && this.systemMappingConfig.getMappingConfig(mcfg.getAttributeName()) != null) {
            throw new Exception("Attribute mapping configuration for term " + mcfg.getAttributeName() + (mcfg.getAttributeValue() != null ? mcfg.getAttributeValue() : "") + " already exists");
        }
        this.systemMappingConfig.setMappingConfig(mcfg);
        this.updateSystemMappingConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public void updateMappingConfig(AttributeMappingConfig mcfg) throws Exception {
        Object object = this.systemMappingConfigLock;
        synchronized (object) {
            this.updateMappingConfig(mcfg, false, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public void removeMappingConfigs(String attributeName) throws Exception {
        List mcfg = null;
        Object object = this.systemMappingConfigLock;
        synchronized (object) {
            if (this.systemMappingConfig == null) {
                this.retrieveSystemAttributeMappingConfig();
            }
            if ((mcfg = this.systemMappingConfig.getMappingConfig(attributeName)) == null) {
                throw new Exception("No mapping configuration found for attribute " + attributeName);
            }
            this.systemMappingConfig.removeMappingConfig(attributeName);
            this.updateSystemMappingConfig();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public void removeMappingConfigs(String attributeName, String attributeValue) throws Exception {
        List mcfg = null;
        Object object = this.systemMappingConfigLock;
        synchronized (object) {
            if (this.systemMappingConfig == null) {
                this.retrieveSystemAttributeMappingConfig();
            }
            if ((mcfg = this.systemMappingConfig.getMappingConfig(attributeName, attributeValue)) == null) {
                throw new Exception("No mapping configuration found for attribute " + attributeName + " and value " + attributeValue);
            }
            this.systemMappingConfig.removeMappingConfig(attributeName, attributeValue);
            this.updateSystemMappingConfig();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public void removeMappingConfigForLayer(String attributeName, String attributeValue, String layerTermId) throws Exception {
        AttributeMappingConfig mcfg = null;
        Object object = this.systemMappingConfigLock;
        synchronized (object) {
            if (this.systemMappingConfig == null) {
                this.retrieveSystemAttributeMappingConfig();
            }
            if ((mcfg = this.systemMappingConfig.getMappingConfigForLayer(attributeName, attributeValue, layerTermId)) == null) {
                throw new Exception("No mapping configuration found for layer " + layerTermId + " and attribute " + attributeName + " and value " + attributeValue);
            }
            this.systemMappingConfig.removeMappingConfigForLayer(attributeName, attributeValue, layerTermId);
            this.updateSystemMappingConfig();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public void removeMappingConfigForLayer(String attributeName, String layerTermId) throws Exception {
        List mcfg = null;
        Object object = this.systemMappingConfigLock;
        synchronized (object) {
            if (this.systemMappingConfig == null) {
                this.retrieveSystemAttributeMappingConfig();
            }
            if ((mcfg = this.systemMappingConfig.getMappingConfigForLayer(attributeName, layerTermId)) == null) {
                throw new Exception("No mapping configuration found for layer " + layerTermId + " and attribute " + attributeName);
            }
            this.systemMappingConfig.removeMappingConfigForLayer(attributeName, layerTermId);
            this.updateSystemMappingConfig();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public void removeMappingConfigForLayer(String layerTermId) throws Exception {
        List mcfg = null;
        Object object = this.systemMappingConfigLock;
        synchronized (object) {
            if (this.systemMappingConfig == null) {
                this.retrieveSystemAttributeMappingConfig();
            }
            if ((mcfg = this.systemMappingConfig.getMappingConfigForLayer(layerTermId)) == null) {
                throw new Exception("No mapping configuration found for layer " + layerTermId);
            }
            this.systemMappingConfig.removeMappingConfigForLayer(layerTermId);
            this.updateSystemMappingConfig();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public void addMappingConfig(AttributeMappingConfig mcfg) throws Exception {
        Object object = this.systemMappingConfigLock;
        synchronized (object) {
            if (this.systemMappingConfig == null) {
                this.retrieveSystemAttributeMappingConfig();
            }
            this.updateMappingConfig(mcfg, true, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(readOnly=true)
    public Map<String, String> getLayerStyles() throws Exception {
        HashMap<String, String> styles = new HashMap<String, String>();
        Object object = this.systemPresentationConfigLock;
        synchronized (object) {
            if (this.systemPresentationConfig == null) {
                this.retrieveSystemPresentationConfig();
            }
            List sts = this.systemPresentationConfig.getLayerStyles();
            for (LayerStyle st : sts) {
                styles.put(st.getName(), st.getStyle());
            }
        }
        return styles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(readOnly=true)
    public SystemPresentationConfig getSystemPresentationConfig() throws Exception {
        Object object = this.systemPresentationConfigLock;
        synchronized (object) {
            if (this.systemPresentationConfig == null) {
                this.retrieveSystemPresentationConfig();
            }
            return this.systemPresentationConfig;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(readOnly=true)
    public String getLayerStyle(String name) throws Exception {
        Object object = this.systemPresentationConfigLock;
        synchronized (object) {
            LayerStyle s;
            if (this.systemPresentationConfig == null) {
                this.retrieveSystemPresentationConfig();
            }
            if ((s = this.systemPresentationConfig.getLayerStyle(name)) == null) {
                return null;
            }
            return s.getStyle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(readOnly=true)
    public List<String> listLayerStyles() throws Exception {
        ArrayList<String> names = new ArrayList<String>();
        Object object = this.systemPresentationConfigLock;
        synchronized (object) {
            if (this.systemPresentationConfig == null) {
                this.retrieveSystemPresentationConfig();
            }
            for (LayerStyle s : this.systemPresentationConfig.getLayerStyles()) {
                names.add(s.getName());
            }
        }
        return names;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public void addLayerStyle(String name, String style) throws Exception {
        Object object = this.systemPresentationConfigLock;
        synchronized (object) {
            if (this.systemPresentationConfig == null) {
                this.retrieveSystemPresentationConfig();
            }
            LayerStyle ls = new LayerStyle();
            ls.setName(name);
            ls.setStyle(style);
            this.systemPresentationConfig.addLayerStyle(ls);
            this.updateSystemPresentationConfig();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public void updateLayerStyle(String name, String style) throws Exception {
        Object object = this.systemPresentationConfigLock;
        synchronized (object) {
            if (this.systemPresentationConfig == null) {
                this.retrieveSystemPresentationConfig();
            }
            LayerStyle ls = new LayerStyle();
            ls.setName(name);
            ls.setStyle(style);
            this.systemPresentationConfig.updateLayerStyle(ls);
            this.updateSystemPresentationConfig();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public void removeLayerStyles(List<String> names) throws Exception {
        Object object = this.systemPresentationConfigLock;
        synchronized (object) {
            if (this.systemPresentationConfig == null) {
                this.retrieveSystemPresentationConfig();
            }
            for (String name : names) {
                if (name.equals("line")) continue;
                this.systemPresentationConfig.removeLayerStyle(name);
            }
            this.updateSystemPresentationConfig();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(readOnly=true)
    public List<String> listThemes() throws Exception {
        ArrayList<String> names = new ArrayList<String>();
        Object object = this.systemPresentationConfigLock;
        synchronized (object) {
            if (this.systemPresentationConfig == null) {
                this.retrieveSystemPresentationConfig();
            }
            for (Theme t : this.systemPresentationConfig.getThemes()) {
                names.add(t.getTitle());
            }
        }
        return names;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public void addTheme(Theme theme, String template) throws Exception {
        Object object = this.systemPresentationConfigLock;
        synchronized (object) {
            if (this.systemPresentationConfig == null) {
                this.retrieveSystemPresentationConfig();
            }
            theme.setGeoStyle(null);
            this.systemPresentationConfig.addTheme(theme);
            if (template != null) {
                Theme t = this.systemPresentationConfig.getTheme(template);
                if (t == null) {
                    throw new Exception("Could not find template theme: " + template);
                }
                GeoStyle gs = new GeoStyle();
                ArrayList<TermStyle> tss = new ArrayList<TermStyle>();
                for (TermStyle tts : t.getGeoStyle().getTermStyles()) {
                    TermStyle ts = new TermStyle();
                    ts.setId(tts.getId());
                    ts.setStyle(tts.getStyle());
                    tss.add(ts);
                }
                gs.setTermStyles(tss);
                theme.setGeoStyle(gs);
            }
            this.updateSystemPresentationConfig();
        }
    }

    @Transactional
    public void addTheme(Theme theme) throws Exception {
        this.addTheme(theme, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public void removeThemes(List<String> names) throws Exception {
        Object object = this.systemPresentationConfigLock;
        synchronized (object) {
            if (this.systemPresentationConfig == null) {
                this.retrieveSystemPresentationConfig();
            }
            for (String name : names) {
                if (name.equals("default")) continue;
                this.systemPresentationConfig.removeTheme(name);
            }
            this.updateSystemPresentationConfig();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(readOnly=true)
    public String getDefaultTermStyle(String termId) throws Exception {
        Object object = this.systemPresentationConfigLock;
        synchronized (object) {
            if (this.systemPresentationConfig == null) {
                this.retrieveSystemPresentationConfig();
            }
            return this.systemPresentationConfig.getTermStyle(termId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(readOnly=true)
    public String getTermStyle(String themeName, String termId) throws Exception {
        Object object = this.systemPresentationConfigLock;
        synchronized (object) {
            if (this.systemPresentationConfig == null) {
                this.retrieveSystemPresentationConfig();
            }
            return this.systemPresentationConfig.getTermStyle(themeName, termId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(readOnly=true)
    public List<LayerStyleMessenger> getLayersReferencingStyle(String style) throws Exception {
        ArrayList<LayerStyleMessenger> lsms = new ArrayList<LayerStyleMessenger>();
        Object object = this.systemPresentationConfigLock;
        synchronized (object) {
            if (this.systemLayerConfig == null) {
                this.retrieveSystemPresentationConfig();
            }
            block3: for (LayerConfig cfg : this.getLayerConfig()) {
                for (Theme theme : this.systemPresentationConfig.getThemes()) {
                    String ts;
                    if (theme.getTitle().equals("default") || (ts = this.systemPresentationConfig.getTermStyle(theme.getTitle(), cfg.getTermId())) == null || !ts.equals(style)) continue;
                    LayerStyleMessenger lsm = new LayerStyleMessenger();
                    lsm.setLayerName(cfg.getName());
                    lsm.setMinScale(cfg.getMinScale());
                    lsm.setMaxScale(cfg.getMaxScale());
                    lsm.setTermId(cfg.getTermId());
                    lsm.setTheme(theme.getTitle());
                    lsms.add(lsm);
                    continue block3;
                }
            }
        }
        return lsms;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(readOnly=true)
    public List<LayerStyleMessenger> getLayersReferencingDefaultStyle(String style) throws Exception {
        ArrayList<LayerStyleMessenger> lsms = new ArrayList<LayerStyleMessenger>();
        Object object = this.systemPresentationConfigLock;
        synchronized (object) {
            if (this.systemLayerConfig == null) {
                this.retrieveSystemPresentationConfig();
            }
            for (LayerConfig cfg : this.getLayerConfig()) {
                String ts = this.systemPresentationConfig.getTermStyle(cfg.getTermId());
                if (ts == null || !ts.equals(style)) continue;
                LayerStyleMessenger lsm = new LayerStyleMessenger();
                lsm.setLayerName(cfg.getName());
                lsm.setMinScale(cfg.getMinScale());
                lsm.setMaxScale(cfg.getMaxScale());
                lsm.setTermId(cfg.getTermId());
                lsm.setTheme("default");
                lsms.add(lsm);
            }
        }
        return lsms;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public void addDefaultTermStyle(String termId, String styleRef) throws Exception {
        Object object = this.systemPresentationConfigLock;
        synchronized (object) {
            if (this.systemPresentationConfig == null) {
                this.retrieveSystemPresentationConfig();
            }
            this.systemPresentationConfig.assignTermStyle(termId, styleRef);
            this.updateSystemPresentationConfig();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public void addTermStyle(String themeName, String termId, String styleRef) throws Exception {
        Object object = this.systemPresentationConfigLock;
        synchronized (object) {
            if (this.systemPresentationConfig == null) {
                this.retrieveSystemPresentationConfig();
            }
            this.systemPresentationConfig.assignTermStyle(themeName, termId, styleRef);
            this.updateSystemPresentationConfig();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public void removeDefaultTermStyle(String termId) throws Exception {
        Object object = this.systemPresentationConfigLock;
        synchronized (object) {
            if (this.systemPresentationConfig == null) {
                this.retrieveSystemPresentationConfig();
            }
            this.systemPresentationConfig.removeTermStyle(termId);
            this.updateSystemPresentationConfig();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public void removeTermStyle(String themeName, String termId) throws Exception {
        Object object = this.systemPresentationConfigLock;
        synchronized (object) {
            if (this.systemPresentationConfig == null) {
                this.retrieveSystemPresentationConfig();
            }
            this.systemPresentationConfig.removeTermStyle(themeName, termId);
            this.updateSystemPresentationConfig();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public void removeTermStyles(String termId) throws Exception {
        Object object = this.systemPresentationConfigLock;
        synchronized (object) {
            if (this.systemPresentationConfig == null) {
                this.retrieveSystemPresentationConfig();
            }
            this.systemPresentationConfig.removeTermStyles(termId);
            this.updateSystemPresentationConfig();
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateTermStyle(String theme, String termId, String style) throws Exception {
        if (theme == null || theme.equals("default")) {
            this.addDefaultTermStyle(termId, style);
        } else {
            this.addTermStyle(theme, termId, style);
        }
    }

    public static class AttributeLayerIdPair {
        public Shape.Attribute attr = null;
        public String layerId = null;

        public AttributeLayerIdPair() {
        }

        public AttributeLayerIdPair(Shape.Attribute attr, String layerId) {
            this.attr = attr;
            this.layerId = layerId;
        }
    }

    public static interface SystemStatusListener {
        public void onStatusChange();
    }
}

