/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.gaap.servicelayer;

import gr.cite.clustermanager.exceptions.NoAvailableGos;
import gr.cite.clustermanager.layers.DataCreatorGeoanalytics;
import gr.cite.clustermanager.layers.DataMonitor;
import gr.cite.clustermanager.model.GosDefinition;
import gr.cite.clustermanager.trafficshaping.TrafficShaper;
import gr.cite.gaap.servicelayer.GeospatialBackendClustered;
import gr.cite.geoanalytics.dataaccess.entities.Entity;
import gr.cite.geoanalytics.dataaccess.entities.style.Style;
import gr.cite.geoanalytics.dataaccess.entities.style.dao.StyleDao;
import gr.cite.geoanalytics.util.http.CustomException;
import gr.cite.gos.client.GeoserverManagement;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class StyleManagerCommons {
    public static Logger logger = LoggerFactory.getLogger(StyleManagerCommons.class);
    @Autowired
    private StyleDao styleDao;
    @Autowired
    private GeospatialBackendClustered geospatialBackendClustered;
    @Autowired
    private DataMonitor dataMonitor;
    @Autowired
    private DataCreatorGeoanalytics dataCreatorGeoanalytics;
    @Autowired
    private GeoserverManagement geoserverManagement;
    @Autowired
    private TrafficShaper trafficShaper;

    public boolean addStyle() {
        return true;
    }

    public boolean removeStyle() {
        return true;
    }

    public boolean updateLayerStyle() {
        return true;
    }

    public List<Style> listAllStyles() throws CustomException {
        List styles = this.styleDao.getAll();
        if (styles == null) {
            throw new CustomException(HttpStatus.NOT_FOUND, "Styles not found");
        }
        return styles;
    }

    @Transactional
    public void createStyle(Style style) throws Exception {
        if (style != null) {
            if (this.styleDao.create((Entity)style) == null) {
                throw new Exception("Could not create " + style);
            }
            Set gosDefinitions = this.trafficShaper.getAllGosEndpoints();
            for (GosDefinition gd : gosDefinitions) {
                this.geoserverManagement.addStyle(gd.getGosEndpoint(), style.getName(), style.getContent());
            }
            logger.info("Created " + style + " successfully!");
        }
    }

    @Transactional
    public void deleteStyle(Style style) throws Exception {
        this.styleDao.delete((Entity)style);
        Set gosDefinitions = this.trafficShaper.getAllGosEndpoints();
        for (GosDefinition gd : gosDefinitions) {
            this.geoserverManagement.removeStyle(gd.getGosEndpoint(), style.getName());
        }
    }

    public Style findStyleById(String id) throws Exception {
        Style style = (Style)this.styleDao.read((Serializable)UUID.fromString(id));
        if (style == null) {
            throw new CustomException(HttpStatus.NOT_FOUND, "Style not found");
        }
        return style;
    }

    public Style findStyleById(UUID id) throws Exception {
        Style style = (Style)this.styleDao.read((Serializable)id);
        if (style == null) {
            throw new CustomException(HttpStatus.NOT_FOUND, "Style not found");
        }
        return style;
    }

    @Transactional
    public void checkStyleNotExists(String name) throws Exception {
        Style style = this.styleDao.findStyleByName(name);
        if (style != null) {
            throw new CustomException(HttpStatus.CONFLICT, "Style \"" + name + "\" already exists!");
        }
    }

    @Transactional
    public void editStyle(Style style, String name, String description) throws Exception {
        Set gosDefinitions = this.trafficShaper.getAllGosEndpoints();
        for (GosDefinition gd : gosDefinitions) {
            this.geoserverManagement.removeStyle(gd.getGosEndpoint(), style.getName());
            this.geoserverManagement.addStyle(gd.getGosEndpoint(), name, style.getContent());
        }
        style.setName(name);
        style.setDescription(description);
        this.styleDao.update((Entity)style);
        logger.info(style + " has been edited successfully!");
    }

    public List<String> getAllStyles() throws NoAvailableGos, IOException {
        GosDefinition gosDefinition = this.trafficShaper.getGosForNewLayer();
        return this.geoserverManagement.getAllStyles(gosDefinition.getGosEndpoint());
    }
}

