/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.gaap.servicelayer;

import gr.cite.gaap.datatransferobjects.LayerInfo;
import gr.cite.gaap.datatransferobjects.TaxonomyTermLinkInfo;
import gr.cite.gaap.servicelayer.GeospatialBackendClustered;
import gr.cite.gaap.utilities.ExceptionUtils;
import gr.cite.geoanalytics.dataaccess.entities.Entity;
import gr.cite.geoanalytics.dataaccess.entities.geocode.Geocode;
import gr.cite.geoanalytics.dataaccess.entities.geocode.GeocodeSystem;
import gr.cite.geoanalytics.dataaccess.entities.geocode.TaxonomyTermLink;
import gr.cite.geoanalytics.dataaccess.entities.geocode.TaxonomyTermLinkPK;
import gr.cite.geoanalytics.dataaccess.entities.geocode.dao.GeocodeDao;
import gr.cite.geoanalytics.dataaccess.entities.geocode.dao.GeocodeSystemDao;
import gr.cite.geoanalytics.dataaccess.entities.geocode.dao.TaxonomyTermLinkDao;
import gr.cite.geoanalytics.dataaccess.entities.layer.Layer;
import gr.cite.geoanalytics.dataaccess.entities.layer.dao.LayerDao;
import gr.cite.geoanalytics.dataaccess.entities.principal.Principal;
import gr.cite.geoanalytics.dataaccess.entities.shape.Shape;
import gr.cite.geoanalytics.dataaccess.entities.taxonomy.definition.TaxonomyData;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.inject.Inject;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class GeocodeManager {
    private static final Logger log = LoggerFactory.getLogger(GeocodeManager.class);
    private GeospatialBackendClustered geospatialBackendClustered;
    private GeocodeSystemDao geocodeSystemDao;
    private GeocodeDao geocodeDao;
    private TaxonomyTermLinkDao taxonomyTermLinkDao;
    private LayerDao layerDao;
    private Object taxonomyDataCtxLock = new Object();
    private JAXBContext taxonomyDataCtx = null;

    @Inject
    public void setGeospatialBackendClustered(GeospatialBackendClustered geospatialBackendClustered) {
        this.geospatialBackendClustered = geospatialBackendClustered;
    }

    @Inject
    public void setGeocodeSystemDao(GeocodeSystemDao geocodeSystemDao) {
        this.geocodeSystemDao = geocodeSystemDao;
    }

    @Inject
    public void setLayerDao(LayerDao layerDao) {
        this.layerDao = layerDao;
    }

    @Inject
    public void setGeocodeDao(GeocodeDao geocodeDao) {
        this.geocodeDao = geocodeDao;
    }

    @Inject
    public void setTaxonomyTermLinkDao(TaxonomyTermLinkDao taxonomyTermLinkDao) {
        this.taxonomyTermLinkDao = taxonomyTermLinkDao;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Unmarshaller getTaxonomyDataUnmarshaller() throws JAXBException {
        Object object = this.taxonomyDataCtxLock;
        synchronized (object) {
            if (this.taxonomyDataCtx == null) {
                this.taxonomyDataCtx = JAXBContext.newInstance((Class[])new Class[]{TaxonomyData.class});
            }
            return this.taxonomyDataCtx.createUnmarshaller();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Marshaller getTaxonomyDataMarshaller() throws JAXBException {
        Object object = this.taxonomyDataCtxLock;
        synchronized (object) {
            if (this.taxonomyDataCtx == null) {
                this.taxonomyDataCtx = JAXBContext.newInstance((Class[])new Class[]{TaxonomyData.class});
            }
            Marshaller marshaller = this.taxonomyDataCtx.createMarshaller();
            marshaller.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
            return marshaller;
        }
    }

    public TaxonomyData unmarshalTaxonomyData(String data) {
        return (TaxonomyData)ExceptionUtils.wrap(() -> (TaxonomyData)this.getTaxonomyDataUnmarshaller().unmarshal((Reader)new StringReader(data))).get();
    }

    public String marshalTaxonomyData(TaxonomyData data) {
        return (String)ExceptionUtils.wrap(() -> {
            StringWriter sw = new StringWriter();
            Marshaller marshaller = this.getTaxonomyDataMarshaller();
            marshaller.marshal((Object)data, (Writer)sw);
            return sw.toString().replace("\r\n", "\n").replace("\n", "&#10;");
        }).get();
    }

    private void getGeocodeSystemDetails(GeocodeSystem t) {
        t.getCreator().getPrincipalData().getFullName();
        if (t.getTaxonomyClass() != null) {
            t.getTaxonomyClass().getName();
        }
    }

    private void getGeocodeSystemDetails(List<GeocodeSystem> ts) {
        for (GeocodeSystem t : ts) {
            this.getGeocodeSystemDetails(t);
        }
    }

    public void getLayerDetails(Layer layer) {
        layer.getCreator().getPrincipalData().getFullName();
        layer.getExtraData();
    }

    public void getLayerDetails(List<Layer> layers) {
        for (Layer layer : layers) {
            this.getLayerDetails(layer);
        }
    }

    public void getGeocodeDetails(Geocode term) {
        term.getCreator().getPrincipalData().getFullName();
        term.getGeocodeSystem();
        term.getExtraData();
    }

    public void getGeocodeDetails(List<Geocode> terms) {
        for (Geocode term : terms) {
            this.getGeocodeDetails(term);
        }
    }

    @Transactional(readOnly=true)
    public GeocodeSystem findGeocodeSystemById(String id, boolean loadDetails) {
        GeocodeSystem t = (GeocodeSystem)this.geocodeSystemDao.read((Serializable)UUID.fromString(id));
        if (loadDetails) {
            this.getGeocodeSystemDetails(Collections.singletonList(t));
        }
        return t;
    }

    @Transactional(readOnly=true)
    public GeocodeSystem findGeocodeSystemByName(String name, boolean loadDetails) {
        List res = this.geocodeSystemDao.findByName(name);
        if (res != null && res.size() > 1) {
            throw new IllegalArgumentException("More than one Geocode Systems with name \"" + name + "\" were found");
        }
        if (res == null || res.isEmpty()) {
            return null;
        }
        if (loadDetails) {
            this.getGeocodeSystemDetails(res);
        }
        return (GeocodeSystem)res.get(0);
    }

    @Transactional(readOnly=true)
    public Layer findLayerById(String id) {
        return this.layerDao.getLayerById(UUID.fromString(id));
    }

    @Transactional(readOnly=true)
    public List<Geocode> findAutoCreatedWithParent(String parentTaxonomyName, boolean loadDetails) throws Exception {
        GeocodeSystem t = this.findGeocodeSystemByName(parentTaxonomyName, false);
        if (t == null) {
            throw new Exception("Taxonomy " + parentTaxonomyName + " not found");
        }
        List res = this.geocodeDao.findAutoCreatedWithParent(t);
        if (loadDetails) {
            this.getGeocodeDetails(res);
        }
        return res;
    }

    @Transactional(readOnly=true)
    public List<GeocodeSystem> allGeocodeSystems(boolean loadDetails) throws Exception {
        List res = this.geocodeSystemDao.getAll();
        if (loadDetails) {
            this.getGeocodeSystemDetails(res);
        }
        return res;
    }

    @Transactional(readOnly=true)
    public List<GeocodeSystem> activeGeocodeSystems(boolean loadDetails) throws Exception {
        List res = this.geocodeSystemDao.getActive();
        if (loadDetails) {
            this.getGeocodeSystemDetails(res);
        }
        return res;
    }

    @Transactional(readOnly=true)
    public List<String> listGeocodeSystems(boolean active) throws Exception {
        if (!active) {
            return this.geocodeSystemDao.listNames();
        }
        return this.geocodeSystemDao.listNamesOfActive();
    }

    @Transactional(readOnly=true)
    public List<Geocode> getGeocodesOfGeocodeSystem(String id, boolean active, boolean loadDetails) throws Exception {
        List res = null;
        GeocodeSystem t = (GeocodeSystem)this.geocodeSystemDao.read((Serializable)UUID.fromString(id));
        if (t == null) {
            throw new Exception("Taxonomy " + id + " does not exist");
        }
        res = !active ? this.geocodeSystemDao.getGeocodes(t) : this.geocodeSystemDao.getActiveGeocodes(t);
        if (loadDetails) {
            this.getGeocodeDetails(res);
        }
        return res;
    }

    @Transactional(readOnly=true)
    public List<GeocodeSystem> getClassDescendantsOfGeocodeSystem(String id, boolean active, boolean loadDetails) throws Exception {
        List<GeocodeSystem> res = null;
        GeocodeSystem t = (GeocodeSystem)this.geocodeSystemDao.read((Serializable)UUID.fromString(id));
        if (t == null) {
            throw new Exception("Taxonomy " + id + " does not exist");
        }
        res = this.geocodeSystemDao.getInstances(t);
        if (active) {
            res = this.filterGeocodeSystemByActive(res);
        }
        if (loadDetails) {
            this.getGeocodeSystemDetails(res);
        }
        return res;
    }

    private List<GeocodeSystem> filterGeocodeSystemByActive(List<GeocodeSystem> ts) {
        ArrayList<GeocodeSystem> res = new ArrayList<GeocodeSystem>();
        for (GeocodeSystem t : ts) {
            if (!t.getIsActive()) continue;
            res.add(t);
        }
        return res;
    }

    @Transactional(readOnly=true)
    public List<Geocode> getChildrenOfGeocode(String id, boolean active, boolean loadDetails) {
        List<Geocode> res = null;
        Geocode t = (Geocode)this.geocodeDao.read((Serializable)UUID.fromString(id));
        if (t == null) {
            throw new RuntimeException("Geocode " + id + " does not exist");
        }
        res = this.geocodeDao.getChildren(t);
        if (active) {
            res = this.filterTermByActive(res);
        }
        if (loadDetails) {
            this.getGeocodeDetails(res);
        }
        return res;
    }

    @Transactional(readOnly=true)
    public List<Geocode> getSiblingsOfGeocode(String id, boolean active, boolean loadDetails) throws Exception {
        List<Geocode> res = null;
        Geocode t = (Geocode)this.geocodeDao.read((Serializable)UUID.fromString(id));
        if (t == null) {
            throw new Exception("Geocode " + id + " does not exist");
        }
        res = this.geocodeDao.getSiblings(t);
        if (active) {
            res = this.filterTermByActive(res);
        }
        if (loadDetails) {
            this.getGeocodeDetails(res);
        }
        return res;
    }

    @Transactional(readOnly=true)
    public List<Geocode> getClassDescendantsOfGeocode(String id, boolean active, boolean loadDetails) throws Exception {
        List<Geocode> res = null;
        Geocode t = (Geocode)this.geocodeDao.read((Serializable)UUID.fromString(id));
        if (t == null) {
            throw new Exception("Geocode " + id + " does not exist");
        }
        res = this.geocodeDao.getClassDescendants(t);
        if (active) {
            res = this.filterTermByActive(res);
        }
        if (loadDetails) {
            this.getGeocodeDetails(res);
        }
        return res;
    }

    @Transactional(readOnly=true)
    public List<Geocode> getClassSiblingsOfGeocode(String id, boolean active, boolean loadDetails) throws Exception {
        List<Geocode> res = null;
        Geocode t = (Geocode)this.geocodeDao.read((Serializable)UUID.fromString(id));
        if (t == null) {
            throw new Exception("Geocode " + id + " does not exist");
        }
        res = this.geocodeDao.getClassSiblings(t);
        if (active) {
            res = this.filterTermByActive(res);
        }
        if (loadDetails) {
            this.getGeocodeDetails(res);
        }
        return res;
    }

    @Transactional(readOnly=true)
    public List<String> listTermsOfGeocodeSystem(String id, boolean active) throws Exception {
        GeocodeSystem t = (GeocodeSystem)this.geocodeSystemDao.read((Serializable)UUID.fromString(id));
        if (t == null) {
            throw new Exception("Taxonomy " + id + " does not exist");
        }
        if (active) {
            return this.geocodeSystemDao.listGeocodes(t);
        }
        return this.geocodeSystemDao.listActiveGeocodes(t);
    }

    @Transactional(readOnly=true)
    public List<TaxonomyTermLink> getTermLinksOfGeocodeSystem(String id, boolean active, boolean loadDetails) throws Exception {
        List res = new ArrayList();
        GeocodeSystem t = (GeocodeSystem)this.geocodeSystemDao.read((Serializable)UUID.fromString(id));
        if (t == null) {
            throw new Exception("Taxonomy " + id + " does not exist");
        }
        res = !active ? this.geocodeSystemDao.getTermLinks(t) : this.geocodeSystemDao.getActiveTermLinks(t);
        if (loadDetails) {
            this.getTermLinkDetails(res);
        }
        return res;
    }

    @Transactional(readOnly=true)
    public Shape getShapeOfTerm(Geocode tt, boolean loadDetails) throws Exception {
        Shape s = this.geocodeDao.getShape(tt);
        return s;
    }

    @Transactional(readOnly=true)
    public List<Shape> getShapesOfTerm(Geocode tt, boolean loadDetails) throws Exception {
        List shapes = this.geocodeDao.getShapes(tt);
        return shapes;
    }

    @Transactional(readOnly=true)
    public Shape getShapeOfTerm(Geocode tt) throws Exception {
        return this.getShapeOfTerm(tt, false);
    }

    @Transactional(readOnly=true)
    public List<Shape> getShapesOfTerm(Geocode tt) throws Exception {
        return this.getShapesOfTerm(tt, false);
    }

    @Transactional
    public void updateTaxonomy(GeocodeSystem t, String originalName, boolean create) {
        if (create) {
            GeocodeSystem ex = null;
            ex = t.getId() != null ? this.findGeocodeSystemById(t.getId().toString(), false) : this.findGeocodeSystemByName(t.getName(), false);
            if (ex != null) {
                log.error("Taxonomy " + t.getName() + " already exists");
                throw new IllegalArgumentException("Taxonomy " + t.getName() + " already exists");
            }
            this.geocodeSystemDao.create((Entity)t);
        } else {
            GeocodeSystem ex = null;
            ex = t.getId() != null ? this.findGeocodeSystemById(t.getId().toString(), false) : this.findGeocodeSystemByName(originalName, false);
            if (ex == null) {
                log.error("Taxonomy " + t.getName() + " does not exist");
                throw new IllegalArgumentException("Taxonomy " + t.getName() + " does not exist");
            }
            t.setId(ex.getId());
            t.setCreationDate(ex.getCreationDate());
            this.geocodeSystemDao.update((Entity)t);
        }
    }

    @Transactional
    public void updateTerm(Geocode t, String originalName, String originalTaxonomyName, boolean create) {
        if (create) {
            Geocode ex = null;
            ex = t.getId() != null ? this.findTermById(t.getId().toString(), false) : this.findTermByNameAndTaxonomy(t.getName(), t.getGeocodeSystem().getName(), false);
            if (ex != null) {
                log.error("Geocode " + t.getName() + " already exists");
                throw new IllegalArgumentException("Geocode " + t.getName() + " already exists");
            }
            this.geocodeDao.create((Entity)t);
            if (t.getParent() != null) {
                List siblings = this.geocodeDao.getSiblings(t);
                int max = 0;
                for (Geocode s : siblings) {
                    if (s.getOrder() <= max) continue;
                    max = s.getOrder();
                }
                if (t.getOrder() <= 0 || t.getOrder() > max) {
                    t.setOrder(max + 1);
                } else {
                    for (Geocode s : siblings) {
                        if (s.getOrder() < t.getOrder()) continue;
                        s.setOrder(s.getOrder() + 1);
                        this.geocodeDao.update((Entity)s);
                    }
                }
            } else {
                t.setOrder(0);
            }
            this.geocodeDao.update((Entity)t);
        } else {
            Geocode ex = null;
            ex = t.getId() != null ? this.findTermById(t.getId().toString(), false) : this.findTermByNameAndTaxonomy(originalName, originalTaxonomyName, false);
            if (ex == null) {
                log.error("Geocode" + t.getName() + " does not exist");
                throw new IllegalArgumentException("Geocode " + t.getName() + " does not exist");
            }
            t.setId(ex.getId());
            t.setCreationDate(ex.getCreationDate());
            t.setCreator(ex.getCreator());
            if (t.getOrder() <= 0) {
                t.setOrder(ex.getOrder());
            } else {
                List siblings = this.geocodeDao.getSiblings(t);
                int max = 0;
                for (Geocode s : siblings) {
                    if (s.getOrder() <= max) continue;
                    max = s.getOrder();
                }
                if (t.getOrder() > max) {
                    t.setOrder(max + 1);
                } else {
                    for (Geocode s : siblings) {
                        if (s.getOrder() < t.getOrder()) continue;
                        s.setOrder(s.getOrder() + 1);
                        this.geocodeDao.update((Entity)s);
                    }
                }
            }
            this.geocodeDao.update((Entity)t);
        }
    }

    @Transactional
    public void updateTermLink(String sourceTermTaxonomy, String sourceTerm, String destTermTaxonomy, String destTerm, String origSourceTermTaxonomy, String origSourceTerm, String origDestTermTaxonomy, String origDestTerm, TaxonomyTermLink.Verb verb, Principal creator, boolean create) throws Exception {
        TaxonomyTermLink ex = null;
        if (create) {
            Geocode stt = this.findTermByNameAndTaxonomy(sourceTerm, sourceTermTaxonomy, false);
            Geocode dtt = this.findTermByNameAndTaxonomy(destTerm, destTermTaxonomy, false);
            if (stt == null) {
                throw new Exception("Geocode " + sourceTermTaxonomy + ":" + sourceTerm + " does not exist");
            }
            if (dtt == null) {
                throw new Exception("Geocode " + destTermTaxonomy + ":" + destTerm + " does not exist");
            }
            ex = (TaxonomyTermLink)this.taxonomyTermLinkDao.read((Serializable)new TaxonomyTermLinkPK(stt.getId(), dtt.getId()));
            if (verb == null) {
                throw new Exception("Verb is mandatory for Geocode links");
            }
            if (ex != null) {
                log.error("Geocode link " + sourceTermTaxonomy + ":" + sourceTerm + "->" + destTermTaxonomy + ":" + destTerm + " already exists");
                throw new Exception("Geocode link " + sourceTermTaxonomy + ":" + sourceTerm + "->" + destTermTaxonomy + ":" + destTerm + " already exists");
            }
            TaxonomyTermLink ttl = new TaxonomyTermLink();
            ttl.setSourceTerm(stt);
            ttl.setDestinationTerm(dtt);
            ttl.setVerb(verb);
            ttl.setCreator(creator);
            this.taxonomyTermLinkDao.create((Entity)ttl);
        } else {
            Geocode stt = this.findTermByNameAndTaxonomy(origSourceTerm, origSourceTermTaxonomy, false);
            Geocode dtt = this.findTermByNameAndTaxonomy(origDestTerm, origDestTermTaxonomy, false);
            if (stt == null) {
                throw new Exception("Geocode " + origSourceTermTaxonomy + ":" + origSourceTerm + " does not exist");
            }
            if (dtt == null) {
                throw new Exception("Geocode " + origDestTermTaxonomy + ":" + origDestTerm + " does not exist");
            }
            ex = (TaxonomyTermLink)this.taxonomyTermLinkDao.read((Serializable)new TaxonomyTermLinkPK(stt.getId(), dtt.getId()));
            if (ex == null) {
                log.error("Geocode link " + origSourceTermTaxonomy + ":" + origSourceTerm + "->" + origDestTermTaxonomy + ":" + origDestTerm + " does not exist");
                throw new Exception("Geocode link " + origSourceTermTaxonomy + ":" + origSourceTerm + "->" + origDestTermTaxonomy + ":" + origDestTerm + " does not exist");
            }
            stt = this.findTermByNameAndTaxonomy(sourceTerm, sourceTermTaxonomy, false);
            dtt = this.findTermByNameAndTaxonomy(destTerm, destTermTaxonomy, false);
            if (stt == null) {
                throw new Exception("Geocode " + sourceTermTaxonomy + ":" + sourceTerm + " does not exist");
            }
            if (dtt == null) {
                throw new Exception("Geocode " + destTermTaxonomy + ":" + destTerm + " does not exist");
            }
            if (verb != null) {
                ex.setVerb(verb);
            }
            ex.setSourceTerm(stt);
            ex.setDestinationTerm(dtt);
            this.taxonomyTermLinkDao.update((Entity)ex);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteTaxonomies(List<String> taxonomies) throws Exception {
        for (String t : taxonomies) {
            GeocodeSystem tax = this.findGeocodeSystemByName(t, false);
            if (tax == null) {
                throw new Exception("Taxonomy " + t + " not found");
            }
            List<Geocode> tts = this.getGeocodesOfGeocodeSystem(tax.getId().toString(), false, false);
            for (Geocode tt : tts) {
                List desc = this.geocodeDao.getClassDescendants(tt);
                for (Geocode d : desc) {
                    d.setGeocodeClass(tt.getGeocodeClass());
                    this.geocodeDao.update((Entity)d);
                }
                desc = this.geocodeDao.getChildren(tt);
                for (Geocode d : desc) {
                    d.setParent(tt.getParent());
                    this.geocodeDao.update((Entity)d);
                }
                List linked = this.geocodeDao.getLinked(tt);
                for (Geocode l : linked) {
                    TaxonomyTermLinkPK linkKey = new TaxonomyTermLinkPK(tt.getId(), l.getId());
                    TaxonomyTermLink link = (TaxonomyTermLink)this.taxonomyTermLinkDao.read((Serializable)linkKey);
                    if (link != null) {
                        this.taxonomyTermLinkDao.delete((Entity)link);
                    }
                    if ((link = (TaxonomyTermLink)this.taxonomyTermLinkDao.read((Serializable)(linkKey = new TaxonomyTermLinkPK(l.getId(), tt.getId())))) == null) continue;
                    this.taxonomyTermLinkDao.delete((Entity)link);
                }
                this.geocodeDao.delete((Entity)tt);
            }
            List desc = this.geocodeSystemDao.getInstances(tax);
            for (GeocodeSystem d : desc) {
                d.setTaxonomyClass(tax.getTaxonomyClass());
                this.geocodeSystemDao.update((Entity)d);
            }
            this.geocodeSystemDao.delete((Entity)tax);
        }
    }

    @Transactional
    public void deleteGeocode(Geocode geocode) {
        if (geocode.getOrder() > 1) {
            List siblings = this.geocodeDao.getSiblings(geocode);
            for (Geocode s : siblings) {
                if (s.getOrder() > 0 && s.getOrder() >= geocode.getOrder()) {
                    s.setOrder(s.getOrder() - 1);
                }
                this.geocodeDao.update((Entity)s);
            }
        }
        List desc = this.geocodeDao.getClassDescendants(geocode);
        for (Geocode d : desc) {
            d.setGeocodeClass(geocode.getGeocodeClass());
            this.geocodeDao.update((Entity)d);
        }
        List children = this.geocodeDao.getChildren(geocode);
        for (Geocode child : children) {
            child.setParent(geocode.getParent());
            this.geocodeDao.update((Entity)child);
        }
        this.geocodeDao.delete((Entity)geocode);
    }

    @Transactional
    public void deleteTerms(List<LayerInfo> terms) throws Exception {
        boolean error = false;
        for (LayerInfo t : terms) {
            Geocode tt = this.findTermByNameAndTaxonomy(t.getlayerName(), t.getGeocodeSystem(), false);
            if (tt != null) {
                this.deleteGeocode(tt);
                continue;
            }
            error = true;
        }
        if (error) {
            throw new Exception("Could not delete all Geocodes");
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteTermLinks(List<TaxonomyTermLinkInfo> links) throws Exception {
        for (TaxonomyTermLinkInfo l : links) {
            Geocode st = this.findTermByNameAndTaxonomy(l.getSourceTerm(), l.getSourceTermTaxonomy(), false);
            Geocode dt = this.findTermByNameAndTaxonomy(l.getDestTerm(), l.getDestTermTaxonomy(), false);
            TaxonomyTermLink ttl = (TaxonomyTermLink)this.taxonomyTermLinkDao.read((Serializable)new TaxonomyTermLinkPK(st.getId(), dt.getId()));
            if (ttl == null) {
                log.error("Geocode link " + l.getSourceTermTaxonomy() + ":" + l.getSourceTerm() + "->" + l.getDestTermTaxonomy() + ":" + l.getDestTerm() + " was not found");
                throw new Exception("Geocode link " + l.getSourceTermTaxonomy() + ":" + l.getSourceTerm() + "->" + l.getDestTermTaxonomy() + ":" + l.getDestTerm() + " was not found");
            }
            this.taxonomyTermLinkDao.delete((Entity)ttl);
        }
    }

    @Transactional(readOnly=true)
    public Geocode findTermByNameAndTaxonomy(String name, String taxonomyName, boolean loadDetails) {
        GeocodeSystem t = this.findGeocodeSystemByName(taxonomyName, false);
        if (t == null) {
            throw new IllegalArgumentException("Taxonomy " + taxonomyName + " was not found");
        }
        List res = this.geocodeDao.findByNameAndGeocodeSystem(name, t);
        if (res != null && res.size() > 1) {
            throw new IllegalArgumentException("More than one Geocodes with name \"" + name + "\" were found");
        }
        if (res == null || res.isEmpty()) {
            return null;
        }
        res.forEach(x -> x.getGeocodeSystem().getName());
        if (loadDetails) {
            this.getGeocodeDetails(res);
        }
        return (Geocode)res.get(0);
    }

    @Transactional(readOnly=true)
    public Geocode findTermById(String id, boolean loadDetails) {
        Geocode tt = (Geocode)this.geocodeDao.read((Serializable)UUID.fromString(id));
        if (loadDetails) {
            this.getGeocodeDetails(Collections.singletonList(tt));
        }
        return tt;
    }

    public List<GeocodeSystem> getAllGeocodeSystems() {
        return this.geocodeSystemDao.getAll();
    }

    private List<Geocode> filterTermByActive(List<Geocode> tts) {
        ArrayList<Geocode> res = new ArrayList<Geocode>();
        for (Geocode tt : tts) {
            if (!tt.getIsActive()) continue;
            res.add(tt);
        }
        return res;
    }

    @Transactional(readOnly=true)
    public List<Geocode> getTopmostTermsOfTaxonomy(String id, boolean loadDetails) {
        List res = null;
        GeocodeSystem t = (GeocodeSystem)this.geocodeSystemDao.read((Serializable)UUID.fromString(id));
        if (t == null) {
            throw new IllegalArgumentException("Taxonomy " + id + " does not exist");
        }
        res = this.geocodeSystemDao.getTopmostGeocodes(t);
        if (loadDetails) {
            this.getGeocodeDetails(res);
        }
        return res;
    }

    @Transactional(readOnly=true)
    public List<Geocode> getBottomTermsOfTaxonomy(String id, boolean loadDetails) throws Exception {
        List res = null;
        GeocodeSystem t = (GeocodeSystem)this.geocodeSystemDao.read((Serializable)UUID.fromString(id));
        if (t == null) {
            throw new Exception("Taxonomy " + id + " does not exist");
        }
        res = this.geocodeSystemDao.getBottomGeocodes(t);
        if (loadDetails) {
            this.getGeocodeDetails(res);
        }
        return res;
    }

    @Transactional(readOnly=true)
    public Geocode findTermByName(String name, boolean loadDetails) throws Exception {
        List res = this.geocodeDao.findByName(name);
        if (res != null && res.size() > 1) {
            throw new Exception("More than one Geocodes with name \"" + name + "\" were found");
        }
        if (res == null || res.isEmpty()) {
            return null;
        }
        if (loadDetails) {
            this.getGeocodeDetails(res);
        }
        return (Geocode)res.get(0);
    }

    private void getTermLinkDetails(List<TaxonomyTermLink> ttls) {
        for (TaxonomyTermLink ttl : ttls) {
            this.getGeocodeDetails(ttl.getSourceTerm());
            this.getGeocodeDetails(ttl.getDestinationTerm());
        }
    }

    public void deleteGeocodesOfTemplateLayer(Layer templateLayer) throws Exception {
        log.info("Removing geocodes of template layer with id: " + templateLayer.getId() + " and name: " + templateLayer.getName() + " ...");
        try {
            List geocodes = this.geocodeDao.findByGeocodeSystem(templateLayer.getGeocodeSystem());
            geocodes.forEach(geocode -> this.deleteGeocode((Geocode)geocode));
        }
        catch (Exception e) {
            throw new Exception("Could not remove all Geocodes of Template Layer " + templateLayer.getName(), e);
        }
        log.info("Geocodes of template layer with id: " + templateLayer.getId() + " and name: " + templateLayer.getName() + " have been removed...");
    }

    @Transactional
    public void createGeocodesOfTemplateLayer(Layer layer, List<Shape> shapes, String geocodeMapping) throws Exception {
        shapes.stream().filter(shape -> shape.getExtraData().contains(geocodeMapping)).forEach(shape -> {
            String name = shape.getExtraData();
            int index = name.lastIndexOf("</" + geocodeMapping);
            name = shape.getExtraData().substring(0, index);
            index = name.substring(0, index).lastIndexOf(">");
            name = name.substring(++index, name.length());
            Geocode geocode = new Geocode();
            geocode.setShapeID(shape.getId());
            geocode.setName(name);
            geocode.setExtraData("<extraData><geocode>" + name + "</geocode></extraData");
            geocode.setGeocodeSystem(layer.getGeocodeSystem());
            geocode.setCreator(layer.getCreator());
            this.geocodeDao.create((Entity)geocode);
        });
    }

    @Transactional
    public GeocodeSystem createGeocodeSystem(Principal creator, String name) throws Exception {
        GeocodeSystem geocodeSystem = new GeocodeSystem();
        geocodeSystem.setName(name);
        geocodeSystem.setExtraData("<extraData geographic=\"true\" />");
        geocodeSystem.setCreator(creator);
        this.geocodeSystemDao.create((Entity)geocodeSystem);
        return geocodeSystem;
    }
}

