/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.gaap.servicelayer;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.io.WKTReader;
import com.vividsolutions.jts.io.WKTWriter;
import gr.cite.clustermanager.actuators.layers.DataCreatorGeoanalytics;
import gr.cite.clustermanager.actuators.layers.DataMonitor;
import gr.cite.clustermanager.model.layers.GosDefinition;
import gr.cite.clustermanager.model.layers.ZNodeData;
import gr.cite.clustermanager.trafficshaping.TrafficShaper;
import gr.cite.gaap.datatransferobjects.AttributeInfo;
import gr.cite.gaap.datatransferobjects.Coords;
import gr.cite.gaap.datatransferobjects.GeoLocation;
import gr.cite.gaap.datatransferobjects.GeoSearchSelection;
import gr.cite.gaap.datatransferobjects.NewProjectData;
import gr.cite.gaap.datatransferobjects.ShapeMessenger;
import gr.cite.gaap.datatransferobjects.WfsShapeInfo;
import gr.cite.gaap.servicelayer.ConfigurationManager;
import gr.cite.gaap.servicelayer.DocumentManager;
import gr.cite.gaap.servicelayer.GeocodeManager;
import gr.cite.gaap.servicelayer.GeographyHierarchy;
import gr.cite.gaap.servicelayer.ShapeInfo;
import gr.cite.gaap.utilities.HtmlUtils;
import gr.cite.geoanalytics.common.ShapeAttributeDataType;
import gr.cite.geoanalytics.dataaccess.dao.UUIDGenerator;
import gr.cite.geoanalytics.dataaccess.entities.coverage.Coverage;
import gr.cite.geoanalytics.dataaccess.entities.geocode.Geocode;
import gr.cite.geoanalytics.dataaccess.entities.geocode.GeocodeSystem;
import gr.cite.geoanalytics.dataaccess.entities.geocode.dao.GeocodeDao;
import gr.cite.geoanalytics.dataaccess.entities.layer.Layer;
import gr.cite.geoanalytics.dataaccess.entities.layer.dao.LayerDao;
import gr.cite.geoanalytics.dataaccess.entities.principal.Principal;
import gr.cite.geoanalytics.dataaccess.entities.project.Project;
import gr.cite.geoanalytics.dataaccess.entities.project.dao.ProjectDao;
import gr.cite.geoanalytics.dataaccess.entities.security.principal.dao.PrincipalDao;
import gr.cite.geoanalytics.dataaccess.entities.shape.Shape;
import gr.cite.geoanalytics.dataaccess.entities.shape.dao.ShapeDocumentDao;
import gr.cite.geoanalytics.dataaccess.entities.sysconfig.xml.global.TaxonomyConfig;
import gr.cite.geoanalytics.dataaccess.entities.sysconfig.xml.mapping.AttributeMappingConfig;
import gr.cite.geoanalytics.dataaccess.entities.taxonomy.definition.TaxonomyData;
import gr.cite.geoanalytics.dataaccess.geoserverbridge.elements.Bounds;
import gr.cite.gos.client.RasterManagement;
import gr.cite.gos.client.ShapeManagement;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFinder;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@Service
@Primary
public class GeospatialBackendClustered {
    private static final Logger log = LoggerFactory.getLogger(GeospatialBackendClustered.class);
    protected GeocodeManager geocodeManager;
    protected ConfigurationManager configurationManager;
    private ShapeManagement shapeManagement;
    private RasterManagement rasterManagement;
    private DataMonitor dataMonitor;
    private DataCreatorGeoanalytics dataCreatorGeoanalytics;
    private TrafficShaper trafficShaper;
    private GeocodeDao geocodeDao;
    private LayerDao layerDao;
    private ProjectDao projectDao;
    private static final String NoMappingKey = "\t\t\t__NoVal__\t\t\t";
    private static final String NoValueKey = "";

    @Inject
    public GeospatialBackendClustered(PrincipalDao principalDao, GeocodeManager geocodeManager, DocumentManager documentManager, ConfigurationManager configurationManager) {
        this.geocodeManager = geocodeManager;
        this.configurationManager = configurationManager;
    }

    @Inject
    public void setDataCreatorGeoanalytics(DataCreatorGeoanalytics dataCreatorGeoanalytics) {
        this.dataCreatorGeoanalytics = dataCreatorGeoanalytics;
    }

    @Inject
    public void setDataMonitor(DataMonitor dataMonitor) {
        this.dataMonitor = dataMonitor;
    }

    public DataMonitor getDataMonitor() {
        return this.dataMonitor;
    }

    @Inject
    public void setTrafficShaper(TrafficShaper trafficShaper) {
        this.trafficShaper = trafficShaper;
    }

    @Inject
    public void setShapeDocumentDao(ShapeDocumentDao shapeDocumentDao) {
    }

    @Inject
    public void setGeocodeDao(GeocodeDao geocodeDao) {
        this.geocodeDao = geocodeDao;
    }

    @Inject
    public void setLayerDao(LayerDao layerDao) {
        this.layerDao = layerDao;
    }

    @Inject
    public void setProjectDao(ProjectDao projectDao) {
        this.projectDao = projectDao;
    }

    @Inject
    public void setShapeManagement(ShapeManagement shapeManagement) {
        this.shapeManagement = shapeManagement;
    }

    @Inject
    public void setRasterManagement(RasterManagement rasterManagement) {
        this.rasterManagement = rasterManagement;
    }

    public ShapeManagement getShapeManagement() {
        return this.shapeManagement;
    }

    @Transactional(readOnly=true)
    public Shape findShapeById(String gosEndpoint, UUID id) throws IOException {
        try {
            return this.shapeManagement.getShapeByID(gosEndpoint, id.toString());
        }
        catch (Exception e) {
            return null;
        }
    }

    @Transactional(readOnly=true)
    public ShapeInfo findShapeByIdInfo(String gosEndpoint, UUID shapeID) throws Exception {
        Shape s = this.findShapeById(gosEndpoint, shapeID);
        ShapeInfo si = new ShapeInfo();
        si.setShape(s);
        si.setLayerID(s.getLayerID());
        return si;
    }

    @Transactional(readOnly=true)
    public Shape findShapeById(UUID id) throws IOException {
        Set shapes = this.dataMonitor.getAllGosEndpoints().parallelStream().map(gosEndpoint -> {
            try {
                return this.shapeManagement.getShapeByID(gosEndpoint.getGosEndpoint(), id.toString());
            }
            catch (Exception e) {
                return null;
            }
        }).filter(shape -> shape != null).collect(Collectors.toSet());
        return (Shape)shapes.iterator().next();
    }

    @Transactional(readOnly=true)
    public ShapeInfo findShapeByIdInfo(UUID shapeID) throws Exception {
        Shape s = this.findShapeById(shapeID);
        ShapeInfo si = new ShapeInfo();
        si.setShape(s);
        si.setLayerID(s.getLayerID());
        return si;
    }

    @Transactional
    public void createCoverageOfLayer(GosDefinition gosDefinition, Coverage coverage) throws Exception {
        this.dataCreatorGeoanalytics.addLayer(coverage.getLayerID().toString(), ZNodeData.ZNodeStatus.ACTIVE, gosDefinition.getGosIdentifier());
        this.rasterManagement.createCoverage(gosDefinition.getGosEndpoint(), coverage);
    }

    @Transactional
    public boolean createShapesOfLayer(GosDefinition gosDefinition, Collection<Shape> shapes) throws Exception {
        if (shapes == null || shapes.isEmpty()) {
            return false;
        }
        String layerID = shapes.iterator().next().getLayerID().toString();
        log.info("Performing shape insertion on GOS: " + gosDefinition.getGosEndpoint());
        this.dataCreatorGeoanalytics.addLayer(layerID, ZNodeData.ZNodeStatus.ACTIVE, gosDefinition.getGosIdentifier());
        boolean status = this.shapeManagement.insertShapes(gosDefinition.getGosEndpoint(), new ArrayList<Shape>(shapes));
        return status;
    }

    public String retrieveShapeAttributeValue(Shape s, String attribute) throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document d = db.parse(new ByteArrayInputStream(s.getExtraData().getBytes("UTF-8")));
        NodeList els = d.getElementsByTagName(attribute);
        if (els == null || els.getLength() == 0) {
            return null;
        }
        Element el = (Element)els.item(0);
        return el.getFirstChild().getNodeValue();
    }

    public AttributeInfo retrieveShapeAttribute(Shape s, String attribute) throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document d = db.parse(new ByteArrayInputStream(s.getExtraData().getBytes("UTF-8")));
        NodeList els = d.getElementsByTagName(attribute);
        if (els == null || els.getLength() == 0) {
            return null;
        }
        Element el = (Element)els.item(0);
        AttributeInfo ai = new AttributeInfo();
        ai.setName(attribute);
        ai.setValue(el.getFirstChild().getNodeValue());
        ai.setTaxonomy(el.getAttribute("taxonomy"));
        ai.setType(ShapeAttributeDataType.valueOf((String)el.getAttribute("type").toUpperCase()).toString());
        ai.setPresentable(Boolean.valueOf(el.getAttribute("presentable")).booleanValue());
        return ai;
    }

    @Transactional(readOnly=true)
    public AttributeInfo retrieveShapeAttributeByTaxonomy(Shape s, String taxonomy) throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document d = db.parse(new ByteArrayInputStream(s.getExtraData().getBytes("UTF-8")));
        NodeList els = d.getElementsByTagName("extraData").item(0).getChildNodes();
        for (int i = 0; i < els.getLength(); ++i) {
            Element el = (Element)els.item(i);
            if (!el.getAttribute("taxonomy").equals(taxonomy)) continue;
            AttributeInfo ai = new AttributeInfo();
            ai.setName(el.getNodeName());
            ai.setValue(el.getFirstChild().getNodeValue());
            ai.setTaxonomy(taxonomy);
            ai.setType(ShapeAttributeDataType.valueOf((String)el.getAttribute("type").toUpperCase()).toString());
            ai.setPresentable(Boolean.valueOf(el.getAttribute("presentable")).booleanValue());
            return ai;
        }
        return null;
    }

    @Transactional(readOnly=true)
    private Map<String, AttributeInfo> retrieveRawShapeAttributes(Shape s) throws Exception {
        HashMap<String, AttributeInfo> attributes = new HashMap<String, AttributeInfo>();
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document d = db.parse(new ByteArrayInputStream(s.getExtraData().getBytes("UTF-8")));
        NodeList els = d.getElementsByTagName("extraData").item(0).getChildNodes();
        for (int i = 0; i < els.getLength(); ++i) {
            Element el = (Element)els.item(i);
            String taxon = el.getAttribute("taxonomy");
            if (taxon == null || taxon.trim().isEmpty()) continue;
            AttributeInfo ai = new AttributeInfo();
            ai.setName(el.getNodeName());
            if (el.getFirstChild() != null) {
                ai.setValue(el.getFirstChild().getNodeValue());
            }
            ai.setTaxonomy(taxon);
            ai.setType(ShapeAttributeDataType.valueOf((String)el.getAttribute("type").toUpperCase()).toString());
            ai.setPresentable(Boolean.valueOf(el.getAttribute("presentable")).booleanValue());
            attributes.put(taxon, ai);
        }
        return attributes;
    }

    @Transactional
    public List<String> addShapeAttribute(Shape s, String attrName, String attrValue, GeocodeSystem taxonomy) throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document d = db.parse(new ByteArrayInputStream(s.getExtraData().getBytes("UTF-8")));
        Element root = d.getDocumentElement();
        NodeList els = d.getElementsByTagName(attrName);
        if (els != null && els.getLength() != 0) {
            throw new Exception("Attribute " + attrName + " already exists");
        }
        Element el = d.createElement(attrName);
        el.setAttribute("type", ShapeAttributeDataType.STRING.toString());
        if (taxonomy != null) {
            el.setAttribute("taxonomy", taxonomy.getId().toString());
        }
        el.appendChild(d.createTextNode(attrValue));
        root.appendChild(el);
        s.setExtraData(this.transformDocToString(d));
        List<String> endpoints = this.dataMonitor.getAllGosEndpoints().parallelStream().map(gosDefinition -> {
            try {
                boolean status = this.shapeManagement.updateShape(gosDefinition.getGosEndpoint(), s);
                if (status) {
                    return gosDefinition.getGosEndpoint();
                }
                return null;
            }
            catch (Exception e) {
                log.error("Could not update shape with id: " + s.getId().toString() + " on endpoint: " + gosDefinition.getGosEndpoint());
                return null;
            }
        }).filter(endpoint -> endpoint != null).collect(Collectors.toList());
        return endpoints;
    }

    private String transformDocToString(Document document) throws TransformerException {
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        StringWriter writer = new StringWriter();
        transformer.transform(new DOMSource(document), new StreamResult(writer));
        return writer.getBuffer().toString().replaceAll("\n|\r", NoValueKey);
    }

    @Transactional
    public List<String> setShapeAttributes(Shape s, Map<String, AttributeInfo> attrs) throws Exception {
        StringBuilder xml = new StringBuilder();
        xml.append("<extraData>");
        for (Map.Entry<String, AttributeInfo> attrE : attrs.entrySet()) {
            AttributeInfo attr = attrE.getValue();
            xml.append("<" + attr.getName() + " type=\"" + ShapeAttributeDataType.valueOf((String)attr.getType().toUpperCase()).toString() + "\" taxonomy=\"" + attr.getTaxonomy() + "\" " + (attr.getTerm() != null ? "term=\"" + attr.getTerm() + "\"" : NoValueKey) + ">");
            xml.append(attr.getValue());
            xml.append("</" + attr.getName() + ">");
        }
        xml.append("</extraData>");
        s.setExtraData(xml.toString());
        List<String> endpoints = this.dataMonitor.getAllGosEndpoints().parallelStream().map(gosDefinition -> {
            try {
                boolean status = this.shapeManagement.updateShape(gosDefinition.getGosEndpoint(), s);
                if (status) {
                    return gosDefinition.getGosEndpoint();
                }
                return null;
            }
            catch (Exception e) {
                log.error("Could not update shape with id: " + s.getId().toString() + " on endpoint: " + gosDefinition.getGosEndpoint());
                return null;
            }
        }).filter(endpoint -> endpoint != null).collect(Collectors.toList());
        return endpoints;
    }

    @Transactional
    public List<String> updateShapeAttribute(Shape s, String attrName, String attrValue) throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document d = db.parse(new ByteArrayInputStream(s.getExtraData().getBytes("UTF-8")));
        NodeList els = d.getElementsByTagName(attrName);
        if (els == null || els.getLength() == 0) {
            throw new Exception("Attribute " + attrName + " not found");
        }
        Element el = (Element)els.item(0);
        el.getFirstChild().setNodeValue(attrValue);
        List<String> endpoints = this.dataMonitor.getAllGosEndpoints().parallelStream().map(gosDefinition -> {
            try {
                boolean status = this.shapeManagement.updateShape(gosDefinition.getGosEndpoint(), s);
                if (status) {
                    return gosDefinition.getGosEndpoint();
                }
                return null;
            }
            catch (Exception e) {
                log.error("Could not update shape with id: " + s.getId().toString() + " on endpoint: " + gosDefinition.getGosEndpoint());
                return null;
            }
        }).filter(endpoint -> endpoint != null).collect(Collectors.toList());
        return endpoints;
    }

    @Transactional
    public List<String> removeShapeAttribute(Shape s, String attrName) throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document d = db.parse(new ByteArrayInputStream(s.getExtraData().getBytes("UTF-8")));
        NodeList els = d.getElementsByTagName(attrName);
        if (els == null || els.getLength() == 0) {
            throw new Exception("Attribute " + attrName + " not found");
        }
        Element el = (Element)els.item(0);
        d.removeChild(el);
        List<String> endpoints = this.dataMonitor.getAllGosEndpoints().parallelStream().map(gosDefinition -> {
            try {
                boolean status = this.shapeManagement.updateShape(gosDefinition.getGosEndpoint(), s);
                if (status) {
                    return gosDefinition.getGosEndpoint();
                }
                return null;
            }
            catch (Exception e) {
                log.error("Could not update shape with id: " + s.getId().toString() + " on endpoint: " + gosDefinition.getGosEndpoint());
                return null;
            }
        }).filter(endpoint -> endpoint != null).collect(Collectors.toList());
        return endpoints;
    }

    @Transactional
    public Set<String> getAttributeValuesOfShapesByLayer(UUID layerID, Shape.Attribute attr) throws Exception {
        GosDefinition gosDefinition = this.trafficShaper.getAppropriateGosForLayer(layerID.toString());
        return this.shapeManagement.getAttributeValuesOfShapesByLayer(gosDefinition.getGosEndpoint(), layerID.toString(), attr);
    }

    @Transactional(readOnly=true)
    public Map<String, AttributeInfo> consolidateAttributes(Shape s) throws Exception {
        HashMap<String, AttributeInfo> attrs = new HashMap<String, AttributeInfo>();
        HashSet<TaxonomyConfig> extraTaxonIds = new HashSet<TaxonomyConfig>();
        List<TaxonomyConfig> infoCategories = this.configurationManager.retrieveTaxonomyConfigByClass(TaxonomyConfig.Type.PROJECTINFOCATEGORYTAXONOMY);
        for (TaxonomyConfig infoCfg : infoCategories) {
            extraTaxonIds.addAll(this.configurationManager.retrieveTaxonomyConfigByClass(TaxonomyConfig.Type.valueOf((String)infoCfg.getType())));
        }
        Point centroid = s.getGeography().getCentroid();
        List<Geocode> geoLocation = this.geoLocate(centroid.getX(), centroid.getY());
        String geographyTaxonId = this.configurationManager.retrieveTaxonomyConfig(TaxonomyConfig.Type.GEOGRAPHYTAXONOMY).get(0).getId();
        new HashSet();
        Geocode tt = null;
        Iterator<Geocode> ttIt = geoLocation.iterator();
        ArrayList<String> attrTaxonomies = new ArrayList<String>();
        for (TaxonomyConfig tcfg : extraTaxonIds) {
            attrTaxonomies.add(tcfg.getId());
        }
        boolean foundWidestGeographyTerm = false;
        while (ttIt.hasNext()) {
            tt = ttIt.next();
            if (tt.getGeocodeSystem().getId().toString().equals(geographyTaxonId)) {
                foundWidestGeographyTerm = true;
            }
            if (!foundWidestGeographyTerm) continue;
            attrTaxonomies.add(tt.getGeocodeSystem().getId().toString());
        }
        return attrs;
    }

    @Transactional(readOnly=true)
    public Map<String, AttributeInfo> computeAttributes(Shape s) throws Exception {
        HashMap<String, AttributeInfo> attrs = new HashMap<String, AttributeInfo>();
        Point centroid = s.getGeography().getCentroid();
        AttributeInfo ai = new AttributeInfo();
        ai.setName("location");
        ai.setPresentable(true);
        ai.setTaxonomy(this.configurationManager.retrieveTaxonomyConfig(TaxonomyConfig.Type.LOCATIONTAXONOMY).get(0).getId());
        ai.setType(ShapeAttributeDataType.STRING.toString());
        ai.setValue(centroid.getX() + "," + centroid.getY());
        attrs.put(TaxonomyConfig.Type.LOCATIONTAXONOMY.toString(), ai);
        double area = s.getGeography().getArea();
        ai = new AttributeInfo();
        ai.setName("area");
        ai.setPresentable(true);
        ai.setTaxonomy(this.configurationManager.retrieveTaxonomyConfig(TaxonomyConfig.Type.AREATAXONOMY).get(0).getId());
        ai.setType(ShapeAttributeDataType.DOUBLE.toString());
        ai.setValue(new Double(area).toString());
        attrs.put(TaxonomyConfig.Type.AREATAXONOMY.toString(), ai);
        return attrs;
    }

    /*
     * Could not resolve type clashes
     */
    @Transactional(readOnly=true)
    public Map<String, AttributeInfo> retrieveShapeAttributes(Shape s) throws Exception {
        HashMap<String, AttributeInfo> res = new HashMap<String, AttributeInfo>();
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        if (s.getExtraData() == null || s.getExtraData().trim().isEmpty()) {
            return res;
        }
        Document d = db.parse(new ByteArrayInputStream(s.getExtraData().getBytes("UTF-8")));
        GeographyHierarchy hier = this.getDefaultGeographyHierarchy();
        NodeList els = d.getChildNodes().item(0).getChildNodes();
        for (int i = 0; i < els.getLength(); ++i) {
            String geogTaxonomyName = null;
            Element el = (Element)els.item(i);
            String taxonomyId = el.getAttribute("taxonomy");
            if (taxonomyId == null || taxonomyId.trim().isEmpty()) continue;
            TaxonomyConfig tcfg = this.configurationManager.retrieveTaxonomyConfigById(taxonomyId, true);
            if (tcfg != null && (tcfg.getType().equals(TaxonomyConfig.Type.GEOGRAPHYTAXONOMY.toString()) || tcfg.getType().equals(TaxonomyConfig.Type.ALTGEOGRAPHYTAXONOMY.toString()))) {
                tcfg = null;
            }
            if (tcfg == null) {
                boolean foundGeog = false;
                for (GeocodeSystem geogT : hier.getMainHierarchy()) {
                    if (!geogT.getId().toString().equals(taxonomyId)) continue;
                    foundGeog = true;
                    geogTaxonomyName = geogT.getName();
                    geogT.getId().toString();
                    break;
                }
                if (!foundGeog) {
                    for (List altHier : hier.getAlternativeHierarchies()) {
                        for (GeocodeSystem geogT : altHier) {
                            if (!geogT.getId().toString().equals(taxonomyId)) continue;
                            foundGeog = true;
                            geogTaxonomyName = geogT.getName();
                            geogT.getId().toString();
                            break;
                        }
                        if (!foundGeog) continue;
                        break;
                    }
                }
                if (!foundGeog) continue;
            }
            List<AttributeMappingConfig> taxonMcfgs = this.configurationManager.getAttributeMappings(el.getNodeName(), null);
            List<AttributeMappingConfig> valMcfgs = null;
            if (el.getFirstChild() != null) {
                valMcfgs = this.configurationManager.getAttributeMappings(el.getNodeName(), el.getFirstChild().getNodeValue());
            }
            boolean presentable = true;
            boolean mapValue = false;
            if (taxonMcfgs != null) {
                GeocodeSystem geogT;
                geogT = taxonMcfgs.iterator();
                while (geogT.hasNext()) {
                    AttributeMappingConfig mcfg = geogT.next();
                    if (mcfg.isPresentable().booleanValue()) continue;
                    presentable = false;
                    break;
                }
                if (!presentable) continue;
            }
            String ttStr = null;
            if (valMcfgs != null) {
                for (AttributeMappingConfig mcfg : valMcfgs) {
                    if (mcfg.isMapValue().booleanValue()) {
                        mapValue = true;
                    }
                    if (mcfg.getTermId() == null) continue;
                    ttStr = mcfg.getTermId();
                }
            }
            Geocode tt = null;
            if (ttStr != null && !ttStr.trim().isEmpty()) {
                tt = this.geocodeManager.findTermById(ttStr, false);
            }
            String val = null;
            if (!mapValue) {
                if (el.getFirstChild() != null) {
                    val = el.getFirstChild().getNodeValue();
                }
            } else {
                if (tt == null) {
                    log.error("Could not find mapped taxonomy term: " + el.getAttribute("term") + ". Skipping");
                    continue;
                }
                val = tt.getName();
            }
            AttributeInfo ai = new AttributeInfo();
            ai.setName(el.getNodeName());
            ai.setValue(val);
            ai.setType(tcfg != null ? tcfg.getId() : geogTaxonomyName);
            ai.setTaxonomy(tcfg != null ? tcfg.getId() : geogTaxonomyName);
            res.put(tcfg != null ? tcfg.getId().toString() : geogTaxonomyName, ai);
        }
        return res;
    }

    private void addMappingConfig(AttributeMappingConfig mcfg, Map<String, Map<String, AttributeMappingConfig>> cfgCache) throws Exception {
        if (cfgCache == null) {
            this.configurationManager.updateMappingConfig(mcfg);
            return;
        }
        String key = null;
        if (mcfg.getAttributeName() == null) {
            return;
        }
        key = mcfg.getTermId() == null && mcfg.getAttributeValue() == null ? NoMappingKey : (mcfg.getAttributeValue() == null ? NoValueKey : mcfg.getAttributeValue());
        if (cfgCache.get(mcfg.getAttributeName()) == null) {
            cfgCache.put(mcfg.getAttributeName(), new HashMap());
        }
        if (cfgCache.get(mcfg.getAttributeName()).get(key) == null) {
            cfgCache.get(mcfg.getAttributeName()).put(key, mcfg);
            this.configurationManager.updateMappingConfig(mcfg);
        }
    }

    @Transactional
    public List<String> generateShapeBoundary(UUID layerID, String layerName, Geocode boundaryTerm, Principal principal) throws Exception {
        List<Shape> shapes = this.getShapesOfLayer(layerID);
        GeometryFactory factory = new GeometryFactory(new PrecisionModel(), 4326);
        GeometryCollection geometryCollection = (GeometryCollection)factory.buildGeometry((Collection)shapes.parallelStream().map(shape -> shape.getGeography()).collect(Collectors.toList()));
        Shape boundary = new Shape();
        boundary.setCreatorID(principal.getId());
        boundary.setGeography(geometryCollection.union());
        boundary.setName(layerName + "_boundary");
        Set gosDefinitions = this.dataMonitor.getAvailableGosFor(layerID.toString());
        gosDefinitions.addAll(this.dataMonitor.getNotAvailableGosFor(layerID.toString()));
        List<String> endpoints = gosDefinitions.parallelStream().map(gosDefinition -> {
            try {
                boolean status = this.shapeManagement.insertShape(gosDefinition.getGosEndpoint(), boundary);
                if (status) {
                    return gosDefinition.getGosEndpoint();
                }
                return null;
            }
            catch (Exception e) {
                log.error("Could not insert (boundary) shape with id: " + boundary.getId().toString() + " on endpoint: " + gosDefinition.getGosEndpoint());
                return null;
            }
        }).filter(e -> e != null).collect(Collectors.toList());
        return endpoints;
    }

    @Transactional(readOnly=true)
    public List<Shape> getShapesOfLayer(UUID layerID) throws Exception {
        GosDefinition gosDefinition = this.trafficShaper.getAppropriateGosForLayer(layerID.toString());
        return this.shapeManagement.getShapesOfLayerID(gosDefinition.getGosEndpoint(), layerID.toString());
    }

    @Transactional(readOnly=true)
    @Deprecated
    public List<ShapeInfo> getShapesInfoForLayer(String layerID) throws Exception {
        return this.getShapesInfoForLayer(UUID.fromString(layerID));
    }

    @Transactional(readOnly=true)
    @Deprecated
    public List<ShapeInfo> getShapesInfoForLayer(UUID layerID) throws Exception {
        return this.getShapesOfLayer(layerID).parallelStream().map(shape -> {
            ShapeInfo si = new ShapeInfo();
            si.setShape((Shape)shape);
            si.setLayerID(layerID);
            return si;
        }).collect(Collectors.toList());
    }

    @Transactional
    public List<String> deleteShapesOfLayer(UUID layerID) throws Exception {
        Set gosDefinitions = this.dataMonitor.getAvailableGosFor(layerID.toString());
        gosDefinitions.addAll(this.dataMonitor.getNotAvailableGosFor(layerID.toString()));
        List<String> endpoints = gosDefinitions.parallelStream().map(gosDefinition -> {
            boolean status = this.shapeManagement.deleteShapesOfLayer(gosDefinition.getGosEndpoint(), layerID.toString());
            if (status) {
                return gosDefinition.getGosEndpoint();
            }
            return null;
        }).filter(e -> e != null).collect(Collectors.toList());
        return endpoints;
    }

    @Transactional(readOnly=true)
    @Deprecated
    public UUID findLayerIDOfShape(Shape s) throws Exception {
        return s.getLayerID();
    }

    @Transactional(readOnly=true)
    public List<ShapeInfo> findShapeWithinBounds(String bounds) throws Exception {
        Geometry geom = new WKTReader().read(bounds);
        geom.setSRID(4326);
        Shape sh = new Shape();
        sh.setId(UUIDGenerator.randomUUID());
        sh.setGeography(geom);
        List shapes = this.dataMonitor.getAllGosEndpoints().parallelStream().map(gosDefinition -> {
            try {
                return this.shapeManagement.findContains(gosDefinition.getGosEndpoint(), sh);
            }
            catch (Exception e) {
                return new ArrayList();
            }
        }).filter(list -> !list.isEmpty()).flatMap(l -> l.stream()).collect(Collectors.toList());
        ArrayList<ShapeInfo> res = new ArrayList<ShapeInfo>();
        for (Shape s : shapes) {
            ShapeInfo si = new ShapeInfo();
            si.setShape(s);
            si.setLayerID(s.getId());
            res.add(si);
        }
        return res;
    }

    @Transactional(readOnly=true)
    public boolean existShapesOfLayer(UUID layerID) throws Exception {
        GosDefinition gosDefinition = this.trafficShaper.getAppropriateGosForLayer(layerID.toString());
        if (gosDefinition == null) {
            return false;
        }
        long count = this.shapeManagement.countShapesOfLayer(gosDefinition.getGosEndpoint(), layerID.toString());
        return count != 0L;
    }

    @Transactional(readOnly=true)
    public ShapeInfo getShape(UUID id) throws Exception {
        List shapes = this.dataMonitor.getAllGosEndpoints().parallelStream().map(gosDefinition -> {
            try {
                return this.shapeManagement.getShapeByID(gosDefinition.getGosEndpoint(), id.toString());
            }
            catch (Exception ex) {
                return null;
            }
        }).filter(shape -> shape != null).collect(Collectors.toList());
        if (shapes != null && shapes.isEmpty()) {
            ShapeInfo si = new ShapeInfo();
            si.setShape((Shape)shapes.iterator().next());
            si.setLayerID(((Shape)shapes.iterator().next()).getLayerID());
            return si;
        }
        return null;
    }

    @Transactional(readOnly=true)
    public Bounds getShapeBounds(UUID id) throws Exception {
        Shape s = this.findShapeById(id);
        if (s == null) {
            throw new Exception("Shape " + id + " not found");
        }
        Geometry envelope = s.getGeography().getEnvelope();
        envelope.setSRID(4326);
        return null;
    }

    public Shape generateShapeFromGeometry(Principal principal, String shapeName, String geometry) throws Exception {
        Geometry geom = new WKTReader().read(geometry);
        geom.setSRID(4326);
        Shape s = new Shape();
        s.setGeography(geom);
        s.setName(shapeName);
        s.setCreatorID(principal.getId());
        s.setId(UUID.randomUUID());
        return s;
    }

    @Transactional
    public List<String> createFromGeometry(Principal principal, String shapeName, String geometry) throws Exception {
        Shape s = this.generateShapeFromGeometry(principal, shapeName, geometry);
        List<String> endpoints = this.dataMonitor.getAllGosEndpoints().parallelStream().map(gosDefinition -> {
            try {
                boolean status = this.shapeManagement.insertShape(gosDefinition.getGosEndpoint(), s);
                if (status) {
                    return gosDefinition.getGosEndpoint();
                }
                return null;
            }
            catch (Exception e) {
                log.error("Could not insert shape with id: " + s.getId().toString() + " on endpoint: " + gosDefinition.getGosEndpoint());
                return null;
            }
        }).filter(e -> e != null).collect(Collectors.toList());
        return endpoints;
    }

    @Transactional
    public List<String> createFromGeometry(Project project, String geometry) throws Exception {
        return this.createFromGeometry(project.getCreator(), project.getName(), geometry);
    }

    public Shape generateShapeFromGeometryPolygon(Project project, NewProjectData npd, Principal principal) throws Exception {
        WKTReader reader = new WKTReader();
        String polygon = "POLYGON((" + npd.getCoords().getCoord0()[0] + " " + npd.getCoords().getCoord0()[1] + "," + npd.getCoords().getCoord1()[0] + " " + npd.getCoords().getCoord1()[1] + "," + npd.getCoords().getCoord2()[0] + " " + npd.getCoords().getCoord2()[1] + "," + npd.getCoords().getCoord3()[0] + " " + npd.getCoords().getCoord3()[1] + "," + npd.getCoords().getCoord0()[0] + " " + npd.getCoords().getCoord0()[1] + "))";
        Geometry g = reader.read(polygon);
        g.setSRID(4326);
        Shape s = new Shape();
        s.setGeography(g);
        s.setCreatorID(principal.getId());
        s.setId(UUID.randomUUID());
        return s;
    }

    @Transactional
    public List<String> createFromGeometryPolygon(Project project, NewProjectData npd, Principal principal) throws Exception {
        Shape s = this.generateShapeFromGeometryPolygon(project, npd, principal);
        List<String> endpoints = this.dataMonitor.getAllGosEndpoints().parallelStream().map(gosDefinition -> {
            try {
                boolean status = this.shapeManagement.insertShape(gosDefinition.getGosEndpoint(), s);
                if (status) {
                    return gosDefinition.getGosEndpoint();
                }
                return null;
            }
            catch (Exception e) {
                log.error("Could not insert shape with id: " + s.getId().toString() + " on endpoint: " + gosDefinition.getGosEndpoint());
                return null;
            }
        }).filter(e -> e != null).collect(Collectors.toList());
        return endpoints;
    }

    @Transactional
    public List<String> updateGeometry(UUID id, String geometry) throws Exception {
        ShapeInfo si = this.getShape(id);
        if (si == null) {
            throw new Exception("Shape with id: " + id + " was not found");
        }
        Shape ex = si.getShape();
        Geometry geom = new WKTReader().read(geometry);
        ex.setGeography(geom);
        return this.update(ex);
    }

    @Transactional(readOnly=true)
    public String getGeometry(UUID id) throws Exception {
        ShapeInfo si = this.getShape(id);
        if (si == null) {
            throw new Exception("Shape with id: " + id + " was not found");
        }
        return new WKTWriter().write(si.getShape().getGeography());
    }

    @Transactional(readOnly=true)
    public String getBoundingBoxByProjectNameAndTenant(String projectName, String tenantName) throws Exception {
        List projects = this.projectDao.findByNameAndTenant(projectName, tenantName);
        if (projects != null && projects.size() > 1) {
            throw new Exception("Multiple projects with name " + projectName);
        }
        Project project = null;
        if (projects != null && !projects.isEmpty()) {
            project = (Project)projects.get(0);
        }
        return project.getExtent();
    }

    public String getBoundingBoxByProjectName(String projectName) throws Exception {
        List projects = this.projectDao.findByName(projectName);
        if (projects != null && projects.size() > 1) {
            throw new Exception("Multiple projects with name " + projectName);
        }
        Project project = null;
        if (projects != null && !projects.isEmpty()) {
            project = (Project)projects.get(0);
        }
        return project.getExtent();
    }

    @Transactional
    public List<String> update(Shape s) throws Exception {
        Set gosDefinitions = this.dataMonitor.getAvailableGosFor(s.getLayerID().toString());
        gosDefinitions.addAll(this.dataMonitor.getNotAvailableGosFor(s.getLayerID().toString()));
        List<String> endpoints = this.dataMonitor.getAllGosEndpoints().parallelStream().map(gosDefinition -> {
            try {
                boolean status = this.shapeManagement.updateShape(gosDefinition.getGosEndpoint(), s);
                if (status) {
                    return gosDefinition.getGosEndpoint();
                }
                return null;
            }
            catch (Exception e) {
                log.error("Could not update shape with id: " + s.getId().toString() + " on endpoint: " + gosDefinition.getGosEndpoint());
                return null;
            }
        }).filter(e -> e != null).collect(Collectors.toList());
        return endpoints;
    }

    @Transactional(rollbackFor={Exception.class})
    public List<String> delete(List<String> shapeIDs) throws Exception {
        List<String> endpoints = this.dataMonitor.getAllGosEndpoints().parallelStream().map(gosDefinition -> {
            try {
                boolean status = this.shapeManagement.deleteShapes(gosDefinition.getGosEndpoint(), shapeIDs);
                if (status) {
                    return gosDefinition.getGosEndpoint();
                }
                return null;
            }
            catch (Exception e) {
                log.error("Could not delete shapes with ids: " + shapeIDs.toString() + " on endpoint: " + gosDefinition.getGosEndpoint());
                return null;
            }
        }).filter(e -> e != null).collect(Collectors.toList());
        return endpoints;
    }

    @Transactional(readOnly=true)
    public List<Shape> findShapesEnclosingGeometry(Shape s) throws Exception {
        return this.dataMonitor.getAllGosEndpoints().parallelStream().map(gosDefinition -> {
            try {
                return this.shapeManagement.findWithin(gosDefinition.getGosEndpoint(), s);
            }
            catch (IOException e) {
                return new ArrayList();
            }
        }).filter(list -> !list.isEmpty()).flatMap(l -> l.stream()).collect(Collectors.toList());
    }

    @Transactional(readOnly=true)
    @Deprecated
    public List<Shape> findShapesEnclosingGeometry(Geometry geometry) throws Exception {
        return null;
    }

    private List<List<GeocodeSystem>> getAlternativeHierarchies(List<GeocodeSystem> mainHierarchy, List<List<GeocodeSystem>> currentAlts, int index, List<GeocodeSystem> allTaxonomies, Map<UUID, TaxonomyData> taxonomyData) throws Exception {
        ArrayList<List<GeocodeSystem>> currHierarchies = new ArrayList<List<GeocodeSystem>>(currentAlts);
        currHierarchies.add(mainHierarchy);
        ArrayList<List<GeocodeSystem>> altHierarchies = new ArrayList<List<GeocodeSystem>>();
        GeocodeSystem altTaxonomy = mainHierarchy.get(index);
        TaxonomyData altTaxonomyData = taxonomyData.get(altTaxonomy.getId());
        block0: for (int i = 0; i < altTaxonomyData.getAlternatives().size(); ++i) {
            for (List list : altHierarchies) {
                GeocodeSystem child = null;
                int ind = i;
                List children = allTaxonomies.stream().filter(t -> ((TaxonomyData)taxonomyData.get(t.getId())).getParent().equals(altTaxonomyData.getAlternatives().get(ind))).collect(Collectors.toList());
                if (!children.isEmpty()) {
                    if (children.size() > 1) {
                        throw new Exception("Branched taxonomy hierarchies not supported");
                    }
                    child = (GeocodeSystem)children.get(0);
                }
                if (child == null) continue block0;
                list.add(child);
            }
        }
        List<GeocodeSystem> rest = mainHierarchy.subList(index + 1, mainHierarchy.size());
        for (List list : altHierarchies) {
            list.addAll(rest);
        }
        return altHierarchies;
    }

    @Transactional(readOnly=true)
    public GeographyHierarchy getDefaultGeographyHierarchy() throws Exception {
        return this.getGeographyHierarchy(this.geocodeManager.findGeocodeSystemById(this.configurationManager.retrieveTaxonomyConfig(TaxonomyConfig.Type.GEOGRAPHYTAXONOMY).get(0).getId(), false));
    }

    @Transactional(readOnly=true)
    public GeographyHierarchy getGeographyHierarchy(GeocodeSystem geogTaxonomy) throws Exception {
        GeographyHierarchy hierarchy = new GeographyHierarchy();
        List<GeocodeSystem> allTaxonomies = this.geocodeManager.allGeocodeSystems(false);
        Map<UUID, TaxonomyData> taxonomyData = allTaxonomies.stream().filter(t -> t.getExtraData() != null).collect(Collectors.toMap(GeocodeSystem::getId, t -> this.geocodeManager.unmarshalTaxonomyData(t.getExtraData())));
        GeocodeSystem reloadedGeoTax = allTaxonomies.stream().filter(t -> t.getId().equals(geogTaxonomy.getId())).findFirst().get();
        hierarchy.setMainHierarchy(this.constructMainHierarchy(reloadedGeoTax, allTaxonomies, taxonomyData));
        hierarchy.setAlternativeHierarchies(this.constructAlternativeHierarchies(hierarchy, allTaxonomies, taxonomyData));
        return hierarchy;
    }

    private List<List<GeocodeSystem>> constructAlternativeHierarchies(GeographyHierarchy hierarchy, List<GeocodeSystem> allTaxonomies, Map<UUID, TaxonomyData> taxonomyData) throws Exception {
        ArrayList<Integer> altIndexes = new ArrayList<Integer>();
        int i = 0;
        for (GeocodeSystem currTaxonomy : hierarchy.getMainHierarchy()) {
            if (!taxonomyData.get(currTaxonomy.getId()).getAlternatives().isEmpty()) {
                altIndexes.add(i);
            }
            ++i;
        }
        ArrayList<List<GeocodeSystem>> altHierarchies = new ArrayList<List<GeocodeSystem>>();
        for (Integer index : altIndexes) {
            altHierarchies.addAll(this.getAlternativeHierarchies(hierarchy.getMainHierarchy(), altHierarchies, index, allTaxonomies, taxonomyData));
        }
        return altHierarchies;
    }

    private List<GeocodeSystem> constructMainHierarchy(GeocodeSystem geogTaxonomy, List<GeocodeSystem> allTaxonomies, Map<UUID, TaxonomyData> taxonomyData) throws Exception {
        TaxonomyData taxData;
        if (geogTaxonomy == null) {
            throw new IllegalArgumentException("Geography taxonomy cannot be null");
        }
        LinkedList<GeocodeSystem> hier = new LinkedList<GeocodeSystem>();
        hier.add(geogTaxonomy);
        GeocodeSystem currTaxonomy = geogTaxonomy;
        while (currTaxonomy != null && (taxData = taxonomyData.get(currTaxonomy.getId())) != null && taxData.getParent() != null) {
            GeocodeSystem parent = this.geocodeManager.findGeocodeSystemById(taxData.getParent().toString(), false);
            if (taxData.getParent() != null) {
                hier.push(parent);
            }
            currTaxonomy = parent;
        }
        currTaxonomy = (GeocodeSystem)hier.peekLast();
        while (true) {
            GeocodeSystem ct = currTaxonomy;
            GeocodeSystem child = null;
            List children = allTaxonomies.stream().filter(t -> {
                TaxonomyData td = (TaxonomyData)taxonomyData.get(t.getId());
                return td != null && td.getParent() != null && td.getParent().equals(ct.getId());
            }).collect(Collectors.toList());
            if (!children.isEmpty()) {
                if (children.size() > 1) {
                    throw new Exception("Branched taxonomy hierarchies not supported");
                }
                child = (GeocodeSystem)children.get(0);
            }
            if (child == null) break;
            hier.add(child);
            currTaxonomy = child;
        }
        return hier;
    }

    @Transactional(readOnly=true)
    public List<Geocode> geoLocate(double x, double y) throws Exception {
        boolean located;
        List<Geocode> terms;
        ArrayList<Geocode> res = new ArrayList<Geocode>();
        GeometryFactory gf = new GeometryFactory(new PrecisionModel(), 4326);
        Point point = gf.createPoint(new Coordinate(x, y));
        Shape pointShape = new Shape();
        pointShape.setGeography((Geometry)point);
        TaxonomyConfig tcfg = null;
        List<TaxonomyConfig> tcfgs = this.configurationManager.retrieveTaxonomyConfig(TaxonomyConfig.Type.GEOGRAPHYTAXONOMY);
        if (tcfgs != null) {
            tcfg = this.configurationManager.retrieveTaxonomyConfig(TaxonomyConfig.Type.GEOGRAPHYTAXONOMY).get(0);
        }
        if ((terms = this.geocodeManager.getTopmostTermsOfTaxonomy(tcfg.getId(), false)) == null || terms.isEmpty()) {
            return res;
        }
        block0: do {
            located = false;
            for (Geocode geocode : terms) {
                List<Shape> termShapes = this.geocodeManager.getShapesOfTerm(geocode);
                if (termShapes == null || termShapes.isEmpty()) {
                    log.error("Could not find shapes of taxonomy term " + geocode.getId());
                    throw new Exception("Could not find shapes of taxonomy term " + geocode.getId());
                }
                for (Shape termShape : termShapes) {
                    if (!pointShape.getGeography().within(termShape.getGeography())) continue;
                    if (geocode.getParent() != null) {
                        geocode.getParent().getName();
                    }
                    if (geocode.getGeocodeClass() != null) {
                        geocode.getGeocodeClass().getName();
                    }
                    geocode.getGeocodeSystem().getName();
                    geocode.getCreator().getName();
                    res.add(geocode);
                    terms = this.geocodeManager.getChildrenOfGeocode(geocode.getId().toString(), true, false);
                    located = true;
                    break;
                }
                if (!located) continue;
                continue block0;
            }
        } while (terms != null && !terms.isEmpty() && located);
        return res;
    }

    @Transactional(readOnly=true)
    public List<GeoLocation> termLocate(GeoSearchSelection.SearchType searchType, String term, Principal principal) throws Exception {
        ArrayList<GeoLocation> res = new ArrayList<GeoLocation>();
        List<Shape> shapes = this.dataMonitor.getAllGosEndpoints().parallelStream().map(gosDefinition -> {
            try {
                return this.shapeManagement.searchShapes(gosDefinition.getGosEndpoint(), Collections.singletonList(term));
            }
            catch (IOException e) {
                return new ArrayList();
            }
        }).filter(list -> !list.isEmpty()).flatMap(l -> l.stream()).collect(Collectors.toList());
        HashMap<String, Project> projectShapeMappings = new HashMap<String, Project>();
        shapes = this.filterBySearchType(searchType, shapes, principal, projectShapeMappings);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.newDocumentBuilder();
        for (Shape s : shapes) {
            Point centroid;
            List<Geocode> terms;
            boolean nonGeographic = false;
            if (!nonGeographic || (terms = this.geoLocate((centroid = s.getGeography().getCentroid()).getX(), centroid.getY())) == null || terms.isEmpty()) continue;
            ArrayList tags = new ArrayList();
            Geometry b = s.getGeography().getEnvelope();
            Bounds bounds = new Bounds(b.getCoordinates()[0].x, b.getCoordinates()[0].y, b.getCoordinates()[2].x, b.getCoordinates()[2].y, null);
            if (searchType == GeoSearchSelection.SearchType.MAP) {
                res.add(new GeoLocation(tags, centroid.getX(), centroid.getY(), bounds));
                continue;
            }
            if (searchType != GeoSearchSelection.SearchType.PROJECTS) continue;
            Project shapeProject = (Project)projectShapeMappings.get(s.getId().toString());
            res.add(new GeoLocation(tags, centroid.getX(), centroid.getY(), bounds, shapeProject.getName(), shapeProject.getId().toString()));
        }
        return res;
    }

    @Transactional
    @Deprecated
    public List<String> getBreadcrumbs(Coords coords) throws Exception {
        GeometryFactory geometryFactory = new GeometryFactory(new PrecisionModel(), 4326);
        Point point = geometryFactory.createPoint(new Coordinate(coords.getLon(), coords.getLat()));
        List<Shape> shapes = this.findShapesEnclosingGeometry((Geometry)point);
        List geocodes = this.geocodeDao.getGeocodesByShapes(shapes);
        geocodes.sort(Comparator.comparing(Geocode::getName));
        List<String> geocodesStr = geocodes.stream().map(g -> g.getName()).collect(Collectors.toList());
        return geocodesStr;
    }

    private List<Shape> filterBySearchType(GeoSearchSelection.SearchType searchType, List<Shape> shapes, Principal principal, Map<String, Project> projectShapeMappings) throws Exception {
        ArrayList<Shape> filtered = new ArrayList<Shape>();
        List projects = this.projectDao.findByCreator(principal);
        ArrayList<Shape> projectShapes = new ArrayList<Shape>();
        HashSet<UUID> filteredIds = new HashSet<UUID>();
        for (Shape s : shapes) {
            for (Project p : projects) {
                if (s.getId().equals(p.getShape())) {
                    if (p.getStatus() == Project.ProjectStatus.DELETED) continue;
                    projectShapeMappings.put(s.getId().toString(), p);
                    projectShapes.add(s);
                    continue;
                }
                if (filteredIds.contains(s.getId())) continue;
                filtered.add(s);
                filteredIds.add(s.getId());
            }
        }
        if (searchType == GeoSearchSelection.SearchType.PROJECTS) {
            return projectShapes;
        }
        return filtered;
    }

    private Map<String, Map<String, Shape.Attribute>> partitionAttributes(Map<String, String> attributes, GeographyHierarchy geographyHierarchy) throws Exception {
        HashSet<String> geographicNames = new HashSet<String>();
        ArrayList<List<GeocodeSystem>> hier = new ArrayList<List<GeocodeSystem>>(geographyHierarchy.getAlternativeHierarchies());
        hier.add(geographyHierarchy.getMainHierarchy());
        for (List list : hier) {
            for (GeocodeSystem t : list) {
                geographicNames.add(t.getName());
            }
        }
        hier.add(geographyHierarchy.getMainHierarchy());
        HashMap<String, String> toProcess = new HashMap<String, String>(attributes);
        HashMap<String, Map<String, Shape.Attribute>> hashMap = new HashMap<String, Map<String, Shape.Attribute>>();
        while (!toProcess.isEmpty()) {
            HashSet<Object> toDelete = new HashSet<Object>();
            for (Map.Entry entry : toProcess.entrySet()) {
                if (geographicNames.contains(entry.getKey())) {
                    toDelete.add(entry.getKey());
                    continue;
                }
                GeocodeSystem t = this.geocodeManager.findGeocodeSystemByName((String)entry.getKey(), false);
                if (t == null) {
                    toDelete.add(entry.getKey());
                    continue;
                }
                TaxonomyConfig tcfg = this.configurationManager.retrieveTaxonomyConfigById(t.getId().toString());
                if (tcfg == null) {
                    toDelete.add(entry.getKey());
                    continue;
                }
                List<AttributeMappingConfig> mcfgs = this.configurationManager.getAttributeMappingsForTermId(t.getId().toString());
                String layer = null;
                for (AttributeMappingConfig mcfg : mcfgs) {
                    if (mcfg.getAttributeValue() != null) continue;
                    layer = mcfg.getLayerTermId();
                    break;
                }
                if (layer == null) {
                    toDelete.add(entry.getKey());
                    continue;
                }
                HashMap<String, Shape.Attribute> layerAttrs = new HashMap<String, Shape.Attribute>();
                mcfgs = this.configurationManager.getMappingConfigsForLayer(layer);
                for (AttributeMappingConfig mcfg : mcfgs) {
                    GeocodeSystem mT;
                    if (mcfg.getTermId() == null || mcfg.getAttributeValue() != null || (mT = this.geocodeManager.findGeocodeSystemById(mcfg.getTermId(), false)) == null || !mT.getName().equals(entry.getKey())) continue;
                    toDelete.add(mT.getName());
                    if (geographicNames.contains(mT.getName()) || layerAttrs.containsKey(mcfg.getAttributeName())) continue;
                    layerAttrs.put(mcfg.getAttributeName(), new Shape.Attribute(mcfg.getAttributeName(), mcfg.getAttributeType(), mcfg.getTermId(), (String)entry.getValue()));
                }
                if (layerAttrs.isEmpty()) continue;
                if (!hashMap.containsKey(layer)) {
                    hashMap.put(layer, new HashMap());
                }
                ((Map)hashMap.get(layer)).putAll(layerAttrs);
            }
            for (String string : toDelete) {
                toProcess.remove(string);
            }
        }
        return hashMap;
    }

    @Transactional(readOnly=true)
    public List<GeoLocation> attributeLocate(GeoSearchSelection.SearchType searchType, Map<String, String> attributes, Principal principal) throws Exception {
        GeographyHierarchy hier = this.getDefaultGeographyHierarchy();
        String mostSpecificGeogTerm = null;
        Iterator<GeocodeSystem> hierIt = hier.getMainHierarchy().iterator();
        int i = 0;
        int tIndex = -1;
        while (hierIt.hasNext()) {
            GeocodeSystem t = hierIt.next();
            if (attributes.containsKey(t.getName())) {
                mostSpecificGeogTerm = attributes.get(t.getName());
                attributes.remove(t.getName());
                tIndex = i;
            }
            ++i;
        }
        int maxIndex = tIndex;
        for (List<GeocodeSystem> alt : hier.getAlternativeHierarchies()) {
            Iterator<GeocodeSystem> altIt = alt.iterator();
            i = 0;
            int altIndex = 0;
            while (altIt.hasNext()) {
                GeocodeSystem t = altIt.next();
                if (attributes.containsKey(t.getName())) {
                    altIndex = i;
                    if (altIndex > maxIndex) {
                        maxIndex = altIndex;
                        mostSpecificGeogTerm = attributes.get(t.getName());
                        altIndex = i;
                    }
                    attributes.remove(t.getName());
                }
                ++i;
            }
        }
        Geocode tt = this.geocodeManager.findTermByName(mostSpecificGeogTerm, false);
        Shape shapeTerm = this.geocodeManager.getShapeOfTerm(tt);
        HashMap<String, Project> projectShapeMappings = new HashMap<String, Project>();
        List<Object> foundShapes = new ArrayList();
        Map<String, Map<String, Shape.Attribute>> partition = this.partitionAttributes(attributes, hier);
        if (!partition.isEmpty()) {
            Map.Entry<String, Map<String, Shape.Attribute>> first = partition.entrySet().iterator().next();
            foundShapes = this.dataMonitor.getAllGosEndpoints().parallelStream().map(gosDefinition -> {
                try {
                    return this.shapeManagement.searchShapesWithinByAttributes(gosDefinition.getGosEndpoint(), (Map)first.getValue(), shapeTerm);
                }
                catch (IOException e) {
                    return new ArrayList();
                }
            }).filter(list -> !list.isEmpty()).flatMap(l -> l.stream()).collect(Collectors.toList());
            foundShapes = this.filterBySearchType(searchType, foundShapes, principal, projectShapeMappings);
            partition.remove(first.getKey());
        } else {
            foundShapes = this.dataMonitor.getAllGosEndpoints().parallelStream().map(gosDefinition -> {
                try {
                    return this.shapeManagement.searchShapesWithinByAttributes(gosDefinition.getGosEndpoint(), new HashMap(), shapeTerm);
                }
                catch (IOException e) {
                    return new ArrayList();
                }
            }).filter(list -> !list.isEmpty()).flatMap(l -> l.stream()).collect(Collectors.toList());
            foundShapes = this.filterBySearchType(searchType, foundShapes, principal, projectShapeMappings);
        }
        for (Map.Entry entry : partition.entrySet()) {
            List list2 = this.dataMonitor.getAllGosEndpoints().parallelStream().map(gosDefinition -> {
                try {
                    return this.shapeManagement.searchShapesWithinByAttributes(gosDefinition.getGosEndpoint(), (Map)layerAttrs.getValue(), shapeTerm);
                }
                catch (IOException e) {
                    return new ArrayList();
                }
            }).filter(list -> !list.isEmpty()).flatMap(l -> l.stream()).collect(Collectors.toList());
            HashMap<String, Shape> toAdd = new HashMap<String, Shape>();
            for (Shape rs : list2) {
                for (Shape shape : foundShapes) {
                    if (shape.getGeography().within(rs.getGeography())) {
                        if (toAdd.containsKey(shape.getId().toString())) continue;
                        toAdd.put(shape.getId().toString(), shape);
                        continue;
                    }
                    if (!rs.getGeography().within(shape.getGeography()) || toAdd.containsKey(rs.getId().toString())) continue;
                    toAdd.put(rs.getId().toString(), rs);
                }
            }
            foundShapes = new ArrayList(toAdd.values());
            foundShapes = this.filterBySearchType(searchType, foundShapes, principal, projectShapeMappings);
        }
        ArrayList<GeoLocation> res = new ArrayList<GeoLocation>();
        for (Shape shape : foundShapes) {
            Point centroid = shape.getGeography().getCentroid();
            List<Geocode> terms = this.geoLocate(centroid.getX(), centroid.getY());
            if (terms == null || terms.isEmpty()) continue;
            ArrayList tags = new ArrayList();
            Geometry b = shape.getGeography().getEnvelope();
            Bounds bounds = new Bounds(b.getCoordinates()[0].x, b.getCoordinates()[0].y, b.getCoordinates()[2].x, b.getCoordinates()[2].y, null);
            if (searchType == GeoSearchSelection.SearchType.MAP) {
                res.add(new GeoLocation(tags, centroid.getX(), centroid.getY(), bounds));
                continue;
            }
            if (searchType != GeoSearchSelection.SearchType.PROJECTS) continue;
            Project shapeProject = (Project)projectShapeMappings.get(shape.getId().toString());
            res.add(new GeoLocation(tags, centroid.getX(), centroid.getY(), bounds, shapeProject.getName(), shapeProject.getId().toString()));
        }
        return res;
    }

    public List<Shape> getShapesOfLayerID(UUID layerID) throws Exception {
        return this.getShapesOfLayer(layerID);
    }

    public List<ShapeMessenger> getShapeMessengerForLayer(UUID layerID) throws Exception {
        List<Shape> shapes = this.getShapesOfLayer(layerID);
        if (shapes == null) {
            return null;
        }
        ArrayList<ShapeMessenger> res = new ArrayList<ShapeMessenger>();
        for (Shape s : shapes) {
            ShapeMessenger sm = new ShapeMessenger();
            sm.setId(s.getId().toString());
            sm.setCode(s.getCode());
            sm.setExtraData(s.getExtraData());
            sm.setGeometry(s.getGeography().toText());
            sm.setName(s.getName());
            sm.setShapeClass(s.getShapeClass());
            Layer layer = this.layerDao.getLayerById(layerID);
            if (layer != null) {
                sm.setLayerId(layer.getId().toString());
                if (layer.getGeocodeSystem() != null) {
                    sm.setLayerGeocodeSystem(layer.getGeocodeSystem().getName());
                }
            }
            res.add(sm);
        }
        return res;
    }

    public List<ShapeInfo> getShapeInfoForLayer(UUID layerID) throws Exception {
        List<Shape> shapes = this.getShapesOfLayer(layerID);
        if (shapes == null) {
            return null;
        }
        ArrayList<ShapeInfo> res = new ArrayList<ShapeInfo>();
        for (Shape s : shapes) {
            ShapeInfo si = new ShapeInfo();
            si.setShape(s);
            si.setLayerID(layerID);
            res.add(si);
        }
        return res;
    }

    @Deprecated
    public Map<String, Shape> getShapesOfLayer(Layer layer) throws Exception {
        List geocodes = this.geocodeDao.findByGeocodeSystem(layer.getGeocodeSystem());
        HashMap<String, Shape> shapes = new HashMap<String, Shape>();
        for (Geocode geocode : geocodes) {
            shapes.put(geocode.getName(), this.findShapeById(geocode.getShapeID()));
        }
        return shapes;
    }

    @Transactional
    public WfsShapeInfo getShapesFromShapefile(String pathName, String termId, int srid, String charset, boolean forceLonLat, Map<String, Map<String, AttributeInfo>> attrInfo, Principal principal, boolean forceOverwriteMappings) throws Exception {
        if (srid < 0 && srid != -1) {
            throw new IllegalArgumentException("Illegal srid code");
        }
        if (principal == null) {
            throw new IllegalArgumentException("Creator not provided");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        File file = new File(pathName);
        map.put("url", file.toURI().toString());
        map.put("charset", charset);
        SimpleFeatureSource featureSource = null;
        DataStore dataStore = null;
        try {
            dataStore = DataStoreFinder.getDataStore(map);
            featureSource = dataStore.getFeatureSource(dataStore.getTypeNames()[0]);
        }
        catch (IOException e) {
            log.error("Error while reading shape file", (Throwable)e);
            throw e;
        }
        return this.fromFeatureSource(dataStore, featureSource, termId, srid, forceLonLat, attrInfo, principal, forceOverwriteMappings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    private WfsShapeInfo fromFeatureSource(DataStore dataStore, SimpleFeatureSource featureSource, String termId, int srid, boolean forceLonLat, Map<String, Map<String, AttributeInfo>> attrInfo, Principal principal, boolean forceOverwriteMappings) throws Exception {
        HashMap<String, GeocodeSystem> taxonomyCache = new HashMap<String, GeocodeSystem>();
        SimpleFeatureCollection collection = featureSource.getFeatures();
        SimpleFeatureType schema = (SimpleFeatureType)featureSource.getSchema();
        SimpleFeatureIterator iterator = collection.features();
        WfsShapeInfo wfsShapeInfo = new WfsShapeInfo();
        ArrayList<Shape> listShape = new ArrayList<Shape>();
        String sourceCode = null;
        if (srid != -1) {
            sourceCode = "EPSG:" + new Integer(srid).toString();
        }
        String targetCode = "EPSG:4326";
        CoordinateReferenceSystem sourceCRS = null;
        if (schema.getCoordinateReferenceSystem() != null) {
            sourceCRS = schema.getCoordinateReferenceSystem();
        } else if (sourceCode != null) {
            sourceCRS = CRS.decode(sourceCode);
        }
        if (sourceCRS == null) {
            throw new Exception("No coordinate system provided nor found in shape file definition");
        }
        CoordinateReferenceSystem targetCRS = CRS.decode((String)targetCode, (boolean)forceLonLat);
        UUID importUUID = UUIDGenerator.randomUUID();
        boolean lenient = false;
        String wkt = sourceCRS.toWKT();
        if (!wkt.toLowerCase().contains("towgs")) {
            if (CRS.lookupEpsgCode((CoordinateReferenceSystem)sourceCRS, (boolean)true) == 2100) {
                double[] bursaWolf = new double[]{-199.87, 74.79, 246.62, 0.0, 0.0, 0.0, 0.0};
                log.warn("No transformation parameters were found within source CRS data.Automatically applying: " + Arrays.toString(bursaWolf));
                wkt = this.insertBursaWolfToWKT(wkt, bursaWolf);
                sourceCRS = CRS.parseWKT((String)wkt);
            } else {
                log.warn("No transformation parameters were found within source CRS data. Transformation may contain errors");
                lenient = true;
            }
        }
        MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)targetCRS, (boolean)lenient);
        ReferencedEnvelope b = featureSource.getBounds();
        b = JTS.transform((Envelope)b, (MathTransform)transform);
        Bounds bounds = new Bounds();
        bounds.setCrs("EPSG:4326");
        bounds.setMinx(b.getMinX());
        bounds.setMiny(b.getMinY());
        bounds.setMaxx(b.getMaxX());
        bounds.setMaxy(b.getMaxY());
        wfsShapeInfo.setBounds(bounds);
        Geometry g = null;
        try {
            HashMap<String, Map<String, AttributeMappingConfig>> cfgCache = new HashMap<String, Map<String, AttributeMappingConfig>>();
            int cnt = 0;
            while (iterator.hasNext()) {
                SimpleFeature feature = (SimpleFeature)iterator.next();
                g = (Geometry)feature.getDefaultGeometry();
                g = JTS.transform((Geometry)g, (MathTransform)transform);
                g.setSRID(4326);
                String data = this.createDataXML(feature, attrInfo, taxonomyCache, termId, cfgCache, forceOverwriteMappings);
                Shape shape = new Shape();
                shape.setCreationDate(Calendar.getInstance().getTime());
                shape.setCreatorID(principal.getId());
                shape.setExtraData(data);
                shape.setId(UUIDGenerator.randomUUID());
                shape.setLastUpdate(Calendar.getInstance().getTime());
                shape.setLayerID(UUID.fromString(termId));
                shape.setGeography(g);
                shape.setShapeClass(1);
                shape.setName(importUUID + "_" + cnt++);
                listShape.add(shape);
            }
            wfsShapeInfo.setListShape(listShape);
        }
        finally {
            iterator.close();
        }
        return wfsShapeInfo;
    }

    private String createDataXML(SimpleFeature feature, Map<String, Map<String, AttributeInfo>> attrInfo, Map<String, GeocodeSystem> taxonomyCache, String layerTermId, Map<String, Map<String, AttributeMappingConfig>> cfgCache, boolean forceOverwriteMappings) throws Exception {
        StringBuilder xml = new StringBuilder();
        xml.append("<extraData>");
        List types = feature.getType().getTypes();
        for (AttributeType t : types) {
            Object val = feature.getAttribute(t.getName());
            if (val == null) continue;
            String type = null;
            type = attrInfo == null ? "double" : attrInfo.get(t.getName().toString()).get(NoValueKey).getType();
            boolean setTaxonomy = false;
            boolean setValue = false;
            String taxonomyId = null;
            String layerId = null;
            String attrValue = null;
            Boolean presentable = true;
            Boolean mapValue = true;
            if (attrInfo != null) {
                if (!val.equals(NoValueKey) && attrInfo.get(t.getName().toString()).get(val.toString()) != null) {
                    setValue = true;
                } else {
                    if (!attrInfo.get(t.getName().toString()).get(NoValueKey).isStore()) continue;
                    presentable = attrInfo.get(t.getName().toString()).get(NoValueKey).isPresentable();
                }
            }
            AttributeMappingConfig mcfg = new AttributeMappingConfig();
            mcfg.setAttributeName(t.getName().toString());
            mcfg.setAttributeType(type);
            mcfg.setLayerTermId(layerTermId);
            mcfg.setPresentable(presentable);
            if (setValue) {
                mcfg.setAttributeValue(attrValue);
                mcfg.setMapValue(mapValue);
                mcfg.setTermId(layerId);
            }
            this.addMappingConfig(mcfg, cfgCache);
            String processedVal = HtmlUtils.htmlEscape((String)this.discardIllegalValues(type, feature.getAttribute(t.getName()).toString().trim()));
            xml.append("<" + t.getName() + " type=\"" + type + "\" " + (setTaxonomy ? "geocodeSystem=\"" + taxonomyId + "\" " : NoValueKey) + (setValue ? "layer=\"" + layerId + "\"" : NoValueKey) + ">");
            xml.append(processedVal);
            xml.append("</" + t.getName() + ">");
        }
        xml.append("</extraData>");
        return xml.toString();
    }

    private String insertBursaWolfToWKT(String wkt, double[] bursaWolf) {
        String[] defs = wkt.split("DATUM\\[");
        if (defs.length != 2) {
            log.warn("Could not insert Bursa-Wolf Parameters to CRS WKT");
            return wkt;
        }
        int bracketCount = 1;
        int index = 0;
        int prevClose = -1;
        while (bracketCount != 0) {
            int close = defs[1].indexOf(93, index);
            if (prevClose == -1) {
                prevClose = close;
            }
            int open = defs[1].indexOf(91, index);
            if (close == -1) {
                log.warn("Invalid wkt");
                return null;
            }
            if (open < close) {
                ++bracketCount;
                index = open + 1;
            } else {
                --bracketCount;
                index = close + 1;
            }
            if (bracketCount == 0) continue;
            prevClose = close;
        }
        StringBuilder formattedBursaWolf = new StringBuilder();
        for (int i = 0; i < bursaWolf.length; ++i) {
            formattedBursaWolf.append(String.format(Locale.US, "%.2f", bursaWolf[i]));
            if (i == bursaWolf.length - 1) continue;
            formattedBursaWolf.append(", ");
        }
        String res = defs[0] + "DATUM[" + defs[1].substring(0, prevClose + 1) + ", TOWGS84[" + formattedBursaWolf.toString() + "]" + defs[1].substring(prevClose + 1);
        return res;
    }

    private String discardIllegalValues(String type, String value) {
        try {
            if (type.equals("short")) {
                Short.parseShort(value);
            } else if (type.equals("integer")) {
                Integer.parseInt(value);
            } else if (type.equals("long")) {
                Long.parseLong(value);
            } else if (type.equals("float")) {
                Float.parseFloat(value);
            } else if (type.equals("double")) {
                Double.parseDouble(value);
            }
        }
        catch (NumberFormatException e) {
            return NoValueKey;
        }
        return value;
    }

    public class GeocodeInsertionPoint {
        private List<Geocode> over;
        private Geocode under;

        public GeocodeInsertionPoint() {
        }

        public GeocodeInsertionPoint(List<Geocode> over, Geocode under) {
            this.over = over;
            this.under = under;
        }

        public List<Geocode> getParent() {
            return this.over;
        }

        public void setOver(List<Geocode> over) {
            this.over = over;
        }

        public Geocode getUnder() {
            return this.under;
        }

        public void setUnder(Geocode under) {
            this.under = under;
        }
    }
}

