/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.gaap.utilities;

import gr.cite.geoanalytics.dataaccess.entities.taxonomy.Taxonomy;
import java.io.ByteArrayInputStream;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class TaxonomyUtils {
    private static DocumentBuilderFactory dbf = null;
    private static DocumentBuilder db = null;
    private static Object dbLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Document parseDocument(String data, DocumentBuilder db) throws Exception {
        if (db == TaxonomyUtils.db) {
            Object object = dbLock;
            synchronized (object) {
                return db.parse(new ByteArrayInputStream(data.getBytes("UTF-8")));
            }
        }
        return db.parse(new ByteArrayInputStream(data.getBytes("UTF-8")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isEditable(Taxonomy t) throws Exception {
        if (t.getExtraData() == null || t.getExtraData().isEmpty()) {
            return false;
        }
        Object object = dbLock;
        synchronized (object) {
            if (db == null) {
                dbf = DocumentBuilderFactory.newInstance();
                db = dbf.newDocumentBuilder();
            }
        }
        return TaxonomyUtils.isEditable(t, db);
    }

    public static boolean isEditable(Taxonomy t, DocumentBuilder db) throws Exception {
        if (t.getExtraData() != null && !t.getExtraData().isEmpty()) {
            Document d = db.parse(new ByteArrayInputStream(t.getExtraData().getBytes("UTF-8")));
            String editable = d.getDocumentElement().getAttribute("editable");
            return editable == null || editable.isEmpty() || Boolean.parseBoolean(editable);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String storeLocalizedName(Taxonomy t, String locale, String name) throws Exception {
        if (t.getExtraData() == null || t.getExtraData().isEmpty()) {
            t.setExtraData("<extraData></extraData>");
        }
        Object object = dbLock;
        synchronized (object) {
            if (db == null) {
                dbf = DocumentBuilderFactory.newInstance();
                db = dbf.newDocumentBuilder();
            }
        }
        return TaxonomyUtils.storeLocalizedName(t, locale, name, db);
    }

    public static String storeLocalizedName(Taxonomy t, String locale, String name, DocumentBuilder db) throws Exception {
        if (t.getExtraData() == null || t.getExtraData().isEmpty()) {
            t.setExtraData("<extraData></extraData>");
        }
        Document d = db.parse(new ByteArrayInputStream(t.getExtraData().getBytes("UTF-8")));
        NodeList names = d.getElementsByTagName("name");
        boolean found = false;
        for (int i = 0; i < names.getLength(); ++i) {
            if (!((Element)names.item(i)).getAttribute("locale").equals(locale)) continue;
            found = true;
            break;
        }
        if (!found) {
            Element n = d.createElement("name");
            Attr l = d.createAttribute("locale");
            l.setValue(locale);
            n.appendChild(l);
            Text c = d.createTextNode(name);
            n.appendChild(c);
            d.appendChild(n);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer tr = tf.newTransformer();
            StringWriter sw = new StringWriter();
            tr.transform(new DOMSource(d), new StreamResult(sw));
            sw.toString();
            return sw.toString();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String retrieveLocalizedName(Taxonomy t, String locale) throws Exception {
        if (t.getExtraData() == null || t.getExtraData().isEmpty()) {
            return null;
        }
        Object object = dbLock;
        synchronized (object) {
            if (db == null) {
                dbf = DocumentBuilderFactory.newInstance();
                db = dbf.newDocumentBuilder();
            }
        }
        return TaxonomyUtils.retrieveLocalizedName(t, locale, db);
    }

    public static String retrieveLocalizedName(Taxonomy t, String locale, DocumentBuilder db) throws Exception {
        if (t.getExtraData() == null || t.getExtraData().isEmpty()) {
            return null;
        }
        Document d = TaxonomyUtils.parseDocument(t.getExtraData(), db);
        NodeList names = d.getElementsByTagName("name");
        for (int i = 0; i < names.getLength(); ++i) {
            if (!((Element)names.item(i)).getAttribute("locale").equals(locale)) continue;
            return names.item(i).getFirstChild().getNodeValue();
        }
        return null;
    }

    public static boolean isOrdered(Taxonomy t) throws Exception {
        return TaxonomyUtils.getOrder(t) != null;
    }

    public static boolean isOrdered(Taxonomy t, DocumentBuilder db) throws Exception {
        return TaxonomyUtils.getOrder(t, db) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Integer getOrder(Taxonomy t) throws Exception {
        if (t.getExtraData() == null || t.getExtraData().isEmpty()) {
            return null;
        }
        Object object = dbLock;
        synchronized (object) {
            if (db == null) {
                dbf = DocumentBuilderFactory.newInstance();
                db = dbf.newDocumentBuilder();
            }
        }
        return TaxonomyUtils.getOrder(t, db);
    }

    public static Integer getOrder(Taxonomy t, DocumentBuilder db) throws Exception {
        if (t.getExtraData() == null || t.getExtraData().isEmpty()) {
            return null;
        }
        Document d = TaxonomyUtils.parseDocument(t.getExtraData(), db);
        NodeList nl = d.getDocumentElement().getElementsByTagName("order");
        if (nl.getLength() == 0) {
            return null;
        }
        return Integer.parseInt(nl.item(0).getFirstChild().getNodeValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isGeographic(Taxonomy t) throws Exception {
        if (t.getExtraData() == null || t.getExtraData().isEmpty()) {
            return false;
        }
        Object object = dbLock;
        synchronized (object) {
            if (db == null) {
                dbf = DocumentBuilderFactory.newInstance();
                db = dbf.newDocumentBuilder();
            }
        }
        return TaxonomyUtils.isGeographic(t, db);
    }

    public static boolean isGeographic(Taxonomy t, DocumentBuilder bd) throws Exception {
        if (t.getExtraData() == null || t.getExtraData().isEmpty()) {
            return false;
        }
        Document d = TaxonomyUtils.parseDocument(t.getExtraData(), db);
        String geographicTaxonomy = d.getDocumentElement().getAttribute("geographic");
        if (geographicTaxonomy == null || geographicTaxonomy.trim().isEmpty()) {
            return false;
        }
        return Boolean.parseBoolean(geographicTaxonomy.trim());
    }
}

