/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.gaap.viewbuilders;

import gr.cite.gaap.servicelayer.ConfigurationManager;
import gr.cite.gaap.servicelayer.ShapeImportManager;
import gr.cite.gaap.servicelayer.ShapeManager;
import gr.cite.gaap.servicelayer.TaxonomyManager;
import gr.cite.gaap.utilities.StringUtils;
import gr.cite.gaap.viewbuilders.PostGISViewBuilder;
import gr.cite.geoanalytics.common.ShapeAttributeDataType;
import gr.cite.geoanalytics.context.Configuration;
import gr.cite.geoanalytics.dataaccess.entities.sysconfig.xml.mapping.AttributeMappingConfig;
import gr.cite.geoanalytics.dataaccess.entities.taxonomy.Taxonomy;
import gr.cite.geoanalytics.dataaccess.entities.taxonomy.TaxonomyTerm;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PostGISMaterializedViewBuilder
extends PostGISViewBuilder {
    private static Logger log = LoggerFactory.getLogger(PostGISMaterializedViewBuilder.class);
    private Configuration configuration = null;

    @Inject
    public PostGISMaterializedViewBuilder(ShapeManager shapeManager, ShapeImportManager shapeImportManager, TaxonomyManager taxonomyManager, ConfigurationManager configurationManager) {
        super(shapeManager, shapeImportManager, taxonomyManager, configurationManager);
    }

    @Inject
    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    @Override
    public void removerViewIfExists() throws Exception {
        String statement;
        try {
            statement = "DROP VIEW IF EXIST" + this.identityName;
            this.entityManager.createNativeQuery(statement);
            log.debug("Drop view if exists" + this.identityName);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        try {
            statement = "DROP MATERIALIZED VIEW IF EXIST" + this.identityName;
            this.entityManager.createNativeQuery(statement);
            log.debug("Drop materialized view if exists" + this.identityName);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    @Override
    protected String generateViewStatement(String identity, String name, Map<String, ShapeAttributeDataType> attrs) throws Exception {
        if (attrs == null || attrs.isEmpty()) {
            throw new IllegalArgumentException("Missing data definitions");
        }
        String funcName = "delete_table_or_view";
        StringBuilder sql = new StringBuilder();
        sql.append("DROP VIEW IF EXISTS \"" + name + "\";");
        sql.append(this.createDropFunction(funcName));
        sql.append("SELECT " + funcName + "('" + name + "MV');");
        sql.append("CREATE MATERIALIZED VIEW \"" + name + "MV\"");
        sql.append(" AS ");
        sql.append("SELECT ");
        sql.append(this.configuration.getDataLayerConfig().getShapeGeographyColumnName() + "::geometry AS " + this.configuration.getDataLayerConfig().getShapeGeographyColumnName());
        sql.append(",");
        sql.append(this.configuration.getDataLayerConfig().getShapeIdColumnName() + " AS " + this.configuration.getDataLayerConfig().getShapeIdColumnName());
        for (Map.Entry<String, ShapeAttributeDataType> attr : attrs.entrySet()) {
            String attrExpression = "(xpath('//extraData/" + attr.getKey() + "/text()', " + "s." + this.configuration.getDataLayerConfig().getShapeDataColumnName() + "))[1]" + "::text";
            List mcfgs = this.configurationManager.getMappingConfigsForLayer(attr.getKey(), identity);
            AttributeMappingConfig taxonomyMapping = null;
            boolean valueMapping = false;
            Boolean mapValue = false;
            boolean presentable = true;
            if (mcfgs != null && !mcfgs.isEmpty()) {
                for (AttributeMappingConfig mcfg : mcfgs) {
                    if (mcfg.getAttributeValue() != null && !mcfg.getAttributeValue().equals("")) {
                        valueMapping = true;
                        mapValue = mcfg.isMapValue();
                        continue;
                    }
                    if (mcfg.getAttributeValue() != null && !mcfg.getAttributeValue().equals("")) continue;
                    if (!mcfg.isPresentable().booleanValue()) {
                        presentable = false;
                        break;
                    }
                    if (mcfg.getTermId() == null) continue;
                    taxonomyMapping = mcfg;
                }
            }
            if (!presentable) continue;
            sql.append(", ");
            if (valueMapping && mapValue.booleanValue()) {
                sql.append("\n");
                sql.append("CASE ");
                sql.append(attrExpression);
                sql.append(attr.getValue() != ShapeAttributeDataType.LONGSTRING ? "::" + this.getSQLDataType(attr.getValue()) : "");
                for (AttributeMappingConfig mcfg : mcfgs) {
                    if (mcfg.getAttributeValue() == null || mcfg.getAttributeValue().equals("")) continue;
                    TaxonomyTerm tt = this.taxonomyManager.findTermById(mcfg.getTermId(), false);
                    if (tt == null) {
                        log.error("Taxonomy term " + mcfg.getTermId() + " defined in mappings of attribute " + mcfg.getAttributeName() + " not found");
                        throw new Exception("Taxonomy term " + mcfg.getTermId() + " defined in mappings of attribute " + mcfg.getAttributeName() + " not found");
                    }
                    String dt = this.getSQLDataType(attr.getValue());
                    sql.append("\n");
                    sql.append(" WHEN ");
                    sql.append(this.quoteTextual(mcfg.getAttributeValue(), attr.getValue()));
                    sql.append(" THEN ");
                    sql.append(this.quoteTextual(tt.getName(), attr.getValue()));
                }
                sql.append("\n");
                sql.append("ELSE ");
                sql.append(attrExpression);
                sql.append(attr.getValue() != ShapeAttributeDataType.LONGSTRING ? "::" + this.getSQLDataType(attr.getValue()) : "");
                sql.append(" END");
            } else {
                sql.append(attrExpression);
                sql.append(attr.getValue() != ShapeAttributeDataType.LONGSTRING ? "::" + this.getSQLDataType(attr.getValue()) : "");
            }
            sql.append(" AS ");
            if (taxonomyMapping != null) {
                Taxonomy t = this.taxonomyManager.findTaxonomyById(taxonomyMapping.getTermId(), false);
                if (t == null) {
                    log.error("Taxonomy " + taxonomyMapping.getTermId() + " defined in mappings of attribute " + taxonomyMapping.getAttributeName() + " not found");
                    throw new Exception("Taxonomy " + taxonomyMapping.getTermId() + " defined in mappings of attribute " + taxonomyMapping.getAttributeName() + " not found");
                }
                sql.append(StringUtils.normalizeEntityName((String)t.getName()));
                continue;
            }
            sql.append("\"" + attr.getKey() + "\"");
        }
        sql.append("\n");
        sql.append("FROM " + this.configuration.getDataLayerConfig().getShapeTableName() + " s, " + this.configuration.getDataLayerConfig().getShapeTermTableName() + " st\n");
        if (identity != null) {
            sql.append("WHERE st." + this.configuration.getDataLayerConfig().getShapeTermShapeColumnName() + "=" + "s." + this.configuration.getDataLayerConfig().getShapeIdColumnName() + " and st." + this.configuration.getDataLayerConfig().getShapeTermTermColumnName() + "='" + identity + "'");
        } else {
            sql.append("WHERE " + this.configuration.getDataLayerConfig().getShapeIdColumnName() + "='" + this.shape.getId() + "'");
        }
        sql.append(" WITH DATA");
        sql.append(";");
        String id = this.configuration.getDataLayerConfig().getShapeIdColumnName();
        id = id.substring(1, id.length() - 2);
        sql.append("CREATE UNIQUE INDEX pki_" + StringUtils.normalizeEntityName((String)name) + "MV_" + id + " ");
        sql.append("ON \"" + name + "MV\" USING btree (" + this.configuration.getDataLayerConfig().getShapeIdColumnName() + ");");
        String geography = this.configuration.getDataLayerConfig().getShapeGeographyColumnName();
        geography = geography.substring(1, id.length() - 2);
        sql.append("CREATE INDEX idx_" + StringUtils.normalizeEntityName((String)name) + "MV_" + geography);
        sql.append("  ON \"" + name + "MV\"");
        sql.append("  USING gist");
        sql.append(" (" + this.configuration.getDataLayerConfig().getShapeGeographyColumnName() + ");");
        sql.append("CREATE VIEW \"" + name + "\" AS SELECT * FROM \"" + name + "MV\";");
        sql.append("VACUUM ANALYZE;");
        return sql.toString();
    }
}

