/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.gaap.viewbuilders;

import gr.cite.gaap.servicelayer.ConfigurationManager;
import gr.cite.gaap.servicelayer.ShapeImportManager;
import gr.cite.gaap.servicelayer.ShapeManager;
import gr.cite.gaap.servicelayer.TaxonomyManager;
import gr.cite.geoanalytics.common.ShapeAttributeDataType;
import gr.cite.geoanalytics.common.ViewBuilder;
import gr.cite.geoanalytics.context.Configuration;
import gr.cite.geoanalytics.dataaccess.entities.shape.Shape;
import gr.cite.geoanalytics.dataaccess.entities.taxonomy.TaxonomyTerm;
import java.io.ByteArrayInputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public abstract class AbstractViewBuilder
implements ViewBuilder {
    private static Logger log = LoggerFactory.getLogger(AbstractViewBuilder.class);
    @PersistenceContext
    protected EntityManager entityManager;
    protected Configuration context;
    protected ShapeManager shapeManager;
    protected ShapeImportManager shapeImportManager;
    protected TaxonomyManager taxonomyManager;
    protected ConfigurationManager configurationManager;
    protected String identity = null;
    protected String identityName = null;
    protected Shape shape = null;
    protected String viewStatement = null;
    protected Map<String, ShapeAttributeDataType> attrs = new LinkedHashMap<String, ShapeAttributeDataType>();

    public AbstractViewBuilder(ShapeManager shapeManager, ShapeImportManager shapeImportManager, TaxonomyManager taxonomyManager, ConfigurationManager configurationManager) {
        this.shapeManager = shapeManager;
        this.shapeImportManager = shapeImportManager;
        this.taxonomyManager = taxonomyManager;
        this.configurationManager = configurationManager;
    }

    @Inject
    public void setContext(Configuration context) {
        this.context = context;
    }

    private ShapeAttributeDataType parseDataType(String dataType, String data) {
        if (dataType.equalsIgnoreCase("short")) {
            return ShapeAttributeDataType.SHORT;
        }
        if (dataType.equalsIgnoreCase("int")) {
            return ShapeAttributeDataType.INTEGER;
        }
        if (dataType.equalsIgnoreCase("decimal") || dataType.equalsIgnoreCase("integer") || dataType.equalsIgnoreCase("long")) {
            return ShapeAttributeDataType.LONG;
        }
        if (dataType.equalsIgnoreCase("float")) {
            return ShapeAttributeDataType.FLOAT;
        }
        if (dataType.equalsIgnoreCase("double")) {
            return ShapeAttributeDataType.DOUBLE;
        }
        if (dataType.equalsIgnoreCase("date")) {
            return ShapeAttributeDataType.DATE;
        }
        if (data.length() < 250) {
            return ShapeAttributeDataType.STRING;
        }
        return ShapeAttributeDataType.LONGSTRING;
    }

    public ViewBuilder createViewStatement() throws Exception {
        this.viewStatement = this.generateViewStatement(this.identity, this.identityName != null ? this.identityName : this.shape.getName(), this.attrs);
        return this;
    }

    public String getViewStatement() throws Exception {
        if (this.viewStatement == null) {
            this.createViewStatement();
        }
        return this.viewStatement;
    }

    public ViewBuilder withAttribute(String key, ShapeAttributeDataType value) {
        this.attrs.put(key, value);
        return this;
    }

    private void mergeInfoForShape() throws Exception {
        String extraData = this.shape.getExtraData();
        if (extraData == null) {
            extraData = "";
        }
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document data = db.parse(new InputSource(new ByteArrayInputStream(extraData.getBytes("UTF-8"))));
        int len = data.getDocumentElement().getChildNodes().getLength();
        for (int i = 0; i < len; ++i) {
            Node n = data.getDocumentElement().getChildNodes().item(i);
            String value = "";
            if (n.getFirstChild() != null) {
                value = n.getFirstChild().getNodeValue();
            }
            String attrName = n.getNodeName();
            this.attrs.put(attrName, this.parseDataType(((Element)n).getAttribute("type"), value));
        }
    }

    public ViewBuilder forShape(Shape shape) throws Exception {
        this.shape = shape;
        this.identity = null;
        this.identityName = null;
        this.attrs = new HashMap<String, ShapeAttributeDataType>();
        if (shape == null) {
            throw new IllegalArgumentException("No shape provided");
        }
        if (shape.getGeography() == null) {
            throw new IllegalArgumentException("Shape geography not present");
        }
        if (shape.getName() == null) {
            throw new IllegalArgumentException("Shape name not assigned");
        }
        this.mergeInfoForShape();
        return this;
    }

    public ViewBuilder forIdentity(String identity, String identityName) throws Exception {
        this.identity = identity;
        this.identityName = identityName;
        this.attrs = new HashMap<String, ShapeAttributeDataType>();
        TaxonomyTerm tt = this.taxonomyManager.findTermById(identity, true);
        List shapes = this.shapeManager.getShapesOfLayer(tt.getName(), tt.getTaxonomy().getName());
        System.out.println("Creating new Shapes (TSV Import)");
        for (Shape s : shapes) {
            System.out.println("shape = " + s.getId());
            this.shape = s;
            this.mergeInfoForShape();
        }
        return this;
    }

    protected abstract String generateViewStatement(String var1, String var2, Map<String, ShapeAttributeDataType> var3) throws Exception;

    public void execute() throws Exception {
        Connection con = null;
        Statement st = null;
        try {
            con = DriverManager.getConnection(this.context.getDataLayerConfig().getDbUrl(), this.context.getDataLayerConfig().getDbUser(), this.context.getDataLayerConfig().getDbPass());
            st = con.createStatement();
            st.executeUpdate(this.getViewStatement());
        }
        catch (SQLException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            throw ex;
        }
        finally {
            try {
                if (st != null) {
                    st.close();
                }
                if (con != null) {
                    con.close();
                }
            }
            catch (SQLException ex) {
                log.warn(ex.getMessage(), (Throwable)ex);
            }
        }
    }

    public abstract void removerViewIfExists() throws Exception;
}

